// services/viz/public/mojom/compositing/compositor_frame_metadata.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/compositor_frame_metadata.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var begin_frame_args$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/begin_frame_args.mojom', 'begin_frame_args.mojom.js');
  }
  var compositor_frame_transition_directive$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom', 'compositor_frame_transition_directive.mojom.js');
  }
  var delegated_ink_metadata$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/delegated_ink_metadata.mojom', '../../../../../ui/gfx/mojom/delegated_ink_metadata.mojom.js');
  }
  var offset_tag$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/offset_tag.mojom', 'offset_tag.mojom.js');
  }
  var frame_deadline$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_deadline.mojom', 'frame_deadline.mojom.js');
  }
  var frame_interval_inputs$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/frame_interval_inputs.mojom', 'frame_interval_inputs.mojom.js');
  }
  var region_capture_bounds$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/region_capture_bounds.mojom', 'region_capture_bounds.mojom.js');
  }
  var trees_in_viz_timing$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/trees_in_viz_timing.mojom', 'trees_in_viz_timing.mojom.js');
  }
  var selection$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/selection.mojom', 'selection.mojom.js');
  }
  var surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_id.mojom', 'surface_id.mojom.js');
  }
  var surface_range$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/surface_range.mojom', 'surface_range.mojom.js');
  }
  var skcolor4f$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor4f.mojom', '../../../../../skia/public/mojom/skcolor4f.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../../../../../third_party/blink/public/mojom/tokens/tokens.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var display_color_spaces$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/display_color_spaces.mojom', '../../../../../ui/gfx/mojom/display_color_spaces.mojom.js');
  }
  var overlay_transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/overlay_transform.mojom', '../../../../../ui/gfx/mojom/overlay_transform.mojom.js');
  }
  var latency_info$ =
      mojo.internal.exposeNamespace('ui.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/latency/mojom/latency_info.mojom', '../../../../../ui/latency/mojom/latency_info.mojom.js');
  }



  function CompositorFrameMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CompositorFrameMetadata.prototype.initDefaults_ = function() {
    this.deviceScaleFactor = 0;
    this.pageScaleFactor = 0;
    this.rootScrollOffset = null;
    this.scrollableViewportSize = null;
    this.visibleViewportSize = null;
    this.contentColorUsage = 0;
    this.mayContainVideo = false;
    this.mayThrottleIfUndrawnFrames = false;
    this.isHandlingInteraction = false;
    this.isHandlingAnimation = false;
    this.sendFrameTokenToEmbedder = false;
    this.topControlsVisibleHeightSet = false;
    this.isMobileOptimized = false;
    this.hasSharedElementResources = false;
    this.isSoftware = false;
    this.rootBackgroundColor = null;
    this.latencyInfo = null;
    this.referencedSurfaces = null;
    this.deadline = null;
    this.activationDependencies = null;
    this.beginFrameAck = null;
    this.frameToken = 0;
    this.topControlsVisibleHeight = 0;
    this.minPageScaleFactor = 0;
    this.displayTransformHint = 0;
    this.delegatedInkMetadata = null;
    this.transitionDirectives = null;
    this.captureBounds = null;
    this.screenshotDestination = null;
    this.offsetTagDefinitions = null;
    this.offsetTagValues = null;
    this.frameIntervalInputs = null;
    this.treesInVizTiming = null;
  };
  CompositorFrameMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CompositorFrameMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 176}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CompositorFrameMetadata.rootScrollOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, geometry$.PointF, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CompositorFrameMetadata.scrollableViewportSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, geometry$.SizeF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.visibleViewportSize
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, geometry$.Size, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.contentColorUsage
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, display_color_spaces$.ContentColorUsage);
    if (err !== validator.validationError.NONE)
        return err;






    // validate CompositorFrameMetadata.rootBackgroundColor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, skcolor4f$.SkColor4f, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.latencyInfo
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 48, 8, new codec.PointerTo(latency_info$.LatencyInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.referencedSurfaces
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 56, 8, new codec.PointerTo(surface_range$.SurfaceRange), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.deadline
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, frame_deadline$.FrameDeadline, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.activationDependencies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 72, 8, new codec.PointerTo(surface_id$.SurfaceId), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.beginFrameAck
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, begin_frame_args$.BeginFrameAck, false);
    if (err !== validator.validationError.NONE)
        return err;







    // validate CompositorFrameMetadata.displayTransformHint
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, overlay_transform$.OverlayTransform);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CompositorFrameMetadata.delegatedInkMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, delegated_ink_metadata$.DelegatedInkMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.transitionDirectives
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 112, 8, new codec.PointerTo(compositor_frame_transition_directive$.CompositorFrameTransitionDirective), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.captureBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, region_capture_bounds$.RegionCaptureBounds, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CompositorFrameMetadata.screenshotDestination
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, tokens$.SameDocNavigationScreenshotDestinationToken, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CompositorFrameMetadata.offsetTagDefinitions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 136, 8, new codec.PointerTo(offset_tag$.OffsetTagDefinition), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.offsetTagValues
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, new codec.PointerTo(offset_tag$.OffsetTagValue), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.frameIntervalInputs
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, frame_interval_inputs$.FrameIntervalInputs, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CompositorFrameMetadata.treesInVizTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 160, trees_in_viz_timing$.TreesInVizTiming, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CompositorFrameMetadata.encodedSize = codec.kStructHeaderSize + 168;

  CompositorFrameMetadata.decode = function(decoder) {
    var packed;
    var val = new CompositorFrameMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.deviceScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.pageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.rootScrollOffset =
        decoder.decodeStructPointer(geometry$.PointF);
    val.scrollableViewportSize =
        decoder.decodeStructPointer(geometry$.SizeF);
    val.visibleViewportSize =
        decoder.decodeStructPointer(geometry$.Size);
    val.contentColorUsage =
        decoder.decodeStruct(new codec.Enum(display_color_spaces$.ContentColorUsage));
    packed = decoder.readUint8();
    val.mayContainVideo = (packed >> 0) & 1 ? true : false;
    val.mayThrottleIfUndrawnFrames = (packed >> 1) & 1 ? true : false;
    val.isHandlingInteraction = (packed >> 2) & 1 ? true : false;
    val.isHandlingAnimation = (packed >> 3) & 1 ? true : false;
    val.sendFrameTokenToEmbedder = (packed >> 4) & 1 ? true : false;
    val.topControlsVisibleHeightSet = (packed >> 5) & 1 ? true : false;
    val.isMobileOptimized = (packed >> 6) & 1 ? true : false;
    val.hasSharedElementResources = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.isSoftware = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    val.rootBackgroundColor =
        decoder.decodeStructPointer(skcolor4f$.SkColor4f);
    val.latencyInfo =
        decoder.decodeArrayPointer(new codec.PointerTo(latency_info$.LatencyInfo));
    val.referencedSurfaces =
        decoder.decodeArrayPointer(new codec.PointerTo(surface_range$.SurfaceRange));
    val.deadline =
        decoder.decodeStructPointer(frame_deadline$.FrameDeadline);
    val.activationDependencies =
        decoder.decodeArrayPointer(new codec.PointerTo(surface_id$.SurfaceId));
    val.beginFrameAck =
        decoder.decodeStructPointer(begin_frame_args$.BeginFrameAck);
    val.frameToken =
        decoder.decodeStruct(codec.Uint32);
    val.topControlsVisibleHeight =
        decoder.decodeStruct(codec.Float);
    val.minPageScaleFactor =
        decoder.decodeStruct(codec.Float);
    val.displayTransformHint =
        decoder.decodeStruct(new codec.Enum(overlay_transform$.OverlayTransform));
    val.delegatedInkMetadata =
        decoder.decodeStructPointer(delegated_ink_metadata$.DelegatedInkMetadata);
    val.transitionDirectives =
        decoder.decodeArrayPointer(new codec.PointerTo(compositor_frame_transition_directive$.CompositorFrameTransitionDirective));
    val.captureBounds =
        decoder.decodeStructPointer(region_capture_bounds$.RegionCaptureBounds);
    val.screenshotDestination =
        decoder.decodeStructPointer(tokens$.SameDocNavigationScreenshotDestinationToken);
    val.offsetTagDefinitions =
        decoder.decodeArrayPointer(new codec.PointerTo(offset_tag$.OffsetTagDefinition));
    val.offsetTagValues =
        decoder.decodeArrayPointer(new codec.PointerTo(offset_tag$.OffsetTagValue));
    val.frameIntervalInputs =
        decoder.decodeStructPointer(frame_interval_inputs$.FrameIntervalInputs);
    val.treesInVizTiming =
        decoder.decodeStructPointer(trees_in_viz_timing$.TreesInVizTiming);
    return val;
  };

  CompositorFrameMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CompositorFrameMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Float, val.deviceScaleFactor);
    encoder.encodeStruct(codec.Float, val.pageScaleFactor);
    encoder.encodeStructPointer(geometry$.PointF, val.rootScrollOffset);
    encoder.encodeStructPointer(geometry$.SizeF, val.scrollableViewportSize);
    encoder.encodeStructPointer(geometry$.Size, val.visibleViewportSize);
    encoder.encodeStruct(codec.Int32, val.contentColorUsage);
    packed = 0;
    packed |= (val.mayContainVideo & 1) << 0
    packed |= (val.mayThrottleIfUndrawnFrames & 1) << 1
    packed |= (val.isHandlingInteraction & 1) << 2
    packed |= (val.isHandlingAnimation & 1) << 3
    packed |= (val.sendFrameTokenToEmbedder & 1) << 4
    packed |= (val.topControlsVisibleHeightSet & 1) << 5
    packed |= (val.isMobileOptimized & 1) << 6
    packed |= (val.hasSharedElementResources & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.isSoftware & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(skcolor4f$.SkColor4f, val.rootBackgroundColor);
    encoder.encodeArrayPointer(new codec.PointerTo(latency_info$.LatencyInfo), val.latencyInfo);
    encoder.encodeArrayPointer(new codec.PointerTo(surface_range$.SurfaceRange), val.referencedSurfaces);
    encoder.encodeStructPointer(frame_deadline$.FrameDeadline, val.deadline);
    encoder.encodeArrayPointer(new codec.PointerTo(surface_id$.SurfaceId), val.activationDependencies);
    encoder.encodeStructPointer(begin_frame_args$.BeginFrameAck, val.beginFrameAck);
    encoder.encodeStruct(codec.Uint32, val.frameToken);
    encoder.encodeStruct(codec.Float, val.topControlsVisibleHeight);
    encoder.encodeStruct(codec.Float, val.minPageScaleFactor);
    encoder.encodeStruct(codec.Int32, val.displayTransformHint);
    encoder.encodeStructPointer(delegated_ink_metadata$.DelegatedInkMetadata, val.delegatedInkMetadata);
    encoder.encodeArrayPointer(new codec.PointerTo(compositor_frame_transition_directive$.CompositorFrameTransitionDirective), val.transitionDirectives);
    encoder.encodeStructPointer(region_capture_bounds$.RegionCaptureBounds, val.captureBounds);
    encoder.encodeStructPointer(tokens$.SameDocNavigationScreenshotDestinationToken, val.screenshotDestination);
    encoder.encodeArrayPointer(new codec.PointerTo(offset_tag$.OffsetTagDefinition), val.offsetTagDefinitions);
    encoder.encodeArrayPointer(new codec.PointerTo(offset_tag$.OffsetTagValue), val.offsetTagValues);
    encoder.encodeStructPointer(frame_interval_inputs$.FrameIntervalInputs, val.frameIntervalInputs);
    encoder.encodeStructPointer(trees_in_viz_timing$.TreesInVizTiming, val.treesInVizTiming);
  };
  exports.CompositorFrameMetadata = CompositorFrameMetadata;
})();