// services/viz/public/mojom/compositing/compositor_frame.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-blink.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass.mojom-blink.h"
#include "services/viz/public/mojom/compositing/transferable_resource.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "components/viz/common/quads/compositor_frame.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {








class BLINK_PLATFORM_EXPORT CompositorFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CompositorFrame, T>::value>;
  using DataView = CompositorFrameDataView;
  using Data_ = internal::CompositorFrame_Data;

  template <typename... Args>
  static CompositorFramePtr New(Args&&... args) {
    return CompositorFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CompositorFramePtr From(const U& u) {
    return mojo::TypeConverter<CompositorFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CompositorFrame>::Convert(*this);
  }


  CompositorFrame();

  CompositorFrame(
      ::viz::CompositorFrameMetadata metadata,
      ::blink::Vector<::viz::mojom::blink::TransferableResourcePtr> resources,
      ::blink::Vector<::viz::mojom::blink::CompositorRenderPassPtr> passes);

CompositorFrame(const CompositorFrame&) = delete;
CompositorFrame& operator=(const CompositorFrame&) = delete;

  ~CompositorFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CompositorFramePtr>
  CompositorFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CompositorFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CompositorFrame_UnserializedMessageContext<
            UserType, CompositorFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CompositorFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CompositorFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CompositorFrame_UnserializedMessageContext<
            UserType, CompositorFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CompositorFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::viz::CompositorFrameMetadata metadata;
  
  ::blink::Vector<::viz::mojom::blink::TransferableResourcePtr> resources;
  
  ::blink::Vector<::viz::mojom::blink::CompositorRenderPassPtr> passes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CompositorFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CompositorFramePtr CompositorFrame::Clone() const {
  return New(
      mojo::Clone(metadata),
      mojo::Clone(resources),
      mojo::Clone(passes)
  );
}

template <typename T, CompositorFrame::EnableIfSame<T>*>
bool CompositorFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->resources, other_struct.resources))
    return false;
  if (!mojo::Equals(this->passes, other_struct.passes))
    return false;
  return true;
}

template <typename T, CompositorFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.resources < rhs.resources)
    return true;
  if (rhs.resources < lhs.resources)
    return false;
  if (lhs.passes < rhs.passes)
    return true;
  if (rhs.passes < lhs.passes)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::CompositorFrame::DataView,
                                         ::viz::mojom::blink::CompositorFramePtr> {
  static bool IsNull(const ::viz::mojom::blink::CompositorFramePtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::CompositorFramePtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::CompositorFrame::metadata)& metadata(
      const ::viz::mojom::blink::CompositorFramePtr& input) {
    return input->metadata;
  }

  static const decltype(::viz::mojom::blink::CompositorFrame::resources)& resources(
      const ::viz::mojom::blink::CompositorFramePtr& input) {
    return input->resources;
  }

  static  decltype(::viz::mojom::blink::CompositorFrame::passes)& passes(
       ::viz::mojom::blink::CompositorFramePtr& input) {
    return input->passes;
  }

  static bool Read(::viz::mojom::blink::CompositorFrame::DataView input, ::viz::mojom::blink::CompositorFramePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_MOJOM_BLINK_H_