// services/viz/public/mojom/compositing/begin_frame_args.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_DATA_VIEW_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace viz::mojom {
class BeginFrameIdDataView;

class BeginFrameArgsDataView;

class BeginFrameAckDataView;



}  // viz::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameIdDataView> {
  using Data = ::viz::mojom::internal::BeginFrameId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameArgsDataView> {
  using Data = ::viz::mojom::internal::BeginFrameArgs_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::BeginFrameAckDataView> {
  using Data = ::viz::mojom::internal::BeginFrameAck_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class BeginFrameArgsType : int32_t {
  
  INVALID = 0,
  
  NORMAL = 1,
  
  MISSED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, BeginFrameArgsType value);
inline bool IsKnownEnumValue(BeginFrameArgsType value) {
  return internal::BeginFrameArgsType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BeginFrameIdDataView {
 public:
  BeginFrameIdDataView() = default;

  BeginFrameIdDataView(
      internal::BeginFrameId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t source_id() const {
    return data_->source_id;
  }
  uint64_t sequence_number() const {
    return data_->sequence_number;
  }
 private:
  internal::BeginFrameId_Data* data_ = nullptr;
};


class BeginFrameArgsDataView {
 public:
  BeginFrameArgsDataView() = default;

  BeginFrameArgsDataView(
      internal::BeginFrameArgs_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFrameTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameTime(UserType* output) {
    
    auto* pointer = data_->frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDeadlineDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeadline(UserType* output) {
    
    auto* pointer = data_->deadline.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterval(UserType* output) {
    
    auto* pointer = data_->interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetFrameIdDataView(
      BeginFrameIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameId(UserType* output) {
    
    auto* pointer = data_->frame_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameIdDataView>(
        pointer, output, message_);
  }
  uint64_t frames_throttled_since_last() const {
    return data_->frames_throttled_since_last;
  }
  int64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetDispatchTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDispatchTime(UserType* output) {
    
    auto* pointer = data_->dispatch_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetClientArrivalTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientArrivalTime(UserType* output) {
    
    auto* pointer = data_->client_arrival_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::BeginFrameArgsType>(
        data_value, output);
  }
  BeginFrameArgsType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::BeginFrameArgsType>(data_->type));
  }
  bool on_critical_path() const {
    return data_->on_critical_path;
  }
  bool animate_only() const {
    return data_->animate_only;
  }
 private:
  internal::BeginFrameArgs_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BeginFrameAckDataView {
 public:
  BeginFrameAckDataView() = default;

  BeginFrameAckDataView(
      internal::BeginFrameAck_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t source_id() const {
    return data_->source_id;
  }
  uint64_t sequence_number() const {
    return data_->sequence_number;
  }
  int64_t trace_id() const {
    return data_->trace_id;
  }
  bool has_damage() const {
    return data_->has_damage;
  }
 private:
  internal::BeginFrameAck_Data* data_ = nullptr;
};


}  // viz::mojom

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_BEGIN_FRAME_ARGS_MOJOM_DATA_VIEW_H_