// services/viz/public/mojom/compositing/animation.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/viz/public/mojom/compositing/animation.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('viz.mojom');
  var element_id$ =
      mojo.internal.exposeNamespace('cc.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'cc/mojom/element_id.mojom', '../../../../../cc/mojom/element_id.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var skcolor$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor.mojom', '../../../../../skia/public/mojom/skcolor.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var transform$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/transform.mojom', '../../../../../ui/gfx/mojom/transform.mojom.js');
  }


  var TimingStepPosition = {};
  TimingStepPosition.kStart = 0;
  TimingStepPosition.kEnd = 1;
  TimingStepPosition.kJumpBoth = 2;
  TimingStepPosition.kJumpEnd = 3;
  TimingStepPosition.kJumpNone = 4;
  TimingStepPosition.kJumpStart = 5;
  TimingStepPosition.MIN_VALUE = 0;
  TimingStepPosition.MAX_VALUE = 5;

  TimingStepPosition.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
      return true;
    }
    return false;
  };

  TimingStepPosition.toKnownEnumValue = function(value) {
    return value;
  };

  TimingStepPosition.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AnimationDirection = {};
  AnimationDirection.kNormal = 0;
  AnimationDirection.kReverse = 1;
  AnimationDirection.kAlternateNormal = 2;
  AnimationDirection.kAlternateReverse = 3;
  AnimationDirection.MIN_VALUE = 0;
  AnimationDirection.MAX_VALUE = 3;

  AnimationDirection.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AnimationDirection.toKnownEnumValue = function(value) {
    return value;
  };

  AnimationDirection.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AnimationFillMode = {};
  AnimationFillMode.kNone = 0;
  AnimationFillMode.kForwards = 1;
  AnimationFillMode.kBackwards = 2;
  AnimationFillMode.kBoth = 3;
  AnimationFillMode.kAuto = 4;
  AnimationFillMode.MIN_VALUE = 0;
  AnimationFillMode.MAX_VALUE = 4;

  AnimationFillMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  AnimationFillMode.toKnownEnumValue = function(value) {
    return value;
  };

  AnimationFillMode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function CubicBezierTimingFunction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CubicBezierTimingFunction.prototype.initDefaults_ = function() {
    this.x1 = 0;
    this.y1 = 0;
    this.x2 = 0;
    this.y2 = 0;
  };
  CubicBezierTimingFunction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CubicBezierTimingFunction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  CubicBezierTimingFunction.encodedSize = codec.kStructHeaderSize + 32;

  CubicBezierTimingFunction.decode = function(decoder) {
    var packed;
    var val = new CubicBezierTimingFunction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.x1 =
        decoder.decodeStruct(codec.Double);
    val.y1 =
        decoder.decodeStruct(codec.Double);
    val.x2 =
        decoder.decodeStruct(codec.Double);
    val.y2 =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  CubicBezierTimingFunction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CubicBezierTimingFunction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.x1);
    encoder.encodeStruct(codec.Double, val.y1);
    encoder.encodeStruct(codec.Double, val.x2);
    encoder.encodeStruct(codec.Double, val.y2);
  };
  function StepsTimingFunction(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StepsTimingFunction.prototype.initDefaults_ = function() {
    this.numSteps = 0;
    this.stepPosition = 0;
  };
  StepsTimingFunction.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StepsTimingFunction.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate StepsTimingFunction.stepPosition
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, TimingStepPosition);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StepsTimingFunction.encodedSize = codec.kStructHeaderSize + 8;

  StepsTimingFunction.decode = function(decoder) {
    var packed;
    var val = new StepsTimingFunction();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.numSteps =
        decoder.decodeStruct(codec.Uint32);
    val.stepPosition =
        decoder.decodeStruct(new codec.Enum(TimingStepPosition));
    return val;
  };

  StepsTimingFunction.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StepsTimingFunction.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.numSteps);
    encoder.encodeStruct(codec.Int32, val.stepPosition);
  };
  function LinearEasingPoint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LinearEasingPoint.prototype.initDefaults_ = function() {
    this.in = 0;
    this.out = 0;
  };
  LinearEasingPoint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LinearEasingPoint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  LinearEasingPoint.encodedSize = codec.kStructHeaderSize + 16;

  LinearEasingPoint.decode = function(decoder) {
    var packed;
    var val = new LinearEasingPoint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.in =
        decoder.decodeStruct(codec.Double);
    val.out =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  LinearEasingPoint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LinearEasingPoint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.in);
    encoder.encodeStruct(codec.Double, val.out);
  };
  function AxisAngle(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AxisAngle.prototype.initDefaults_ = function() {
    this.axis = null;
    this.angle = 0;
  };
  AxisAngle.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AxisAngle.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AxisAngle.axis
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, geometry$.Vector3dF, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AxisAngle.encodedSize = codec.kStructHeaderSize + 16;

  AxisAngle.decode = function(decoder) {
    var packed;
    var val = new AxisAngle();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.axis =
        decoder.decodeStructPointer(geometry$.Vector3dF);
    val.angle =
        decoder.decodeStruct(codec.Float);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AxisAngle.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AxisAngle.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(geometry$.Vector3dF, val.axis);
    encoder.encodeStruct(codec.Float, val.angle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AnimationKeyframe(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnimationKeyframe.prototype.initDefaults_ = function() {
    this.value = null;
    this.startTime = null;
    this.timingFunction = null;
  };
  AnimationKeyframe.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnimationKeyframe.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframe.value
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, AnimationKeyframeValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframe.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframe.timingFunction
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, TimingFunction, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnimationKeyframe.encodedSize = codec.kStructHeaderSize + 40;

  AnimationKeyframe.decode = function(decoder) {
    var packed;
    var val = new AnimationKeyframe();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStruct(AnimationKeyframeValue);
    val.startTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.timingFunction =
        decoder.decodeStruct(TimingFunction);
    return val;
  };

  AnimationKeyframe.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnimationKeyframe.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(AnimationKeyframeValue, val.value);
    encoder.encodeStructPointer(time$.TimeDelta, val.startTime);
    encoder.encodeStruct(TimingFunction, val.timingFunction);
  };
  function AnimationKeyframeModel(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnimationKeyframeModel.prototype.initDefaults_ = function() {
    this.id = 0;
    this.groupId = 0;
    this.targetPropertyType = 0;
    this.direction = 0;
    this.elementId = null;
    this.timingFunction = null;
    this.keyframes = null;
    this.scaledDuration = 0;
    this.fillMode = 0;
    this.playbackRate = 0;
    this.iterations = 0;
    this.iterationStart = 0;
    this.timeOffset = null;
  };
  AnimationKeyframeModel.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnimationKeyframeModel.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 104}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate AnimationKeyframeModel.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframeModel.timingFunction
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 24, TimingFunction, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframeModel.keyframes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(AnimationKeyframe), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnimationKeyframeModel.direction
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AnimationDirection);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationKeyframeModel.fillMode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 56, AnimationFillMode);
    if (err !== validator.validationError.NONE)
        return err;





    // validate AnimationKeyframeModel.timeOffset
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnimationKeyframeModel.encodedSize = codec.kStructHeaderSize + 96;

  AnimationKeyframeModel.decode = function(decoder) {
    var packed;
    var val = new AnimationKeyframeModel();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    val.groupId =
        decoder.decodeStruct(codec.Int32);
    val.targetPropertyType =
        decoder.decodeStruct(codec.Int32);
    val.direction =
        decoder.decodeStruct(new codec.Enum(AnimationDirection));
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.timingFunction =
        decoder.decodeStruct(TimingFunction);
    val.keyframes =
        decoder.decodeArrayPointer(new codec.PointerTo(AnimationKeyframe));
    val.scaledDuration =
        decoder.decodeStruct(codec.Double);
    val.fillMode =
        decoder.decodeStruct(new codec.Enum(AnimationFillMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.playbackRate =
        decoder.decodeStruct(codec.Double);
    val.iterations =
        decoder.decodeStruct(codec.Double);
    val.iterationStart =
        decoder.decodeStruct(codec.Double);
    val.timeOffset =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  AnimationKeyframeModel.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnimationKeyframeModel.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.encodeStruct(codec.Int32, val.groupId);
    encoder.encodeStruct(codec.Int32, val.targetPropertyType);
    encoder.encodeStruct(codec.Int32, val.direction);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
    encoder.encodeStruct(TimingFunction, val.timingFunction);
    encoder.encodeArrayPointer(new codec.PointerTo(AnimationKeyframe), val.keyframes);
    encoder.encodeStruct(codec.Double, val.scaledDuration);
    encoder.encodeStruct(codec.Int32, val.fillMode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Double, val.playbackRate);
    encoder.encodeStruct(codec.Double, val.iterations);
    encoder.encodeStruct(codec.Double, val.iterationStart);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeOffset);
  };
  function Animation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Animation.prototype.initDefaults_ = function() {
    this.id = 0;
    this.elementId = null;
    this.keyframeModels = null;
  };
  Animation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Animation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate Animation.elementId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, element_id$.ElementId, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate Animation.keyframeModels
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(AnimationKeyframeModel), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Animation.encodedSize = codec.kStructHeaderSize + 24;

  Animation.decode = function(decoder) {
    var packed;
    var val = new Animation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.elementId =
        decoder.decodeStructPointer(element_id$.ElementId);
    val.keyframeModels =
        decoder.decodeArrayPointer(new codec.PointerTo(AnimationKeyframeModel));
    return val;
  };

  Animation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Animation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(element_id$.ElementId, val.elementId);
    encoder.encodeArrayPointer(new codec.PointerTo(AnimationKeyframeModel), val.keyframeModels);
  };
  function AnimationTimeline(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnimationTimeline.prototype.initDefaults_ = function() {
    this.id = 0;
    this.newAnimations = null;
    this.removedAnimations = null;
  };
  AnimationTimeline.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnimationTimeline.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate AnimationTimeline.newAnimations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(Animation), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationTimeline.removedAnimations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnimationTimeline.encodedSize = codec.kStructHeaderSize + 24;

  AnimationTimeline.decode = function(decoder) {
    var packed;
    var val = new AnimationTimeline();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.newAnimations =
        decoder.decodeArrayPointer(new codec.PointerTo(Animation));
    val.removedAnimations =
        decoder.decodeArrayPointer(codec.Int32);
    return val;
  };

  AnimationTimeline.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnimationTimeline.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.id);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(Animation), val.newAnimations);
    encoder.encodeArrayPointer(codec.Int32, val.removedAnimations);
  };

  function TimingFunction(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TimingFunction.Tags = {
    cubicBezier: 0,
    steps: 1,
    linear: 2,
  };

  TimingFunction.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TimingFunction.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "cubicBezier",
        "steps",
        "linear",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TimingFunction member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TimingFunction.prototype, "cubicBezier", {
    get: function() {
      if (this.$tag != TimingFunction.Tags.cubicBezier) {
        throw new ReferenceError(
            "TimingFunction.cubicBezier is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TimingFunction.Tags.cubicBezier;
      this.$data = value;
    }
  });
  Object.defineProperty(TimingFunction.prototype, "steps", {
    get: function() {
      if (this.$tag != TimingFunction.Tags.steps) {
        throw new ReferenceError(
            "TimingFunction.steps is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TimingFunction.Tags.steps;
      this.$data = value;
    }
  });
  Object.defineProperty(TimingFunction.prototype, "linear", {
    get: function() {
      if (this.$tag != TimingFunction.Tags.linear) {
        throw new ReferenceError(
            "TimingFunction.linear is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TimingFunction.Tags.linear;
      this.$data = value;
    }
  });


    TimingFunction.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TimingFunction.Tags.cubicBezier:
          encoder.encodeStructPointer(CubicBezierTimingFunction, val.cubicBezier);
          break;
        case TimingFunction.Tags.steps:
          encoder.encodeStructPointer(StepsTimingFunction, val.steps);
          break;
        case TimingFunction.Tags.linear:
          encoder.encodeArrayPointer(new codec.PointerTo(LinearEasingPoint), val.linear);
          break;
      }
      encoder.align();
    };


    TimingFunction.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TimingFunction();
      var tag = decoder.readUint32();
      switch (tag) {
        case TimingFunction.Tags.cubicBezier:
          result.cubicBezier = decoder.decodeStructPointer(CubicBezierTimingFunction);
          break;
        case TimingFunction.Tags.steps:
          result.steps = decoder.decodeStructPointer(StepsTimingFunction);
          break;
        case TimingFunction.Tags.linear:
          result.linear = decoder.decodeArrayPointer(new codec.PointerTo(LinearEasingPoint));
          break;
      }
      decoder.align();

      return result;
    };


    TimingFunction.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TimingFunction.Tags.cubicBezier:
          

    // validate TimingFunction.cubicBezier
    err = messageValidator.validateStructPointer(data_offset, CubicBezierTimingFunction, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TimingFunction.Tags.steps:
          

    // validate TimingFunction.steps
    err = messageValidator.validateStructPointer(data_offset, StepsTimingFunction, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TimingFunction.Tags.linear:
          

    // validate TimingFunction.linear
    err = messageValidator.validateArrayPointer(data_offset, 8, new codec.PointerTo(LinearEasingPoint), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TimingFunction.encodedSize = 16;

  function TransformOperation(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  TransformOperation.Tags = {
    identity: 0,
    perspectiveDepth: 1,
    skew: 2,
    scale: 3,
    translate: 4,
    rotate: 5,
    matrix: 6,
  };

  TransformOperation.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  TransformOperation.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "identity",
        "perspectiveDepth",
        "skew",
        "scale",
        "translate",
        "rotate",
        "matrix",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a TransformOperation member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(TransformOperation.prototype, "identity", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.identity) {
        throw new ReferenceError(
            "TransformOperation.identity is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.identity;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "perspectiveDepth", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.perspectiveDepth) {
        throw new ReferenceError(
            "TransformOperation.perspectiveDepth is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.perspectiveDepth;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "skew", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.skew) {
        throw new ReferenceError(
            "TransformOperation.skew is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.skew;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "scale", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.scale) {
        throw new ReferenceError(
            "TransformOperation.scale is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.scale;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "translate", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.translate) {
        throw new ReferenceError(
            "TransformOperation.translate is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.translate;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "rotate", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.rotate) {
        throw new ReferenceError(
            "TransformOperation.rotate is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.rotate;
      this.$data = value;
    }
  });
  Object.defineProperty(TransformOperation.prototype, "matrix", {
    get: function() {
      if (this.$tag != TransformOperation.Tags.matrix) {
        throw new ReferenceError(
            "TransformOperation.matrix is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = TransformOperation.Tags.matrix;
      this.$data = value;
    }
  });


    TransformOperation.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case TransformOperation.Tags.identity:
          encoder.writeUint8(val.identity ? 1 : 0);
          break;
        case TransformOperation.Tags.perspectiveDepth:
          encoder.encodeStruct(codec.Float, val.perspectiveDepth);
          break;
        case TransformOperation.Tags.skew:
          encoder.encodeStructPointer(geometry$.Vector2dF, val.skew);
          break;
        case TransformOperation.Tags.scale:
          encoder.encodeStructPointer(geometry$.Vector3dF, val.scale);
          break;
        case TransformOperation.Tags.translate:
          encoder.encodeStructPointer(geometry$.Vector3dF, val.translate);
          break;
        case TransformOperation.Tags.rotate:
          encoder.encodeStructPointer(AxisAngle, val.rotate);
          break;
        case TransformOperation.Tags.matrix:
          encoder.encodeStructPointer(transform$.Transform, val.matrix);
          break;
      }
      encoder.align();
    };


    TransformOperation.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new TransformOperation();
      var tag = decoder.readUint32();
      switch (tag) {
        case TransformOperation.Tags.identity:
          result.identity = decoder.readUint8() ? true : false;
          break;
        case TransformOperation.Tags.perspectiveDepth:
          result.perspectiveDepth = decoder.decodeStruct(codec.Float);
          break;
        case TransformOperation.Tags.skew:
          result.skew = decoder.decodeStructPointer(geometry$.Vector2dF);
          break;
        case TransformOperation.Tags.scale:
          result.scale = decoder.decodeStructPointer(geometry$.Vector3dF);
          break;
        case TransformOperation.Tags.translate:
          result.translate = decoder.decodeStructPointer(geometry$.Vector3dF);
          break;
        case TransformOperation.Tags.rotate:
          result.rotate = decoder.decodeStructPointer(AxisAngle);
          break;
        case TransformOperation.Tags.matrix:
          result.matrix = decoder.decodeStructPointer(transform$.Transform);
          break;
      }
      decoder.align();

      return result;
    };


    TransformOperation.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case TransformOperation.Tags.identity:
          

          break;
        case TransformOperation.Tags.perspectiveDepth:
          

          break;
        case TransformOperation.Tags.skew:
          

    // validate TransformOperation.skew
    err = messageValidator.validateStructPointer(data_offset, geometry$.Vector2dF, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransformOperation.Tags.scale:
          

    // validate TransformOperation.scale
    err = messageValidator.validateStructPointer(data_offset, geometry$.Vector3dF, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransformOperation.Tags.translate:
          

    // validate TransformOperation.translate
    err = messageValidator.validateStructPointer(data_offset, geometry$.Vector3dF, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransformOperation.Tags.rotate:
          

    // validate TransformOperation.rotate
    err = messageValidator.validateStructPointer(data_offset, AxisAngle, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case TransformOperation.Tags.matrix:
          

    // validate TransformOperation.matrix
    err = messageValidator.validateStructPointer(data_offset, transform$.Transform, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  TransformOperation.encodedSize = 16;

  function AnimationKeyframeValue(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  AnimationKeyframeValue.Tags = {
    scalar: 0,
    color: 1,
    size: 2,
    rect: 3,
    transform: 4,
  };

  AnimationKeyframeValue.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  AnimationKeyframeValue.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "scalar",
        "color",
        "size",
        "rect",
        "transform",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a AnimationKeyframeValue member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(AnimationKeyframeValue.prototype, "scalar", {
    get: function() {
      if (this.$tag != AnimationKeyframeValue.Tags.scalar) {
        throw new ReferenceError(
            "AnimationKeyframeValue.scalar is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AnimationKeyframeValue.Tags.scalar;
      this.$data = value;
    }
  });
  Object.defineProperty(AnimationKeyframeValue.prototype, "color", {
    get: function() {
      if (this.$tag != AnimationKeyframeValue.Tags.color) {
        throw new ReferenceError(
            "AnimationKeyframeValue.color is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AnimationKeyframeValue.Tags.color;
      this.$data = value;
    }
  });
  Object.defineProperty(AnimationKeyframeValue.prototype, "size", {
    get: function() {
      if (this.$tag != AnimationKeyframeValue.Tags.size) {
        throw new ReferenceError(
            "AnimationKeyframeValue.size is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AnimationKeyframeValue.Tags.size;
      this.$data = value;
    }
  });
  Object.defineProperty(AnimationKeyframeValue.prototype, "rect", {
    get: function() {
      if (this.$tag != AnimationKeyframeValue.Tags.rect) {
        throw new ReferenceError(
            "AnimationKeyframeValue.rect is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AnimationKeyframeValue.Tags.rect;
      this.$data = value;
    }
  });
  Object.defineProperty(AnimationKeyframeValue.prototype, "transform", {
    get: function() {
      if (this.$tag != AnimationKeyframeValue.Tags.transform) {
        throw new ReferenceError(
            "AnimationKeyframeValue.transform is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = AnimationKeyframeValue.Tags.transform;
      this.$data = value;
    }
  });


    AnimationKeyframeValue.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case AnimationKeyframeValue.Tags.scalar:
          encoder.encodeStruct(codec.Float, val.scalar);
          break;
        case AnimationKeyframeValue.Tags.color:
          encoder.encodeStructPointer(skcolor$.SkColor, val.color);
          break;
        case AnimationKeyframeValue.Tags.size:
          encoder.encodeStructPointer(geometry$.SizeF, val.size);
          break;
        case AnimationKeyframeValue.Tags.rect:
          encoder.encodeStructPointer(geometry$.Rect, val.rect);
          break;
        case AnimationKeyframeValue.Tags.transform:
          encoder.encodeArrayPointer(TransformOperation, val.transform);
          break;
      }
      encoder.align();
    };


    AnimationKeyframeValue.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new AnimationKeyframeValue();
      var tag = decoder.readUint32();
      switch (tag) {
        case AnimationKeyframeValue.Tags.scalar:
          result.scalar = decoder.decodeStruct(codec.Float);
          break;
        case AnimationKeyframeValue.Tags.color:
          result.color = decoder.decodeStructPointer(skcolor$.SkColor);
          break;
        case AnimationKeyframeValue.Tags.size:
          result.size = decoder.decodeStructPointer(geometry$.SizeF);
          break;
        case AnimationKeyframeValue.Tags.rect:
          result.rect = decoder.decodeStructPointer(geometry$.Rect);
          break;
        case AnimationKeyframeValue.Tags.transform:
          result.transform = decoder.decodeArrayPointer(TransformOperation);
          break;
      }
      decoder.align();

      return result;
    };


    AnimationKeyframeValue.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case AnimationKeyframeValue.Tags.scalar:
          

          break;
        case AnimationKeyframeValue.Tags.color:
          

    // validate AnimationKeyframeValue.color
    err = messageValidator.validateStructPointer(data_offset, skcolor$.SkColor, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AnimationKeyframeValue.Tags.size:
          

    // validate AnimationKeyframeValue.size
    err = messageValidator.validateStructPointer(data_offset, geometry$.SizeF, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AnimationKeyframeValue.Tags.rect:
          

    // validate AnimationKeyframeValue.rect
    err = messageValidator.validateStructPointer(data_offset, geometry$.Rect, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case AnimationKeyframeValue.Tags.transform:
          

    // validate AnimationKeyframeValue.transform
    err = messageValidator.validateArrayPointer(data_offset, 16, TransformOperation, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  AnimationKeyframeValue.encodedSize = 16;
  exports.TimingStepPosition = TimingStepPosition;
  exports.AnimationDirection = AnimationDirection;
  exports.AnimationFillMode = AnimationFillMode;
  exports.CubicBezierTimingFunction = CubicBezierTimingFunction;
  exports.StepsTimingFunction = StepsTimingFunction;
  exports.LinearEasingPoint = LinearEasingPoint;
  exports.AxisAngle = AxisAngle;
  exports.AnimationKeyframe = AnimationKeyframe;
  exports.AnimationKeyframeModel = AnimationKeyframeModel;
  exports.Animation = Animation;
  exports.AnimationTimeline = AnimationTimeline;
  exports.TimingFunction = TimingFunction;
  exports.TransformOperation = TransformOperation;
  exports.AnimationKeyframeValue = AnimationKeyframeValue;
})();