// services/viz/privileged/mojom/viz_main.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/privileged/mojom/viz_main.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/viz_main.mojom-params-data.h"
#include "services/viz/privileged/mojom/viz_main.mojom-shared-message-ids.h"

#include "services/viz/privileged/mojom/viz_main.mojom-import-headers.h"
#include "services/viz/privileged/mojom/viz_main.mojom-test-utils.h"


namespace viz::mojom {
FrameSinkManagerParams::FrameSinkManagerParams()
    : restart_id(),
      use_activation_deadline(true),
      activation_deadline_in_frames(4U),
      frame_sink_manager(),
      frame_sink_manager_client(),
      debug_renderer_settings() {}

FrameSinkManagerParams::FrameSinkManagerParams(
    uint32_t restart_id_in,
    bool use_activation_deadline_in,
    uint32_t activation_deadline_in_frames_in,
    ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager> frame_sink_manager_in,
    ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient> frame_sink_manager_client_in,
    const ::viz::DebugRendererSettings& debug_renderer_settings_in)
    : restart_id(std::move(restart_id_in)),
      use_activation_deadline(std::move(use_activation_deadline_in)),
      activation_deadline_in_frames(std::move(activation_deadline_in_frames_in)),
      frame_sink_manager(std::move(frame_sink_manager_in)),
      frame_sink_manager_client(std::move(frame_sink_manager_client_in)),
      debug_renderer_settings(std::move(debug_renderer_settings_in)) {}

FrameSinkManagerParams::~FrameSinkManagerParams() = default;

void FrameSinkManagerParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "restart_id"), this->restart_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_activation_deadline"), this->use_activation_deadline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "activation_deadline_in_frames"), this->activation_deadline_in_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_manager"), this->frame_sink_manager,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<::viz::mojom::FrameSinkManager>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_sink_manager_client"), this->frame_sink_manager_client,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::viz::mojom::FrameSinkManagerClient>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_renderer_settings"), this->debug_renderer_settings,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::DebugRendererSettings&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FrameSinkManagerParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GpuServiceCreationParams::GpuServiceCreationParams() {}

GpuServiceCreationParams::~GpuServiceCreationParams() = default;
size_t GpuServiceCreationParams::Hash(size_t seed) const {
  return seed;
}

void GpuServiceCreationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool GpuServiceCreationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

VizMain::IPCStableHashFunction VizMain::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VizMain>(message.name())) {
    case messages::VizMain::kCreateFrameSinkManager: {
      return &VizMain::CreateFrameSinkManager_Sym::IPCStableHash;
    }
    case messages::VizMain::kCreateGpuService: {
      return &VizMain::CreateGpuService_Sym::IPCStableHash;
    }
    case messages::VizMain::kSetRenderParams: {
      return &VizMain::SetRenderParams_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VizMain::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VizMain>(message.name())) {
      case messages::VizMain::kCreateFrameSinkManager:
            return "Receive viz::mojom::VizMain::CreateFrameSinkManager";
      case messages::VizMain::kCreateGpuService:
            return "Receive viz::mojom::VizMain::CreateGpuService";
      case messages::VizMain::kSetRenderParams:
            return "Receive viz::mojom::VizMain::SetRenderParams";
    }
  } else {
    switch (static_cast<messages::VizMain>(message.name())) {
      case messages::VizMain::kCreateFrameSinkManager:
            return "Receive reply viz::mojom::VizMain::CreateFrameSinkManager";
      case messages::VizMain::kCreateGpuService:
            return "Receive reply viz::mojom::VizMain::CreateGpuService";
      case messages::VizMain::kSetRenderParams:
            return "Receive reply viz::mojom::VizMain::SetRenderParams";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VizMain::CreateFrameSinkManager_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ba8c66b;  // IPCStableHash for viz::mojom::VizMain::CreateFrameSinkManager
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VizMain::CreateGpuService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ae288e1;  // IPCStableHash for viz::mojom::VizMain::CreateGpuService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t VizMain::SetRenderParams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41e0472f;  // IPCStableHash for viz::mojom::VizMain::SetRenderParams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

VizMainProxy::VizMainProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VizMainProxy::CreateFrameSinkManager(
    FrameSinkManagerParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::VizMain::CreateFrameSinkManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type FrameSinkManagerParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VizMain::kCreateFrameSinkManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VizMain_CreateFrameSinkManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::FrameSinkManagerParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in VizMain.CreateFrameSinkManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VizMain::Name_);
  message.set_method_name("CreateFrameSinkManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VizMainProxy::CreateGpuService(
    ::mojo::PendingReceiver<::viz::mojom::GpuService> in_gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> in_gpu_host, ::mojo::PendingRemote<::viz::mojom::GpuLogging> in_gpu_logging, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> in_discardable_memory_manager, ::base::UnsafeSharedMemoryRegion in_use_shader_cache_shm_count, GpuServiceCreationParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::VizMain::CreateGpuService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_service"), in_gpu_service,
                        "<value of type ::mojo::PendingReceiver<::viz::mojom::GpuService>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_host"), in_gpu_host,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::GpuHost>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gpu_logging"), in_gpu_logging,
                        "<value of type ::mojo::PendingRemote<::viz::mojom::GpuLogging>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("discardable_memory_manager"), in_discardable_memory_manager,
                        "<value of type ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_shader_cache_shm_count"), in_use_shader_cache_shm_count,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type GpuServiceCreationParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VizMain::kCreateGpuService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VizMain_CreateGpuService_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::GpuServiceInterfaceBase>>(
    in_gpu_service,
    &params->gpu_service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->gpu_service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid gpu_service in VizMain.CreateGpuService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::GpuHostInterfaceBase>>(
    in_gpu_host,
    &params->gpu_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->gpu_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid gpu_host in VizMain.CreateGpuService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::GpuLoggingInterfaceBase>>(
    in_gpu_logging,
    &params->gpu_logging,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->gpu_logging)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid gpu_logging in VizMain.CreateGpuService request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::discardable_memory::mojom::DiscardableSharedMemoryManagerInterfaceBase>>(
    in_discardable_memory_manager,
    &params->discardable_memory_manager,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->discardable_memory_manager)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid discardable_memory_manager in VizMain.CreateGpuService request");
  mojo::internal::MessageFragment<
      typename decltype(params->use_shader_cache_shm_count)::BaseType> use_shader_cache_shm_count_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
    in_use_shader_cache_shm_count,
    use_shader_cache_shm_count_fragment);

  params->use_shader_cache_shm_count.Set(
      use_shader_cache_shm_count_fragment.is_null() ? nullptr : use_shader_cache_shm_count_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::viz::mojom::GpuServiceCreationParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in VizMain.CreateGpuService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VizMain::Name_);
  message.set_method_name("CreateGpuService");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void VizMainProxy::SetRenderParams(
    ::gfx::FontRenderParams::SubpixelRendering in_subpixel_rendering, float in_text_contrast, float in_text_gamma) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send viz::mojom::VizMain::SetRenderParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subpixel_rendering"), in_subpixel_rendering,
                        "<value of type ::gfx::FontRenderParams::SubpixelRendering>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_contrast"), in_text_contrast,
                        "<value of type float>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("text_gamma"), in_text_gamma,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VizMain::kSetRenderParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::viz::mojom::internal::VizMain_SetRenderParams_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::gfx::mojom::SubpixelRendering>(
    in_subpixel_rendering,
    &params->subpixel_rendering);

  params->text_contrast = in_text_contrast;

  params->text_gamma = in_text_gamma;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VizMain::Name_);
  message.set_method_name("SetRenderParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool VizMainStubDispatch::Accept(
    VizMain* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VizMain>(message->header()->name)) {
    case messages::VizMain::kCreateFrameSinkManager: {
      DCHECK(message->is_serialized());
      internal::VizMain_CreateFrameSinkManager_Params_Data* params =
          reinterpret_cast<internal::VizMain_CreateFrameSinkManager_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VizMain.0
      bool success = true;
      FrameSinkManagerParamsPtr p_params{};
      VizMain_CreateFrameSinkManager_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VizMain::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFrameSinkManager(        
        std::move(p_params));
      return true;
    }
    case messages::VizMain::kCreateGpuService: {
      DCHECK(message->is_serialized());
      internal::VizMain_CreateGpuService_Params_Data* params =
          reinterpret_cast<internal::VizMain_CreateGpuService_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VizMain.1
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::GpuService> p_gpu_service{};
      ::mojo::PendingRemote<::viz::mojom::GpuHost> p_gpu_host{};
      ::mojo::PendingRemote<::viz::mojom::GpuLogging> p_gpu_logging{};
      ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> p_discardable_memory_manager{};
      ::base::UnsafeSharedMemoryRegion p_use_shader_cache_shm_count{};
      GpuServiceCreationParamsPtr p_params{};
      VizMain_CreateGpuService_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_gpu_service =
            input_data_view.TakeGpuService<decltype(p_gpu_service)>();
      }
      if (success) {
        p_gpu_host =
            input_data_view.TakeGpuHost<decltype(p_gpu_host)>();
      }
      if (success) {
        p_gpu_logging =
            input_data_view.TakeGpuLogging<decltype(p_gpu_logging)>();
      }
      if (success) {
        p_discardable_memory_manager =
            input_data_view.TakeDiscardableMemoryManager<decltype(p_discardable_memory_manager)>();
      }
      if (success && !input_data_view.ReadUseShaderCacheShmCount(&p_use_shader_cache_shm_count))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VizMain::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuService(        
        std::move(p_gpu_service), 
        std::move(p_gpu_host), 
        std::move(p_gpu_logging), 
        std::move(p_discardable_memory_manager), 
        std::move(p_use_shader_cache_shm_count), 
        std::move(p_params));
      return true;
    }
    case messages::VizMain::kSetRenderParams: {
      DCHECK(message->is_serialized());
      internal::VizMain_SetRenderParams_Params_Data* params =
          reinterpret_cast<internal::VizMain_SetRenderParams_Params_Data*>(
              message->mutable_payload());
      

      // Validation for VizMain.2
      bool success = true;
      ::gfx::FontRenderParams::SubpixelRendering p_subpixel_rendering{};
      float p_text_contrast{};
      float p_text_gamma{};
      VizMain_SetRenderParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubpixelRendering(&p_subpixel_rendering))
        success = false;
      if (success)
        p_text_contrast = input_data_view.text_contrast();
      if (success)
        p_text_gamma = input_data_view.text_gamma();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VizMain::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRenderParams(        
        std::move(p_subpixel_rendering), 
        std::move(p_text_contrast), 
        std::move(p_text_gamma));
      return true;
    }
  }
  return false;
}

// static
bool VizMainStubDispatch::AcceptWithResponder(
    VizMain* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VizMain>(message->header()->name)) {
    case messages::VizMain::kCreateFrameSinkManager: {
      break;
    }
    case messages::VizMain::kCreateGpuService: {
      break;
    }
    case messages::VizMain::kSetRenderParams: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kVizMainValidationInfo[] = {
    { &internal::VizMain_CreateFrameSinkManager_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VizMain_CreateGpuService_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::VizMain_SetRenderParams_Params_Data::Validate,
     nullptr /* no response */},
};

bool VizMainRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::viz::mojom::VizMain::Name_,
    kVizMainValidationInfo);
}



}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::FrameSinkManagerParams::DataView, ::viz::mojom::FrameSinkManagerParamsPtr>::Read(
    ::viz::mojom::FrameSinkManagerParams::DataView input,
    ::viz::mojom::FrameSinkManagerParamsPtr* output) {
  bool success = true;
  ::viz::mojom::FrameSinkManagerParamsPtr result(::viz::mojom::FrameSinkManagerParams::New());
  
      if (success)
        result->restart_id = input.restart_id();
      if (success)
        result->use_activation_deadline = input.use_activation_deadline();
      if (success)
        result->activation_deadline_in_frames = input.activation_deadline_in_frames();
      if (success) {
        result->frame_sink_manager =
            input.TakeFrameSinkManager<decltype(result->frame_sink_manager)>();
      }
      if (success) {
        result->frame_sink_manager_client =
            input.TakeFrameSinkManagerClient<decltype(result->frame_sink_manager_client)>();
      }
      if (success && !input.ReadDebugRendererSettings(&result->debug_renderer_settings))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::viz::mojom::GpuServiceCreationParams::DataView, ::viz::mojom::GpuServiceCreationParamsPtr>::Read(
    ::viz::mojom::GpuServiceCreationParams::DataView input,
    ::viz::mojom::GpuServiceCreationParamsPtr* output) {
  bool success = true;
  ::viz::mojom::GpuServiceCreationParamsPtr result(::viz::mojom::GpuServiceCreationParams::New());
  
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {


void VizMainInterceptorForTesting::CreateFrameSinkManager(FrameSinkManagerParamsPtr params) {
  GetForwardingInterface()->CreateFrameSinkManager(
    std::move(params)
    );
}
void VizMainInterceptorForTesting::CreateGpuService(::mojo::PendingReceiver<::viz::mojom::GpuService> gpu_service, ::mojo::PendingRemote<::viz::mojom::GpuHost> gpu_host, ::mojo::PendingRemote<::viz::mojom::GpuLogging> gpu_logging, ::mojo::PendingRemote<::discardable_memory::mojom::DiscardableSharedMemoryManager> discardable_memory_manager, ::base::UnsafeSharedMemoryRegion use_shader_cache_shm_count, GpuServiceCreationParamsPtr params) {
  GetForwardingInterface()->CreateGpuService(
    std::move(gpu_service)
    , 
    std::move(gpu_host)
    , 
    std::move(gpu_logging)
    , 
    std::move(discardable_memory_manager)
    , 
    std::move(use_shader_cache_shm_count)
    , 
    std::move(params)
    );
}
void VizMainInterceptorForTesting::SetRenderParams(::gfx::FontRenderParams::SubpixelRendering subpixel_rendering, float text_contrast, float text_gamma) {
  GetForwardingInterface()->SetRenderParams(
    std::move(subpixel_rendering)
    , 
    std::move(text_contrast)
    , 
    std::move(text_gamma)
    );
}
VizMainAsyncWaiter::VizMainAsyncWaiter(
    VizMain* proxy) : proxy_(proxy) {}

VizMainAsyncWaiter::~VizMainAsyncWaiter() = default;







}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif