// services/viz/privileged/mojom/viz_main.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/privileged/mojom/viz_main.mojom-shared-internal.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"
#include "components/viz/service/debugger/mojom/viz_debugger.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_logging.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/viz/privileged/mojom/viz_main.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameSinkManagerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameSinkManagerParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::FrameSinkManagerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->restart_id = Traits::restart_id(input);

    fragment->use_activation_deadline = Traits::use_activation_deadline(input);

    fragment->activation_deadline_in_frames = Traits::activation_deadline_in_frames(input);

    decltype(Traits::frame_sink_manager(input)) in_frame_sink_manager = Traits::frame_sink_manager(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerInterfaceBase>>(
      in_frame_sink_manager,
      &fragment->frame_sink_manager,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_sink_manager)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_sink_manager in FrameSinkManagerParams struct");

    decltype(Traits::frame_sink_manager_client(input)) in_frame_sink_manager_client = Traits::frame_sink_manager_client(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkManagerClientInterfaceBase>>(
      in_frame_sink_manager_client,
      &fragment->frame_sink_manager_client,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->frame_sink_manager_client)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_sink_manager_client in FrameSinkManagerParams struct");

    decltype(Traits::debug_renderer_settings(input)) in_debug_renderer_settings = Traits::debug_renderer_settings(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_renderer_settings)::BaseType> debug_renderer_settings_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::viz::mojom::DebugRendererSettingsDataView>(
      in_debug_renderer_settings,
      debug_renderer_settings_fragment);

    fragment->debug_renderer_settings.Set(
        debug_renderer_settings_fragment.is_null() ? nullptr : debug_renderer_settings_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_renderer_settings.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_renderer_settings in FrameSinkManagerParams struct");
  }

  static bool Deserialize(::viz::mojom::internal::FrameSinkManagerParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameSinkManagerParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::GpuServiceCreationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::GpuServiceCreationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::GpuServiceCreationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::viz::mojom::internal::GpuServiceCreationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::GpuServiceCreationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void FrameSinkManagerParamsDataView::GetDebugRendererSettingsDataView(
    ::viz::mojom::DebugRendererSettingsDataView* output) {
  auto pointer = data_->debug_renderer_settings.Get();
  *output = ::viz::mojom::DebugRendererSettingsDataView(pointer, message_);
}





}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_