// services/viz/privileged/mojom/gl/gpu_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/privileged/mojom/gl/gpu_service.mojom-params-data.h"
namespace viz {
namespace mojom {

namespace internal {


// static
bool GpuService_EstablishGpuChannel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_EstablishGpuChannel_Params_Data* object =
      static_cast<const GpuService_EstablishGpuChannel_Params_Data*>(data);

  return true;
}

GpuService_EstablishGpuChannel_Params_Data::GpuService_EstablishGpuChannel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_EstablishGpuChannel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_EstablishGpuChannel_ResponseParams_Data* object =
      static_cast<const GpuService_EstablishGpuChannel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->channel_handle,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_feature_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_feature_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_image_capabilities, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_image_capabilities, validation_context))
    return false;

  return true;
}

GpuService_EstablishGpuChannel_ResponseParams_Data::GpuService_EstablishGpuChannel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_SetChannelClientPid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_SetChannelClientPid_Params_Data* object =
      static_cast<const GpuService_SetChannelClientPid_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_pid, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_pid, validation_context))
    return false;

  return true;
}

GpuService_SetChannelClientPid_Params_Data::GpuService_SetChannelClientPid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_SetChannelDiskCacheHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_SetChannelDiskCacheHandle_Params_Data* object =
      static_cast<const GpuService_SetChannelDiskCacheHandle_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->cache_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->cache_handle, validation_context))
    return false;

  return true;
}

GpuService_SetChannelDiskCacheHandle_Params_Data::GpuService_SetChannelDiskCacheHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_SetChannelPersistentCacheFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_SetChannelPersistentCacheFile_Params_Data* object =
      static_cast<const GpuService_SetChannelPersistentCacheFile_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->cache_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->cache_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->db_file, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->db_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->journal_file, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->journal_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->shared_lock, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->shared_lock, validation_context))
    return false;

  return true;
}

GpuService_SetChannelPersistentCacheFile_Params_Data::GpuService_SetChannelPersistentCacheFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_OnDiskCacheHandleDestoyed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_OnDiskCacheHandleDestoyed_Params_Data* object =
      static_cast<const GpuService_OnDiskCacheHandleDestoyed_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->cache_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->cache_handle, validation_context))
    return false;

  return true;
}

GpuService_OnDiskCacheHandleDestoyed_Params_Data::GpuService_OnDiskCacheHandleDestoyed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_CloseChannel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_CloseChannel_Params_Data* object =
      static_cast<const GpuService_CloseChannel_Params_Data*>(data);

  return true;
}

GpuService_CloseChannel_Params_Data::GpuService_CloseChannel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data* object =
      static_cast<const GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->vea_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->vea_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data::GpuService_CreateVideoEncodeAcceleratorProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_BindWebNNContextProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_BindWebNNContextProvider_Params_Data* object =
      static_cast<const GpuService_BindWebNNContextProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

GpuService_BindWebNNContextProvider_Params_Data::GpuService_BindWebNNContextProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetVideoMemoryUsageStats_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetVideoMemoryUsageStats_Params_Data* object =
      static_cast<const GpuService_GetVideoMemoryUsageStats_Params_Data*>(data);

  return true;
}

GpuService_GetVideoMemoryUsageStats_Params_Data::GpuService_GetVideoMemoryUsageStats_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetVideoMemoryUsageStats_ResponseParams_Data* object =
      static_cast<const GpuService_GetVideoMemoryUsageStats_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->stats, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->stats, validation_context))
    return false;

  return true;
}

GpuService_GetVideoMemoryUsageStats_ResponseParams_Data::GpuService_GetVideoMemoryUsageStats_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_StartPeakMemoryMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_StartPeakMemoryMonitor_Params_Data* object =
      static_cast<const GpuService_StartPeakMemoryMonitor_Params_Data*>(data);

  return true;
}

GpuService_StartPeakMemoryMonitor_Params_Data::GpuService_StartPeakMemoryMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetPeakMemoryUsage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetPeakMemoryUsage_Params_Data* object =
      static_cast<const GpuService_GetPeakMemoryUsage_Params_Data*>(data);

  return true;
}

GpuService_GetPeakMemoryUsage_Params_Data::GpuService_GetPeakMemoryUsage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetPeakMemoryUsage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetPeakMemoryUsage_ResponseParams_Data* object =
      static_cast<const GpuService_GetPeakMemoryUsage_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory_per_allocation_source, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& memory_per_allocation_source_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::gpu::mojom::internal::GpuPeakMemoryAllocationSource_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->memory_per_allocation_source, validation_context,
                                         &memory_per_allocation_source_validate_params)) {
    return false;
  }

  return true;
}

GpuService_GetPeakMemoryUsage_ResponseParams_Data::GpuService_GetPeakMemoryUsage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_LoadedBlob_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_LoadedBlob_Params_Data* object =
      static_cast<const GpuService_LoadedBlob_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->cache_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->cache_handle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

GpuService_LoadedBlob_Params_Data::GpuService_LoadedBlob_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_WakeUpGpu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_WakeUpGpu_Params_Data* object =
      static_cast<const GpuService_WakeUpGpu_Params_Data*>(data);

  return true;
}

GpuService_WakeUpGpu_Params_Data::GpuService_WakeUpGpu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GpuSwitched_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GpuSwitched_Params_Data* object =
      static_cast<const GpuService_GpuSwitched_Params_Data*>(data);

  return true;
}

GpuService_GpuSwitched_Params_Data::GpuService_GpuSwitched_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_DisplayAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_DisplayAdded_Params_Data* object =
      static_cast<const GpuService_DisplayAdded_Params_Data*>(data);

  return true;
}

GpuService_DisplayAdded_Params_Data::GpuService_DisplayAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_DisplayRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_DisplayRemoved_Params_Data* object =
      static_cast<const GpuService_DisplayRemoved_Params_Data*>(data);

  return true;
}

GpuService_DisplayRemoved_Params_Data::GpuService_DisplayRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_DisplayMetricsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_DisplayMetricsChanged_Params_Data* object =
      static_cast<const GpuService_DisplayMetricsChanged_Params_Data*>(data);

  return true;
}

GpuService_DisplayMetricsChanged_Params_Data::GpuService_DisplayMetricsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_DestroyAllChannels_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_DestroyAllChannels_Params_Data* object =
      static_cast<const GpuService_DestroyAllChannels_Params_Data*>(data);

  return true;
}

GpuService_DestroyAllChannels_Params_Data::GpuService_DestroyAllChannels_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_OnBackgroundCleanup_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_OnBackgroundCleanup_Params_Data* object =
      static_cast<const GpuService_OnBackgroundCleanup_Params_Data*>(data);

  return true;
}

GpuService_OnBackgroundCleanup_Params_Data::GpuService_OnBackgroundCleanup_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_OnBackgrounded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_OnBackgrounded_Params_Data* object =
      static_cast<const GpuService_OnBackgrounded_Params_Data*>(data);

  return true;
}

GpuService_OnBackgrounded_Params_Data::GpuService_OnBackgrounded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_OnForegrounded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_OnForegrounded_Params_Data* object =
      static_cast<const GpuService_OnForegrounded_Params_Data*>(data);

  return true;
}

GpuService_OnForegrounded_Params_Data::GpuService_OnForegrounded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_OnMemoryPressure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_OnMemoryPressure_Params_Data* object =
      static_cast<const GpuService_OnMemoryPressure_Params_Data*>(data);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->level, validation_context))
    return false;

  return true;
}

GpuService_OnMemoryPressure_Params_Data::GpuService_OnMemoryPressure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_BeginCATransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_BeginCATransaction_Params_Data* object =
      static_cast<const GpuService_BeginCATransaction_Params_Data*>(data);

  return true;
}

GpuService_BeginCATransaction_Params_Data::GpuService_BeginCATransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_CommitCATransaction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_CommitCATransaction_Params_Data* object =
      static_cast<const GpuService_CommitCATransaction_Params_Data*>(data);

  return true;
}

GpuService_CommitCATransaction_Params_Data::GpuService_CommitCATransaction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_CommitCATransaction_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_CommitCATransaction_ResponseParams_Data* object =
      static_cast<const GpuService_CommitCATransaction_ResponseParams_Data*>(data);

  return true;
}

GpuService_CommitCATransaction_ResponseParams_Data::GpuService_CommitCATransaction_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetDawnInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetDawnInfo_Params_Data* object =
      static_cast<const GpuService_GetDawnInfo_Params_Data*>(data);

  return true;
}

GpuService_GetDawnInfo_Params_Data::GpuService_GetDawnInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_GetDawnInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_GetDawnInfo_ResponseParams_Data* object =
      static_cast<const GpuService_GetDawnInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dawn_info_list, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dawn_info_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->dawn_info_list, validation_context,
                                         &dawn_info_list_validate_params)) {
    return false;
  }

  return true;
}

GpuService_GetDawnInfo_ResponseParams_Data::GpuService_GetDawnInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_Crash_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_Crash_Params_Data* object =
      static_cast<const GpuService_Crash_Params_Data*>(data);

  return true;
}

GpuService_Crash_Params_Data::GpuService_Crash_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_Hang_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_Hang_Params_Data* object =
      static_cast<const GpuService_Hang_Params_Data*>(data);

  return true;
}

GpuService_Hang_Params_Data::GpuService_Hang_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GpuService_ThrowJavaException_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GpuService_ThrowJavaException_Params_Data* object =
      static_cast<const GpuService_ThrowJavaException_Params_Data*>(data);

  return true;
}

GpuService_ThrowJavaException_Params_Data::GpuService_ThrowJavaException_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz