// services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_buffer.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/subtree_capture_id.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::viz::mojom::BufferFormatPreference, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::VideoCaptureTargetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::VideoCaptureTargetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::VideoCaptureTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView, send_validation>(
        in_frame_sink_id,
        frame_sink_id_fragment);

      fragment->frame_sink_id.Set(
          frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in VideoCaptureTarget struct");

      decltype(Traits::sub_target(input)) in_sub_target = Traits::sub_target(input);
      mojo::internal::MessageFragment<decltype(fragment->sub_target)>
          sub_target_fragment(fragment.message());
      sub_target_fragment.Claim(&fragment->sub_target);
      
      mojo::internal::Serialize<::viz::mojom::VideoCaptureSubTargetDataView, send_validation>(
        in_sub_target,
        sub_target_fragment,
        true);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::VideoCaptureSubTargetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::viz::mojom::VideoCaptureSubTargetDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::viz::mojom::internal::VideoCaptureSubTarget_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::viz::mojom::VideoCaptureSubTargetDataView::Tag::kSubtreeCaptureId: {
    decltype(Traits::subtree_capture_id(input))
    in_subtree_capture_id = Traits::subtree_capture_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_subtree_capture_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::viz::mojom::SubtreeCaptureIdDataView, send_validation>(
  in_subtree_capture_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null subtree_capture_id in VideoCaptureSubTarget union");
    fragment->data.f_subtree_capture_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::viz::mojom::VideoCaptureSubTargetDataView::Tag::kRegionCaptureCropId: {
    decltype(Traits::region_capture_crop_id(input))
    in_region_capture_crop_id = Traits::region_capture_crop_id(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_region_capture_crop_id)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::TokenDataView, send_validation>(
  in_region_capture_crop_id,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null region_capture_crop_id in VideoCaptureSubTarget union");
    fragment->data.f_region_capture_crop_id.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_VIDEO_CAPTURE_MOJOM_SEND_VALIDATION_H_