// services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SEND_VALIDATION_H_

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared-internal.h"
#include "gpu/ipc/common/surface_handle.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/display_private.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/external_begin_frame_controller.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/features.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager_test_api.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_video_capture.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sinks_metrics_recorder.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_request.mojom-shared.h"
#include "services/viz/public/mojom/compositing/copy_output_result.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom-shared.h"
#include "services/viz/public/mojom/compositing/video_detector_observer.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/aggregated_hit_test_region.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "components/input/render_input_router.mojom-shared.h"

#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::viz::mojom::RootCompositorFrameSinkParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::RootCompositorFrameSinkParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::RootCompositorFrameSinkParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::frame_sink_id(input)) in_frame_sink_id = Traits::frame_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_sink_id)::BaseType> frame_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView, send_validation>(
        in_frame_sink_id,
        frame_sink_id_fragment);

      fragment->frame_sink_id.Set(
          frame_sink_id_fragment.is_null() ? nullptr : frame_sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_sink_id in RootCompositorFrameSinkParams struct");

      decltype(Traits::widget(input)) in_widget = Traits::widget(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->widget)::BaseType> widget_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView, send_validation>(
        in_widget,
        widget_fragment);

      fragment->widget.Set(
          widget_fragment.is_null() ? nullptr : widget_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->widget.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null widget in RootCompositorFrameSinkParams struct");

      fragment->gpu_compositing = Traits::gpu_compositing(input);

      decltype(Traits::renderer_settings(input)) in_renderer_settings = Traits::renderer_settings(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->renderer_settings)::BaseType> renderer_settings_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::RendererSettingsDataView, send_validation>(
        in_renderer_settings,
        renderer_settings_fragment);

      fragment->renderer_settings.Set(
          renderer_settings_fragment.is_null() ? nullptr : renderer_settings_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->renderer_settings.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null renderer_settings in RootCompositorFrameSinkParams struct");

      fragment->send_swap_size_notifications = Traits::send_swap_size_notifications(input);

      fragment->disable_frame_rate_limit = Traits::disable_frame_rate_limit(input);

      decltype(Traits::compositor_frame_sink(input)) in_compositor_frame_sink = Traits::compositor_frame_sink(input);

      
      mojo::internal::Serialize<::viz::mojom::CompositorFrameSinkAssociatedRequestDataView>(
        in_compositor_frame_sink,
        &fragment->compositor_frame_sink,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->compositor_frame_sink)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid compositor_frame_sink in RootCompositorFrameSinkParams struct");

      decltype(Traits::compositor_frame_sink_client(input)) in_compositor_frame_sink_client = Traits::compositor_frame_sink_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositorFrameSinkClientInterfaceBase>>(
        in_compositor_frame_sink_client,
        &fragment->compositor_frame_sink_client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->compositor_frame_sink_client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid compositor_frame_sink_client in RootCompositorFrameSinkParams struct");

      decltype(Traits::display_private(input)) in_display_private = Traits::display_private(input);

      
      mojo::internal::Serialize<::viz::mojom::DisplayPrivateAssociatedRequestDataView>(
        in_display_private,
        &fragment->display_private,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->display_private)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid display_private in RootCompositorFrameSinkParams struct");

      decltype(Traits::display_client(input)) in_display_client = Traits::display_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::DisplayClientInterfaceBase>>(
        in_display_client,
        &fragment->display_client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->display_client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid display_client in RootCompositorFrameSinkParams struct");

      decltype(Traits::external_begin_frame_controller(input)) in_external_begin_frame_controller = Traits::external_begin_frame_controller(input);

      
      mojo::internal::Serialize<::viz::mojom::ExternalBeginFrameControllerAssociatedRequestDataView>(
        in_external_begin_frame_controller,
        &fragment->external_begin_frame_controller,
        &fragment.message());

      decltype(Traits::external_begin_frame_controller_client(input)) in_external_begin_frame_controller_client = Traits::external_begin_frame_controller_client(input);

      
      mojo::internal::Serialize<::viz::mojom::ExternalBeginFrameControllerClientAssociatedPtrInfoDataView>(
        in_external_begin_frame_controller_client,
        &fragment->external_begin_frame_controller_client,
        &fragment.message());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_COMPOSITING_FRAME_SINK_MANAGER_MOJOM_SEND_VALIDATION_H_