// services/video_capture/public/mojom/video_source.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/video_capture/public/mojom/video_source.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/video_source.mojom-params-data.h"
namespace video_capture {
namespace mojom {

NOINLINE static const char* CreatePushSubscriptionSuccessCodeToStringHelper(CreatePushSubscriptionSuccessCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CreatePushSubscriptionSuccessCode::kCreatedWithRequestedSettings:
      return "kCreatedWithRequestedSettings";
    case CreatePushSubscriptionSuccessCode::kCreatedWithDifferentSettings:
      return "kCreatedWithDifferentSettings";
    default:
      return nullptr;
  }
}

std::string CreatePushSubscriptionSuccessCodeToString(CreatePushSubscriptionSuccessCode value) {
  const char *str = CreatePushSubscriptionSuccessCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CreatePushSubscriptionSuccessCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CreatePushSubscriptionSuccessCode value) {
  return os << CreatePushSubscriptionSuccessCodeToString(value);
}

namespace internal {
// static
bool CreatePushSubscriptionResultCode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const CreatePushSubscriptionResultCode_Data* object = static_cast<const CreatePushSubscriptionResultCode_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case CreatePushSubscriptionResultCode_Tag::kSuccessCode: {


      if (!::video_capture::mojom::internal::CreatePushSubscriptionSuccessCode_Data
            ::Validate(object->data.f_success_code, validation_context))
        return false;
      return true;
    }
    case CreatePushSubscriptionResultCode_Tag::kErrorCode: {


      if (!::media::mojom::internal::VideoCaptureError_Data
            ::Validate(object->data.f_error_code, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in CreatePushSubscriptionResultCode");
      return false;
    }
  }
}


// static
bool PushVideoStreamSubscription_Activate_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Activate_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_Activate_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Activate_Params_Data::PushVideoStreamSubscription_Activate_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Suspend_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_Suspend_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Suspend_Params_Data::PushVideoStreamSubscription_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Suspend_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Suspend_ResponseParams_Data* object =
      static_cast<const PushVideoStreamSubscription_Suspend_ResponseParams_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Suspend_ResponseParams_Data::PushVideoStreamSubscription_Suspend_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Resume_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_Resume_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Resume_Params_Data::PushVideoStreamSubscription_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_GetPhotoState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_GetPhotoState_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_GetPhotoState_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_GetPhotoState_Params_Data::PushVideoStreamSubscription_GetPhotoState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data* object =
      static_cast<const PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->capabilities, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data::PushVideoStreamSubscription_GetPhotoState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_SetPhotoOptions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_SetPhotoOptions_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_SetPhotoOptions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->settings, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_SetPhotoOptions_Params_Data::PushVideoStreamSubscription_SetPhotoOptions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data* object =
      static_cast<const PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data*>(data);

  return true;
}

PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data::PushVideoStreamSubscription_SetPhotoOptions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_TakePhoto_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_TakePhoto_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_TakePhoto_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_TakePhoto_Params_Data::PushVideoStreamSubscription_TakePhoto_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_TakePhoto_ResponseParams_Data* object =
      static_cast<const PushVideoStreamSubscription_TakePhoto_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->blob, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_TakePhoto_ResponseParams_Data::PushVideoStreamSubscription_TakePhoto_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Close_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Close_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_Close_Params_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Close_Params_Data::PushVideoStreamSubscription_Close_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_Close_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_Close_ResponseParams_Data* object =
      static_cast<const PushVideoStreamSubscription_Close_ResponseParams_Data*>(data);

  return true;
}

PushVideoStreamSubscription_Close_ResponseParams_Data::PushVideoStreamSubscription_Close_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PushVideoStreamSubscription_ProcessFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PushVideoStreamSubscription_ProcessFeedback_Params_Data* object =
      static_cast<const PushVideoStreamSubscription_ProcessFeedback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->feedback, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->feedback, validation_context))
    return false;

  return true;
}

PushVideoStreamSubscription_ProcessFeedback_Params_Data::PushVideoStreamSubscription_ProcessFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSource_CreatePushSubscription_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSource_CreatePushSubscription_Params_Data* object =
      static_cast<const VideoSource_CreatePushSubscription_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscriber, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscriber,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_settings, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->requested_settings, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->subscription, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->subscription,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VideoSource_CreatePushSubscription_Params_Data::VideoSource_CreatePushSubscription_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VideoSource_CreatePushSubscription_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VideoSource_CreatePushSubscription_ResponseParams_Data* object =
      static_cast<const VideoSource_CreatePushSubscription_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result_code, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result_code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings_source_was_opened_with, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->settings_source_was_opened_with, validation_context))
    return false;

  return true;
}

VideoSource_CreatePushSubscription_ResponseParams_Data::VideoSource_CreatePushSubscription_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace video_capture

namespace perfetto {

// static
void TraceFormatTraits<::video_capture::mojom::CreatePushSubscriptionSuccessCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::video_capture::mojom::CreatePushSubscriptionSuccessCode value) {
  return std::move(context).WriteString(::video_capture::mojom::CreatePushSubscriptionSuccessCodeToString(value));
}

} // namespace perfetto