// services/video_capture/public/mojom/producer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_capture/public/mojom/producer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_capture/public/mojom/producer.mojom-params-data.h"
#include "services/video_capture/public/mojom/producer.mojom-shared-message-ids.h"

#include "services/video_capture/public/mojom/producer.mojom-import-headers.h"
#include "services/video_capture/public/mojom/producer.mojom-test-utils.h"


namespace video_capture::mojom {
// The declaration includes the definition on other builds.

Producer::IPCStableHashFunction Producer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Producer>(message.name())) {
    case messages::Producer::kOnNewBuffer: {
      return &Producer::OnNewBuffer_Sym::IPCStableHash;
    }
    case messages::Producer::kOnBufferRetired: {
      return &Producer::OnBufferRetired_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Producer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Producer>(message.name())) {
      case messages::Producer::kOnNewBuffer:
            return "Receive video_capture::mojom::Producer::OnNewBuffer";
      case messages::Producer::kOnBufferRetired:
            return "Receive video_capture::mojom::Producer::OnBufferRetired";
    }
  } else {
    switch (static_cast<messages::Producer>(message.name())) {
      case messages::Producer::kOnNewBuffer:
            return "Receive reply video_capture::mojom::Producer::OnNewBuffer";
      case messages::Producer::kOnBufferRetired:
            return "Receive reply video_capture::mojom::Producer::OnBufferRetired";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Producer::OnNewBuffer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x052c4438;  // IPCStableHash for video_capture::mojom::Producer::OnNewBuffer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Producer::OnBufferRetired_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8ef0ae87;  // IPCStableHash for video_capture::mojom::Producer::OnBufferRetired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Producer_OnNewBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Producer_OnNewBuffer_ForwardToCallback(
      Producer::OnNewBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  Producer_OnNewBuffer_ForwardToCallback(const Producer_OnNewBuffer_ForwardToCallback&) = delete;
  Producer_OnNewBuffer_ForwardToCallback& operator=(const Producer_OnNewBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Producer::OnNewBufferCallback callback_;
};

ProducerProxy::ProducerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProducerProxy::OnNewBuffer(
    int32_t in_buffer_id, ::media::mojom::VideoBufferHandlePtr in_buffer_handle, OnNewBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::Producer::OnNewBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Producer::kOnNewBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Producer_OnNewBuffer_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;
  mojo::internal::MessageFragment<decltype(params->buffer_handle)>
      buffer_handle_fragment(params.message());
  buffer_handle_fragment.Claim(&params->buffer_handle);
  
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
    in_buffer_handle,
    buffer_handle_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer_handle.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer_handle in Producer.OnNewBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Producer::Name_);
  message.set_method_name("OnNewBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Producer_OnNewBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ProducerProxy::OnBufferRetired(
    int32_t in_buffer_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_capture::mojom::Producer::OnBufferRetired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_id"), in_buffer_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Producer::kOnBufferRetired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Producer_OnBufferRetired_Params_Data> params(
          message);
  params.Allocate();

  params->buffer_id = in_buffer_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Producer::Name_);
  message.set_method_name("OnBufferRetired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Producer_OnNewBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Producer::OnNewBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Producer_OnNewBuffer_ProxyToResponder> proxy(
        new Producer_OnNewBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Producer_OnNewBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Producer_OnNewBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Producer_OnNewBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Producer::OnNewBufferCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool Producer_OnNewBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Producer_OnNewBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Producer_OnNewBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Producer.0
  bool success = true;
  Producer_OnNewBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Producer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void Producer_OnNewBuffer_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply video_capture::mojom::Producer::OnNewBuffer");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Producer::kOnNewBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_capture::mojom::internal::Producer_OnNewBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Producer::Name_);
  message.set_method_name("OnNewBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProducerStubDispatch::Accept(
    Producer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Producer>(message->header()->name)) {
    case messages::Producer::kOnNewBuffer: {
      break;
    }
    case messages::Producer::kOnBufferRetired: {
      DCHECK(message->is_serialized());
      internal::Producer_OnBufferRetired_Params_Data* params =
          reinterpret_cast<internal::Producer_OnBufferRetired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Producer.1
      bool success = true;
      int32_t p_buffer_id{};
      Producer_OnBufferRetired_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Producer::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBufferRetired(        
        std::move(p_buffer_id));
      return true;
    }
  }
  return false;
}

// static
bool ProducerStubDispatch::AcceptWithResponder(
    Producer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Producer>(message->header()->name)) {
    case messages::Producer::kOnNewBuffer: {
      internal::Producer_OnNewBuffer_Params_Data* params =
          reinterpret_cast<
              internal::Producer_OnNewBuffer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Producer.0
      bool success = true;
      int32_t p_buffer_id{};
      ::media::mojom::VideoBufferHandlePtr p_buffer_handle{};
      Producer_OnNewBuffer_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_buffer_id = input_data_view.buffer_id();
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Producer::Name_, 0, false);
        return false;
      }
      auto callback =
          Producer_OnNewBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNewBuffer(        
        std::move(p_buffer_id), 
        std::move(p_buffer_handle), std::move(callback));
      return true;
    }
    case messages::Producer::kOnBufferRetired: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProducerValidationInfo[] = {
    { &internal::Producer_OnNewBuffer_Params_Data::Validate,
     &internal::Producer_OnNewBuffer_ResponseParams_Data::Validate},
    { &internal::Producer_OnBufferRetired_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProducerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::video_capture::mojom::Producer::Name_,
    kProducerValidationInfo);
}

bool ProducerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::video_capture::mojom::Producer::Name_,
    kProducerValidationInfo);
}


}  // video_capture::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_capture::mojom {


void ProducerInterceptorForTesting::OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle, OnNewBufferCallback callback) {
  GetForwardingInterface()->OnNewBuffer(
    std::move(buffer_id)
    , 
    std::move(buffer_handle)
    , std::move(callback));
}
void ProducerInterceptorForTesting::OnBufferRetired(int32_t buffer_id) {
  GetForwardingInterface()->OnBufferRetired(
    std::move(buffer_id)
    );
}
ProducerAsyncWaiter::ProducerAsyncWaiter(
    Producer* proxy) : proxy_(proxy) {}

ProducerAsyncWaiter::~ProducerAsyncWaiter() = default;


void ProducerAsyncWaiter::OnNewBuffer(
    int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) {
  base::RunLoop loop;
  proxy_->OnNewBuffer(
      std::move(buffer_id),
      std::move(buffer_handle),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // video_capture::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif