// services/service_manager/public/mojom/service_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/service_manager/public/mojom/service_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('serviceManager.mojom');
  var connector$ =
      mojo.internal.exposeNamespace('serviceManager.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/service_manager/public/mojom/connector.mojom', 'connector.mojom.js');
  }


  var InstanceState = {};
  InstanceState.kCreated = 0;
  InstanceState.kStarted = 1;
  InstanceState.kUnreachable = 2;
  InstanceState.MIN_VALUE = 0;
  InstanceState.MAX_VALUE = 2;

  InstanceState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  InstanceState.toKnownEnumValue = function(value) {
    return value;
  };

  InstanceState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function RunningServiceInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RunningServiceInfo.prototype.initDefaults_ = function() {
    this.identity = null;
    this.pid = 0;
    this.state = 0;
  };
  RunningServiceInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RunningServiceInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RunningServiceInfo.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, connector$.Identity, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate RunningServiceInfo.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, InstanceState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RunningServiceInfo.encodedSize = codec.kStructHeaderSize + 16;

  RunningServiceInfo.decode = function(decoder) {
    var packed;
    var val = new RunningServiceInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(connector$.Identity);
    val.pid =
        decoder.decodeStruct(codec.Uint32);
    val.state =
        decoder.decodeStruct(new codec.Enum(InstanceState));
    return val;
  };

  RunningServiceInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RunningServiceInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(connector$.Identity, val.identity);
    encoder.encodeStruct(codec.Uint32, val.pid);
    encoder.encodeStruct(codec.Int32, val.state);
  };
  function ServiceManagerListener_OnInit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnInit_Params.prototype.initDefaults_ = function() {
    this.runningServices = null;
  };
  ServiceManagerListener_OnInit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnInit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnInit_Params.runningServices
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(RunningServiceInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnInit_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceManagerListener_OnInit_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnInit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.runningServices =
        decoder.decodeArrayPointer(new codec.PointerTo(RunningServiceInfo));
    return val;
  };

  ServiceManagerListener_OnInit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnInit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(RunningServiceInfo), val.runningServices);
  };
  function ServiceManagerListener_OnServiceCreated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnServiceCreated_Params.prototype.initDefaults_ = function() {
    this.service = null;
  };
  ServiceManagerListener_OnServiceCreated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnServiceCreated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnServiceCreated_Params.service
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, RunningServiceInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnServiceCreated_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceManagerListener_OnServiceCreated_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnServiceCreated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.service =
        decoder.decodeStructPointer(RunningServiceInfo);
    return val;
  };

  ServiceManagerListener_OnServiceCreated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnServiceCreated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(RunningServiceInfo, val.service);
  };
  function ServiceManagerListener_OnServiceStarted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnServiceStarted_Params.prototype.initDefaults_ = function() {
    this.identity = null;
    this.pidDeprecated = 0;
  };
  ServiceManagerListener_OnServiceStarted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnServiceStarted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnServiceStarted_Params.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, connector$.Identity, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnServiceStarted_Params.encodedSize = codec.kStructHeaderSize + 16;

  ServiceManagerListener_OnServiceStarted_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnServiceStarted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(connector$.Identity);
    val.pidDeprecated =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceManagerListener_OnServiceStarted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnServiceStarted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(connector$.Identity, val.identity);
    encoder.encodeStruct(codec.Uint32, val.pidDeprecated);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceManagerListener_OnServicePIDReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnServicePIDReceived_Params.prototype.initDefaults_ = function() {
    this.identity = null;
    this.pid = 0;
  };
  ServiceManagerListener_OnServicePIDReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnServicePIDReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnServicePIDReceived_Params.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, connector$.Identity, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnServicePIDReceived_Params.encodedSize = codec.kStructHeaderSize + 16;

  ServiceManagerListener_OnServicePIDReceived_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnServicePIDReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(connector$.Identity);
    val.pid =
        decoder.decodeStruct(codec.Uint32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ServiceManagerListener_OnServicePIDReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnServicePIDReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(connector$.Identity, val.identity);
    encoder.encodeStruct(codec.Uint32, val.pid);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ServiceManagerListener_OnServiceFailedToStart_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnServiceFailedToStart_Params.prototype.initDefaults_ = function() {
    this.identity = null;
  };
  ServiceManagerListener_OnServiceFailedToStart_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnServiceFailedToStart_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnServiceFailedToStart_Params.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, connector$.Identity, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnServiceFailedToStart_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceManagerListener_OnServiceFailedToStart_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnServiceFailedToStart_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(connector$.Identity);
    return val;
  };

  ServiceManagerListener_OnServiceFailedToStart_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnServiceFailedToStart_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(connector$.Identity, val.identity);
  };
  function ServiceManagerListener_OnServiceStopped_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManagerListener_OnServiceStopped_Params.prototype.initDefaults_ = function() {
    this.identity = null;
  };
  ServiceManagerListener_OnServiceStopped_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManagerListener_OnServiceStopped_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManagerListener_OnServiceStopped_Params.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, connector$.Identity, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceManagerListener_OnServiceStopped_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceManagerListener_OnServiceStopped_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManagerListener_OnServiceStopped_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(connector$.Identity);
    return val;
  };

  ServiceManagerListener_OnServiceStopped_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManagerListener_OnServiceStopped_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(connector$.Identity, val.identity);
  };
  function ServiceManager_AddListener_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceManager_AddListener_Params.prototype.initDefaults_ = function() {
    this.listener = new ServiceManagerListenerPtr();
  };
  ServiceManager_AddListener_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceManager_AddListener_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceManager_AddListener_Params.listener
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceManager_AddListener_Params.encodedSize = codec.kStructHeaderSize + 8;

  ServiceManager_AddListener_Params.decode = function(decoder) {
    var packed;
    var val = new ServiceManager_AddListener_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.listener =
        decoder.decodeStruct(new codec.Interface(ServiceManagerListenerPtr));
    return val;
  };

  ServiceManager_AddListener_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceManager_AddListener_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(ServiceManagerListenerPtr), val.listener);
  };
  var kServiceManagerListener_OnInit_Name = 0;
  var kServiceManagerListener_OnServiceCreated_Name = 1;
  var kServiceManagerListener_OnServiceStarted_Name = 2;
  var kServiceManagerListener_OnServicePIDReceived_Name = 3;
  var kServiceManagerListener_OnServiceFailedToStart_Name = 4;
  var kServiceManagerListener_OnServiceStopped_Name = 5;

  function ServiceManagerListenerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceManagerListener,
                                                   handleOrPtrInfo);
  }

  function ServiceManagerListenerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceManagerListener, associatedInterfacePtrInfo);
  }

  ServiceManagerListenerAssociatedPtr.prototype =
      Object.create(ServiceManagerListenerPtr.prototype);
  ServiceManagerListenerAssociatedPtr.prototype.constructor =
      ServiceManagerListenerAssociatedPtr;

  function ServiceManagerListenerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceManagerListenerPtr.prototype.onInit = function() {
    return ServiceManagerListenerProxy.prototype.onInit
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onInit = function(runningServices) {
    var params_ = new ServiceManagerListener_OnInit_Params();
    params_.runningServices = runningServices;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnInit_Name,
        codec.align(ServiceManagerListener_OnInit_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnInit_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceManagerListenerPtr.prototype.onServiceCreated = function() {
    return ServiceManagerListenerProxy.prototype.onServiceCreated
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onServiceCreated = function(service) {
    var params_ = new ServiceManagerListener_OnServiceCreated_Params();
    params_.service = service;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnServiceCreated_Name,
        codec.align(ServiceManagerListener_OnServiceCreated_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnServiceCreated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceManagerListenerPtr.prototype.onServiceStarted = function() {
    return ServiceManagerListenerProxy.prototype.onServiceStarted
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onServiceStarted = function(identity, pidDeprecated) {
    var params_ = new ServiceManagerListener_OnServiceStarted_Params();
    params_.identity = identity;
    params_.pidDeprecated = pidDeprecated;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnServiceStarted_Name,
        codec.align(ServiceManagerListener_OnServiceStarted_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnServiceStarted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceManagerListenerPtr.prototype.onServicePIDReceived = function() {
    return ServiceManagerListenerProxy.prototype.onServicePIDReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onServicePIDReceived = function(identity, pid) {
    var params_ = new ServiceManagerListener_OnServicePIDReceived_Params();
    params_.identity = identity;
    params_.pid = pid;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnServicePIDReceived_Name,
        codec.align(ServiceManagerListener_OnServicePIDReceived_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnServicePIDReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceManagerListenerPtr.prototype.onServiceFailedToStart = function() {
    return ServiceManagerListenerProxy.prototype.onServiceFailedToStart
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onServiceFailedToStart = function(identity) {
    var params_ = new ServiceManagerListener_OnServiceFailedToStart_Params();
    params_.identity = identity;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnServiceFailedToStart_Name,
        codec.align(ServiceManagerListener_OnServiceFailedToStart_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnServiceFailedToStart_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ServiceManagerListenerPtr.prototype.onServiceStopped = function() {
    return ServiceManagerListenerProxy.prototype.onServiceStopped
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerListenerProxy.prototype.onServiceStopped = function(identity) {
    var params_ = new ServiceManagerListener_OnServiceStopped_Params();
    params_.identity = identity;
    var builder = new codec.MessageV0Builder(
        kServiceManagerListener_OnServiceStopped_Name,
        codec.align(ServiceManagerListener_OnServiceStopped_Params.encodedSize));
    builder.encodeStruct(ServiceManagerListener_OnServiceStopped_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceManagerListenerStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceManagerListenerStub.prototype.onInit = function(runningServices) {
    return this.delegate_ && this.delegate_.onInit && this.delegate_.onInit(runningServices);
  }
  ServiceManagerListenerStub.prototype.onServiceCreated = function(service) {
    return this.delegate_ && this.delegate_.onServiceCreated && this.delegate_.onServiceCreated(service);
  }
  ServiceManagerListenerStub.prototype.onServiceStarted = function(identity, pidDeprecated) {
    return this.delegate_ && this.delegate_.onServiceStarted && this.delegate_.onServiceStarted(identity, pidDeprecated);
  }
  ServiceManagerListenerStub.prototype.onServicePIDReceived = function(identity, pid) {
    return this.delegate_ && this.delegate_.onServicePIDReceived && this.delegate_.onServicePIDReceived(identity, pid);
  }
  ServiceManagerListenerStub.prototype.onServiceFailedToStart = function(identity) {
    return this.delegate_ && this.delegate_.onServiceFailedToStart && this.delegate_.onServiceFailedToStart(identity);
  }
  ServiceManagerListenerStub.prototype.onServiceStopped = function(identity) {
    return this.delegate_ && this.delegate_.onServiceStopped && this.delegate_.onServiceStopped(identity);
  }

  ServiceManagerListenerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceManagerListener_OnInit_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnInit_Params);
      this.onInit(params.runningServices);
      return true;
    case kServiceManagerListener_OnServiceCreated_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnServiceCreated_Params);
      this.onServiceCreated(params.service);
      return true;
    case kServiceManagerListener_OnServiceStarted_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnServiceStarted_Params);
      this.onServiceStarted(params.identity, params.pidDeprecated);
      return true;
    case kServiceManagerListener_OnServicePIDReceived_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnServicePIDReceived_Params);
      this.onServicePIDReceived(params.identity, params.pid);
      return true;
    case kServiceManagerListener_OnServiceFailedToStart_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnServiceFailedToStart_Params);
      this.onServiceFailedToStart(params.identity);
      return true;
    case kServiceManagerListener_OnServiceStopped_Name:
      var params = reader.decodeStruct(ServiceManagerListener_OnServiceStopped_Params);
      this.onServiceStopped(params.identity);
      return true;
    default:
      return false;
    }
  };

  ServiceManagerListenerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceManagerListenerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceManagerListener_OnInit_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnInit_Params;
      break;
      case kServiceManagerListener_OnServiceCreated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnServiceCreated_Params;
      break;
      case kServiceManagerListener_OnServiceStarted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnServiceStarted_Params;
      break;
      case kServiceManagerListener_OnServicePIDReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnServicePIDReceived_Params;
      break;
      case kServiceManagerListener_OnServiceFailedToStart_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnServiceFailedToStart_Params;
      break;
      case kServiceManagerListener_OnServiceStopped_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManagerListener_OnServiceStopped_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceManagerListenerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceManagerListener = {
    name: 'service_manager.mojom.ServiceManagerListener',
    kVersion: 0,
    ptrClass: ServiceManagerListenerPtr,
    proxyClass: ServiceManagerListenerProxy,
    stubClass: ServiceManagerListenerStub,
    validateRequest: validateServiceManagerListenerRequest,
    validateResponse: null,
  };
  ServiceManagerListenerStub.prototype.validator = validateServiceManagerListenerRequest;
  ServiceManagerListenerProxy.prototype.validator = null;
  var kServiceManager_AddListener_Name = 0;

  function ServiceManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ServiceManager,
                                                   handleOrPtrInfo);
  }

  function ServiceManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ServiceManager, associatedInterfacePtrInfo);
  }

  ServiceManagerAssociatedPtr.prototype =
      Object.create(ServiceManagerPtr.prototype);
  ServiceManagerAssociatedPtr.prototype.constructor =
      ServiceManagerAssociatedPtr;

  function ServiceManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  ServiceManagerPtr.prototype.addListener = function() {
    return ServiceManagerProxy.prototype.addListener
        .apply(this.ptr.getProxy(), arguments);
  };

  ServiceManagerProxy.prototype.addListener = function(listener) {
    var params_ = new ServiceManager_AddListener_Params();
    params_.listener = listener;
    var builder = new codec.MessageV0Builder(
        kServiceManager_AddListener_Name,
        codec.align(ServiceManager_AddListener_Params.encodedSize));
    builder.encodeStruct(ServiceManager_AddListener_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ServiceManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  ServiceManagerStub.prototype.addListener = function(listener) {
    return this.delegate_ && this.delegate_.addListener && this.delegate_.addListener(listener);
  }

  ServiceManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kServiceManager_AddListener_Name:
      var params = reader.decodeStruct(ServiceManager_AddListener_Params);
      this.addListener(params.listener);
      return true;
    default:
      return false;
    }
  };

  ServiceManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateServiceManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kServiceManager_AddListener_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ServiceManager_AddListener_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateServiceManagerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ServiceManager = {
    name: 'service_manager.mojom.ServiceManager',
    kVersion: 0,
    ptrClass: ServiceManagerPtr,
    proxyClass: ServiceManagerProxy,
    stubClass: ServiceManagerStub,
    validateRequest: validateServiceManagerRequest,
    validateResponse: null,
  };
  ServiceManagerStub.prototype.validator = validateServiceManagerRequest;
  ServiceManagerProxy.prototype.validator = null;
  exports.InstanceState = InstanceState;
  exports.RunningServiceInfo = RunningServiceInfo;
  exports.ServiceManagerListener = ServiceManagerListener;
  exports.ServiceManagerListenerPtr = ServiceManagerListenerPtr;
  exports.ServiceManagerListenerAssociatedPtr = ServiceManagerListenerAssociatedPtr;
  exports.ServiceManager = ServiceManager;
  exports.ServiceManagerPtr = ServiceManagerPtr;
  exports.ServiceManagerAssociatedPtr = ServiceManagerAssociatedPtr;
})();