// services/service_manager/public/mojom/service.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_BLINK_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/service.mojom-features.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/service.mojom-shared.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/service.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/connector.mojom-blink.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-blink-forward.h"
#include "services/service_manager/public/mojom/interface_provider_spec.mojom-blink.h"
#include "services/service_manager/public/mojom/service_control.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace service_manager::mojom::blink {

class ServiceProxy;

template <typename ImplRefTraits>
class ServiceStub;

class ServiceRequestValidator;
class ServiceResponseValidator;


class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) Service
    : public ServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "service_manager.mojom.Service";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceInterfaceBase;
  using Proxy_ = ServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceStub<ImplRefTraits>;

  using RequestValidator_ = ServiceRequestValidator;
  using ResponseValidator_ = ServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnStartMinVersion = 0,
    kOnBindInterfaceMinVersion = 0,
    kCreatePackagedServiceInstanceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBindInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatePackagedServiceInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Service() = default;

  using OnStartCallback = base::OnceCallback<void(::mojo::PendingReceiver<::service_manager::mojom::blink::Connector>, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl>)>;
  using OnStartMojoCallback = base::OnceCallback<void(::mojo::PendingReceiver<::service_manager::mojom::blink::Connector>, ::mojo::PendingAssociatedReceiver<::service_manager::mojom::blink::ServiceControl>)>;

  virtual void OnStart(::service_manager::mojom::blink::IdentityPtr identity, OnStartCallback callback) = 0;

  using OnBindInterfaceCallback = base::OnceCallback<void()>;
  using OnBindInterfaceMojoCallback = base::OnceCallback<void()>;

  virtual void OnBindInterface(BindSourceInfoPtr source, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback) = 0;

  virtual void CreatePackagedServiceInstance(::service_manager::mojom::blink::IdentityPtr identity, ::mojo::PendingReceiver<Service> receiver, ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata> metadata) = 0;
};



class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ServiceProxy
    : public Service {
 public:
  using InterfaceType = Service;

  explicit ServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnStart(::service_manager::mojom::blink::IdentityPtr identity, OnStartCallback callback) final;
  
  void OnBindInterface(BindSourceInfoPtr source, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, OnBindInterfaceCallback callback) final;
  
  void CreatePackagedServiceInstance(::service_manager::mojom::blink::IdentityPtr identity, ::mojo::PendingReceiver<Service> receiver, ::mojo::PendingRemote<::service_manager::mojom::blink::ProcessMetadata> metadata) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ServiceStubDispatch {
 public:
  static bool Accept(Service* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Service* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Service>>
class ServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceStub() = default;
  ~ServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) BindSourceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BindSourceInfo, T>::value>;
  using DataView = BindSourceInfoDataView;
  using Data_ = internal::BindSourceInfo_Data;

  template <typename... Args>
  static BindSourceInfoPtr New(Args&&... args) {
    return BindSourceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BindSourceInfoPtr From(const U& u) {
    return mojo::TypeConverter<BindSourceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BindSourceInfo>::Convert(*this);
  }


  BindSourceInfo();

  BindSourceInfo(
      ::service_manager::mojom::blink::IdentityPtr identity,
      ::service_manager::mojom::blink::CapabilitySetPtr required_capabilities);

BindSourceInfo(const BindSourceInfo&) = delete;
BindSourceInfo& operator=(const BindSourceInfo&) = delete;

  ~BindSourceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BindSourceInfoPtr>
  BindSourceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BindSourceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BindSourceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BindSourceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BindSourceInfo_UnserializedMessageContext<
            UserType, BindSourceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BindSourceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BindSourceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BindSourceInfo_UnserializedMessageContext<
            UserType, BindSourceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BindSourceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::service_manager::mojom::blink::IdentityPtr identity;
  
  ::service_manager::mojom::blink::CapabilitySetPtr required_capabilities;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BindSourceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BindSourceInfoPtr BindSourceInfo::Clone() const {
  return New(
      mojo::Clone(identity),
      mojo::Clone(required_capabilities)
  );
}

template <typename T, BindSourceInfo::EnableIfSame<T>*>
bool BindSourceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->identity, other_struct.identity))
    return false;
  if (!mojo::Equals(this->required_capabilities, other_struct.required_capabilities))
    return false;
  return true;
}

template <typename T, BindSourceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.identity < rhs.identity)
    return true;
  if (rhs.identity < lhs.identity)
    return false;
  if (lhs.required_capabilities < rhs.required_capabilities)
    return true;
  if (rhs.required_capabilities < lhs.required_capabilities)
    return false;
  return false;
}


}  // service_manager::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) StructTraits<::service_manager::mojom::blink::BindSourceInfo::DataView,
                                         ::service_manager::mojom::blink::BindSourceInfoPtr> {
  static bool IsNull(const ::service_manager::mojom::blink::BindSourceInfoPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::blink::BindSourceInfoPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::blink::BindSourceInfo::identity)& identity(
      const ::service_manager::mojom::blink::BindSourceInfoPtr& input) {
    return input->identity;
  }

  static const decltype(::service_manager::mojom::blink::BindSourceInfo::required_capabilities)& required_capabilities(
      const ::service_manager::mojom::blink::BindSourceInfoPtr& input) {
    return input->required_capabilities;
  }

  static bool Read(::service_manager::mojom::blink::BindSourceInfo::DataView input, ::service_manager::mojom::blink::BindSourceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_SERVICE_MOJOM_BLINK_H_