// services/service_manager/public/mojom/connector.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_BLINK_H_
#define SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/service_manager/public/mojom/connector.mojom-features.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/connector.mojom-shared.h"  // IWYU pragma: export
#include "services/service_manager/public/mojom/connector.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/process_id.mojom-blink-forward.h"
#include "mojo/public/mojom/base/token.mojom-blink.h"
#include "services/service_manager/public/mojom/constants.mojom-blink-forward.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-blink-forward.h"
#include "services/service_manager/public/mojom/service_filter.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace service_manager::mojom::blink {

class ProcessMetadataProxy;

template <typename ImplRefTraits>
class ProcessMetadataStub;

class ProcessMetadataRequestValidator;


class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ProcessMetadata
    : public ProcessMetadataInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "service_manager.mojom.ProcessMetadata";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProcessMetadataInterfaceBase;
  using Proxy_ = ProcessMetadataProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProcessMetadataStub<ImplRefTraits>;

  using RequestValidator_ = ProcessMetadataRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPIDMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPID_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProcessMetadata() = default;

  virtual void SetPID(::mojo_base::mojom::blink::ProcessIdPtr pid) = 0;
};

class ConnectorProxy;

template <typename ImplRefTraits>
class ConnectorStub;

class ConnectorRequestValidator;
class ConnectorResponseValidator;


class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) Connector
    : public ConnectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "service_manager.mojom.Connector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ConnectorInterfaceBase;
  using Proxy_ = ConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ConnectorStub<ImplRefTraits>;

  using RequestValidator_ = ConnectorRequestValidator;
  using ResponseValidator_ = ConnectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindInterfaceMinVersion = 0,
    kQueryServiceMinVersion = 0,
    kWarmServiceMinVersion = 0,
    kRegisterServiceInstanceMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindInterface_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct QueryService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WarmService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterServiceInstance_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Connector() = default;

  using BindInterfaceCallback = base::OnceCallback<void(ConnectResult, IdentityPtr)>;
  using BindInterfaceMojoCallback = base::OnceCallback<void(ConnectResult, IdentityPtr)>;

  virtual void BindInterface(::service_manager::mojom::blink::ServiceFilterPtr filter, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, BindInterfacePriority priority, BindInterfaceCallback callback) = 0;

  using QueryServiceCallback = base::OnceCallback<void(ServiceInfoPtr)>;
  using QueryServiceMojoCallback = base::OnceCallback<void(ServiceInfoPtr)>;

  virtual void QueryService(const ::blink::String& service_name, QueryServiceCallback callback) = 0;

  using WarmServiceCallback = base::OnceCallback<void(ConnectResult, IdentityPtr)>;
  using WarmServiceMojoCallback = base::OnceCallback<void(ConnectResult, IdentityPtr)>;

  virtual void WarmService(::service_manager::mojom::blink::ServiceFilterPtr filter, WarmServiceCallback callback) = 0;

  using RegisterServiceInstanceCallback = base::OnceCallback<void(ConnectResult)>;
  using RegisterServiceInstanceMojoCallback = base::OnceCallback<void(ConnectResult)>;

  virtual void RegisterServiceInstance(IdentityPtr identity, ::mojo::ScopedMessagePipeHandle service, ::mojo::PendingReceiver<ProcessMetadata> metadata_receiver, RegisterServiceInstanceCallback callback) = 0;

  virtual void Clone(::mojo::PendingReceiver<Connector> receiver) = 0;
};



class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ProcessMetadataProxy
    : public ProcessMetadata {
 public:
  using InterfaceType = ProcessMetadata;

  explicit ProcessMetadataProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPID(::mojo_base::mojom::blink::ProcessIdPtr pid) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ConnectorProxy
    : public Connector {
 public:
  using InterfaceType = Connector;

  explicit ConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindInterface(::service_manager::mojom::blink::ServiceFilterPtr filter, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, BindInterfacePriority priority, BindInterfaceCallback callback) final;
  
  void QueryService(const ::blink::String& service_name, QueryServiceCallback callback) final;
  
  void WarmService(::service_manager::mojom::blink::ServiceFilterPtr filter, WarmServiceCallback callback) final;
  
  void RegisterServiceInstance(IdentityPtr identity, ::mojo::ScopedMessagePipeHandle service, ::mojo::PendingReceiver<ProcessMetadata> metadata_receiver, RegisterServiceInstanceCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<Connector> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ProcessMetadataStubDispatch {
 public:
  static bool Accept(ProcessMetadata* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProcessMetadata* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProcessMetadata>>
class ProcessMetadataStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProcessMetadataStub() = default;
  ~ProcessMetadataStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessMetadataStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProcessMetadataStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ConnectorStubDispatch {
 public:
  static bool Accept(Connector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Connector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Connector>>
class ConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ConnectorStub() = default;
  ~ConnectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ProcessMetadataRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ConnectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) ServiceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceInfo, T>::value>;
  using DataView = ServiceInfoDataView;
  using Data_ = internal::ServiceInfo_Data;

  template <typename... Args>
  static ServiceInfoPtr New(Args&&... args) {
    return ServiceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceInfo>::Convert(*this);
  }


  ServiceInfo();

  explicit ServiceInfo(
      const ::blink::String& sandbox_type);


  ~ServiceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceInfoPtr>
  ServiceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ServiceInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceInfo_UnserializedMessageContext<
            UserType, ServiceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceInfo_UnserializedMessageContext<
            UserType, ServiceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String sandbox_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) Identity {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Identity, T>::value>;
  using DataView = IdentityDataView;
  using Data_ = internal::Identity_Data;

  template <typename... Args>
  static IdentityPtr New(Args&&... args) {
    return IdentityPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityPtr From(const U& u) {
    return mojo::TypeConverter<IdentityPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Identity>::Convert(*this);
  }


  Identity();

  Identity(
      const ::blink::String& name,
      const ::base::Token& instance_group,
      const ::base::Token& instance_id,
      const ::base::Token& globally_unique_id);


  ~Identity();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityPtr>
  IdentityPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Identity::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Identity::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Identity::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Identity::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Identity::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Identity::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Identity_UnserializedMessageContext<
            UserType, Identity::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Identity::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Identity::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Identity_UnserializedMessageContext<
            UserType, Identity::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Identity::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String name;
  
  ::base::Token instance_group;
  
  ::base::Token instance_id;
  
  ::base::Token globally_unique_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Identity::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Identity::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Identity::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Identity::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
IdentityPtr Identity::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(instance_group),
      mojo::Clone(instance_id),
      mojo::Clone(globally_unique_id)
  );
}

template <typename T, Identity::EnableIfSame<T>*>
bool Identity::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->instance_group, other_struct.instance_group))
    return false;
  if (!mojo::Equals(this->instance_id, other_struct.instance_id))
    return false;
  if (!mojo::Equals(this->globally_unique_id, other_struct.globally_unique_id))
    return false;
  return true;
}

template <typename T, Identity::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.instance_group < rhs.instance_group)
    return true;
  if (rhs.instance_group < lhs.instance_group)
    return false;
  if (lhs.instance_id < rhs.instance_id)
    return true;
  if (rhs.instance_id < lhs.instance_id)
    return false;
  if (lhs.globally_unique_id < rhs.globally_unique_id)
    return true;
  if (rhs.globally_unique_id < lhs.globally_unique_id)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceInfoPtr ServiceInfo::Clone() const {
  return New(
      mojo::Clone(sandbox_type)
  );
}

template <typename T, ServiceInfo::EnableIfSame<T>*>
bool ServiceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sandbox_type, other_struct.sandbox_type))
    return false;
  return true;
}

template <typename T, ServiceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sandbox_type < rhs.sandbox_type)
    return true;
  if (rhs.sandbox_type < lhs.sandbox_type)
    return false;
  return false;
}


}  // service_manager::mojom::blink

namespace mojo {


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) StructTraits<::service_manager::mojom::blink::Identity::DataView,
                                         ::service_manager::mojom::blink::IdentityPtr> {
  static bool IsNull(const ::service_manager::mojom::blink::IdentityPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::blink::IdentityPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::blink::Identity::name)& name(
      const ::service_manager::mojom::blink::IdentityPtr& input) {
    return input->name;
  }

  static const decltype(::service_manager::mojom::blink::Identity::instance_group)& instance_group(
      const ::service_manager::mojom::blink::IdentityPtr& input) {
    return input->instance_group;
  }

  static const decltype(::service_manager::mojom::blink::Identity::instance_id)& instance_id(
      const ::service_manager::mojom::blink::IdentityPtr& input) {
    return input->instance_id;
  }

  static const decltype(::service_manager::mojom::blink::Identity::globally_unique_id)& globally_unique_id(
      const ::service_manager::mojom::blink::IdentityPtr& input) {
    return input->globally_unique_id;
  }

  static bool Read(::service_manager::mojom::blink::Identity::DataView input, ::service_manager::mojom::blink::IdentityPtr* output);
};


template <>
struct COMPONENT_EXPORT(SERVICE_MANAGER_MOJOM_BLINK) StructTraits<::service_manager::mojom::blink::ServiceInfo::DataView,
                                         ::service_manager::mojom::blink::ServiceInfoPtr> {
  static bool IsNull(const ::service_manager::mojom::blink::ServiceInfoPtr& input) { return !input; }
  static void SetToNull(::service_manager::mojom::blink::ServiceInfoPtr* output) { output->reset(); }

  static const decltype(::service_manager::mojom::blink::ServiceInfo::sandbox_type)& sandbox_type(
      const ::service_manager::mojom::blink::ServiceInfoPtr& input) {
    return input->sandbox_type;
  }

  static bool Read(::service_manager::mojom::blink::ServiceInfo::DataView input, ::service_manager::mojom::blink::ServiceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_SERVICE_MANAGER_PUBLIC_MOJOM_CONNECTOR_MOJOM_BLINK_H_