// services/service_manager/public/mojom/connector.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/connector.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/connector.mojom-params-data.h"
#include "services/service_manager/public/mojom/connector.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/connector.mojom-blink-import-headers.h"
#include "services/service_manager/public/mojom/connector.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace service_manager::mojom::blink {
Identity::Identity()
    : name(),
      instance_group(),
      instance_id(),
      globally_unique_id() {}

Identity::Identity(
    const ::blink::String& name_in,
    const ::base::Token& instance_group_in,
    const ::base::Token& instance_id_in,
    const ::base::Token& globally_unique_id_in)
    : name(std::move(name_in)),
      instance_group(std::move(instance_group_in)),
      instance_id(std::move(instance_id_in)),
      globally_unique_id(std::move(globally_unique_id_in)) {}

Identity::~Identity() = default;

void Identity::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_group"), this->instance_group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instance_id"), this->instance_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "globally_unique_id"), this->globally_unique_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Identity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ServiceInfo::ServiceInfo()
    : sandbox_type() {}

ServiceInfo::ServiceInfo(
    const ::blink::String& sandbox_type_in)
    : sandbox_type(std::move(sandbox_type_in)) {}

ServiceInfo::~ServiceInfo() = default;
size_t ServiceInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->sandbox_type);
  return seed;
}

void ServiceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sandbox_type"), this->sandbox_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ProcessMetadata::IPCStableHashFunction ProcessMetadata::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProcessMetadata>(message.name())) {
    case messages::ProcessMetadata::kSetPID: {
      return &ProcessMetadata::SetPID_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProcessMetadata::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProcessMetadata>(message.name())) {
      case messages::ProcessMetadata::kSetPID:
            return "Receive service_manager::mojom::ProcessMetadata::SetPID";
    }
  } else {
    switch (static_cast<messages::ProcessMetadata>(message.name())) {
      case messages::ProcessMetadata::kSetPID:
            return "Receive reply service_manager::mojom::ProcessMetadata::SetPID";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProcessMetadata::SetPID_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x260895f5;  // IPCStableHash for service_manager::mojom::ProcessMetadata::SetPID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProcessMetadataProxy::ProcessMetadataProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProcessMetadataProxy::SetPID(
    ::mojo_base::mojom::blink::ProcessIdPtr in_pid) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::ProcessMetadata::SetPID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pid"), in_pid,
                        "<value of type ::mojo_base::mojom::blink::ProcessIdPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProcessMetadata::kSetPID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::ProcessMetadata_SetPID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pid)::BaseType> pid_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ProcessIdDataView>(
    in_pid,
    pid_fragment);

  params->pid.Set(
      pid_fragment.is_null() ? nullptr : pid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pid in ProcessMetadata.SetPID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProcessMetadata::Name_);
  message.set_method_name("SetPID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProcessMetadataStubDispatch::Accept(
    ProcessMetadata* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProcessMetadata>(message->header()->name)) {
    case messages::ProcessMetadata::kSetPID: {
      DCHECK(message->is_serialized());
      internal::ProcessMetadata_SetPID_Params_Data* params =
          reinterpret_cast<internal::ProcessMetadata_SetPID_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProcessMetadata.0
      bool success = true;
      ::mojo_base::mojom::blink::ProcessIdPtr p_pid{};
      ProcessMetadata_SetPID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPid(&p_pid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProcessMetadata::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPID(        
        std::move(p_pid));
      return true;
    }
  }
  return false;
}

// static
bool ProcessMetadataStubDispatch::AcceptWithResponder(
    ProcessMetadata* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProcessMetadata>(message->header()->name)) {
    case messages::ProcessMetadata::kSetPID: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProcessMetadataValidationInfo[] = {
    { &internal::ProcessMetadata_SetPID_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProcessMetadataRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::ProcessMetadata::Name_,
    kProcessMetadataValidationInfo);
}

// The declaration includes the definition on other builds.

Connector::IPCStableHashFunction Connector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Connector>(message.name())) {
    case messages::Connector::kBindInterface: {
      return &Connector::BindInterface_Sym::IPCStableHash;
    }
    case messages::Connector::kQueryService: {
      return &Connector::QueryService_Sym::IPCStableHash;
    }
    case messages::Connector::kWarmService: {
      return &Connector::WarmService_Sym::IPCStableHash;
    }
    case messages::Connector::kRegisterServiceInstance: {
      return &Connector::RegisterServiceInstance_Sym::IPCStableHash;
    }
    case messages::Connector::kClone: {
      return &Connector::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Connector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Connector>(message.name())) {
      case messages::Connector::kBindInterface:
            return "Receive service_manager::mojom::Connector::BindInterface";
      case messages::Connector::kQueryService:
            return "Receive service_manager::mojom::Connector::QueryService";
      case messages::Connector::kWarmService:
            return "Receive service_manager::mojom::Connector::WarmService";
      case messages::Connector::kRegisterServiceInstance:
            return "Receive service_manager::mojom::Connector::RegisterServiceInstance";
      case messages::Connector::kClone:
            return "Receive service_manager::mojom::Connector::Clone";
    }
  } else {
    switch (static_cast<messages::Connector>(message.name())) {
      case messages::Connector::kBindInterface:
            return "Receive reply service_manager::mojom::Connector::BindInterface";
      case messages::Connector::kQueryService:
            return "Receive reply service_manager::mojom::Connector::QueryService";
      case messages::Connector::kWarmService:
            return "Receive reply service_manager::mojom::Connector::WarmService";
      case messages::Connector::kRegisterServiceInstance:
            return "Receive reply service_manager::mojom::Connector::RegisterServiceInstance";
      case messages::Connector::kClone:
            return "Receive reply service_manager::mojom::Connector::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Connector::BindInterface_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbf102bb;  // IPCStableHash for service_manager::mojom::Connector::BindInterface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Connector::QueryService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e5de0fb;  // IPCStableHash for service_manager::mojom::Connector::QueryService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Connector::WarmService_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe3f1db15;  // IPCStableHash for service_manager::mojom::Connector::WarmService
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Connector::RegisterServiceInstance_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23832237;  // IPCStableHash for service_manager::mojom::Connector::RegisterServiceInstance
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Connector::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe06ad724;  // IPCStableHash for service_manager::mojom::Connector::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Connector_BindInterface_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_BindInterface_ForwardToCallback(
      Connector::BindInterfaceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Connector_BindInterface_ForwardToCallback(const Connector_BindInterface_ForwardToCallback&) = delete;
  Connector_BindInterface_ForwardToCallback& operator=(const Connector_BindInterface_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Connector::BindInterfaceCallback callback_;
};

class Connector_QueryService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_QueryService_ForwardToCallback(
      Connector::QueryServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Connector_QueryService_ForwardToCallback(const Connector_QueryService_ForwardToCallback&) = delete;
  Connector_QueryService_ForwardToCallback& operator=(const Connector_QueryService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Connector::QueryServiceCallback callback_;
};

class Connector_WarmService_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_WarmService_ForwardToCallback(
      Connector::WarmServiceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Connector_WarmService_ForwardToCallback(const Connector_WarmService_ForwardToCallback&) = delete;
  Connector_WarmService_ForwardToCallback& operator=(const Connector_WarmService_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Connector::WarmServiceCallback callback_;
};

class Connector_RegisterServiceInstance_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Connector_RegisterServiceInstance_ForwardToCallback(
      Connector::RegisterServiceInstanceCallback callback
      ) : callback_(std::move(callback)) {
  }

  Connector_RegisterServiceInstance_ForwardToCallback(const Connector_RegisterServiceInstance_ForwardToCallback&) = delete;
  Connector_RegisterServiceInstance_ForwardToCallback& operator=(const Connector_RegisterServiceInstance_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Connector::RegisterServiceInstanceCallback callback_;
};

ConnectorProxy::ConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ConnectorProxy::BindInterface(
    ::service_manager::mojom::blink::ServiceFilterPtr in_filter, const ::blink::String& in_interface_name, ::mojo::ScopedMessagePipeHandle in_interface_pipe, BindInterfacePriority in_priority, BindInterfaceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Connector::BindInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::service_manager::mojom::blink::ServiceFilterPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_pipe"), in_interface_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("priority"), in_priority,
                        "<value of type BindInterfacePriority>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kBindInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_BindInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::ServiceFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in Connector.BindInterface request");
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_interface_name,
    interface_name_fragment);

  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->interface_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null interface_name in Connector.BindInterface request");

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_interface_pipe,
    &params->interface_pipe,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->interface_pipe)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid interface_pipe in Connector.BindInterface request");

  
  mojo::internal::Serialize<::service_manager::mojom::BindInterfacePriority>(
    in_priority,
    &params->priority);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("BindInterface");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_BindInterface_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ConnectorProxy::QueryService(
    const ::blink::String& in_service_name, QueryServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Connector::QueryService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_name"), in_service_name,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kQueryService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_QueryService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->service_name)::BaseType> service_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_service_name,
    service_name_fragment);

  params->service_name.Set(
      service_name_fragment.is_null() ? nullptr : service_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->service_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null service_name in Connector.QueryService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("QueryService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_QueryService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ConnectorProxy::WarmService(
    ::service_manager::mojom::blink::ServiceFilterPtr in_filter, WarmServiceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Connector::WarmService", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("filter"), in_filter,
                        "<value of type ::service_manager::mojom::blink::ServiceFilterPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kWarmService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_WarmService_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->filter)::BaseType> filter_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::ServiceFilterDataView>(
    in_filter,
    filter_fragment);

  params->filter.Set(
      filter_fragment.is_null() ? nullptr : filter_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->filter.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null filter in Connector.WarmService request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("WarmService");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_WarmService_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ConnectorProxy::RegisterServiceInstance(
    IdentityPtr in_identity, ::mojo::ScopedMessagePipeHandle in_service, ::mojo::PendingReceiver<ProcessMetadata> in_metadata_receiver, RegisterServiceInstanceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Connector::RegisterServiceInstance", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type IdentityPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service"), in_service,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata_receiver"), in_metadata_receiver,
                        "<value of type ::mojo::PendingReceiver<ProcessMetadata>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kRegisterServiceInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_RegisterServiceInstance_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->identity.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null identity in Connector.RegisterServiceInstance request");

  
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
    in_service,
    &params->service,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->service)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid service in Connector.RegisterServiceInstance request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ProcessMetadataInterfaceBase>>(
    in_metadata_receiver,
    &params->metadata_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("RegisterServiceInstance");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Connector_RegisterServiceInstance_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ConnectorProxy::Clone(
    ::mojo::PendingReceiver<Connector> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::Connector::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Connector>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::service_manager::mojom::ConnectorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in Connector.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Connector_BindInterface_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Connector::BindInterfaceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Connector_BindInterface_ProxyToResponder> proxy(
        new Connector_BindInterface_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Connector_BindInterface_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_BindInterface_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Connector_BindInterface_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Connector::BindInterfaceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result, IdentityPtr in_identity);
};

bool Connector_BindInterface_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Connector_BindInterface_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_BindInterface_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Connector.0
  bool success = true;
  ConnectResult p_result{};
  IdentityPtr p_identity{};
  Connector_BindInterface_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadIdentity(&p_identity))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_identity));
  }
  return true;
}

void Connector_BindInterface_ProxyToResponder::Run(
    ConnectResult in_result, IdentityPtr in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply service_manager::mojom::Connector::BindInterface", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type IdentityPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kBindInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_BindInterface_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("BindInterface");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_QueryService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Connector::QueryServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Connector_QueryService_ProxyToResponder> proxy(
        new Connector_QueryService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Connector_QueryService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_QueryService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Connector_QueryService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Connector::QueryServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ServiceInfoPtr in_info);
};

bool Connector_QueryService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Connector_QueryService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_QueryService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Connector.1
  bool success = true;
  ServiceInfoPtr p_info{};
  Connector_QueryService_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_info));
  }
  return true;
}

void Connector_QueryService_ProxyToResponder::Run(
    ServiceInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply service_manager::mojom::Connector::QueryService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type ServiceInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kQueryService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_QueryService_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::ServiceInfoDataView>(
    in_info,
    info_fragment);

  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("QueryService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_WarmService_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Connector::WarmServiceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Connector_WarmService_ProxyToResponder> proxy(
        new Connector_WarmService_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Connector_WarmService_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_WarmService_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Connector_WarmService_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Connector::WarmServiceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result, IdentityPtr in_identity);
};

bool Connector_WarmService_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Connector_WarmService_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_WarmService_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Connector.2
  bool success = true;
  ConnectResult p_result{};
  IdentityPtr p_identity{};
  Connector_WarmService_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadIdentity(&p_identity))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_identity));
  }
  return true;
}

void Connector_WarmService_ProxyToResponder::Run(
    ConnectResult in_result, IdentityPtr in_identity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply service_manager::mojom::Connector::WarmService", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("identity"), in_identity,
                        "<value of type IdentityPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kWarmService), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_WarmService_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->identity)::BaseType> identity_fragment(
          params.message());
  
  mojo::internal::Serialize<::service_manager::mojom::IdentityDataView>(
    in_identity,
    identity_fragment);

  params->identity.Set(
      identity_fragment.is_null() ? nullptr : identity_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("WarmService");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Connector_RegisterServiceInstance_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Connector::RegisterServiceInstanceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Connector_RegisterServiceInstance_ProxyToResponder> proxy(
        new Connector_RegisterServiceInstance_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Connector_RegisterServiceInstance_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Connector_RegisterServiceInstance_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Connector_RegisterServiceInstance_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Connector::RegisterServiceInstanceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ConnectResult in_result);
};

bool Connector_RegisterServiceInstance_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Connector_RegisterServiceInstance_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Connector_RegisterServiceInstance_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Connector.3
  bool success = true;
  ConnectResult p_result{};
  Connector_RegisterServiceInstance_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Connector::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Connector_RegisterServiceInstance_ProxyToResponder::Run(
    ConnectResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply service_manager::mojom::Connector::RegisterServiceInstance", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ConnectResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Connector::kRegisterServiceInstance), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::Connector_RegisterServiceInstance_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::service_manager::mojom::ConnectResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Connector::Name_);
  message.set_method_name("RegisterServiceInstance");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ConnectorStubDispatch::Accept(
    Connector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Connector>(message->header()->name)) {
    case messages::Connector::kBindInterface: {
      break;
    }
    case messages::Connector::kQueryService: {
      break;
    }
    case messages::Connector::kWarmService: {
      break;
    }
    case messages::Connector::kRegisterServiceInstance: {
      break;
    }
    case messages::Connector::kClone: {
      DCHECK(message->is_serialized());
      internal::Connector_Clone_Params_Data* params =
          reinterpret_cast<internal::Connector_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Connector.4
      bool success = true;
      ::mojo::PendingReceiver<Connector> p_receiver{};
      Connector_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ConnectorStubDispatch::AcceptWithResponder(
    Connector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Connector>(message->header()->name)) {
    case messages::Connector::kBindInterface: {
      internal::Connector_BindInterface_Params_Data* params =
          reinterpret_cast<
              internal::Connector_BindInterface_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Connector.0
      bool success = true;
      ::service_manager::mojom::blink::ServiceFilterPtr p_filter{};
      ::blink::String p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_interface_pipe{};
      BindInterfacePriority p_priority{};
      Connector_BindInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_interface_pipe = input_data_view.TakeInterfacePipe();
      if (success && !input_data_view.ReadPriority(&p_priority))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 0, false);
        return false;
      }
      auto callback =
          Connector_BindInterface_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInterface(        
        std::move(p_filter), 
        std::move(p_interface_name), 
        std::move(p_interface_pipe), 
        std::move(p_priority), std::move(callback));
      return true;
    }
    case messages::Connector::kQueryService: {
      internal::Connector_QueryService_Params_Data* params =
          reinterpret_cast<
              internal::Connector_QueryService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Connector.1
      bool success = true;
      ::blink::String p_service_name{};
      Connector_QueryService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadServiceName(&p_service_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 1, false);
        return false;
      }
      auto callback =
          Connector_QueryService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryService(        
        std::move(p_service_name), std::move(callback));
      return true;
    }
    case messages::Connector::kWarmService: {
      internal::Connector_WarmService_Params_Data* params =
          reinterpret_cast<
              internal::Connector_WarmService_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Connector.2
      bool success = true;
      ::service_manager::mojom::blink::ServiceFilterPtr p_filter{};
      Connector_WarmService_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 2, false);
        return false;
      }
      auto callback =
          Connector_WarmService_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WarmService(        
        std::move(p_filter), std::move(callback));
      return true;
    }
    case messages::Connector::kRegisterServiceInstance: {
      internal::Connector_RegisterServiceInstance_Params_Data* params =
          reinterpret_cast<
              internal::Connector_RegisterServiceInstance_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Connector.3
      bool success = true;
      IdentityPtr p_identity{};
      ::mojo::ScopedMessagePipeHandle p_service{};
      ::mojo::PendingReceiver<ProcessMetadata> p_metadata_receiver{};
      Connector_RegisterServiceInstance_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdentity(&p_identity))
        success = false;
      if (success)
        p_service = input_data_view.TakeService();
      if (success) {
        p_metadata_receiver =
            input_data_view.TakeMetadataReceiver<decltype(p_metadata_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Connector::Name_, 3, false);
        return false;
      }
      auto callback =
          Connector_RegisterServiceInstance_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RegisterServiceInstance(        
        std::move(p_identity), 
        std::move(p_service), 
        std::move(p_metadata_receiver), std::move(callback));
      return true;
    }
    case messages::Connector::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kConnectorValidationInfo[] = {
    { &internal::Connector_BindInterface_Params_Data::Validate,
     &internal::Connector_BindInterface_ResponseParams_Data::Validate},
    { &internal::Connector_QueryService_Params_Data::Validate,
     &internal::Connector_QueryService_ResponseParams_Data::Validate},
    { &internal::Connector_WarmService_Params_Data::Validate,
     &internal::Connector_WarmService_ResponseParams_Data::Validate},
    { &internal::Connector_RegisterServiceInstance_Params_Data::Validate,
     &internal::Connector_RegisterServiceInstance_ResponseParams_Data::Validate},
    { &internal::Connector_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::service_manager::mojom::blink::Connector::Name_,
    kConnectorValidationInfo);
}

bool ConnectorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::service_manager::mojom::blink::Connector::Name_,
    kConnectorValidationInfo);
}


}  // service_manager::mojom::blink


namespace mojo {


// static
bool StructTraits<::service_manager::mojom::blink::Identity::DataView, ::service_manager::mojom::blink::IdentityPtr>::Read(
    ::service_manager::mojom::blink::Identity::DataView input,
    ::service_manager::mojom::blink::IdentityPtr* output) {
  bool success = true;
  ::service_manager::mojom::blink::IdentityPtr result(::service_manager::mojom::blink::Identity::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadInstanceGroup(&result->instance_group))
        success = false;
      if (success && !input.ReadInstanceId(&result->instance_id))
        success = false;
      if (success && !input.ReadGloballyUniqueId(&result->globally_unique_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::service_manager::mojom::blink::ServiceInfo::DataView, ::service_manager::mojom::blink::ServiceInfoPtr>::Read(
    ::service_manager::mojom::blink::ServiceInfo::DataView input,
    ::service_manager::mojom::blink::ServiceInfoPtr* output) {
  bool success = true;
  ::service_manager::mojom::blink::ServiceInfoPtr result(::service_manager::mojom::blink::ServiceInfo::New());
  
      if (success && !input.ReadSandboxType(&result->sandbox_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace service_manager::mojom::blink {


void ProcessMetadataInterceptorForTesting::SetPID(::mojo_base::mojom::blink::ProcessIdPtr pid) {
  GetForwardingInterface()->SetPID(
    std::move(pid)
    );
}
ProcessMetadataAsyncWaiter::ProcessMetadataAsyncWaiter(
    ProcessMetadata* proxy) : proxy_(proxy) {}

ProcessMetadataAsyncWaiter::~ProcessMetadataAsyncWaiter() = default;





void ConnectorInterceptorForTesting::BindInterface(::service_manager::mojom::blink::ServiceFilterPtr filter, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, BindInterfacePriority priority, BindInterfaceCallback callback) {
  GetForwardingInterface()->BindInterface(
    std::move(filter)
    , 
    std::move(interface_name)
    , 
    std::move(interface_pipe)
    , 
    std::move(priority)
    , std::move(callback));
}
void ConnectorInterceptorForTesting::QueryService(const ::blink::String& service_name, QueryServiceCallback callback) {
  GetForwardingInterface()->QueryService(
    std::move(service_name)
    , std::move(callback));
}
void ConnectorInterceptorForTesting::WarmService(::service_manager::mojom::blink::ServiceFilterPtr filter, WarmServiceCallback callback) {
  GetForwardingInterface()->WarmService(
    std::move(filter)
    , std::move(callback));
}
void ConnectorInterceptorForTesting::RegisterServiceInstance(IdentityPtr identity, ::mojo::ScopedMessagePipeHandle service, ::mojo::PendingReceiver<ProcessMetadata> metadata_receiver, RegisterServiceInstanceCallback callback) {
  GetForwardingInterface()->RegisterServiceInstance(
    std::move(identity)
    , 
    std::move(service)
    , 
    std::move(metadata_receiver)
    , std::move(callback));
}
void ConnectorInterceptorForTesting::Clone(::mojo::PendingReceiver<Connector> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
ConnectorAsyncWaiter::ConnectorAsyncWaiter(
    Connector* proxy) : proxy_(proxy) {}

ConnectorAsyncWaiter::~ConnectorAsyncWaiter() = default;


void ConnectorAsyncWaiter::BindInterface(
    ::service_manager::mojom::blink::ServiceFilterPtr filter, const ::blink::String& interface_name, ::mojo::ScopedMessagePipeHandle interface_pipe, BindInterfacePriority priority, ConnectResult* out_result, IdentityPtr* out_identity) {
  base::RunLoop loop;
  proxy_->BindInterface(
      std::move(filter),
      std::move(interface_name),
      std::move(interface_pipe),
      std::move(priority),
      base::BindOnce(
          [](base::RunLoop* loop,
             ConnectResult* out_result
,
             IdentityPtr* out_identity
,
             ConnectResult result,
             IdentityPtr identity) {*out_result = std::move(result);*out_identity = std::move(identity);
            loop->Quit();
          },
          &loop,
          out_result,
          out_identity));
  loop.Run();
}



void ConnectorAsyncWaiter::QueryService(
    const ::blink::String& service_name, ServiceInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->QueryService(
      std::move(service_name),
      base::BindOnce(
          [](base::RunLoop* loop,
             ServiceInfoPtr* out_info
,
             ServiceInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

ServiceInfoPtr ConnectorAsyncWaiter::QueryService(
    const ::blink::String& service_name) {
  ServiceInfoPtr async_wait_result;
  QueryService(std::move(service_name),&async_wait_result);
  return async_wait_result;
}

void ConnectorAsyncWaiter::WarmService(
    ::service_manager::mojom::blink::ServiceFilterPtr filter, ConnectResult* out_result, IdentityPtr* out_identity) {
  base::RunLoop loop;
  proxy_->WarmService(
      std::move(filter),
      base::BindOnce(
          [](base::RunLoop* loop,
             ConnectResult* out_result
,
             IdentityPtr* out_identity
,
             ConnectResult result,
             IdentityPtr identity) {*out_result = std::move(result);*out_identity = std::move(identity);
            loop->Quit();
          },
          &loop,
          out_result,
          out_identity));
  loop.Run();
}



void ConnectorAsyncWaiter::RegisterServiceInstance(
    IdentityPtr identity, ::mojo::ScopedMessagePipeHandle service, ::mojo::PendingReceiver<ProcessMetadata> metadata_receiver, ConnectResult* out_result) {
  base::RunLoop loop;
  proxy_->RegisterServiceInstance(
      std::move(identity),
      std::move(service),
      std::move(metadata_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             ConnectResult* out_result
,
             ConnectResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ConnectResult ConnectorAsyncWaiter::RegisterServiceInstance(
    IdentityPtr identity, ::mojo::ScopedMessagePipeHandle service, ::mojo::PendingReceiver<ProcessMetadata> metadata_receiver) {
  ConnectResult async_wait_result;
  RegisterServiceInstance(std::move(identity),std::move(service),std::move(metadata_receiver),&async_wait_result);
  return async_wait_result;
}






}  // service_manager::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif