// services/screen_ai/public/mojom/screen_ai_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_H_
#define SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-features.h"  // IWYU pragma: export
#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared.h"  // IWYU pragma: export
#include "services/screen_ai/public/mojom/screen_ai_service.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "ui/accessibility/ax_features.mojom-forward.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace screen_ai::mojom {

class ScreenAIAnnotatorProxy;

template <typename ImplRefTraits>
class ScreenAIAnnotatorStub;

class ScreenAIAnnotatorRequestValidator;
class ScreenAIAnnotatorResponseValidator;


class ScreenAIAnnotator
    : public ScreenAIAnnotatorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.ScreenAIAnnotator";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static bool RuntimeFeature_IsEnabled_(bool expected);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ScreenAIAnnotatorInterfaceBase;
  using Proxy_ = ScreenAIAnnotatorProxy;

  template <typename ImplRefTraits>
  using Stub_ = ScreenAIAnnotatorStub<ImplRefTraits>;

  using RequestValidator_ = ScreenAIAnnotatorRequestValidator;
  using ResponseValidator_ = ScreenAIAnnotatorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPerformOcrAndReturnAnnotationMinVersion = 0,
    kSetClientTypeMinVersion = 0,
    kGetMaxImageDimensionMinVersion = 0,
    kSetOCRLightModeMinVersion = 0,
    kIsOCRBusyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PerformOcrAndReturnAnnotation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClientType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMaxImageDimension_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOCRLightMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsOCRBusy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ScreenAIAnnotator() = default;

  using PerformOcrAndReturnAnnotationCallback = base::OnceCallback<void(VisualAnnotationPtr)>;
  using PerformOcrAndReturnAnnotationMojoCallback = base::OnceCallback<void(VisualAnnotationPtr)>;

  virtual void PerformOcrAndReturnAnnotation(const ::SkBitmap& image, PerformOcrAndReturnAnnotationCallback callback) = 0;

  virtual void SetClientType(OcrClientType client_type) = 0;

  using GetMaxImageDimensionCallback = base::OnceCallback<void(uint32_t)>;
  using GetMaxImageDimensionMojoCallback = base::OnceCallback<void(uint32_t)>;

  virtual void GetMaxImageDimension(GetMaxImageDimensionCallback callback) = 0;

  virtual void SetOCRLightMode(bool enabled) = 0;

  using IsOCRBusyCallback = base::OnceCallback<void(bool)>;
  using IsOCRBusyMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsOCRBusy(IsOCRBusyCallback callback) = 0;
};

class Screen2xMainContentExtractorProxy;

template <typename ImplRefTraits>
class Screen2xMainContentExtractorStub;

class Screen2xMainContentExtractorRequestValidator;
class Screen2xMainContentExtractorResponseValidator;


class Screen2xMainContentExtractor
    : public Screen2xMainContentExtractorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.Screen2xMainContentExtractor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = Screen2xMainContentExtractorInterfaceBase;
  using Proxy_ = Screen2xMainContentExtractorProxy;

  template <typename ImplRefTraits>
  using Stub_ = Screen2xMainContentExtractorStub<ImplRefTraits>;

  using RequestValidator_ = Screen2xMainContentExtractorRequestValidator;
  using ResponseValidator_ = Screen2xMainContentExtractorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtractMainContentMinVersion = 0,
    kExtractMainNodeMinVersion = 0,
    kIdentifyMainNodeMinVersion = 0,
    kSetClientTypeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExtractMainContent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExtractMainNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IdentifyMainNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetClientType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Screen2xMainContentExtractor() = default;

  using ExtractMainContentCallback = base::OnceCallback<void(const std::vector<int32_t>&)>;
  using ExtractMainContentMojoCallback = base::OnceCallback<void(const std::vector<int32_t>&)>;

  virtual void ExtractMainContent(const ::ui::AXTreeUpdate& snapshot, ExtractMainContentCallback callback) = 0;

  using ExtractMainNodeCallback = base::OnceCallback<void(int32_t)>;
  using ExtractMainNodeMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void ExtractMainNode(const ::ui::AXTreeUpdate& snapshot, ExtractMainNodeCallback callback) = 0;

  using IdentifyMainNodeCallback = base::OnceCallback<void(const ::ui::AXTreeID&, int32_t)>;
  using IdentifyMainNodeMojoCallback = base::OnceCallback<void(const ::ui::AXTreeID&, int32_t)>;

  virtual void IdentifyMainNode(const ::ui::AXTreeUpdate& ax_tree, IdentifyMainNodeCallback callback) = 0;

  virtual void SetClientType(MceClientType client_type) = 0;
};

class OCRServiceProxy;

template <typename ImplRefTraits>
class OCRServiceStub;

class OCRServiceRequestValidator;


class OCRService
    : public OCRServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.OCRService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static bool RuntimeFeature_IsEnabled_(bool expected);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = OCRServiceInterfaceBase;
  using Proxy_ = OCRServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = OCRServiceStub<ImplRefTraits>;

  using RequestValidator_ = OCRServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAnnotatorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindAnnotator_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~OCRService() = default;

  virtual void BindAnnotator(::mojo::PendingReceiver<ScreenAIAnnotator> annotator) = 0;
};

class MainContentExtractionServiceProxy;

template <typename ImplRefTraits>
class MainContentExtractionServiceStub;

class MainContentExtractionServiceRequestValidator;


class MainContentExtractionService
    : public MainContentExtractionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "screen_ai.mojom.MainContentExtractionService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static bool RuntimeFeature_IsEnabled_(bool expected);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MainContentExtractionServiceInterfaceBase;
  using Proxy_ = MainContentExtractionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MainContentExtractionServiceStub<ImplRefTraits>;

  using RequestValidator_ = MainContentExtractionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindMainContentExtractorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindMainContentExtractor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MainContentExtractionService() = default;

  virtual void BindMainContentExtractor(::mojo::PendingReceiver<Screen2xMainContentExtractor> main_content_extractor) = 0;
};



class  ScreenAIAnnotatorProxy
    : public ScreenAIAnnotator {
 public:
  using InterfaceType = ScreenAIAnnotator;

  explicit ScreenAIAnnotatorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PerformOcrAndReturnAnnotation(const ::SkBitmap& image, PerformOcrAndReturnAnnotationCallback callback) final;
  
  void SetClientType(OcrClientType client_type) final;
  
  void GetMaxImageDimension(GetMaxImageDimensionCallback callback) final;
  
  void SetOCRLightMode(bool enabled) final;
  
  void IsOCRBusy(IsOCRBusyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  Screen2xMainContentExtractorProxy
    : public Screen2xMainContentExtractor {
 public:
  using InterfaceType = Screen2xMainContentExtractor;

  explicit Screen2xMainContentExtractorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExtractMainContent(const ::ui::AXTreeUpdate& snapshot, ExtractMainContentCallback callback) final;
  
  void ExtractMainNode(const ::ui::AXTreeUpdate& snapshot, ExtractMainNodeCallback callback) final;
  
  void IdentifyMainNode(const ::ui::AXTreeUpdate& ax_tree, IdentifyMainNodeCallback callback) final;
  
  void SetClientType(MceClientType client_type) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  OCRServiceProxy
    : public OCRService {
 public:
  using InterfaceType = OCRService;

  explicit OCRServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAnnotator(::mojo::PendingReceiver<ScreenAIAnnotator> annotator) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MainContentExtractionServiceProxy
    : public MainContentExtractionService {
 public:
  using InterfaceType = MainContentExtractionService;

  explicit MainContentExtractionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindMainContentExtractor(::mojo::PendingReceiver<Screen2xMainContentExtractor> main_content_extractor) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ScreenAIAnnotatorStubDispatch {
 public:
  static bool Accept(ScreenAIAnnotator* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ScreenAIAnnotator* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ScreenAIAnnotator>>
class ScreenAIAnnotatorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ScreenAIAnnotatorStub() = default;
  ~ScreenAIAnnotatorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIAnnotatorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ScreenAIAnnotatorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  Screen2xMainContentExtractorStubDispatch {
 public:
  static bool Accept(Screen2xMainContentExtractor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Screen2xMainContentExtractor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Screen2xMainContentExtractor>>
class Screen2xMainContentExtractorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  Screen2xMainContentExtractorStub() = default;
  ~Screen2xMainContentExtractorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return Screen2xMainContentExtractorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return Screen2xMainContentExtractorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  OCRServiceStubDispatch {
 public:
  static bool Accept(OCRService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      OCRService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<OCRService>>
class OCRServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  OCRServiceStub() = default;
  ~OCRServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OCRServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return OCRServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MainContentExtractionServiceStubDispatch {
 public:
  static bool Accept(MainContentExtractionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MainContentExtractionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MainContentExtractionService>>
class MainContentExtractionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MainContentExtractionServiceStub() = default;
  ~MainContentExtractionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MainContentExtractionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MainContentExtractionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ScreenAIAnnotatorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  Screen2xMainContentExtractorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  OCRServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MainContentExtractionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ScreenAIAnnotatorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  Screen2xMainContentExtractorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  VisualAnnotation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VisualAnnotation, T>::value>;
  using DataView = VisualAnnotationDataView;
  using Data_ = internal::VisualAnnotation_Data;

  template <typename... Args>
  static VisualAnnotationPtr New(Args&&... args) {
    return VisualAnnotationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VisualAnnotationPtr From(const U& u) {
    return mojo::TypeConverter<VisualAnnotationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VisualAnnotation>::Convert(*this);
  }


  VisualAnnotation();

  explicit VisualAnnotation(
      std::vector<LineBoxPtr> lines);

VisualAnnotation(const VisualAnnotation&) = delete;
VisualAnnotation& operator=(const VisualAnnotation&) = delete;

  ~VisualAnnotation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VisualAnnotationPtr>
  VisualAnnotationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VisualAnnotation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VisualAnnotation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VisualAnnotation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VisualAnnotation_UnserializedMessageContext<
            UserType, VisualAnnotation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VisualAnnotation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VisualAnnotation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VisualAnnotation_UnserializedMessageContext<
            UserType, VisualAnnotation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VisualAnnotation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<LineBoxPtr> lines;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VisualAnnotation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  LineBox {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LineBox, T>::value>;
  using DataView = LineBoxDataView;
  using Data_ = internal::LineBox_Data;

  template <typename... Args>
  static LineBoxPtr New(Args&&... args) {
    return LineBoxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LineBoxPtr From(const U& u) {
    return mojo::TypeConverter<LineBoxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LineBox>::Convert(*this);
  }


  LineBox();

  LineBox(
      std::vector<WordBoxPtr> words,
      const std::string& text_line,
      const std::string& language,
      int32_t block_id,
      int32_t paragraph_id,
      const ::gfx::Rect& bounding_box,
      float bounding_box_angle,
      float confidence);

LineBox(const LineBox&) = delete;
LineBox& operator=(const LineBox&) = delete;

  ~LineBox();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LineBoxPtr>
  LineBoxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LineBox::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LineBox::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LineBox::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LineBox::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LineBox::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LineBox::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LineBox_UnserializedMessageContext<
            UserType, LineBox::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LineBox::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LineBox::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LineBox_UnserializedMessageContext<
            UserType, LineBox::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LineBox::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<WordBoxPtr> words;
  
  std::string text_line;
  
  std::string language;
  
  int32_t block_id;
  
  int32_t paragraph_id;
  
  ::gfx::Rect bounding_box;
  
  float bounding_box_angle;
  
  float confidence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LineBox::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LineBox::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LineBox::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LineBox::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WordBox {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WordBox, T>::value>;
  using DataView = WordBoxDataView;
  using Data_ = internal::WordBox_Data;

  template <typename... Args>
  static WordBoxPtr New(Args&&... args) {
    return WordBoxPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WordBoxPtr From(const U& u) {
    return mojo::TypeConverter<WordBoxPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WordBox>::Convert(*this);
  }


  WordBox();

  WordBox(
      const std::string& word,
      const std::string& language,
      const ::gfx::Rect& bounding_box,
      float bounding_box_angle,
      Direction direction,
      const ::gfx::Rect& whitespace_bounding_box,
      float whitespace_bounding_box_angle,
      float confidence);


  ~WordBox();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WordBoxPtr>
  WordBoxPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WordBox::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WordBox::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WordBox::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WordBox::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WordBox::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WordBox::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WordBox_UnserializedMessageContext<
            UserType, WordBox::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WordBox::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WordBox::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WordBox_UnserializedMessageContext<
            UserType, WordBox::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WordBox::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string word;
  
  std::string language;
  
  ::gfx::Rect bounding_box;
  
  float bounding_box_angle;
  
  Direction direction;
  
  ::gfx::Rect whitespace_bounding_box;
  
  float whitespace_bounding_box_angle;
  
  float confidence;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WordBox::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WordBox::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WordBox::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WordBox::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
VisualAnnotationPtr VisualAnnotation::Clone() const {
  return New(
      mojo::Clone(lines)
  );
}

template <typename T, VisualAnnotation::EnableIfSame<T>*>
bool VisualAnnotation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->lines, other_struct.lines))
    return false;
  return true;
}

template <typename T, VisualAnnotation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.lines < rhs.lines)
    return true;
  if (rhs.lines < lhs.lines)
    return false;
  return false;
}
template <typename StructPtrType>
LineBoxPtr LineBox::Clone() const {
  return New(
      mojo::Clone(words),
      mojo::Clone(text_line),
      mojo::Clone(language),
      mojo::Clone(block_id),
      mojo::Clone(paragraph_id),
      mojo::Clone(bounding_box),
      mojo::Clone(bounding_box_angle),
      mojo::Clone(confidence)
  );
}

template <typename T, LineBox::EnableIfSame<T>*>
bool LineBox::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->words, other_struct.words))
    return false;
  if (!mojo::Equals(this->text_line, other_struct.text_line))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->block_id, other_struct.block_id))
    return false;
  if (!mojo::Equals(this->paragraph_id, other_struct.paragraph_id))
    return false;
  if (!mojo::Equals(this->bounding_box, other_struct.bounding_box))
    return false;
  if (!mojo::Equals(this->bounding_box_angle, other_struct.bounding_box_angle))
    return false;
  if (!mojo::Equals(this->confidence, other_struct.confidence))
    return false;
  return true;
}

template <typename T, LineBox::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.words < rhs.words)
    return true;
  if (rhs.words < lhs.words)
    return false;
  if (lhs.text_line < rhs.text_line)
    return true;
  if (rhs.text_line < lhs.text_line)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.block_id < rhs.block_id)
    return true;
  if (rhs.block_id < lhs.block_id)
    return false;
  if (lhs.paragraph_id < rhs.paragraph_id)
    return true;
  if (rhs.paragraph_id < lhs.paragraph_id)
    return false;
  if (lhs.bounding_box < rhs.bounding_box)
    return true;
  if (rhs.bounding_box < lhs.bounding_box)
    return false;
  if (lhs.bounding_box_angle < rhs.bounding_box_angle)
    return true;
  if (rhs.bounding_box_angle < lhs.bounding_box_angle)
    return false;
  if (lhs.confidence < rhs.confidence)
    return true;
  if (rhs.confidence < lhs.confidence)
    return false;
  return false;
}
template <typename StructPtrType>
WordBoxPtr WordBox::Clone() const {
  return New(
      mojo::Clone(word),
      mojo::Clone(language),
      mojo::Clone(bounding_box),
      mojo::Clone(bounding_box_angle),
      mojo::Clone(direction),
      mojo::Clone(whitespace_bounding_box),
      mojo::Clone(whitespace_bounding_box_angle),
      mojo::Clone(confidence)
  );
}

template <typename T, WordBox::EnableIfSame<T>*>
bool WordBox::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->word, other_struct.word))
    return false;
  if (!mojo::Equals(this->language, other_struct.language))
    return false;
  if (!mojo::Equals(this->bounding_box, other_struct.bounding_box))
    return false;
  if (!mojo::Equals(this->bounding_box_angle, other_struct.bounding_box_angle))
    return false;
  if (!mojo::Equals(this->direction, other_struct.direction))
    return false;
  if (!mojo::Equals(this->whitespace_bounding_box, other_struct.whitespace_bounding_box))
    return false;
  if (!mojo::Equals(this->whitespace_bounding_box_angle, other_struct.whitespace_bounding_box_angle))
    return false;
  if (!mojo::Equals(this->confidence, other_struct.confidence))
    return false;
  return true;
}

template <typename T, WordBox::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.word < rhs.word)
    return true;
  if (rhs.word < lhs.word)
    return false;
  if (lhs.language < rhs.language)
    return true;
  if (rhs.language < lhs.language)
    return false;
  if (lhs.bounding_box < rhs.bounding_box)
    return true;
  if (rhs.bounding_box < lhs.bounding_box)
    return false;
  if (lhs.bounding_box_angle < rhs.bounding_box_angle)
    return true;
  if (rhs.bounding_box_angle < lhs.bounding_box_angle)
    return false;
  if (lhs.direction < rhs.direction)
    return true;
  if (rhs.direction < lhs.direction)
    return false;
  if (lhs.whitespace_bounding_box < rhs.whitespace_bounding_box)
    return true;
  if (rhs.whitespace_bounding_box < lhs.whitespace_bounding_box)
    return false;
  if (lhs.whitespace_bounding_box_angle < rhs.whitespace_bounding_box_angle)
    return true;
  if (rhs.whitespace_bounding_box_angle < lhs.whitespace_bounding_box_angle)
    return false;
  if (lhs.confidence < rhs.confidence)
    return true;
  if (rhs.confidence < lhs.confidence)
    return false;
  return false;
}


}  // screen_ai::mojom

namespace mojo {


template <>
struct  StructTraits<::screen_ai::mojom::VisualAnnotation::DataView,
                                         ::screen_ai::mojom::VisualAnnotationPtr> {
  static bool IsNull(const ::screen_ai::mojom::VisualAnnotationPtr& input) { return !input; }
  static void SetToNull(::screen_ai::mojom::VisualAnnotationPtr* output) { output->reset(); }

  static const decltype(::screen_ai::mojom::VisualAnnotation::lines)& lines(
      const ::screen_ai::mojom::VisualAnnotationPtr& input) {
    return input->lines;
  }

  static bool Read(::screen_ai::mojom::VisualAnnotation::DataView input, ::screen_ai::mojom::VisualAnnotationPtr* output);
};


template <>
struct  StructTraits<::screen_ai::mojom::LineBox::DataView,
                                         ::screen_ai::mojom::LineBoxPtr> {
  static bool IsNull(const ::screen_ai::mojom::LineBoxPtr& input) { return !input; }
  static void SetToNull(::screen_ai::mojom::LineBoxPtr* output) { output->reset(); }

  static const decltype(::screen_ai::mojom::LineBox::words)& words(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->words;
  }

  static const decltype(::screen_ai::mojom::LineBox::text_line)& text_line(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->text_line;
  }

  static const decltype(::screen_ai::mojom::LineBox::language)& language(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->language;
  }

  static decltype(::screen_ai::mojom::LineBox::block_id) block_id(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->block_id;
  }

  static decltype(::screen_ai::mojom::LineBox::paragraph_id) paragraph_id(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->paragraph_id;
  }

  static const decltype(::screen_ai::mojom::LineBox::bounding_box)& bounding_box(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->bounding_box;
  }

  static decltype(::screen_ai::mojom::LineBox::bounding_box_angle) bounding_box_angle(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->bounding_box_angle;
  }

  static decltype(::screen_ai::mojom::LineBox::confidence) confidence(
      const ::screen_ai::mojom::LineBoxPtr& input) {
    return input->confidence;
  }

  static bool Read(::screen_ai::mojom::LineBox::DataView input, ::screen_ai::mojom::LineBoxPtr* output);
};


template <>
struct  StructTraits<::screen_ai::mojom::WordBox::DataView,
                                         ::screen_ai::mojom::WordBoxPtr> {
  static bool IsNull(const ::screen_ai::mojom::WordBoxPtr& input) { return !input; }
  static void SetToNull(::screen_ai::mojom::WordBoxPtr* output) { output->reset(); }

  static const decltype(::screen_ai::mojom::WordBox::word)& word(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->word;
  }

  static const decltype(::screen_ai::mojom::WordBox::language)& language(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->language;
  }

  static const decltype(::screen_ai::mojom::WordBox::bounding_box)& bounding_box(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->bounding_box;
  }

  static decltype(::screen_ai::mojom::WordBox::bounding_box_angle) bounding_box_angle(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->bounding_box_angle;
  }

  static decltype(::screen_ai::mojom::WordBox::direction) direction(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->direction;
  }

  static const decltype(::screen_ai::mojom::WordBox::whitespace_bounding_box)& whitespace_bounding_box(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->whitespace_bounding_box;
  }

  static decltype(::screen_ai::mojom::WordBox::whitespace_bounding_box_angle) whitespace_bounding_box_angle(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->whitespace_bounding_box_angle;
  }

  static decltype(::screen_ai::mojom::WordBox::confidence) confidence(
      const ::screen_ai::mojom::WordBoxPtr& input) {
    return input->confidence;
  }

  static bool Read(::screen_ai::mojom::WordBox::DataView input, ::screen_ai::mojom::WordBoxPtr* output);
};
namespace internal {
template <>
inline bool GetRuntimeFeature_IsEnabled<::screen_ai::mojom::ScreenAIAnnotator>() {
  return ::screen_ai::mojom::ScreenAIAnnotator::RuntimeFeature_IsEnabled_(false);
}
template <>
inline bool GetRuntimeFeature_ExpectEnabled<::screen_ai::mojom::ScreenAIAnnotator>() {
  return ::screen_ai::mojom::ScreenAIAnnotator::RuntimeFeature_IsEnabled_(true);
}template <>
inline constexpr bool kIsRuntimeFeatureGuarded<::screen_ai::mojom::ScreenAIAnnotator> = true;
template <>
inline bool GetRuntimeFeature_IsEnabled<::screen_ai::mojom::OCRService>() {
  return ::screen_ai::mojom::OCRService::RuntimeFeature_IsEnabled_(false);
}
template <>
inline bool GetRuntimeFeature_ExpectEnabled<::screen_ai::mojom::OCRService>() {
  return ::screen_ai::mojom::OCRService::RuntimeFeature_IsEnabled_(true);
}template <>
inline constexpr bool kIsRuntimeFeatureGuarded<::screen_ai::mojom::OCRService> = true;
template <>
inline bool GetRuntimeFeature_IsEnabled<::screen_ai::mojom::MainContentExtractionService>() {
  return ::screen_ai::mojom::MainContentExtractionService::RuntimeFeature_IsEnabled_(false);
}
template <>
inline bool GetRuntimeFeature_ExpectEnabled<::screen_ai::mojom::MainContentExtractionService>() {
  return ::screen_ai::mojom::MainContentExtractionService::RuntimeFeature_IsEnabled_(true);
}template <>
inline constexpr bool kIsRuntimeFeatureGuarded<::screen_ai::mojom::MainContentExtractionService> = true;
}  // namespace internal

}  // namespace mojo

#endif  // SERVICES_SCREEN_AI_PUBLIC_MOJOM_SCREEN_AI_SERVICE_MOJOM_H_