// services/screen_ai/public/mojom/screen_ai_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/screen_ai/public/mojom/screen_ai_service.mojom-params-data.h"
namespace screen_ai {
namespace mojom {

NOINLINE static const char* DirectionToStringHelper(Direction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Direction::DIRECTION_UNSPECIFIED:
      return "DIRECTION_UNSPECIFIED";
    case Direction::DIRECTION_LEFT_TO_RIGHT:
      return "DIRECTION_LEFT_TO_RIGHT";
    case Direction::DIRECTION_RIGHT_TO_LEFT:
      return "DIRECTION_RIGHT_TO_LEFT";
    case Direction::DIRECTION_TOP_TO_BOTTOM:
      return "DIRECTION_TOP_TO_BOTTOM";
    default:
      return nullptr;
  }
}

std::string DirectionToString(Direction value) {
  const char *str = DirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Direction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Direction value) {
  return os << DirectionToString(value);
}

NOINLINE static const char* OcrClientTypeToStringHelper(OcrClientType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OcrClientType::kTest:
      return "kTest";
    case OcrClientType::kPdfViewer:
      return "kPdfViewer";
    case OcrClientType::kLocalSearch:
      return "kLocalSearch";
    case OcrClientType::kCameraApp:
      return "kCameraApp";
    case OcrClientType::kMediaApp:
      return "kMediaApp";
    case OcrClientType::kScreenshotTextDetection:
      return "kScreenshotTextDetection";
    default:
      return nullptr;
  }
}

std::string OcrClientTypeToString(OcrClientType value) {
  const char *str = OcrClientTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OcrClientType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OcrClientType value) {
  return os << OcrClientTypeToString(value);
}

NOINLINE static const char* MceClientTypeToStringHelper(MceClientType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MceClientType::kTest:
      return "kTest";
    case MceClientType::kReadingMode:
      return "kReadingMode";
    case MceClientType::kMainNode:
      return "kMainNode";
    case MceClientType::kMahi:
      return "kMahi";
    default:
      return nullptr;
  }
}

std::string MceClientTypeToString(MceClientType value) {
  const char *str = MceClientTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MceClientType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MceClientType value) {
  return os << MceClientTypeToString(value);
}

namespace internal {


// static
bool VisualAnnotation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const VisualAnnotation_Data* object =
      static_cast<const VisualAnnotation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->lines, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& lines_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->lines, validation_context,
                                         &lines_validate_params)) {
    return false;
  }

  return true;
}

VisualAnnotation_Data::VisualAnnotation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LineBox_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LineBox_Data* object =
      static_cast<const LineBox_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->words, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& words_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->words, validation_context,
                                         &words_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_line, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_line_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text_line, validation_context,
                                         &text_line_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounding_box, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounding_box, validation_context))
    return false;

  return true;
}

LineBox_Data::LineBox_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WordBox_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WordBox_Data* object =
      static_cast<const WordBox_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->word, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& word_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->word, validation_context,
                                         &word_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->language, validation_context,
                                         &language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounding_box, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounding_box, validation_context))
    return false;


  if (!::screen_ai::mojom::internal::Direction_Data
        ::Validate(object->direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->whitespace_bounding_box, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->whitespace_bounding_box, validation_context))
    return false;

  return true;
}

WordBox_Data::WordBox_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data* object =
      static_cast<const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data* object =
      static_cast<const ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visual_annotation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visual_annotation, validation_context))
    return false;

  return true;
}

ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data::ScreenAIAnnotator_PerformOcrAndReturnAnnotation_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_SetClientType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_SetClientType_Params_Data* object =
      static_cast<const ScreenAIAnnotator_SetClientType_Params_Data*>(data);


  if (!::screen_ai::mojom::internal::OcrClientType_Data
        ::Validate(object->client_type, validation_context))
    return false;

  return true;
}

ScreenAIAnnotator_SetClientType_Params_Data::ScreenAIAnnotator_SetClientType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_GetMaxImageDimension_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_GetMaxImageDimension_Params_Data* object =
      static_cast<const ScreenAIAnnotator_GetMaxImageDimension_Params_Data*>(data);

  return true;
}

ScreenAIAnnotator_GetMaxImageDimension_Params_Data::ScreenAIAnnotator_GetMaxImageDimension_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data* object =
      static_cast<const ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data*>(data);

  return true;
}

ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data::ScreenAIAnnotator_GetMaxImageDimension_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_SetOCRLightMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_SetOCRLightMode_Params_Data* object =
      static_cast<const ScreenAIAnnotator_SetOCRLightMode_Params_Data*>(data);

  return true;
}

ScreenAIAnnotator_SetOCRLightMode_Params_Data::ScreenAIAnnotator_SetOCRLightMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_IsOCRBusy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_IsOCRBusy_Params_Data* object =
      static_cast<const ScreenAIAnnotator_IsOCRBusy_Params_Data*>(data);

  return true;
}

ScreenAIAnnotator_IsOCRBusy_Params_Data::ScreenAIAnnotator_IsOCRBusy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data* object =
      static_cast<const ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data*>(data);

  return true;
}

ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data::ScreenAIAnnotator_IsOCRBusy_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_ExtractMainContent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_ExtractMainContent_Params_Data* object =
      static_cast<const Screen2xMainContentExtractor_ExtractMainContent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snapshot, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snapshot, validation_context))
    return false;

  return true;
}

Screen2xMainContentExtractor_ExtractMainContent_Params_Data::Screen2xMainContentExtractor_ExtractMainContent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data* object =
      static_cast<const Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_node_ids, validation_context,
                                         &content_node_ids_validate_params)) {
    return false;
  }

  return true;
}

Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data::Screen2xMainContentExtractor_ExtractMainContent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_ExtractMainNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_ExtractMainNode_Params_Data* object =
      static_cast<const Screen2xMainContentExtractor_ExtractMainNode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snapshot, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snapshot, validation_context))
    return false;

  return true;
}

Screen2xMainContentExtractor_ExtractMainNode_Params_Data::Screen2xMainContentExtractor_ExtractMainNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data* object =
      static_cast<const Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data*>(data);

  return true;
}

Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data::Screen2xMainContentExtractor_ExtractMainNode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_IdentifyMainNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_IdentifyMainNode_Params_Data* object =
      static_cast<const Screen2xMainContentExtractor_IdentifyMainNode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ax_tree, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ax_tree, validation_context))
    return false;

  return true;
}

Screen2xMainContentExtractor_IdentifyMainNode_Params_Data::Screen2xMainContentExtractor_IdentifyMainNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data* object =
      static_cast<const Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->tree_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->tree_id, validation_context))
    return false;

  return true;
}

Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data::Screen2xMainContentExtractor_IdentifyMainNode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Screen2xMainContentExtractor_SetClientType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Screen2xMainContentExtractor_SetClientType_Params_Data* object =
      static_cast<const Screen2xMainContentExtractor_SetClientType_Params_Data*>(data);


  if (!::screen_ai::mojom::internal::MceClientType_Data
        ::Validate(object->client_type, validation_context))
    return false;

  return true;
}

Screen2xMainContentExtractor_SetClientType_Params_Data::Screen2xMainContentExtractor_SetClientType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OCRService_BindAnnotator_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OCRService_BindAnnotator_Params_Data* object =
      static_cast<const OCRService_BindAnnotator_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->annotator,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OCRService_BindAnnotator_Params_Data::OCRService_BindAnnotator_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MainContentExtractionService_BindMainContentExtractor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MainContentExtractionService_BindMainContentExtractor_Params_Data* object =
      static_cast<const MainContentExtractionService_BindMainContentExtractor_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->main_content_extractor,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MainContentExtractionService_BindMainContentExtractor_Params_Data::MainContentExtractionService_BindMainContentExtractor_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace screen_ai

namespace perfetto {

// static
void TraceFormatTraits<::screen_ai::mojom::Direction>::WriteIntoTrace(
   perfetto::TracedValue context, ::screen_ai::mojom::Direction value) {
  return std::move(context).WriteString(::screen_ai::mojom::DirectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::screen_ai::mojom::OcrClientType>::WriteIntoTrace(
   perfetto::TracedValue context, ::screen_ai::mojom::OcrClientType value) {
  return std::move(context).WriteString(::screen_ai::mojom::OcrClientTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::screen_ai::mojom::MceClientType>::WriteIntoTrace(
   perfetto::TracedValue context, ::screen_ai::mojom::MceClientType value) {
  return std::move(context).WriteString(::screen_ai::mojom::MceClientTypeToString(value));
}

} // namespace perfetto