// services/screen_ai/public/mojom/screen_ai_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/screen_ai/public/mojom/screen_ai_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-params-data.h"
#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-shared-message-ids.h"

#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-import-headers.h"
#include "services/screen_ai/public/mojom/screen_ai_factory.mojom-test-utils.h"


namespace screen_ai::mojom {
// The declaration includes the definition on other builds.

ScreenAIServiceShutdownHandler::IPCStableHashFunction ScreenAIServiceShutdownHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScreenAIServiceShutdownHandler>(message.name())) {
    case messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle: {
      return &ScreenAIServiceShutdownHandler::ShuttingDownOnIdle_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScreenAIServiceShutdownHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScreenAIServiceShutdownHandler>(message.name())) {
      case messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle:
            return "Receive screen_ai::mojom::ScreenAIServiceShutdownHandler::ShuttingDownOnIdle";
    }
  } else {
    switch (static_cast<messages::ScreenAIServiceShutdownHandler>(message.name())) {
      case messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle:
            return "Receive reply screen_ai::mojom::ScreenAIServiceShutdownHandler::ShuttingDownOnIdle";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScreenAIServiceShutdownHandler::ShuttingDownOnIdle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23a028f1;  // IPCStableHash for screen_ai::mojom::ScreenAIServiceShutdownHandler::ShuttingDownOnIdle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ScreenAIServiceShutdownHandlerProxy::ScreenAIServiceShutdownHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenAIServiceShutdownHandlerProxy::ShuttingDownOnIdle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send screen_ai::mojom::ScreenAIServiceShutdownHandler::ShuttingDownOnIdle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceShutdownHandler_ShuttingDownOnIdle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceShutdownHandler::Name_);
  message.set_method_name("ShuttingDownOnIdle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ScreenAIServiceShutdownHandlerStubDispatch::Accept(
    ScreenAIServiceShutdownHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScreenAIServiceShutdownHandler>(message->header()->name)) {
    case messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle: {
      DCHECK(message->is_serialized());
      internal::ScreenAIServiceShutdownHandler_ShuttingDownOnIdle_Params_Data* params =
          reinterpret_cast<internal::ScreenAIServiceShutdownHandler_ShuttingDownOnIdle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ScreenAIServiceShutdownHandler.0
      bool success = true;
      ScreenAIServiceShutdownHandler_ShuttingDownOnIdle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIServiceShutdownHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShuttingDownOnIdle(        );
      return true;
    }
  }
  return false;
}

// static
bool ScreenAIServiceShutdownHandlerStubDispatch::AcceptWithResponder(
    ScreenAIServiceShutdownHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScreenAIServiceShutdownHandler>(message->header()->name)) {
    case messages::ScreenAIServiceShutdownHandler::kShuttingDownOnIdle: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kScreenAIServiceShutdownHandlerValidationInfo[] = {
    { &internal::ScreenAIServiceShutdownHandler_ShuttingDownOnIdle_Params_Data::Validate,
     nullptr /* no response */},
};

bool ScreenAIServiceShutdownHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::ScreenAIServiceShutdownHandler::Name_,
    kScreenAIServiceShutdownHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

ScreenAIServiceFactory::IPCStableHashFunction ScreenAIServiceFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScreenAIServiceFactory>(message.name())) {
    case messages::ScreenAIServiceFactory::kInitializeOCR: {
      return &ScreenAIServiceFactory::InitializeOCR_Sym::IPCStableHash;
    }
    case messages::ScreenAIServiceFactory::kInitializeMainContentExtraction: {
      return &ScreenAIServiceFactory::InitializeMainContentExtraction_Sym::IPCStableHash;
    }
    case messages::ScreenAIServiceFactory::kBindShutdownHandler: {
      return &ScreenAIServiceFactory::BindShutdownHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScreenAIServiceFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScreenAIServiceFactory>(message.name())) {
      case messages::ScreenAIServiceFactory::kInitializeOCR:
            return "Receive screen_ai::mojom::ScreenAIServiceFactory::InitializeOCR";
      case messages::ScreenAIServiceFactory::kInitializeMainContentExtraction:
            return "Receive screen_ai::mojom::ScreenAIServiceFactory::InitializeMainContentExtraction";
      case messages::ScreenAIServiceFactory::kBindShutdownHandler:
            return "Receive screen_ai::mojom::ScreenAIServiceFactory::BindShutdownHandler";
    }
  } else {
    switch (static_cast<messages::ScreenAIServiceFactory>(message.name())) {
      case messages::ScreenAIServiceFactory::kInitializeOCR:
            return "Receive reply screen_ai::mojom::ScreenAIServiceFactory::InitializeOCR";
      case messages::ScreenAIServiceFactory::kInitializeMainContentExtraction:
            return "Receive reply screen_ai::mojom::ScreenAIServiceFactory::InitializeMainContentExtraction";
      case messages::ScreenAIServiceFactory::kBindShutdownHandler:
            return "Receive reply screen_ai::mojom::ScreenAIServiceFactory::BindShutdownHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScreenAIServiceFactory::InitializeOCR_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa11b1f9;  // IPCStableHash for screen_ai::mojom::ScreenAIServiceFactory::InitializeOCR
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIServiceFactory::InitializeMainContentExtraction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1949b832;  // IPCStableHash for screen_ai::mojom::ScreenAIServiceFactory::InitializeMainContentExtraction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenAIServiceFactory::BindShutdownHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x302a87f2;  // IPCStableHash for screen_ai::mojom::ScreenAIServiceFactory::BindShutdownHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ScreenAIServiceFactory_InitializeOCR_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenAIServiceFactory_InitializeOCR_ForwardToCallback(
      ScreenAIServiceFactory::InitializeOCRCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenAIServiceFactory_InitializeOCR_ForwardToCallback(const ScreenAIServiceFactory_InitializeOCR_ForwardToCallback&) = delete;
  ScreenAIServiceFactory_InitializeOCR_ForwardToCallback& operator=(const ScreenAIServiceFactory_InitializeOCR_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenAIServiceFactory::InitializeOCRCallback callback_;
};

class ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback(
      ScreenAIServiceFactory::InitializeMainContentExtractionCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback(const ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback&) = delete;
  ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback& operator=(const ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenAIServiceFactory::InitializeMainContentExtractionCallback callback_;
};

ScreenAIServiceFactoryProxy::ScreenAIServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenAIServiceFactoryProxy::InitializeOCR(
    const ::base::FilePath& in_library_path, base::flat_map<::base::FilePath, ::base::File> in_model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> in_ocr_service_receiver, InitializeOCRCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIServiceFactory::InitializeOCR", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("library_path"), in_library_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_files"), in_model_files,
                        "<value of type base::flat_map<::base::FilePath, ::base::File>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ocr_service_receiver"), in_ocr_service_receiver,
                        "<value of type ::mojo::PendingReceiver<::screen_ai::mojom::OCRService>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIOCREnabled));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceFactory::kInitializeOCR), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceFactory_InitializeOCR_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->library_path)::BaseType> library_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_library_path,
    library_path_fragment);

  params->library_path.Set(
      library_path_fragment.is_null() ? nullptr : library_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->library_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null library_path in ScreenAIServiceFactory.InitializeOCR request");
  mojo::internal::MessageFragment<
      typename decltype(params->model_files)::BaseType>
      model_files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& model_files_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::RelativeFilePathDataView, ::mojo_base::mojom::ReadOnlyFileDataView>>(
    in_model_files,
    model_files_fragment,
    &model_files_validate_params);

  params->model_files.Set(
      model_files_fragment.is_null() ? nullptr : model_files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_files in ScreenAIServiceFactory.InitializeOCR request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::screen_ai::mojom::OCRServiceInterfaceBase>>(
    in_ocr_service_receiver,
    &params->ocr_service_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceFactory::Name_);
  message.set_method_name("InitializeOCR");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenAIServiceFactory_InitializeOCR_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ScreenAIServiceFactoryProxy::InitializeMainContentExtraction(
    const ::base::FilePath& in_library_path, base::flat_map<::base::FilePath, ::base::File> in_model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> in_main_content_extractor_service, InitializeMainContentExtractionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIServiceFactory::InitializeMainContentExtraction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("library_path"), in_library_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_files"), in_model_files,
                        "<value of type base::flat_map<::base::FilePath, ::base::File>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("main_content_extractor_service"), in_main_content_extractor_service,
                        "<value of type ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService>>");
   });
#endif

  CHECK(base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIMainContentExtractionEnabled));
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceFactory::kInitializeMainContentExtraction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceFactory_InitializeMainContentExtraction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->library_path)::BaseType> library_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_library_path,
    library_path_fragment);

  params->library_path.Set(
      library_path_fragment.is_null() ? nullptr : library_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->library_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null library_path in ScreenAIServiceFactory.InitializeMainContentExtraction request");
  mojo::internal::MessageFragment<
      typename decltype(params->model_files)::BaseType>
      model_files_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& model_files_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<::mojo_base::mojom::RelativeFilePathDataView, ::mojo_base::mojom::ReadOnlyFileDataView>>(
    in_model_files,
    model_files_fragment,
    &model_files_validate_params);

  params->model_files.Set(
      model_files_fragment.is_null() ? nullptr : model_files_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_files.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_files in ScreenAIServiceFactory.InitializeMainContentExtraction request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::screen_ai::mojom::MainContentExtractionServiceInterfaceBase>>(
    in_main_content_extractor_service,
    &params->main_content_extractor_service,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceFactory::Name_);
  message.set_method_name("InitializeMainContentExtraction");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ScreenAIServiceFactoryProxy::BindShutdownHandler(
    ::mojo::PendingRemote<ScreenAIServiceShutdownHandler> in_shutdown_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send screen_ai::mojom::ScreenAIServiceFactory::BindShutdownHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shutdown_handler"), in_shutdown_handler,
                        "<value of type ::mojo::PendingRemote<ScreenAIServiceShutdownHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceFactory::kBindShutdownHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceFactory_BindShutdownHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::screen_ai::mojom::ScreenAIServiceShutdownHandlerInterfaceBase>>(
    in_shutdown_handler,
    &params->shutdown_handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->shutdown_handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid shutdown_handler in ScreenAIServiceFactory.BindShutdownHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceFactory::Name_);
  message.set_method_name("BindShutdownHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ScreenAIServiceFactory_InitializeOCR_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenAIServiceFactory::InitializeOCRCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenAIServiceFactory_InitializeOCR_ProxyToResponder> proxy(
        new ScreenAIServiceFactory_InitializeOCR_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenAIServiceFactory_InitializeOCR_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenAIServiceFactory_InitializeOCR_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenAIServiceFactory_InitializeOCR_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ScreenAIServiceFactory::InitializeOCRCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_initialized);
};

bool ScreenAIServiceFactory_InitializeOCR_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenAIServiceFactory_InitializeOCR_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenAIServiceFactory_InitializeOCR_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ScreenAIServiceFactory.0
  bool success = true;
  bool p_initialized{};
  ScreenAIServiceFactory_InitializeOCR_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_initialized = input_data_view.initialized();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenAIServiceFactory::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_initialized));
  }
  return true;
}

void ScreenAIServiceFactory_InitializeOCR_ProxyToResponder::Run(
    bool in_initialized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::ScreenAIServiceFactory::InitializeOCR", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initialized"), in_initialized,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceFactory::kInitializeOCR), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceFactory_InitializeOCR_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->initialized = in_initialized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceFactory::Name_);
  message.set_method_name("InitializeOCR");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenAIServiceFactory::InitializeMainContentExtractionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder> proxy(
        new ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ScreenAIServiceFactory::InitializeMainContentExtractionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_initialized);
};

bool ScreenAIServiceFactory_InitializeMainContentExtraction_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenAIServiceFactory_InitializeMainContentExtraction_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenAIServiceFactory_InitializeMainContentExtraction_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ScreenAIServiceFactory.1
  bool success = true;
  bool p_initialized{};
  ScreenAIServiceFactory_InitializeMainContentExtraction_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_initialized = input_data_view.initialized();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenAIServiceFactory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_initialized));
  }
  return true;
}

void ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder::Run(
    bool in_initialized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply screen_ai::mojom::ScreenAIServiceFactory::InitializeMainContentExtraction", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initialized"), in_initialized,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenAIServiceFactory::kInitializeMainContentExtraction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::screen_ai::mojom::internal::ScreenAIServiceFactory_InitializeMainContentExtraction_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->initialized = in_initialized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenAIServiceFactory::Name_);
  message.set_method_name("InitializeMainContentExtraction");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenAIServiceFactoryStubDispatch::Accept(
    ScreenAIServiceFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScreenAIServiceFactory>(message->header()->name)) {
    case messages::ScreenAIServiceFactory::kInitializeOCR: {
      break;
    }
    case messages::ScreenAIServiceFactory::kInitializeMainContentExtraction: {
      break;
    }
    case messages::ScreenAIServiceFactory::kBindShutdownHandler: {
      DCHECK(message->is_serialized());
      internal::ScreenAIServiceFactory_BindShutdownHandler_Params_Data* params =
          reinterpret_cast<internal::ScreenAIServiceFactory_BindShutdownHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ScreenAIServiceFactory.2
      bool success = true;
      ::mojo::PendingRemote<ScreenAIServiceShutdownHandler> p_shutdown_handler{};
      ScreenAIServiceFactory_BindShutdownHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_shutdown_handler =
            input_data_view.TakeShutdownHandler<decltype(p_shutdown_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIServiceFactory::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindShutdownHandler(        
        std::move(p_shutdown_handler));
      return true;
    }
  }
  return false;
}

// static
bool ScreenAIServiceFactoryStubDispatch::AcceptWithResponder(
    ScreenAIServiceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScreenAIServiceFactory>(message->header()->name)) {
    case messages::ScreenAIServiceFactory::kInitializeOCR: {
      internal::ScreenAIServiceFactory_InitializeOCR_Params_Data* params =
          reinterpret_cast<
              internal::ScreenAIServiceFactory_InitializeOCR_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ScreenAIServiceFactory.0
      bool success = true;
      ::base::FilePath p_library_path{};
      base::flat_map<::base::FilePath, ::base::File> p_model_files{};
      ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> p_ocr_service_receiver{};
      ScreenAIServiceFactory_InitializeOCR_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLibraryPath(&p_library_path))
        success = false;
      if (success && !input_data_view.ReadModelFiles(&p_model_files))
        success = false;
      if (success) {
        p_ocr_service_receiver =
            input_data_view.TakeOcrServiceReceiver<decltype(p_ocr_service_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIServiceFactory::Name_, 0, false);
        return false;
      }
      auto callback =
          ScreenAIServiceFactory_InitializeOCR_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeOCR(        
        std::move(p_library_path), 
        std::move(p_model_files), 
        std::move(p_ocr_service_receiver), std::move(callback));
      return true;
    }
    case messages::ScreenAIServiceFactory::kInitializeMainContentExtraction: {
      internal::ScreenAIServiceFactory_InitializeMainContentExtraction_Params_Data* params =
          reinterpret_cast<
              internal::ScreenAIServiceFactory_InitializeMainContentExtraction_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ScreenAIServiceFactory.1
      bool success = true;
      ::base::FilePath p_library_path{};
      base::flat_map<::base::FilePath, ::base::File> p_model_files{};
      ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> p_main_content_extractor_service{};
      ScreenAIServiceFactory_InitializeMainContentExtraction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLibraryPath(&p_library_path))
        success = false;
      if (success && !input_data_view.ReadModelFiles(&p_model_files))
        success = false;
      if (success) {
        p_main_content_extractor_service =
            input_data_view.TakeMainContentExtractorService<decltype(p_main_content_extractor_service)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenAIServiceFactory::Name_, 1, false);
        return false;
      }
      auto callback =
          ScreenAIServiceFactory_InitializeMainContentExtraction_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InitializeMainContentExtraction(        
        std::move(p_library_path), 
        std::move(p_model_files), 
        std::move(p_main_content_extractor_service), std::move(callback));
      return true;
    }
    case messages::ScreenAIServiceFactory::kBindShutdownHandler: {
      break;
    }
  }
  return false;
}
namespace {

bool ValidateWithRuntimeFeature_ScreenAIServiceFactory_InitializeOCR(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIOCREnabled)) {
    return false;
  }
  return internal::ScreenAIServiceFactory_InitializeOCR_Params_Data::Validate(
    data, validation_context);
}

bool ValidateWithRuntimeFeature_ScreenAIServiceFactory_InitializeMainContentExtraction(
  const void* data, mojo::internal::ValidationContext* validation_context) {
  if (!base::FeatureList::IsEnabled(::ax::mojom::features::kScreenAIMainContentExtractionEnabled)) {
    return false;
  }
  return internal::ScreenAIServiceFactory_InitializeMainContentExtraction_Params_Data::Validate(
    data, validation_context);
}
}  // namespace
static const mojo::internal::GenericValidationInfo kScreenAIServiceFactoryValidationInfo[] = {
    { &ValidateWithRuntimeFeature_ScreenAIServiceFactory_InitializeOCR,
     &internal::ScreenAIServiceFactory_InitializeOCR_ResponseParams_Data::Validate},
    { &ValidateWithRuntimeFeature_ScreenAIServiceFactory_InitializeMainContentExtraction,
     &internal::ScreenAIServiceFactory_InitializeMainContentExtraction_ResponseParams_Data::Validate},
    { &internal::ScreenAIServiceFactory_BindShutdownHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ScreenAIServiceFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::screen_ai::mojom::ScreenAIServiceFactory::Name_,
    kScreenAIServiceFactoryValidationInfo);
}

bool ScreenAIServiceFactoryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::screen_ai::mojom::ScreenAIServiceFactory::Name_,
    kScreenAIServiceFactoryValidationInfo);
}


}  // screen_ai::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace screen_ai::mojom {


void ScreenAIServiceShutdownHandlerInterceptorForTesting::ShuttingDownOnIdle() {
  GetForwardingInterface()->ShuttingDownOnIdle();
}
ScreenAIServiceShutdownHandlerAsyncWaiter::ScreenAIServiceShutdownHandlerAsyncWaiter(
    ScreenAIServiceShutdownHandler* proxy) : proxy_(proxy) {}

ScreenAIServiceShutdownHandlerAsyncWaiter::~ScreenAIServiceShutdownHandlerAsyncWaiter() = default;





void ScreenAIServiceFactoryInterceptorForTesting::InitializeOCR(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> ocr_service_receiver, InitializeOCRCallback callback) {
  GetForwardingInterface()->InitializeOCR(
    std::move(library_path)
    , 
    std::move(model_files)
    , 
    std::move(ocr_service_receiver)
    , std::move(callback));
}
void ScreenAIServiceFactoryInterceptorForTesting::InitializeMainContentExtraction(const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> main_content_extractor_service, InitializeMainContentExtractionCallback callback) {
  GetForwardingInterface()->InitializeMainContentExtraction(
    std::move(library_path)
    , 
    std::move(model_files)
    , 
    std::move(main_content_extractor_service)
    , std::move(callback));
}
void ScreenAIServiceFactoryInterceptorForTesting::BindShutdownHandler(::mojo::PendingRemote<ScreenAIServiceShutdownHandler> shutdown_handler) {
  GetForwardingInterface()->BindShutdownHandler(
    std::move(shutdown_handler)
    );
}
ScreenAIServiceFactoryAsyncWaiter::ScreenAIServiceFactoryAsyncWaiter(
    ScreenAIServiceFactory* proxy) : proxy_(proxy) {}

ScreenAIServiceFactoryAsyncWaiter::~ScreenAIServiceFactoryAsyncWaiter() = default;


void ScreenAIServiceFactoryAsyncWaiter::InitializeOCR(
    const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> ocr_service_receiver, bool* out_initialized) {
  base::RunLoop loop;
  proxy_->InitializeOCR(
      std::move(library_path),
      std::move(model_files),
      std::move(ocr_service_receiver),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_initialized
,
             bool initialized) {*out_initialized = std::move(initialized);
            loop->Quit();
          },
          &loop,
          out_initialized));
  loop.Run();
}

bool ScreenAIServiceFactoryAsyncWaiter::InitializeOCR(
    const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::OCRService> ocr_service_receiver) {
  bool async_wait_result;
  InitializeOCR(std::move(library_path),std::move(model_files),std::move(ocr_service_receiver),&async_wait_result);
  return async_wait_result;
}

void ScreenAIServiceFactoryAsyncWaiter::InitializeMainContentExtraction(
    const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> main_content_extractor_service, bool* out_initialized) {
  base::RunLoop loop;
  proxy_->InitializeMainContentExtraction(
      std::move(library_path),
      std::move(model_files),
      std::move(main_content_extractor_service),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_initialized
,
             bool initialized) {*out_initialized = std::move(initialized);
            loop->Quit();
          },
          &loop,
          out_initialized));
  loop.Run();
}

bool ScreenAIServiceFactoryAsyncWaiter::InitializeMainContentExtraction(
    const ::base::FilePath& library_path, base::flat_map<::base::FilePath, ::base::File> model_files, ::mojo::PendingReceiver<::screen_ai::mojom::MainContentExtractionService> main_content_extractor_service) {
  bool async_wait_result;
  InitializeMainContentExtraction(std::move(library_path),std::move(model_files),std::move(main_content_extractor_service),&async_wait_result);
  return async_wait_result;
}






}  // screen_ai::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif