// services/resource_coordinator/public/mojom/memory_instrumentation/memory_instrumentation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  BigString as mojoBase_mojom_BigString,
  BigStringSpec as mojoBase_mojom_BigStringSpec
} from '../../../../../mojo/public/mojom/base/big_string.mojom.m.js';

import {
  ProcessId as mojoBase_mojom_ProcessId,
  ProcessIdSpec as mojoBase_mojom_ProcessIdSpec
} from '../../../../../mojo/public/mojom/base/process_id.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DumpTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DumpType = {
  
  PERIODIC_INTERVAL: 0,
  EXPLICITLY_TRIGGERED: 1,
  SUMMARY_ONLY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const LevelOfDetailSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const LevelOfDetail = {
  
  BACKGROUND: 0,
  LIGHT: 1,
  DETAILED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeterminismSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const Determinism = {
  
  NONE: 0,
  FORCE_GC: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ProcessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ProcessType = {
  
  OTHER: 0,
  BROWSER: 1,
  RENDERER: 2,
  GPU: 3,
  UTILITY: 4,
  PLUGIN: 5,
  ARC: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MemoryMapOptionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MemoryMapOption = {
  
  NONE: 0,
  MODULES: 1,
  FULL: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MemDumpFlagsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MemDumpFlags = {
  
  MEM_DUMP_COUNT_MAPPINGS: 0,
  MEM_DUMP_PSS: 1,
  MEM_DUMP_PAGES_BITMAP: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ClientProcessPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'memory_instrumentation.mojom.ClientProcess', scope);
  }
}

/** @interface */
export class ClientProcessInterface {
  
  /**
   * @param { !RequestArgs } args
   * @return {!Promise<{
        success: !boolean,
        dumpId: !bigint,
        rawProcessMemoryDump: ?RawProcessMemoryDump,
   *  }>}
   */

  requestChromeMemoryDump(args) {}
  
  /**
   * @param { !MemoryMapOption } option
   * @param { !Array<!MemDumpFlags> } flags
   * @param { !Array<!mojoBase_mojom_ProcessId> } pids
   * @return {!Promise<{
        success: !boolean,
        dumps: !Map<!mojoBase_mojom_ProcessId, !RawOSMemDump>,
   *  }>}
   */

  requestOSMemoryDump(option, flags, pids) {}
}

/**
 * @implements { ClientProcessInterface }
 */
export class ClientProcessRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ClientProcessPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ClientProcessPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ClientProcessPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !RequestArgs } args
   * @return {!Promise<{
        success: !boolean,
        dumpId: !bigint,
        rawProcessMemoryDump: ?RawProcessMemoryDump,
   *  }>}
   */

  requestChromeMemoryDump(
      args) {
    return this.proxy.sendMessage(
        0,
        ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        [
          args
        ],
        false);
  }

  
  /**
   * @param { !MemoryMapOption } option
   * @param { !Array<!MemDumpFlags> } flags
   * @param { !Array<!mojoBase_mojom_ProcessId> } pids
   * @return {!Promise<{
        success: !boolean,
        dumps: !Map<!mojoBase_mojom_ProcessId, !RawOSMemDump>,
   *  }>}
   */

  requestOSMemoryDump(
      option,
      flags,
      pids) {
    return this.proxy.sendMessage(
        1,
        ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        [
          option,
          flags,
          pids
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ClientProcess
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ClientProcessReceiver {
  /**
   * @param {!ClientProcessInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ClientProcessRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ClientProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClientProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        impl.requestChromeMemoryDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        impl.requestOSMemoryDump.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ClientProcess {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.ClientProcess";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ClientProcessRemote}
   */
  static getRemote() {
    let remote = new ClientProcessRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ClientProcess
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ClientProcessCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ClientProcessRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ClientProcessRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestChromeMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
        ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
        this.requestChromeMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestOSMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
        ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
        this.requestOSMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HeapProfilerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'memory_instrumentation.mojom.HeapProfiler', scope);
  }
}

/** @interface */
export class HeapProfilerInterface {
  
  /**
   * @param { !boolean } stripPathFromMappedFiles
   * @param { !boolean } writeProto
   * @return {!Promise<{
        results: !Array<!HeapProfileResult>,
   *  }>}
   */

  dumpProcessesForTracing(stripPathFromMappedFiles, writeProto) {}
}

/**
 * @implements { HeapProfilerInterface }
 */
export class HeapProfilerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HeapProfilerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HeapProfilerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HeapProfilerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } stripPathFromMappedFiles
   * @param { !boolean } writeProto
   * @return {!Promise<{
        results: !Array<!HeapProfileResult>,
   *  }>}
   */

  dumpProcessesForTracing(
      stripPathFromMappedFiles,
      writeProto) {
    return this.proxy.sendMessage(
        0,
        HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        [
          stripPathFromMappedFiles,
          writeProto
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HeapProfiler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HeapProfilerReceiver {
  /**
   * @param {!HeapProfilerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HeapProfilerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HeapProfilerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapProfilerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        impl.dumpProcessesForTracing.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HeapProfiler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.HeapProfiler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HeapProfilerRemote}
   */
  static getRemote() {
    let remote = new HeapProfilerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HeapProfiler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HeapProfilerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HeapProfilerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapProfilerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpProcessesForTracing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
        HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
        this.dumpProcessesForTracing.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HeapProfilerHelperPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'memory_instrumentation.mojom.HeapProfilerHelper', scope);
  }
}

/** @interface */
export class HeapProfilerHelperInterface {
  
  /**
   * @param { !Array<!mojoBase_mojom_ProcessId> } pids
   * @return {!Promise<{
        vmRegions: !Map<!mojoBase_mojom_ProcessId, !Array<!VmRegion>>,
   *  }>}
   */

  getVmRegionsForHeapProfiler(pids) {}
}

/**
 * @implements { HeapProfilerHelperInterface }
 */
export class HeapProfilerHelperRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HeapProfilerHelperPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HeapProfilerHelperPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HeapProfilerHelperPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!mojoBase_mojom_ProcessId> } pids
   * @return {!Promise<{
        vmRegions: !Map<!mojoBase_mojom_ProcessId, !Array<!VmRegion>>,
   *  }>}
   */

  getVmRegionsForHeapProfiler(
      pids) {
    return this.proxy.sendMessage(
        0,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        [
          pids
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HeapProfilerHelper
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HeapProfilerHelperReceiver {
  /**
   * @param {!HeapProfilerHelperInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HeapProfilerHelperRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HeapProfilerHelperRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapProfilerHelperRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        impl.getVmRegionsForHeapProfiler.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HeapProfilerHelper {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.HeapProfilerHelper";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HeapProfilerHelperRemote}
   */
  static getRemote() {
    let remote = new HeapProfilerHelperRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HeapProfilerHelper
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HeapProfilerHelperCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HeapProfilerHelperRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HeapProfilerHelperRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVmRegionsForHeapProfiler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
        HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
        this.getVmRegionsForHeapProfiler.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CoordinatorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'memory_instrumentation.mojom.Coordinator', scope);
  }
}

/** @interface */
export class CoordinatorInterface {
  
  /**
   * @param { !DumpType } dumpType
   * @param { !LevelOfDetail } levelOfDetail
   * @param { !Determinism } determinism
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDump(dumpType, levelOfDetail, determinism, allocatorDumpNames) {}
  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDumpForPid(pid, allocatorDumpNames) {}
  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestPrivateMemoryFootprint(pid) {}
  
  /**
   * @param { !DumpType } dumpType
   * @param { !LevelOfDetail } levelOfDetail
   * @param { !Determinism } determinism
   * @return {!Promise<{
        success: !boolean,
        dumpId: !bigint,
   *  }>}
   */

  requestGlobalMemoryDumpAndAppendToTrace(dumpType, levelOfDetail, determinism) {}
}

/**
 * @implements { CoordinatorInterface }
 */
export class CoordinatorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CoordinatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CoordinatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CoordinatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DumpType } dumpType
   * @param { !LevelOfDetail } levelOfDetail
   * @param { !Determinism } determinism
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDump(
      dumpType,
      levelOfDetail,
      determinism,
      allocatorDumpNames) {
    return this.proxy.sendMessage(
        0,
        Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        [
          dumpType,
          levelOfDetail,
          determinism,
          allocatorDumpNames
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   * @param { !Array<!string> } allocatorDumpNames
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestGlobalMemoryDumpForPid(
      pid,
      allocatorDumpNames) {
    return this.proxy.sendMessage(
        1,
        Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        [
          pid,
          allocatorDumpNames
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ProcessId } pid
   * @return {!Promise<{
        success: !boolean,
        globalMemoryDump: ?GlobalMemoryDump,
   *  }>}
   */

  requestPrivateMemoryFootprint(
      pid) {
    return this.proxy.sendMessage(
        2,
        Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        [
          pid
        ],
        false);
  }

  
  /**
   * @param { !DumpType } dumpType
   * @param { !LevelOfDetail } levelOfDetail
   * @param { !Determinism } determinism
   * @return {!Promise<{
        success: !boolean,
        dumpId: !bigint,
   *  }>}
   */

  requestGlobalMemoryDumpAndAppendToTrace(
      dumpType,
      levelOfDetail,
      determinism) {
    return this.proxy.sendMessage(
        3,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        [
          dumpType,
          levelOfDetail,
          determinism
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Coordinator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CoordinatorReceiver {
  /**
   * @param {!CoordinatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CoordinatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CoordinatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoordinatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDumpForPid.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        impl.requestPrivateMemoryFootprint.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        impl.requestGlobalMemoryDumpAndAppendToTrace.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Coordinator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.Coordinator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CoordinatorRemote}
   */
  static getRemote() {
    let remote = new CoordinatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Coordinator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CoordinatorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CoordinatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoordinatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
        this.requestGlobalMemoryDump.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDumpForPid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
        this.requestGlobalMemoryDumpForPid.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPrivateMemoryFootprint =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
        Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
        this.requestPrivateMemoryFootprint.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGlobalMemoryDumpAndAppendToTrace =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
        Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
        this.requestGlobalMemoryDumpAndAppendToTrace.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CoordinatorConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'memory_instrumentation.mojom.CoordinatorConnector', scope);
  }
}

/** @interface */
export class CoordinatorConnectorInterface {
  
  /**
   * @param { !CoordinatorPendingReceiver } receiver
   * @param { !ClientProcessRemote } clientProcess
   */

  registerCoordinatorClient(receiver, clientProcess) {}
}

/**
 * @implements { CoordinatorConnectorInterface }
 */
export class CoordinatorConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CoordinatorConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CoordinatorConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CoordinatorConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CoordinatorPendingReceiver } receiver
   * @param { !ClientProcessRemote } clientProcess
   */

  registerCoordinatorClient(
      receiver,
      clientProcess) {
    this.proxy.sendMessage(
        0,
        CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        [
          receiver,
          clientProcess
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CoordinatorConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CoordinatorConnectorReceiver {
  /**
   * @param {!CoordinatorConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CoordinatorConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CoordinatorConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoordinatorConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        impl.registerCoordinatorClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CoordinatorConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "memory_instrumentation.mojom.CoordinatorConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CoordinatorConnectorRemote}
   */
  static getRemote() {
    let remote = new CoordinatorConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CoordinatorConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CoordinatorConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CoordinatorConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CoordinatorConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerCoordinatorClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
        null,
        this.registerCoordinatorClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RequestArgsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RawAllocatorDumpEdgeSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RawAllocatorDumpEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RawAllocatorDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RawProcessMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VmRegionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PlatformPrivateFootprintSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RawOSMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const OSMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AllocatorMemDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProcessMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AggregatedMetricsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GlobalMemoryDumpSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapProfileResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientProcess_RequestChromeMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientProcess_RequestOSMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ClientProcess_RequestOSMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapProfiler_DumpProcessesForTracing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestPrivateMemoryFootprint_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const RawAllocatorDumpEntryValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RequestArgsSpec.$,
    'RequestArgs',
    [
      mojo.internal.StructField(
        'dumpGuid', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dumpType', 8,
        0,
        DumpTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 12,
        0,
        LevelOfDetailSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'determinism', 16,
        0,
        DeterminismSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RequestArgs {
  constructor() {
    /** @type { !bigint } */
    this.dumpGuid;
    /** @type { !DumpType } */
    this.dumpType;
    /** @type { !LevelOfDetail } */
    this.levelOfDetail;
    /** @type { !Determinism } */
    this.determinism;
  }
}



mojo.internal.Struct(
    RawAllocatorDumpEdgeSpec.$,
    'RawAllocatorDumpEdge',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'targetId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'importance', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'overridable', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RawAllocatorDumpEdge {
  constructor() {
    /** @type { !bigint } */
    this.sourceId;
    /** @type { !bigint } */
    this.targetId;
    /** @type { !number } */
    this.importance;
    /** @type { !boolean } */
    this.overridable;
  }
}



mojo.internal.Struct(
    RawAllocatorDumpEntrySpec.$,
    'RawAllocatorDumpEntry',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'units', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 16,
        0,
        RawAllocatorDumpEntryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RawAllocatorDumpEntry {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.units;
    /** @type { !RawAllocatorDumpEntryValue } */
    this.value;
  }
}



mojo.internal.Struct(
    RawAllocatorDumpSpec.$,
    'RawAllocatorDump',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'absoluteName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'weak', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 20,
        0,
        LevelOfDetailSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'entries', 24,
        0,
        mojo.internal.Array(RawAllocatorDumpEntrySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class RawAllocatorDump {
  constructor() {
    /** @type { !bigint } */
    this.id;
    /** @type { !string } */
    this.absoluteName;
    /** @type { !boolean } */
    this.weak;
    /** @type { !LevelOfDetail } */
    this.levelOfDetail;
    /** @type { !Array<!RawAllocatorDumpEntry> } */
    this.entries;
  }
}



mojo.internal.Struct(
    RawProcessMemoryDumpSpec.$,
    'RawProcessMemoryDump',
    [
      mojo.internal.StructField(
        'levelOfDetail', 0,
        0,
        LevelOfDetailSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allocatorDumpEdges', 8,
        0,
        mojo.internal.Array(RawAllocatorDumpEdgeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allocatorDumps', 16,
        0,
        mojo.internal.Array(RawAllocatorDumpSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class RawProcessMemoryDump {
  constructor() {
    /** @type { !LevelOfDetail } */
    this.levelOfDetail;
    /** @type { !Array<!RawAllocatorDumpEdge> } */
    this.allocatorDumpEdges;
    /** @type { !Array<!RawAllocatorDump> } */
    this.allocatorDumps;
  }
}

/**
 * @const { !number }
 */
export const VmRegion_PROTECTION_FLAGS_READ =
    4;

/**
 * @const { !number }
 */
export const VmRegion_PROTECTION_FLAGS_WRITE =
    2;

/**
 * @const { !number }
 */
export const VmRegion_PROTECTION_FLAGS_EXEC =
    1;

/**
 * @const { !number }
 */
export const VmRegion_PROTECTION_FLAGS_MAYSHARE =
    128;



mojo.internal.Struct(
    VmRegionSpec.$,
    'VmRegion',
    [
      mojo.internal.StructField(
        'startAddress', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizeInBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'moduleTimestamp', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'moduleDebugid', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'moduleDebugPath', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protectionFlags', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mappedFile', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsPrivateDirtyResident', 56,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsPrivateCleanResident', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsSharedDirtyResident', 72,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsSharedCleanResident', 80,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsSwapped', 88,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteLocked', 96,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'byteStatsProportionalResident', 104,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 120],]);



/**
 * @record
 */
export class VmRegion {
  constructor() {
    /** @type { !bigint } */
    this.startAddress;
    /** @type { !bigint } */
    this.sizeInBytes;
    /** @type { !bigint } */
    this.moduleTimestamp;
    /** @type { !string } */
    this.moduleDebugid;
    /** @type { !string } */
    this.moduleDebugPath;
    /** @type { !number } */
    this.protectionFlags;
    /** @type { !string } */
    this.mappedFile;
    /** @type { !bigint } */
    this.byteStatsPrivateDirtyResident;
    /** @type { !bigint } */
    this.byteStatsPrivateCleanResident;
    /** @type { !bigint } */
    this.byteStatsSharedDirtyResident;
    /** @type { !bigint } */
    this.byteStatsSharedCleanResident;
    /** @type { !bigint } */
    this.byteStatsSwapped;
    /** @type { !bigint } */
    this.byteLocked;
    /** @type { !bigint } */
    this.byteStatsProportionalResident;
  }
}



mojo.internal.Struct(
    PlatformPrivateFootprintSpec.$,
    'PlatformPrivateFootprint',
    [
      mojo.internal.StructField(
        'physFootprintBytes', 0,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'internalBytes', 8,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'compressedBytes', 16,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rssAnonBytes', 24,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vmSwapBytes', 32,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privateBytes', 40,
        0,
        mojo.internal.Uint64,
        BigInt('0'),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class PlatformPrivateFootprint {
  constructor() {
    /** @type { !bigint } */
    this.physFootprintBytes;
    /** @type { !bigint } */
    this.internalBytes;
    /** @type { !bigint } */
    this.compressedBytes;
    /** @type { !bigint } */
    this.rssAnonBytes;
    /** @type { !bigint } */
    this.vmSwapBytes;
    /** @type { !bigint } */
    this.privateBytes;
  }
}



mojo.internal.Struct(
    RawOSMemDumpSpec.$,
    'RawOSMemDump',
    [
      mojo.internal.StructField(
        'residentSetKb', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peakResidentSetKb', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPeakRssResettable', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'platformPrivateFootprint', 16,
        0,
        PlatformPrivateFootprintSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'memoryMaps', 24,
        0,
        mojo.internal.Array(VmRegionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeLibraryPagesBitmap', 32,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class RawOSMemDump {
  constructor() {
    /** @type { !number } */
    this.residentSetKb;
    /** @type { !number } */
    this.peakResidentSetKb;
    /** @type { !boolean } */
    this.isPeakRssResettable;
    /** @type { !PlatformPrivateFootprint } */
    this.platformPrivateFootprint;
    /** @type { !Array<!VmRegion> } */
    this.memoryMaps;
    /** @type { !Array<!number> } */
    this.nativeLibraryPagesBitmap;
  }
}



mojo.internal.Struct(
    OSMemDumpSpec.$,
    'OSMemDump',
    [
      mojo.internal.StructField(
        'residentSetKb', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peakResidentSetKb', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPeakRssResettable', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'privateFootprintKb', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sharedFootprintKb', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class OSMemDump {
  constructor() {
    /** @type { !number } */
    this.residentSetKb;
    /** @type { !number } */
    this.peakResidentSetKb;
    /** @type { !boolean } */
    this.isPeakRssResettable;
    /** @type { !number } */
    this.privateFootprintKb;
    /** @type { !number } */
    this.sharedFootprintKb;
  }
}



mojo.internal.Struct(
    AllocatorMemDumpSpec.$,
    'AllocatorMemDump',
    [
      mojo.internal.StructField(
        'numericEntries', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Uint64, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'children', 8,
        0,
        mojo.internal.Map(mojo.internal.String, AllocatorMemDumpSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AllocatorMemDump {
  constructor() {
    /** @type { !Object<!string, !bigint> } */
    this.numericEntries;
    /** @type { !Object<!string, !AllocatorMemDump> } */
    this.children;
  }
}



mojo.internal.Struct(
    ProcessMemoryDumpSpec.$,
    'ProcessMemoryDump',
    [
      mojo.internal.StructField(
        'processType', 0,
        0,
        ProcessTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'osDump', 8,
        0,
        OSMemDumpSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'chromeAllocatorDumps', 16,
        0,
        mojo.internal.Map(mojo.internal.String, AllocatorMemDumpSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pid', 24,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serviceName', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ProcessMemoryDump {
  constructor() {
    /** @type { !ProcessType } */
    this.processType;
    /** @type { !OSMemDump } */
    this.osDump;
    /** @type { !Object<!string, !AllocatorMemDump> } */
    this.chromeAllocatorDumps;
    /** @type { !mojoBase_mojom_ProcessId } */
    this.pid;
    /** @type { (string|undefined) } */
    this.serviceName;
  }
}



mojo.internal.Struct(
    AggregatedMetricsSpec.$,
    'AggregatedMetrics',
    [
      mojo.internal.StructField(
        'nativeLibraryResidentKb', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeLibraryResidentNotOrderedKb', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nativeLibraryNotResidentOrderedKb', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AggregatedMetrics {
  constructor() {
    /** @type { !number } */
    this.nativeLibraryResidentKb;
    /** @type { !number } */
    this.nativeLibraryResidentNotOrderedKb;
    /** @type { !number } */
    this.nativeLibraryNotResidentOrderedKb;
  }
}



mojo.internal.Struct(
    GlobalMemoryDumpSpec.$,
    'GlobalMemoryDump',
    [
      mojo.internal.StructField(
        'startTime', 0,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'processDumps', 8,
        0,
        mojo.internal.Array(ProcessMemoryDumpSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'aggregatedMetrics', 16,
        0,
        AggregatedMetricsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class GlobalMemoryDump {
  constructor() {
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.startTime;
    /** @type { !Array<!ProcessMemoryDump> } */
    this.processDumps;
    /** @type { !AggregatedMetrics } */
    this.aggregatedMetrics;
  }
}



mojo.internal.Struct(
    HeapProfileResultSpec.$,
    'HeapProfileResult',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'json', 8,
        0,
        mojoBase_mojom_BigStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HeapProfileResult {
  constructor() {
    /** @type { !mojoBase_mojom_ProcessId } */
    this.pid;
    /** @type { !mojoBase_mojom_BigString } */
    this.json;
  }
}



mojo.internal.Struct(
    ClientProcess_RequestChromeMemoryDump_ParamsSpec.$,
    'ClientProcess_RequestChromeMemoryDump_Params',
    [
      mojo.internal.StructField(
        'args', 0,
        0,
        RequestArgsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ClientProcess_RequestChromeMemoryDump_Params {
  constructor() {
    /** @type { !RequestArgs } */
    this.args;
  }
}



mojo.internal.Struct(
    ClientProcess_RequestChromeMemoryDump_ResponseParamsSpec.$,
    'ClientProcess_RequestChromeMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dumpId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rawProcessMemoryDump', 16,
        0,
        RawProcessMemoryDumpSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ClientProcess_RequestChromeMemoryDump_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !bigint } */
    this.dumpId;
    /** @type { (RawProcessMemoryDump|undefined) } */
    this.rawProcessMemoryDump;
  }
}



mojo.internal.Struct(
    ClientProcess_RequestOSMemoryDump_ParamsSpec.$,
    'ClientProcess_RequestOSMemoryDump_Params',
    [
      mojo.internal.StructField(
        'option', 0,
        0,
        MemoryMapOptionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 8,
        0,
        mojo.internal.Array(MemDumpFlagsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pids', 16,
        0,
        mojo.internal.Array(mojoBase_mojom_ProcessIdSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ClientProcess_RequestOSMemoryDump_Params {
  constructor() {
    /** @type { !MemoryMapOption } */
    this.option;
    /** @type { !Array<!MemDumpFlags> } */
    this.flags;
    /** @type { !Array<!mojoBase_mojom_ProcessId> } */
    this.pids;
  }
}



mojo.internal.Struct(
    ClientProcess_RequestOSMemoryDump_ResponseParamsSpec.$,
    'ClientProcess_RequestOSMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dumps', 8,
        0,
        mojo.internal.Map(mojoBase_mojom_ProcessIdSpec.$, RawOSMemDumpSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ClientProcess_RequestOSMemoryDump_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !Map<!mojoBase_mojom_ProcessId, !RawOSMemDump> } */
    this.dumps;
  }
}



mojo.internal.Struct(
    HeapProfiler_DumpProcessesForTracing_ParamsSpec.$,
    'HeapProfiler_DumpProcessesForTracing_Params',
    [
      mojo.internal.StructField(
        'stripPathFromMappedFiles', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'writeProto', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeapProfiler_DumpProcessesForTracing_Params {
  constructor() {
    /** @type { !boolean } */
    this.stripPathFromMappedFiles;
    /** @type { !boolean } */
    this.writeProto;
  }
}



mojo.internal.Struct(
    HeapProfiler_DumpProcessesForTracing_ResponseParamsSpec.$,
    'HeapProfiler_DumpProcessesForTracing_ResponseParams',
    [
      mojo.internal.StructField(
        'results', 0,
        0,
        mojo.internal.Array(HeapProfileResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeapProfiler_DumpProcessesForTracing_ResponseParams {
  constructor() {
    /** @type { !Array<!HeapProfileResult> } */
    this.results;
  }
}



mojo.internal.Struct(
    HeapProfilerHelper_GetVmRegionsForHeapProfiler_ParamsSpec.$,
    'HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params',
    [
      mojo.internal.StructField(
        'pids', 0,
        0,
        mojo.internal.Array(mojoBase_mojom_ProcessIdSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeapProfilerHelper_GetVmRegionsForHeapProfiler_Params {
  constructor() {
    /** @type { !Array<!mojoBase_mojom_ProcessId> } */
    this.pids;
  }
}



mojo.internal.Struct(
    HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParamsSpec.$,
    'HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams',
    [
      mojo.internal.StructField(
        'vmRegions', 0,
        0,
        mojo.internal.Map(mojoBase_mojom_ProcessIdSpec.$, mojo.internal.Array(VmRegionSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HeapProfilerHelper_GetVmRegionsForHeapProfiler_ResponseParams {
  constructor() {
    /** @type { !Map<!mojoBase_mojom_ProcessId, !Array<!VmRegion>> } */
    this.vmRegions;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDump_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDump_Params',
    [
      mojo.internal.StructField(
        'dumpType', 0,
        0,
        DumpTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 4,
        0,
        LevelOfDetailSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'determinism', 8,
        0,
        DeterminismSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allocatorDumpNames', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDump_Params {
  constructor() {
    /** @type { !DumpType } */
    this.dumpType;
    /** @type { !LevelOfDetail } */
    this.levelOfDetail;
    /** @type { !Determinism } */
    this.determinism;
    /** @type { !Array<!string> } */
    this.allocatorDumpNames;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDump_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDump_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        GlobalMemoryDumpSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDump_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDumpForPid_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpForPid_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allocatorDumpNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDumpForPid_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ProcessId } */
    this.pid;
    /** @type { !Array<!string> } */
    this.allocatorDumpNames;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDumpForPid_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        GlobalMemoryDumpSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDumpForPid_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
}



mojo.internal.Struct(
    Coordinator_RequestPrivateMemoryFootprint_ParamsSpec.$,
    'Coordinator_RequestPrivateMemoryFootprint_Params',
    [
      mojo.internal.StructField(
        'pid', 0,
        0,
        mojoBase_mojom_ProcessIdSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Coordinator_RequestPrivateMemoryFootprint_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ProcessId } */
    this.pid;
  }
}



mojo.internal.Struct(
    Coordinator_RequestPrivateMemoryFootprint_ResponseParamsSpec.$,
    'Coordinator_RequestPrivateMemoryFootprint_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'globalMemoryDump', 8,
        0,
        GlobalMemoryDumpSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestPrivateMemoryFootprint_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (GlobalMemoryDump|undefined) } */
    this.globalMemoryDump;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params',
    [
      mojo.internal.StructField(
        'dumpType', 0,
        0,
        DumpTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'levelOfDetail', 4,
        0,
        LevelOfDetailSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'determinism', 8,
        0,
        DeterminismSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_Params {
  constructor() {
    /** @type { !DumpType } */
    this.dumpType;
    /** @type { !LevelOfDetail } */
    this.levelOfDetail;
    /** @type { !Determinism } */
    this.determinism;
  }
}



mojo.internal.Struct(
    Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParamsSpec.$,
    'Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dumpId', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Coordinator_RequestGlobalMemoryDumpAndAppendToTrace_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !bigint } */
    this.dumpId;
  }
}



mojo.internal.Struct(
    CoordinatorConnector_RegisterCoordinatorClient_ParamsSpec.$,
    'CoordinatorConnector_RegisterCoordinatorClient_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(CoordinatorPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientProcess', 4,
        0,
        mojo.internal.InterfaceProxy(ClientProcessRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CoordinatorConnector_RegisterCoordinatorClient_Params {
  constructor() {
    /** @type { !CoordinatorPendingReceiver } */
    this.receiver;
    /** @type { !ClientProcessRemote } */
    this.clientProcess;
  }
}

mojo.internal.Union(
    RawAllocatorDumpEntryValueSpec.$, 'RawAllocatorDumpEntryValue',
    {
      'valueUint64': {
        'ordinal': 0,
        'type': mojo.internal.Uint64,
      },
      'valueString': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   valueUint64: (!bigint|undefined),
 *   valueString: (!string|undefined),
 * } }
 */
export const RawAllocatorDumpEntryValue = {};
