// services/proxy_resolver/public/mojom/proxy_resolver.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from '../../../network/public/mojom/ip_address.mojom.m.js';

import {
  NetworkAnonymizationKey as network_mojom_NetworkAnonymizationKey,
  NetworkAnonymizationKeySpec as network_mojom_NetworkAnonymizationKeySpec
} from '../../../network/public/mojom/network_anonymization_key.mojom.m.js';

import {
  ProxyChain as network_mojom_ProxyChain,
  ProxyChainSpec as network_mojom_ProxyChainSpec
} from '../../../network/public/mojom/network_param.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HostResolveOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HostResolveOperation = {
  
  DNS_RESOLVE: 0,
  DNS_RESOLVE_EX: 1,
  MY_IP_ADDRESS: 2,
  MY_IP_ADDRESS_EX: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HostResolverRequestClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'proxy_resolver.mojom.HostResolverRequestClient', scope);
  }
}

/** @interface */
export class HostResolverRequestClientInterface {
  
  /**
   * @param { !number } error
   * @param { !Array<!network_mojom_IPAddress> } result
   */

  reportResult(error, result) {}
}

/**
 * @implements { HostResolverRequestClientInterface }
 */
export class HostResolverRequestClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HostResolverRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HostResolverRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HostResolverRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   * @param { !Array<!network_mojom_IPAddress> } result
   */

  reportResult(
      error,
      result) {
    this.proxy.sendMessage(
        0,
        HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error,
          result
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HostResolverRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HostResolverRequestClientReceiver {
  /**
   * @param {!HostResolverRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HostResolverRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HostResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HostResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HostResolverRequestClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.HostResolverRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HostResolverRequestClientRemote}
   */
  static getRemote() {
    let remote = new HostResolverRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HostResolverRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HostResolverRequestClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HostResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HostResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'proxy_resolver.mojom.ProxyResolver', scope);
  }
}

/** @interface */
export class ProxyResolverInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !ProxyResolverRequestClientRemote } client
   */

  getProxyForUrl(url, networkAnonymizationKey, client) {}
}

/**
 * @implements { ProxyResolverInterface }
 */
export class ProxyResolverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !ProxyResolverRequestClientRemote } client
   */

  getProxyForUrl(
      url,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        0,
        ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        [
          url,
          networkAnonymizationKey,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolverReceiver {
  /**
   * @param {!ProxyResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        impl.getProxyForUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolverRemote}
   */
  static getRemote() {
    let remote = new ProxyResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProxyForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        this.getProxyForUrl.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolverRequestClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'proxy_resolver.mojom.ProxyResolverRequestClient', scope);
  }
}

/** @interface */
export class ProxyResolverRequestClientInterface {
  
  /**
   * @param { !number } error
   * @param { !ProxyInfo } proxyInfo
   */

  reportResult(error, proxyInfo) {}
  
  /**
   * @param { !string } error
   */

  alert(error) {}
  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(lineNumber, error) {}
  
  /**
   * @param { !string } host
   * @param { !HostResolveOperation } operation
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !HostResolverRequestClientRemote } client
   */

  resolveDns(host, operation, networkAnonymizationKey, client) {}
}

/**
 * @implements { ProxyResolverRequestClientInterface }
 */
export class ProxyResolverRequestClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolverRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolverRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolverRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   * @param { !ProxyInfo } proxyInfo
   */

  reportResult(
      error,
      proxyInfo) {
    this.proxy.sendMessage(
        0,
        ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error,
          proxyInfo
        ],
        false);
  }

  
  /**
   * @param { !string } error
   */

  alert(
      error) {
    this.proxy.sendMessage(
        1,
        ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(
      lineNumber,
      error) {
    this.proxy.sendMessage(
        2,
        ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        [
          lineNumber,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !HostResolveOperation } operation
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !HostResolverRequestClientRemote } client
   */

  resolveDns(
      host,
      operation,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        3,
        ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        [
          host,
          operation,
          networkAnonymizationKey,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolverRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolverRequestClientReceiver {
  /**
   * @param {!ProxyResolverRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolverRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        impl.alert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        impl.resolveDns.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolverRequestClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolverRequestClientRemote}
   */
  static getRemote() {
    let remote = new ProxyResolverRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolverRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolverRequestClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.alert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        this.alert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        this.resolveDns.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolverFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'proxy_resolver.mojom.ProxyResolverFactory', scope);
  }
}

/** @interface */
export class ProxyResolverFactoryInterface {
  
  /**
   * @param { !string } pacScript
   * @param { !ProxyResolverPendingReceiver } receiver
   * @param { !ProxyResolverFactoryRequestClientRemote } client
   */

  createResolver(pacScript, receiver, client) {}
}

/**
 * @implements { ProxyResolverFactoryInterface }
 */
export class ProxyResolverFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolverFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolverFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolverFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } pacScript
   * @param { !ProxyResolverPendingReceiver } receiver
   * @param { !ProxyResolverFactoryRequestClientRemote } client
   */

  createResolver(
      pacScript,
      receiver,
      client) {
    this.proxy.sendMessage(
        0,
        ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        [
          pacScript,
          receiver,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolverFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolverFactoryReceiver {
  /**
   * @param {!ProxyResolverFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolverFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolverFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        impl.createResolver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolverFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolverFactoryRemote}
   */
  static getRemote() {
    let remote = new ProxyResolverFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolverFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolverFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolverFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        this.createResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyResolverFactoryRequestClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'proxy_resolver.mojom.ProxyResolverFactoryRequestClient', scope);
  }
}

/** @interface */
export class ProxyResolverFactoryRequestClientInterface {
  
  /**
   * @param { !number } error
   */

  reportResult(error) {}
  
  /**
   * @param { !string } error
   */

  alert(error) {}
  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(lineNumber, error) {}
  
  /**
   * @param { !string } host
   * @param { !HostResolveOperation } operation
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !HostResolverRequestClientRemote } client
   */

  resolveDns(host, operation, networkAnonymizationKey, client) {}
}

/**
 * @implements { ProxyResolverFactoryRequestClientInterface }
 */
export class ProxyResolverFactoryRequestClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyResolverFactoryRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyResolverFactoryRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyResolverFactoryRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   */

  reportResult(
      error) {
    this.proxy.sendMessage(
        0,
        ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !string } error
   */

  alert(
      error) {
    this.proxy.sendMessage(
        1,
        ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(
      lineNumber,
      error) {
    this.proxy.sendMessage(
        2,
        ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        [
          lineNumber,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !HostResolveOperation } operation
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !HostResolverRequestClientRemote } client
   */

  resolveDns(
      host,
      operation,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        3,
        ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        [
          host,
          operation,
          networkAnonymizationKey,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyResolverFactoryRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyResolverFactoryRequestClientReceiver {
  /**
   * @param {!ProxyResolverFactoryRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyResolverFactoryRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyResolverFactoryRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverFactoryRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        impl.alert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        impl.resolveDns.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyResolverFactoryRequestClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverFactoryRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyResolverFactoryRequestClientRemote}
   */
  static getRemote() {
    let remote = new ProxyResolverFactoryRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyResolverFactoryRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyResolverFactoryRequestClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyResolverFactoryRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyResolverFactoryRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.alert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        this.alert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        this.resolveDns.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HostResolverRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolver_GetProxyForUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverRequestClient_Alert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverRequestClient_ResolveDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverFactory_CreateResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverFactoryRequestClient_Alert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverFactoryRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProxyInfoSpec.$,
    'ProxyInfo',
    [
      mojo.internal.StructField(
        'proxyChains', 0,
        0,
        mojo.internal.Array(network_mojom_ProxyChainSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyInfo {
  constructor() {
    /** @type { !Array<!network_mojom_ProxyChain> } */
    this.proxyChains;
  }
}



mojo.internal.Struct(
    HostResolverRequestClient_ReportResult_ParamsSpec.$,
    'HostResolverRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Array(network_mojom_IPAddressSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HostResolverRequestClient_ReportResult_Params {
  constructor() {
    /** @type { !number } */
    this.error;
    /** @type { !Array<!network_mojom_IPAddress> } */
    this.result;
  }
}



mojo.internal.Struct(
    ProxyResolver_GetProxyForUrl_ParamsSpec.$,
    'ProxyResolver_GetProxyForUrl_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(ProxyResolverRequestClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ProxyResolver_GetProxyForUrl_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !ProxyResolverRequestClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
    'ProxyResolverRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyInfo', 8,
        0,
        ProxyInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyResolverRequestClient_ReportResult_Params {
  constructor() {
    /** @type { !number } */
    this.error;
    /** @type { !ProxyInfo } */
    this.proxyInfo;
  }
}



mojo.internal.Struct(
    ProxyResolverRequestClient_Alert_ParamsSpec.$,
    'ProxyResolverRequestClient_Alert_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyResolverRequestClient_Alert_Params {
  constructor() {
    /** @type { !string } */
    this.error;
  }
}



mojo.internal.Struct(
    ProxyResolverRequestClient_OnError_ParamsSpec.$,
    'ProxyResolverRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyResolverRequestClient_OnError_Params {
  constructor() {
    /** @type { !number } */
    this.lineNumber;
    /** @type { !string } */
    this.error;
  }
}



mojo.internal.Struct(
    ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
    'ProxyResolverRequestClient_ResolveDns_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'operation', 8,
        0,
        HostResolveOperationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 32,
        0,
        mojo.internal.InterfaceProxy(HostResolverRequestClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ProxyResolverRequestClient_ResolveDns_Params {
  constructor() {
    /** @type { !string } */
    this.host;
    /** @type { !HostResolveOperation } */
    this.operation;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !HostResolverRequestClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    ProxyResolverFactory_CreateResolver_ParamsSpec.$,
    'ProxyResolverFactory_CreateResolver_Params',
    [
      mojo.internal.StructField(
        'pacScript', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(ProxyResolverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 12,
        0,
        mojo.internal.InterfaceProxy(ProxyResolverFactoryRequestClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ProxyResolverFactory_CreateResolver_Params {
  constructor() {
    /** @type { !string } */
    this.pacScript;
    /** @type { !ProxyResolverPendingReceiver } */
    this.receiver;
    /** @type { !ProxyResolverFactoryRequestClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyResolverFactoryRequestClient_ReportResult_Params {
  constructor() {
    /** @type { !number } */
    this.error;
  }
}



mojo.internal.Struct(
    ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_Alert_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ProxyResolverFactoryRequestClient_Alert_Params {
  constructor() {
    /** @type { !string } */
    this.error;
  }
}



mojo.internal.Struct(
    ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyResolverFactoryRequestClient_OnError_Params {
  constructor() {
    /** @type { !number } */
    this.lineNumber;
    /** @type { !string } */
    this.error;
  }
}



mojo.internal.Struct(
    ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_ResolveDns_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'operation', 8,
        0,
        HostResolveOperationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 32,
        0,
        mojo.internal.InterfaceProxy(HostResolverRequestClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ProxyResolverFactoryRequestClient_ResolveDns_Params {
  constructor() {
    /** @type { !string } */
    this.host;
    /** @type { !HostResolveOperation } */
    this.operation;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { !HostResolverRequestClientRemote } */
    this.client;
  }
}

