// services/proxy_resolver/public/mojom/proxy_resolver.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.IPAddress');
goog.require('network.mojom.ProxyChain');
goog.require('url.mojom.Url');
goog.require('network.mojom.NetworkAnonymizationKey');




goog.provide('proxyResolver.mojom.HostResolveOperation');
goog.provide('proxyResolver.mojom.HostResolveOperationSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
proxyResolver.mojom.HostResolveOperationSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
proxyResolver.mojom.HostResolveOperation = {
  
  DNS_RESOLVE: 0,
  DNS_RESOLVE_EX: 1,
  MY_IP_ADDRESS: 2,
  MY_IP_ADDRESS_EX: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



goog.provide('proxyResolver.mojom.HostResolverRequestClient');
goog.provide('proxyResolver.mojom.HostResolverRequestClientReceiver');
goog.provide('proxyResolver.mojom.HostResolverRequestClientCallbackRouter');
goog.provide('proxyResolver.mojom.HostResolverRequestClientInterface');
goog.provide('proxyResolver.mojom.HostResolverRequestClientRemote');
goog.provide('proxyResolver.mojom.HostResolverRequestClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
proxyResolver.mojom.HostResolverRequestClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        proxyResolver.mojom.HostResolverRequestClient.$interfaceName,
        scope);
  }
};

/** @interface */
proxyResolver.mojom.HostResolverRequestClientInterface = class {
  
  /**
   * @param { !number } error
   * @param { !Array<!network.mojom.IPAddress> } result
   */

  reportResult(error, result) {}
};

/**
 * @export
 * @implements { proxyResolver.mojom.HostResolverRequestClientInterface }
 */
proxyResolver.mojom.HostResolverRequestClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!proxyResolver.mojom.HostResolverRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          proxyResolver.mojom.HostResolverRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!proxyResolver.mojom.HostResolverRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   * @param { !Array<!network.mojom.IPAddress> } result
   */

  reportResult(
      error,
      result) {
    this.proxy.sendMessage(
        0,
        proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error,
          result
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HostResolverRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
proxyResolver.mojom.HostResolverRequestClientReceiver = class {
  /**
   * @param {!proxyResolver.mojom.HostResolverRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!proxyResolver.mojom.HostResolverRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        proxyResolver.mojom.HostResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.HostResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
proxyResolver.mojom.HostResolverRequestClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.HostResolverRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!proxyResolver.mojom.HostResolverRequestClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new proxyResolver.mojom.HostResolverRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HostResolverRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
proxyResolver.mojom.HostResolverRequestClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      proxyResolver.mojom.HostResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.HostResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('proxyResolver.mojom.ProxyResolver');
goog.provide('proxyResolver.mojom.ProxyResolverReceiver');
goog.provide('proxyResolver.mojom.ProxyResolverCallbackRouter');
goog.provide('proxyResolver.mojom.ProxyResolverInterface');
goog.provide('proxyResolver.mojom.ProxyResolverRemote');
goog.provide('proxyResolver.mojom.ProxyResolverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
proxyResolver.mojom.ProxyResolverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        proxyResolver.mojom.ProxyResolver.$interfaceName,
        scope);
  }
};

/** @interface */
proxyResolver.mojom.ProxyResolverInterface = class {
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.ProxyResolverRequestClientRemote } client
   */

  getProxyForUrl(url, networkAnonymizationKey, client) {}
};

/**
 * @export
 * @implements { proxyResolver.mojom.ProxyResolverInterface }
 */
proxyResolver.mojom.ProxyResolverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!proxyResolver.mojom.ProxyResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          proxyResolver.mojom.ProxyResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!proxyResolver.mojom.ProxyResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.ProxyResolverRequestClientRemote } client
   */

  getProxyForUrl(
      url,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        0,
        proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        [
          url,
          networkAnonymizationKey,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverReceiver = class {
  /**
   * @param {!proxyResolver.mojom.ProxyResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!proxyResolver.mojom.ProxyResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        proxyResolver.mojom.ProxyResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        impl.getProxyForUrl.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
proxyResolver.mojom.ProxyResolver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!proxyResolver.mojom.ProxyResolverRemote}
   * @export
   */
  static getRemote() {
    let remote = new proxyResolver.mojom.ProxyResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      proxyResolver.mojom.ProxyResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProxyForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec.$,
        null,
        this.getProxyForUrl.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('proxyResolver.mojom.ProxyResolverRequestClient');
goog.provide('proxyResolver.mojom.ProxyResolverRequestClientReceiver');
goog.provide('proxyResolver.mojom.ProxyResolverRequestClientCallbackRouter');
goog.provide('proxyResolver.mojom.ProxyResolverRequestClientInterface');
goog.provide('proxyResolver.mojom.ProxyResolverRequestClientRemote');
goog.provide('proxyResolver.mojom.ProxyResolverRequestClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        proxyResolver.mojom.ProxyResolverRequestClient.$interfaceName,
        scope);
  }
};

/** @interface */
proxyResolver.mojom.ProxyResolverRequestClientInterface = class {
  
  /**
   * @param { !number } error
   * @param { !proxyResolver.mojom.ProxyInfo } proxyInfo
   */

  reportResult(error, proxyInfo) {}
  
  /**
   * @param { !string } error
   */

  alert(error) {}
  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(lineNumber, error) {}
  
  /**
   * @param { !string } host
   * @param { !proxyResolver.mojom.HostResolveOperation } operation
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.HostResolverRequestClientRemote } client
   */

  resolveDns(host, operation, networkAnonymizationKey, client) {}
};

/**
 * @export
 * @implements { proxyResolver.mojom.ProxyResolverRequestClientInterface }
 */
proxyResolver.mojom.ProxyResolverRequestClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!proxyResolver.mojom.ProxyResolverRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          proxyResolver.mojom.ProxyResolverRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!proxyResolver.mojom.ProxyResolverRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   * @param { !proxyResolver.mojom.ProxyInfo } proxyInfo
   */

  reportResult(
      error,
      proxyInfo) {
    this.proxy.sendMessage(
        0,
        proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error,
          proxyInfo
        ],
        false);
  }

  
  /**
   * @param { !string } error
   */

  alert(
      error) {
    this.proxy.sendMessage(
        1,
        proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(
      lineNumber,
      error) {
    this.proxy.sendMessage(
        2,
        proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        [
          lineNumber,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !proxyResolver.mojom.HostResolveOperation } operation
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.HostResolverRequestClientRemote } client
   */

  resolveDns(
      host,
      operation,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        3,
        proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        [
          host,
          operation,
          networkAnonymizationKey,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolverRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClientReceiver = class {
  /**
   * @param {!proxyResolver.mojom.ProxyResolverRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!proxyResolver.mojom.ProxyResolverRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        proxyResolver.mojom.ProxyResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        impl.alert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        impl.resolveDns.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
proxyResolver.mojom.ProxyResolverRequestClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!proxyResolver.mojom.ProxyResolverRequestClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new proxyResolver.mojom.ProxyResolverRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolverRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      proxyResolver.mojom.ProxyResolverRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.alert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec.$,
        null,
        this.alert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
        null,
        this.resolveDns.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('proxyResolver.mojom.ProxyResolverFactory');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryReceiver');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryCallbackRouter');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryInterface');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRemote');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        proxyResolver.mojom.ProxyResolverFactory.$interfaceName,
        scope);
  }
};

/** @interface */
proxyResolver.mojom.ProxyResolverFactoryInterface = class {
  
  /**
   * @param { !string } pacScript
   * @param { !proxyResolver.mojom.ProxyResolverPendingReceiver } receiver
   * @param { !proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote } client
   */

  createResolver(pacScript, receiver, client) {}
};

/**
 * @export
 * @implements { proxyResolver.mojom.ProxyResolverFactoryInterface }
 */
proxyResolver.mojom.ProxyResolverFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!proxyResolver.mojom.ProxyResolverFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          proxyResolver.mojom.ProxyResolverFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!proxyResolver.mojom.ProxyResolverFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } pacScript
   * @param { !proxyResolver.mojom.ProxyResolverPendingReceiver } receiver
   * @param { !proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote } client
   */

  createResolver(
      pacScript,
      receiver,
      client) {
    this.proxy.sendMessage(
        0,
        proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        [
          pacScript,
          receiver,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolverFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryReceiver = class {
  /**
   * @param {!proxyResolver.mojom.ProxyResolverFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!proxyResolver.mojom.ProxyResolverFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        proxyResolver.mojom.ProxyResolverFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        impl.createResolver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
proxyResolver.mojom.ProxyResolverFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!proxyResolver.mojom.ProxyResolverFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new proxyResolver.mojom.ProxyResolverFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolverFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      proxyResolver.mojom.ProxyResolverFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec.$,
        null,
        this.createResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClientReceiver');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClientCallbackRouter');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClientInterface');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote');
goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient.$interfaceName,
        scope);
  }
};

/** @interface */
proxyResolver.mojom.ProxyResolverFactoryRequestClientInterface = class {
  
  /**
   * @param { !number } error
   */

  reportResult(error) {}
  
  /**
   * @param { !string } error
   */

  alert(error) {}
  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(lineNumber, error) {}
  
  /**
   * @param { !string } host
   * @param { !proxyResolver.mojom.HostResolveOperation } operation
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.HostResolverRequestClientRemote } client
   */

  resolveDns(host, operation, networkAnonymizationKey, client) {}
};

/**
 * @export
 * @implements { proxyResolver.mojom.ProxyResolverFactoryRequestClientInterface }
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!proxyResolver.mojom.ProxyResolverFactoryRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          proxyResolver.mojom.ProxyResolverFactoryRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!proxyResolver.mojom.ProxyResolverFactoryRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } error
   */

  reportResult(
      error) {
    this.proxy.sendMessage(
        0,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !string } error
   */

  alert(
      error) {
    this.proxy.sendMessage(
        1,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }

  
  /**
   * @param { !number } lineNumber
   * @param { !string } error
   */

  onError(
      lineNumber,
      error) {
    this.proxy.sendMessage(
        2,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        [
          lineNumber,
          error
        ],
        false);
  }

  
  /**
   * @param { !string } host
   * @param { !proxyResolver.mojom.HostResolveOperation } operation
   * @param { !network.mojom.NetworkAnonymizationKey } networkAnonymizationKey
   * @param { !proxyResolver.mojom.HostResolverRequestClientRemote } client
   */

  resolveDns(
      host,
      operation,
      networkAnonymizationKey,
      client) {
    this.proxy.sendMessage(
        3,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        [
          host,
          operation,
          networkAnonymizationKey,
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ProxyResolverFactoryRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClientReceiver = class {
  /**
   * @param {!proxyResolver.mojom.ProxyResolverFactoryRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        impl.reportResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        impl.alert.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        impl.resolveDns.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "proxy_resolver.mojom.ProxyResolverFactoryRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ProxyResolverFactoryRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reportResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
        null,
        this.reportResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.alert =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
        null,
        this.alert.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveDns =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
        null,
        this.resolveDns.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('proxyResolver.mojom.ProxyInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    proxyResolver.mojom.ProxyInfoSpec.$,
    'ProxyInfo',
    [
      mojo.internal.StructField(
        'proxyChains', 0,
        0,
        mojo.internal.Array(network.mojom.ProxyChainSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('proxyResolver.mojom.ProxyInfo');

/** @record */
proxyResolver.mojom.ProxyInfo = class {
  constructor() {
    /** @export { !Array<!network.mojom.ProxyChain> } */
    this.proxyChains;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.HostResolverRequestClient_ReportResult_ParamsSpec.$,
    'HostResolverRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        mojo.internal.Array(network.mojom.IPAddressSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('proxyResolver.mojom.HostResolverRequestClient_ReportResult_Params');

/** @record */
proxyResolver.mojom.HostResolverRequestClient_ReportResult_Params = class {
  constructor() {
    /** @export { !number } */
    this.error;
    /** @export { !Array<!network.mojom.IPAddress> } */
    this.result;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolver_GetProxyForUrl_ParamsSpec.$,
    'ProxyResolver_GetProxyForUrl_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 8,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(proxyResolver.mojom.ProxyResolverRequestClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('proxyResolver.mojom.ProxyResolver_GetProxyForUrl_Params');

/** @record */
proxyResolver.mojom.ProxyResolver_GetProxyForUrl_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !proxyResolver.mojom.ProxyResolverRequestClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_ParamsSpec.$,
    'ProxyResolverRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyInfo', 8,
        0,
        proxyResolver.mojom.ProxyInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_Params');

/** @record */
proxyResolver.mojom.ProxyResolverRequestClient_ReportResult_Params = class {
  constructor() {
    /** @export { !number } */
    this.error;
    /** @export { !proxyResolver.mojom.ProxyInfo } */
    this.proxyInfo;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverRequestClient_Alert_ParamsSpec.$,
    'ProxyResolverRequestClient_Alert_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_Alert_Params');

/** @record */
proxyResolver.mojom.ProxyResolverRequestClient_Alert_Params = class {
  constructor() {
    /** @export { !string } */
    this.error;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverRequestClient_OnError_ParamsSpec.$,
    'ProxyResolverRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_OnError_Params');

/** @record */
proxyResolver.mojom.ProxyResolverRequestClient_OnError_Params = class {
  constructor() {
    /** @export { !number } */
    this.lineNumber;
    /** @export { !string } */
    this.error;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_ParamsSpec.$,
    'ProxyResolverRequestClient_ResolveDns_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operation', 8,
        0,
        proxyResolver.mojom.HostResolveOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 32,
        0,
        mojo.internal.InterfaceProxy(proxyResolver.mojom.HostResolverRequestClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_Params');

/** @record */
proxyResolver.mojom.ProxyResolverRequestClient_ResolveDns_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
    /** @export { !proxyResolver.mojom.HostResolveOperation } */
    this.operation;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !proxyResolver.mojom.HostResolverRequestClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverFactory_CreateResolver_ParamsSpec.$,
    'ProxyResolverFactory_CreateResolver_Params',
    [
      mojo.internal.StructField(
        'pacScript', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'receiver', 8,
        0,
        mojo.internal.InterfaceRequest(proxyResolver.mojom.ProxyResolverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 12,
        0,
        mojo.internal.InterfaceProxy(proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('proxyResolver.mojom.ProxyResolverFactory_CreateResolver_Params');

/** @record */
proxyResolver.mojom.ProxyResolverFactory_CreateResolver_Params = class {
  constructor() {
    /** @export { !string } */
    this.pacScript;
    /** @export { !proxyResolver.mojom.ProxyResolverPendingReceiver } */
    this.receiver;
    /** @export { !proxyResolver.mojom.ProxyResolverFactoryRequestClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_ReportResult_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_Params');

/** @record */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_ReportResult_Params = class {
  constructor() {
    /** @export { !number } */
    this.error;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_Alert_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_Params');

/** @record */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_Alert_Params = class {
  constructor() {
    /** @export { !string } */
    this.error;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_OnError_Params',
    [
      mojo.internal.StructField(
        'lineNumber', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_Params');

/** @record */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_OnError_Params = class {
  constructor() {
    /** @export { !number } */
    this.lineNumber;
    /** @export { !string } */
    this.error;
  }
};



mojo.internal.Struct(
    proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_ParamsSpec.$,
    'ProxyResolverFactoryRequestClient_ResolveDns_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'operation', 8,
        0,
        proxyResolver.mojom.HostResolveOperationSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network.mojom.NetworkAnonymizationKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 32,
        0,
        mojo.internal.InterfaceProxy(proxyResolver.mojom.HostResolverRequestClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);



goog.provide('proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_Params');

/** @record */
proxyResolver.mojom.ProxyResolverFactoryRequestClient_ResolveDns_Params = class {
  constructor() {
    /** @export { !string } */
    this.host;
    /** @export { !proxyResolver.mojom.HostResolveOperation } */
    this.operation;
    /** @export { !network.mojom.NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @export { !proxyResolver.mojom.HostResolverRequestClientRemote } */
    this.client;
  }
};

