// services/passage_embeddings/public/mojom/passage_embeddings.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_DATA_VIEW_H_
#define SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/passage_embeddings/public/mojom/passage_embeddings.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"


namespace passage_embeddings::mojom {
class PassageEmbeddingsResultDataView;

class PassageEmbeddingsLoadModelsParamsDataView;

class PassageEmbedderParamsDataView;



}  // passage_embeddings::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::passage_embeddings::mojom::PassageEmbeddingsResultDataView> {
  using Data = ::passage_embeddings::mojom::internal::PassageEmbeddingsResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::passage_embeddings::mojom::PassageEmbeddingsLoadModelsParamsDataView> {
  using Data = ::passage_embeddings::mojom::internal::PassageEmbeddingsLoadModelsParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::passage_embeddings::mojom::PassageEmbedderParamsDataView> {
  using Data = ::passage_embeddings::mojom::internal::PassageEmbedderParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace passage_embeddings::mojom {


enum class PassagePriority : int32_t {
  
  kUnknown = 0,
  
  kUrgent = 1,
  
  kUserInitiated = 2,
  
  kPassive = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, PassagePriority value);
inline bool IsKnownEnumValue(PassagePriority value) {
  return internal::PassagePriority_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PassageEmbedderInterfaceBase {};

using PassageEmbedderPtrDataView =
    mojo::InterfacePtrDataView<PassageEmbedderInterfaceBase>;
using PassageEmbedderRequestDataView =
    mojo::InterfaceRequestDataView<PassageEmbedderInterfaceBase>;
using PassageEmbedderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PassageEmbedderInterfaceBase>;
using PassageEmbedderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PassageEmbedderInterfaceBase>;
class PassageEmbeddingsServiceInterfaceBase {};

using PassageEmbeddingsServicePtrDataView =
    mojo::InterfacePtrDataView<PassageEmbeddingsServiceInterfaceBase>;
using PassageEmbeddingsServiceRequestDataView =
    mojo::InterfaceRequestDataView<PassageEmbeddingsServiceInterfaceBase>;
using PassageEmbeddingsServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PassageEmbeddingsServiceInterfaceBase>;
using PassageEmbeddingsServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PassageEmbeddingsServiceInterfaceBase>;


class PassageEmbeddingsResultDataView {
 public:
  PassageEmbeddingsResultDataView() = default;

  PassageEmbeddingsResultDataView(
      internal::PassageEmbeddingsResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmbeddingsDataView(
      mojo::ArrayDataView<float>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddings(UserType* output) {
    
    auto* pointer = data_->embeddings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<float>>(
        pointer, output, message_);
  }
 private:
  internal::PassageEmbeddingsResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PassageEmbeddingsLoadModelsParamsDataView {
 public:
  PassageEmbeddingsLoadModelsParamsDataView() = default;

  PassageEmbeddingsLoadModelsParamsDataView(
      internal::PassageEmbeddingsLoadModelsParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetEmbeddingsModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEmbeddingsModel(UserType* output) {
    
    auto* pointer = data_->embeddings_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetSpModelDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSpModel(UserType* output) {
    
    auto* pointer = data_->sp_model.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  uint32_t input_window_size() const {
    return data_->input_window_size;
  }
 private:
  internal::PassageEmbeddingsLoadModelsParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PassageEmbedderParamsDataView {
 public:
  PassageEmbedderParamsDataView() = default;

  PassageEmbedderParamsDataView(
      internal::PassageEmbedderParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t user_initiated_priority_num_threads() const {
    return data_->user_initiated_priority_num_threads;
  }
  uint32_t urgent_priority_num_threads() const {
    return data_->urgent_priority_num_threads;
  }
  uint32_t passive_priority_num_threads() const {
    return data_->passive_priority_num_threads;
  }
  uint32_t embedder_cache_size() const {
    return data_->embedder_cache_size;
  }
  bool allow_gpu_execution() const {
    return data_->allow_gpu_execution;
  }
 private:
  internal::PassageEmbedderParams_Data* data_ = nullptr;
};


}  // passage_embeddings::mojom

#endif  // SERVICES_PASSAGE_EMBEDDINGS_PUBLIC_MOJOM_PASSAGE_EMBEDDINGS_MOJOM_DATA_VIEW_H_