// services/on_device_model/public/mojom/on_device_model_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/on_device_model/public/mojom/on_device_model_service.mojom-params-data.h"
namespace on_device_model {
namespace mojom {

NOINLINE static const char* ModelBackendTypeToStringHelper(ModelBackendType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModelBackendType::kGpu:
      return "kGpu";
    case ModelBackendType::kApu:
      return "kApu";
    case ModelBackendType::kCpu:
      return "kCpu";
    default:
      return nullptr;
  }
}

std::string ModelBackendTypeToString(ModelBackendType value) {
  const char *str = ModelBackendTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModelBackendType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModelBackendType value) {
  return os << ModelBackendTypeToString(value);
}

NOINLINE static const char* ModelPerformanceHintToStringHelper(ModelPerformanceHint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ModelPerformanceHint::kHighestQuality:
      return "kHighestQuality";
    case ModelPerformanceHint::kFastestInference:
      return "kFastestInference";
    default:
      return nullptr;
  }
}

std::string ModelPerformanceHintToString(ModelPerformanceHint value) {
  const char *str = ModelPerformanceHintToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ModelPerformanceHint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ModelPerformanceHint value) {
  return os << ModelPerformanceHintToString(value);
}

NOINLINE static const char* PlatformModelStateToStringHelper(PlatformModelState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PlatformModelState::kUnknownState:
      return "kUnknownState";
    case PlatformModelState::kInstalledOnDisk:
      return "kInstalledOnDisk";
    case PlatformModelState::kInvalidUuid:
      return "kInvalidUuid";
    case PlatformModelState::kInvalidDlcClient:
      return "kInvalidDlcClient";
    case PlatformModelState::kInvalidDlcPackage:
      return "kInvalidDlcPackage";
    case PlatformModelState::kInvalidDlcVerifiedState:
      return "kInvalidDlcVerifiedState";
    case PlatformModelState::kInvalidDlcInstall:
      return "kInvalidDlcInstall";
    case PlatformModelState::kInvalidModelFormat:
      return "kInvalidModelFormat";
    case PlatformModelState::kInvalidModelDescriptor:
      return "kInvalidModelDescriptor";
    case PlatformModelState::kInvalidBaseModelDescriptor:
      return "kInvalidBaseModelDescriptor";
    default:
      return nullptr;
  }
}

std::string PlatformModelStateToString(PlatformModelState value) {
  const char *str = PlatformModelStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PlatformModelState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PlatformModelState value) {
  return os << PlatformModelStateToString(value);
}

NOINLINE static const char* FormatFeatureToStringHelper(FormatFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FormatFeature::kNone:
      return "kNone";
    case FormatFeature::kPrompt:
      return "kPrompt";
    case FormatFeature::kAudioSummary:
      return "kAudioSummary";
    case FormatFeature::kAudioTitle:
      return "kAudioTitle";
    default:
      return nullptr;
  }
}

std::string FormatFeatureToString(FormatFeature value) {
  const char *str = FormatFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FormatFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FormatFeature value) {
  return os << FormatFeatureToString(value);
}

NOINLINE static const char* SafetyFeatureToStringHelper(SafetyFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SafetyFeature::kGeneral:
      return "kGeneral";
    case SafetyFeature::kAudioSummaryRequest:
      return "kAudioSummaryRequest";
    case SafetyFeature::kAudioTitleRequest:
      return "kAudioTitleRequest";
    case SafetyFeature::kAudioSummaryResponse:
      return "kAudioSummaryResponse";
    case SafetyFeature::kAudioTitleResponse:
      return "kAudioTitleResponse";
    case SafetyFeature::kAudioSummaryResponseV2:
      return "kAudioSummaryResponseV2";
    case SafetyFeature::kAudioTitleResponseV2:
      return "kAudioTitleResponseV2";
    default:
      return nullptr;
  }
}

std::string SafetyFeatureToString(SafetyFeature value) {
  const char *str = SafetyFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SafetyFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SafetyFeature value) {
  return os << SafetyFeatureToString(value);
}

namespace internal {
// static
bool ModelFile_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ModelFile_Data* object = static_cast<const ModelFile_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ModelFile_Tag::kFile: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_file, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_file, validation_context))
        return false;
      return true;
    }
    case ModelFile_Tag::kPath: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_path, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_path, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ModelFile");
      return false;
    }
  }
}
// static
bool SafetyModelAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const SafetyModelAssets_Data* object = static_cast<const SafetyModelAssets_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case SafetyModelAssets_Tag::kTsAssets: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_ts_assets, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_ts_assets, validation_context))
        return false;
      return true;
    }
    case SafetyModelAssets_Tag::kBsAssets: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_bs_assets, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_bs_assets, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in SafetyModelAssets");
      return false;
    }
  }
}


// static
bool ModelAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModelAssets_Data* object =
      static_cast<const ModelAssets_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->weights, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->weights, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sp_model_path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cache, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->encoder_cache, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->adapter_cache, validation_context))
    return false;

  return true;
}

ModelAssets_Data::ModelAssets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoadModelParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoadModelParams_Data* object =
      static_cast<const LoadModelParams_Data*>(data);


  if (!::on_device_model::mojom::internal::ModelBackendType_Data
        ::Validate(object->backend_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->assets, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->assets, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->adaptation_ranks, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& adaptation_ranks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->adaptation_ranks, validation_context,
                                         &adaptation_ranks_validate_params)) {
    return false;
  }


  if (!::on_device_model::mojom::internal::ModelPerformanceHint_Data
        ::Validate(object->performance_hint, validation_context))
    return false;

  return true;
}

LoadModelParams_Data::LoadModelParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetyModelAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetyModelAssets_Data* object =
      static_cast<const TextSafetyModelAssets_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sp_model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sp_model, validation_context))
    return false;

  return true;
}

TextSafetyModelAssets_Data::TextSafetyModelAssets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BertSafetyModelAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BertSafetyModelAssets_Data* object =
      static_cast<const BertSafetyModelAssets_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->model, validation_context))
    return false;

  return true;
}

BertSafetyModelAssets_Data::BertSafetyModelAssets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LanguageModelAssets_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LanguageModelAssets_Data* object =
      static_cast<const LanguageModelAssets_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->model, validation_context))
    return false;

  return true;
}

LanguageModelAssets_Data::LanguageModelAssets_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TextSafetyModelParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TextSafetyModelParams_Data* object =
      static_cast<const TextSafetyModelParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->safety_assets, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->language_assets, validation_context))
    return false;

  return true;
}

TextSafetyModelParams_Data::TextSafetyModelParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PlatformModelProgressObserver_Progress_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PlatformModelProgressObserver_Progress_Params_Data* object =
      static_cast<const PlatformModelProgressObserver_Progress_Params_Data*>(data);

  return true;
}

PlatformModelProgressObserver_Progress_Params_Data::PlatformModelProgressObserver_Progress_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_LoadModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_LoadModel_Params_Data* object =
      static_cast<const OnDeviceModelService_LoadModel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceModelService_LoadModel_Params_Data::OnDeviceModelService_LoadModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_LoadModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_LoadModel_ResponseParams_Data* object =
      static_cast<const OnDeviceModelService_LoadModel_ResponseParams_Data*>(data);


  if (!::on_device_model::mojom::internal::LoadModelResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

OnDeviceModelService_LoadModel_ResponseParams_Data::OnDeviceModelService_LoadModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_GetCapabilities_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_GetCapabilities_Params_Data* object =
      static_cast<const OnDeviceModelService_GetCapabilities_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->weights, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->weights, validation_context))
    return false;

  return true;
}

OnDeviceModelService_GetCapabilities_Params_Data::OnDeviceModelService_GetCapabilities_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_GetCapabilities_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_GetCapabilities_ResponseParams_Data* object =
      static_cast<const OnDeviceModelService_GetCapabilities_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->capabilities, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->capabilities, validation_context))
    return false;

  return true;
}

OnDeviceModelService_GetCapabilities_ResponseParams_Data::OnDeviceModelService_GetCapabilities_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_LoadTextSafetyModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_LoadTextSafetyModel_Params_Data* object =
      static_cast<const OnDeviceModelService_LoadTextSafetyModel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceModelService_LoadTextSafetyModel_Params_Data::OnDeviceModelService_LoadTextSafetyModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data* object =
      static_cast<const OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data*>(data);

  return true;
}

OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data::OnDeviceModelService_GetDeviceAndPerformanceInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data* object =
      static_cast<const OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->performanceInfo, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->performanceInfo, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->device_info, validation_context))
    return false;

  return true;
}

OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data::OnDeviceModelService_GetDeviceAndPerformanceInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_LoadPlatformModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_LoadPlatformModel_Params_Data* object =
      static_cast<const OnDeviceModelPlatformService_LoadPlatformModel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->model, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->model,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->progress_observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

OnDeviceModelPlatformService_LoadPlatformModel_Params_Data::OnDeviceModelPlatformService_LoadPlatformModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data* object =
      static_cast<const OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data*>(data);


  if (!::on_device_model::mojom::internal::LoadModelResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data::OnDeviceModelPlatformService_LoadPlatformModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_GetPlatformModelState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_GetPlatformModelState_Params_Data* object =
      static_cast<const OnDeviceModelPlatformService_GetPlatformModelState_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

OnDeviceModelPlatformService_GetPlatformModelState_Params_Data::OnDeviceModelPlatformService_GetPlatformModelState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data* object =
      static_cast<const OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data*>(data);


  if (!::on_device_model::mojom::internal::PlatformModelState_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data::OnDeviceModelPlatformService_GetPlatformModelState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data* object =
      static_cast<const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data*>(data);

  return true;
}

OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data* object =
      static_cast<const OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data*>(data);


  if (!::on_device_model::mojom::internal::PerformanceClass_Data
        ::Validate(object->performance_class, validation_context))
    return false;

  return true;
}

OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data::OnDeviceModelPlatformService_GetEstimatedPerformanceClass_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_FormatInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_FormatInput_Params_Data* object =
      static_cast<const OnDeviceModelPlatformService_FormatInput_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;


  if (!::on_device_model::mojom::internal::FormatFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fields, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fields_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->fields, validation_context,
                                         &fields_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceModelPlatformService_FormatInput_Params_Data::OnDeviceModelPlatformService_FormatInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_FormatInput_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_FormatInput_ResponseParams_Data* object =
      static_cast<const OnDeviceModelPlatformService_FormatInput_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->result, validation_context,
                                         &result_validate_params)) {
    return false;
  }

  return true;
}

OnDeviceModelPlatformService_FormatInput_ResponseParams_Data::OnDeviceModelPlatformService_FormatInput_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data* object =
      static_cast<const OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data*>(data);


  if (!::on_device_model::mojom::internal::SafetyFeature_Data
        ::Validate(object->safety_feature, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->safety_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->safety_info, validation_context))
    return false;

  return true;
}

OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data::OnDeviceModelPlatformService_ValidateSafetyResult_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data* object =
      static_cast<const OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data*>(data);

  return true;
}

OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data::OnDeviceModelPlatformService_ValidateSafetyResult_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace on_device_model

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::ModelBackendType>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::ModelBackendType value) {
  return std::move(context).WriteString(::on_device_model::mojom::ModelBackendTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::ModelPerformanceHint>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::ModelPerformanceHint value) {
  return std::move(context).WriteString(::on_device_model::mojom::ModelPerformanceHintToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::PlatformModelState>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::PlatformModelState value) {
  return std::move(context).WriteString(::on_device_model::mojom::PlatformModelStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::FormatFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::FormatFeature value) {
  return std::move(context).WriteString(::on_device_model::mojom::FormatFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::on_device_model::mojom::SafetyFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::on_device_model::mojom::SafetyFeature value) {
  return std::move(context).WriteString(::on_device_model::mojom::SafetyFeatureToString(value));
}

} // namespace perfetto