// services/network/public/mojom/web_transport.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/web_transport.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/web_transport.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/web_transport.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/web_transport_error_mojom_traits.h"




namespace network::mojom {

class WebTransportProxy;

template <typename ImplRefTraits>
class WebTransportStub;

class WebTransportRequestValidator;
class WebTransportResponseValidator;


class WebTransport
    : public WebTransportInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebTransport";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebTransportInterfaceBase;
  using Proxy_ = WebTransportProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebTransportStub<ImplRefTraits>;

  using RequestValidator_ = WebTransportRequestValidator;
  using ResponseValidator_ = WebTransportResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSendDatagramMinVersion = 0,
    kCreateStreamMinVersion = 0,
    kAcceptBidirectionalStreamMinVersion = 0,
    kAcceptUnidirectionalStreamMinVersion = 0,
    kSendFinMinVersion = 0,
    kAbortStreamMinVersion = 0,
    kStopSendingMinVersion = 0,
    kSetOutgoingDatagramExpirationDurationMinVersion = 0,
    kGetStatsMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendDatagram_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptBidirectionalStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AcceptUnidirectionalStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AbortStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopSending_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetOutgoingDatagramExpirationDuration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStats_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebTransport() = default;

  using SendDatagramCallback = base::OnceCallback<void(bool)>;
  using SendDatagramMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) = 0;

  using CreateStreamCallback = base::OnceCallback<void(bool, uint32_t)>;
  using CreateStreamMojoCallback = base::OnceCallback<void(bool, uint32_t)>;

  virtual void CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) = 0;

  using AcceptBidirectionalStreamCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using AcceptBidirectionalStreamMojoCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) = 0;

  using AcceptUnidirectionalStreamCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle)>;
  using AcceptUnidirectionalStreamMojoCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle)>;

  virtual void AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) = 0;

  virtual void SendFin(uint32_t stream_id) = 0;

  virtual void AbortStream(uint32_t stream_id, uint8_t code) = 0;

  virtual void StopSending(uint32_t stream_id, uint8_t code) = 0;

  virtual void SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) = 0;

  using GetStatsCallback = base::OnceCallback<void(WebTransportStatsPtr)>;
  using GetStatsMojoCallback = base::OnceCallback<void(WebTransportStatsPtr)>;

  virtual void GetStats(GetStatsCallback callback) = 0;

  virtual void Close(WebTransportCloseInfoPtr close_info) = 0;
};

class WebTransportClientProxy;

template <typename ImplRefTraits>
class WebTransportClientStub;

class WebTransportClientRequestValidator;


class WebTransportClient
    : public WebTransportClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebTransportClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebTransportClientInterfaceBase;
  using Proxy_ = WebTransportClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebTransportClientStub<ImplRefTraits>;

  using RequestValidator_ = WebTransportClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDatagramReceivedMinVersion = 0,
    kOnIncomingStreamClosedMinVersion = 0,
    kOnOutgoingStreamClosedMinVersion = 0,
    kOnReceivedStopSendingMinVersion = 0,
    kOnReceivedResetStreamMinVersion = 0,
    kOnClosedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDatagramReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnIncomingStreamClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOutgoingStreamClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReceivedStopSending_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReceivedResetStream_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebTransportClient() = default;

  virtual void OnDatagramReceived(::base::span<const ::uint8_t> data) = 0;

  virtual void OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) = 0;

  virtual void OnOutgoingStreamClosed(uint32_t stream_id) = 0;

  virtual void OnReceivedStopSending(uint32_t stream_id, uint32_t stream_error_code) = 0;

  virtual void OnReceivedResetStream(uint32_t stream_id, uint32_t stream_error_code) = 0;

  virtual void OnClosed(WebTransportCloseInfoPtr close_info, WebTransportStatsPtr final_stats) = 0;
};

class WebTransportHandshakeClientProxy;

template <typename ImplRefTraits>
class WebTransportHandshakeClientStub;

class WebTransportHandshakeClientRequestValidator;


class WebTransportHandshakeClient
    : public WebTransportHandshakeClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.WebTransportHandshakeClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebTransportHandshakeClientInterfaceBase;
  using Proxy_ = WebTransportHandshakeClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebTransportHandshakeClientStub<ImplRefTraits>;

  using RequestValidator_ = WebTransportHandshakeClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnBeforeConnectMinVersion = 0,
    kOnConnectionEstablishedMinVersion = 0,
    kOnHandshakeFailedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBeforeConnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnConnectionEstablished_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHandshakeFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebTransportHandshakeClient() = default;

  virtual void OnBeforeConnect(const ::net::IPEndPoint& server_address) = 0;

  virtual void OnConnectionEstablished(::mojo::PendingRemote<WebTransport> transport, ::mojo::PendingReceiver<WebTransportClient> client, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers, const std::optional<std::string>& selected_application_protocol, WebTransportStatsPtr initial_stats) = 0;

  virtual void OnHandshakeFailed(const std::optional<::net::WebTransportError>& error) = 0;
};



class  WebTransportProxy
    : public WebTransport {
 public:
  using InterfaceType = WebTransport;

  explicit WebTransportProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) final;
  
  void CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) final;
  
  void AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) final;
  
  void AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) final;
  
  void SendFin(uint32_t stream_id) final;
  
  void AbortStream(uint32_t stream_id, uint8_t code) final;
  
  void StopSending(uint32_t stream_id, uint8_t code) final;
  
  void SetOutgoingDatagramExpirationDuration(::base::TimeDelta duration) final;
  
  void GetStats(GetStatsCallback callback) final;
  
  void Close(WebTransportCloseInfoPtr close_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebTransportClientProxy
    : public WebTransportClient {
 public:
  using InterfaceType = WebTransportClient;

  explicit WebTransportClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDatagramReceived(::base::span<const ::uint8_t> data) final;
  
  void OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) final;
  
  void OnOutgoingStreamClosed(uint32_t stream_id) final;
  
  void OnReceivedStopSending(uint32_t stream_id, uint32_t stream_error_code) final;
  
  void OnReceivedResetStream(uint32_t stream_id, uint32_t stream_error_code) final;
  
  void OnClosed(WebTransportCloseInfoPtr close_info, WebTransportStatsPtr final_stats) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebTransportHandshakeClientProxy
    : public WebTransportHandshakeClient {
 public:
  using InterfaceType = WebTransportHandshakeClient;

  explicit WebTransportHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBeforeConnect(const ::net::IPEndPoint& server_address) final;
  
  void OnConnectionEstablished(::mojo::PendingRemote<WebTransport> transport, ::mojo::PendingReceiver<WebTransportClient> client, const ::scoped_refptr<::net::HttpResponseHeaders>& response_headers, const std::optional<std::string>& selected_application_protocol, WebTransportStatsPtr initial_stats) final;
  
  void OnHandshakeFailed(const std::optional<::net::WebTransportError>& error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebTransportStubDispatch {
 public:
  static bool Accept(WebTransport* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebTransport* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebTransport>>
class WebTransportStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebTransportStub() = default;
  ~WebTransportStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebTransportClientStubDispatch {
 public:
  static bool Accept(WebTransportClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebTransportClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebTransportClient>>
class WebTransportClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebTransportClientStub() = default;
  ~WebTransportClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebTransportHandshakeClientStubDispatch {
 public:
  static bool Accept(WebTransportHandshakeClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebTransportHandshakeClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebTransportHandshakeClient>>
class WebTransportHandshakeClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebTransportHandshakeClientStub() = default;
  ~WebTransportHandshakeClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportHandshakeClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebTransportHandshakeClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebTransportRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebTransportClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebTransportHandshakeClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebTransportResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  WebTransportError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebTransportError, T>::value>;
  using DataView = WebTransportErrorDataView;
  using Data_ = internal::WebTransportError_Data;

  template <typename... Args>
  static WebTransportErrorPtr New(Args&&... args) {
    return WebTransportErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebTransportErrorPtr From(const U& u) {
    return mojo::TypeConverter<WebTransportErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebTransportError>::Convert(*this);
  }


  WebTransportError();

  WebTransportError(
      int32_t net_error,
      int32_t quic_error,
      const std::string& details,
      bool safe_to_report_details);


  ~WebTransportError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebTransportErrorPtr>
  WebTransportErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportError::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebTransportError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebTransportError_UnserializedMessageContext<
            UserType, WebTransportError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebTransportError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebTransportError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebTransportError_UnserializedMessageContext<
            UserType, WebTransportError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebTransportError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t net_error;
  
  int32_t quic_error;
  
  std::string details;
  
  bool safe_to_report_details;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebTransportError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebTransportCertificateFingerprint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebTransportCertificateFingerprint, T>::value>;
  using DataView = WebTransportCertificateFingerprintDataView;
  using Data_ = internal::WebTransportCertificateFingerprint_Data;

  template <typename... Args>
  static WebTransportCertificateFingerprintPtr New(Args&&... args) {
    return WebTransportCertificateFingerprintPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebTransportCertificateFingerprintPtr From(const U& u) {
    return mojo::TypeConverter<WebTransportCertificateFingerprintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebTransportCertificateFingerprint>::Convert(*this);
  }


  WebTransportCertificateFingerprint();

  WebTransportCertificateFingerprint(
      const std::string& algorithm,
      const std::string& fingerprint);


  ~WebTransportCertificateFingerprint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebTransportCertificateFingerprintPtr>
  WebTransportCertificateFingerprintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportCertificateFingerprint::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportCertificateFingerprint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebTransportCertificateFingerprint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebTransportCertificateFingerprint_UnserializedMessageContext<
            UserType, WebTransportCertificateFingerprint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebTransportCertificateFingerprint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebTransportCertificateFingerprint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebTransportCertificateFingerprint_UnserializedMessageContext<
            UserType, WebTransportCertificateFingerprint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebTransportCertificateFingerprint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string algorithm;
  
  std::string fingerprint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WebTransportCloseInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebTransportCloseInfo, T>::value>;
  using DataView = WebTransportCloseInfoDataView;
  using Data_ = internal::WebTransportCloseInfo_Data;

  template <typename... Args>
  static WebTransportCloseInfoPtr New(Args&&... args) {
    return WebTransportCloseInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebTransportCloseInfoPtr From(const U& u) {
    return mojo::TypeConverter<WebTransportCloseInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebTransportCloseInfo>::Convert(*this);
  }


  WebTransportCloseInfo();

  WebTransportCloseInfo(
      uint32_t code,
      const std::string& reason);


  ~WebTransportCloseInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebTransportCloseInfoPtr>
  WebTransportCloseInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportCloseInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportCloseInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebTransportCloseInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebTransportCloseInfo_UnserializedMessageContext<
            UserType, WebTransportCloseInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebTransportCloseInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebTransportCloseInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebTransportCloseInfo_UnserializedMessageContext<
            UserType, WebTransportCloseInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebTransportCloseInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t code;
  
  std::string reason;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebTransportCloseInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}











class  WebTransportStats {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebTransportStats, T>::value>;
  using DataView = WebTransportStatsDataView;
  using Data_ = internal::WebTransportStats_Data;

  template <typename... Args>
  static WebTransportStatsPtr New(Args&&... args) {
    return WebTransportStatsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebTransportStatsPtr From(const U& u) {
    return mojo::TypeConverter<WebTransportStatsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebTransportStats>::Convert(*this);
  }


  WebTransportStats();

  WebTransportStats(
      ::base::Time timestamp,
      ::base::TimeDelta min_rtt,
      ::base::TimeDelta smoothed_rtt,
      ::base::TimeDelta rtt_variation,
      uint64_t estimated_send_rate_bps,
      uint64_t datagrams_expired_outgoing,
      uint64_t datagrams_lost_outgoing);


  ~WebTransportStats();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebTransportStatsPtr>
  WebTransportStatsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportStats::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebTransportStats::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebTransportStats::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebTransportStats_UnserializedMessageContext<
            UserType, WebTransportStats::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebTransportStats::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebTransportStats::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebTransportStats_UnserializedMessageContext<
            UserType, WebTransportStats::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebTransportStats::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::Time timestamp;
  
  ::base::TimeDelta min_rtt;
  
  ::base::TimeDelta smoothed_rtt;
  
  ::base::TimeDelta rtt_variation;
  
  uint64_t estimated_send_rate_bps;
  
  uint64_t datagrams_expired_outgoing;
  
  uint64_t datagrams_lost_outgoing;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebTransportStats::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebTransportErrorPtr WebTransportError::Clone() const {
  return New(
      mojo::Clone(net_error),
      mojo::Clone(quic_error),
      mojo::Clone(details),
      mojo::Clone(safe_to_report_details)
  );
}

template <typename T, WebTransportError::EnableIfSame<T>*>
bool WebTransportError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->net_error, other_struct.net_error))
    return false;
  if (!mojo::Equals(this->quic_error, other_struct.quic_error))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  if (!mojo::Equals(this->safe_to_report_details, other_struct.safe_to_report_details))
    return false;
  return true;
}

template <typename T, WebTransportError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.net_error < rhs.net_error)
    return true;
  if (rhs.net_error < lhs.net_error)
    return false;
  if (lhs.quic_error < rhs.quic_error)
    return true;
  if (rhs.quic_error < lhs.quic_error)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  if (lhs.safe_to_report_details < rhs.safe_to_report_details)
    return true;
  if (rhs.safe_to_report_details < lhs.safe_to_report_details)
    return false;
  return false;
}
template <typename StructPtrType>
WebTransportCertificateFingerprintPtr WebTransportCertificateFingerprint::Clone() const {
  return New(
      mojo::Clone(algorithm),
      mojo::Clone(fingerprint)
  );
}

template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>*>
bool WebTransportCertificateFingerprint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  if (!mojo::Equals(this->fingerprint, other_struct.fingerprint))
    return false;
  return true;
}

template <typename T, WebTransportCertificateFingerprint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.algorithm < rhs.algorithm)
    return true;
  if (rhs.algorithm < lhs.algorithm)
    return false;
  if (lhs.fingerprint < rhs.fingerprint)
    return true;
  if (rhs.fingerprint < lhs.fingerprint)
    return false;
  return false;
}
template <typename StructPtrType>
WebTransportCloseInfoPtr WebTransportCloseInfo::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(reason)
  );
}

template <typename T, WebTransportCloseInfo::EnableIfSame<T>*>
bool WebTransportCloseInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->reason, other_struct.reason))
    return false;
  return true;
}

template <typename T, WebTransportCloseInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.reason < rhs.reason)
    return true;
  if (rhs.reason < lhs.reason)
    return false;
  return false;
}
template <typename StructPtrType>
WebTransportStatsPtr WebTransportStats::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(min_rtt),
      mojo::Clone(smoothed_rtt),
      mojo::Clone(rtt_variation),
      mojo::Clone(estimated_send_rate_bps),
      mojo::Clone(datagrams_expired_outgoing),
      mojo::Clone(datagrams_lost_outgoing)
  );
}

template <typename T, WebTransportStats::EnableIfSame<T>*>
bool WebTransportStats::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->min_rtt, other_struct.min_rtt))
    return false;
  if (!mojo::Equals(this->smoothed_rtt, other_struct.smoothed_rtt))
    return false;
  if (!mojo::Equals(this->rtt_variation, other_struct.rtt_variation))
    return false;
  if (!mojo::Equals(this->estimated_send_rate_bps, other_struct.estimated_send_rate_bps))
    return false;
  if (!mojo::Equals(this->datagrams_expired_outgoing, other_struct.datagrams_expired_outgoing))
    return false;
  if (!mojo::Equals(this->datagrams_lost_outgoing, other_struct.datagrams_lost_outgoing))
    return false;
  return true;
}

template <typename T, WebTransportStats::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.min_rtt < rhs.min_rtt)
    return true;
  if (rhs.min_rtt < lhs.min_rtt)
    return false;
  if (lhs.smoothed_rtt < rhs.smoothed_rtt)
    return true;
  if (rhs.smoothed_rtt < lhs.smoothed_rtt)
    return false;
  if (lhs.rtt_variation < rhs.rtt_variation)
    return true;
  if (rhs.rtt_variation < lhs.rtt_variation)
    return false;
  if (lhs.estimated_send_rate_bps < rhs.estimated_send_rate_bps)
    return true;
  if (rhs.estimated_send_rate_bps < lhs.estimated_send_rate_bps)
    return false;
  if (lhs.datagrams_expired_outgoing < rhs.datagrams_expired_outgoing)
    return true;
  if (rhs.datagrams_expired_outgoing < lhs.datagrams_expired_outgoing)
    return false;
  if (lhs.datagrams_lost_outgoing < rhs.datagrams_lost_outgoing)
    return true;
  if (rhs.datagrams_lost_outgoing < lhs.datagrams_lost_outgoing)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::WebTransportError::DataView,
                                         ::network::mojom::WebTransportErrorPtr> {
  static bool IsNull(const ::network::mojom::WebTransportErrorPtr& input) { return !input; }
  static void SetToNull(::network::mojom::WebTransportErrorPtr* output) { output->reset(); }

  static decltype(::network::mojom::WebTransportError::net_error) net_error(
      const ::network::mojom::WebTransportErrorPtr& input) {
    return input->net_error;
  }

  static decltype(::network::mojom::WebTransportError::quic_error) quic_error(
      const ::network::mojom::WebTransportErrorPtr& input) {
    return input->quic_error;
  }

  static const decltype(::network::mojom::WebTransportError::details)& details(
      const ::network::mojom::WebTransportErrorPtr& input) {
    return input->details;
  }

  static decltype(::network::mojom::WebTransportError::safe_to_report_details) safe_to_report_details(
      const ::network::mojom::WebTransportErrorPtr& input) {
    return input->safe_to_report_details;
  }

  static bool Read(::network::mojom::WebTransportError::DataView input, ::network::mojom::WebTransportErrorPtr* output);
};


template <>
struct  StructTraits<::network::mojom::WebTransportCertificateFingerprint::DataView,
                                         ::network::mojom::WebTransportCertificateFingerprintPtr> {
  static bool IsNull(const ::network::mojom::WebTransportCertificateFingerprintPtr& input) { return !input; }
  static void SetToNull(::network::mojom::WebTransportCertificateFingerprintPtr* output) { output->reset(); }

  static const decltype(::network::mojom::WebTransportCertificateFingerprint::algorithm)& algorithm(
      const ::network::mojom::WebTransportCertificateFingerprintPtr& input) {
    return input->algorithm;
  }

  static const decltype(::network::mojom::WebTransportCertificateFingerprint::fingerprint)& fingerprint(
      const ::network::mojom::WebTransportCertificateFingerprintPtr& input) {
    return input->fingerprint;
  }

  static bool Read(::network::mojom::WebTransportCertificateFingerprint::DataView input, ::network::mojom::WebTransportCertificateFingerprintPtr* output);
};


template <>
struct  StructTraits<::network::mojom::WebTransportCloseInfo::DataView,
                                         ::network::mojom::WebTransportCloseInfoPtr> {
  static bool IsNull(const ::network::mojom::WebTransportCloseInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::WebTransportCloseInfoPtr* output) { output->reset(); }

  static decltype(::network::mojom::WebTransportCloseInfo::code) code(
      const ::network::mojom::WebTransportCloseInfoPtr& input) {
    return input->code;
  }

  static const decltype(::network::mojom::WebTransportCloseInfo::reason)& reason(
      const ::network::mojom::WebTransportCloseInfoPtr& input) {
    return input->reason;
  }

  static bool Read(::network::mojom::WebTransportCloseInfo::DataView input, ::network::mojom::WebTransportCloseInfoPtr* output);
};


template <>
struct  StructTraits<::network::mojom::WebTransportStats::DataView,
                                         ::network::mojom::WebTransportStatsPtr> {
  static bool IsNull(const ::network::mojom::WebTransportStatsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::WebTransportStatsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::WebTransportStats::timestamp)& timestamp(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->timestamp;
  }

  static const decltype(::network::mojom::WebTransportStats::min_rtt)& min_rtt(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->min_rtt;
  }

  static const decltype(::network::mojom::WebTransportStats::smoothed_rtt)& smoothed_rtt(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->smoothed_rtt;
  }

  static const decltype(::network::mojom::WebTransportStats::rtt_variation)& rtt_variation(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->rtt_variation;
  }

  static decltype(::network::mojom::WebTransportStats::estimated_send_rate_bps) estimated_send_rate_bps(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->estimated_send_rate_bps;
  }

  static decltype(::network::mojom::WebTransportStats::datagrams_expired_outgoing) datagrams_expired_outgoing(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->datagrams_expired_outgoing;
  }

  static decltype(::network::mojom::WebTransportStats::datagrams_lost_outgoing) datagrams_lost_outgoing(
      const ::network::mojom::WebTransportStatsPtr& input) {
    return input->datagrams_lost_outgoing;
  }

  static bool Read(::network::mojom::WebTransportStats::DataView input, ::network::mojom::WebTransportStatsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_H_