// services/network/public/mojom/web_transport.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/web_transport.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"


namespace network::mojom {
class WebTransportErrorDataView;

class WebTransportCertificateFingerprintDataView;

class WebTransportCloseInfoDataView;

class WebTransportStatsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::WebTransportErrorDataView> {
  using Data = ::network::mojom::internal::WebTransportError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebTransportCertificateFingerprintDataView> {
  using Data = ::network::mojom::internal::WebTransportCertificateFingerprint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebTransportCloseInfoDataView> {
  using Data = ::network::mojom::internal::WebTransportCloseInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebTransportStatsDataView> {
  using Data = ::network::mojom::internal::WebTransportStats_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class WebTransportInterfaceBase {};

using WebTransportPtrDataView =
    mojo::InterfacePtrDataView<WebTransportInterfaceBase>;
using WebTransportRequestDataView =
    mojo::InterfaceRequestDataView<WebTransportInterfaceBase>;
using WebTransportAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebTransportInterfaceBase>;
using WebTransportAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebTransportInterfaceBase>;
class WebTransportClientInterfaceBase {};

using WebTransportClientPtrDataView =
    mojo::InterfacePtrDataView<WebTransportClientInterfaceBase>;
using WebTransportClientRequestDataView =
    mojo::InterfaceRequestDataView<WebTransportClientInterfaceBase>;
using WebTransportClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebTransportClientInterfaceBase>;
using WebTransportClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebTransportClientInterfaceBase>;
class WebTransportHandshakeClientInterfaceBase {};

using WebTransportHandshakeClientPtrDataView =
    mojo::InterfacePtrDataView<WebTransportHandshakeClientInterfaceBase>;
using WebTransportHandshakeClientRequestDataView =
    mojo::InterfaceRequestDataView<WebTransportHandshakeClientInterfaceBase>;
using WebTransportHandshakeClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<WebTransportHandshakeClientInterfaceBase>;
using WebTransportHandshakeClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<WebTransportHandshakeClientInterfaceBase>;


class WebTransportErrorDataView {
 public:
  WebTransportErrorDataView() = default;

  WebTransportErrorDataView(
      internal::WebTransportError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
  int32_t quic_error() const {
    return data_->quic_error;
  }
  inline void GetDetailsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool safe_to_report_details() const {
    return data_->safe_to_report_details;
  }
 private:
  internal::WebTransportError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebTransportCertificateFingerprintDataView {
 public:
  WebTransportCertificateFingerprintDataView() = default;

  WebTransportCertificateFingerprintDataView(
      internal::WebTransportCertificateFingerprint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAlgorithmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlgorithm(UserType* output) {
    
    auto* pointer = data_->algorithm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFingerprintDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFingerprint(UserType* output) {
    
    auto* pointer = data_->fingerprint.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebTransportCertificateFingerprint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebTransportCloseInfoDataView {
 public:
  WebTransportCloseInfoDataView() = default;

  WebTransportCloseInfoDataView(
      internal::WebTransportCloseInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t code() const {
    return data_->code;
  }
  inline void GetReasonDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) {
    
    auto* pointer = data_->reason.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebTransportCloseInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebTransportStatsDataView {
 public:
  WebTransportStatsDataView() = default;

  WebTransportStatsDataView(
      internal::WebTransportStats_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetMinRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMinRtt(UserType* output) {
    
    auto* pointer = data_->min_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSmoothedRttDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSmoothedRtt(UserType* output) {
    
    auto* pointer = data_->smoothed_rtt.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetRttVariationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRttVariation(UserType* output) {
    
    auto* pointer = data_->rtt_variation.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t estimated_send_rate_bps() const {
    return data_->estimated_send_rate_bps;
  }
  uint64_t datagrams_expired_outgoing() const {
    return data_->datagrams_expired_outgoing;
  }
  uint64_t datagrams_lost_outgoing() const {
    return data_->datagrams_lost_outgoing;
  }
 private:
  internal::WebTransportStats_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_WEB_TRANSPORT_MOJOM_DATA_VIEW_H_