// services/network/public/mojom/url_response_head.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/url_response_head.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/alternate_protocol_usage.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/encoded_body_length.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/load_timing_internal_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/parsed_request_cookie.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/unencoded_digest.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/url_response_head.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::NavigationDeliveryType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::URLResponseHeadDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLResponseHeadDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLResponseHead_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::request_time(input)) in_request_time = Traits::request_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_time)::BaseType> request_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_request_time,
        request_time_fragment);

      fragment->request_time.Set(
          request_time_fragment.is_null() ? nullptr : request_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_time in URLResponseHead struct");

      decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_time)::BaseType> response_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_response_time,
        response_time_fragment);

      fragment->response_time.Set(
          response_time_fragment.is_null() ? nullptr : response_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_time in URLResponseHead struct");

      decltype(Traits::original_response_time(input)) in_original_response_time = Traits::original_response_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->original_response_time)::BaseType> original_response_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_original_response_time,
        original_response_time_fragment);

      fragment->original_response_time.Set(
          original_response_time_fragment.is_null() ? nullptr : original_response_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->original_response_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_response_time in URLResponseHead struct");

      decltype(Traits::headers(input)) in_headers = Traits::headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->headers)::BaseType> headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView, send_validation>(
        in_headers,
        headers_fragment);

      fragment->headers.Set(
          headers_fragment.is_null() ? nullptr : headers_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->headers.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in URLResponseHead struct");

      decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mime_type,
        mime_type_fragment);

      fragment->mime_type.Set(
          mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mime_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in URLResponseHead struct");

      decltype(Traits::charset(input)) in_charset = Traits::charset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->charset)::BaseType> charset_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_charset,
        charset_fragment);

      fragment->charset.Set(
          charset_fragment.is_null() ? nullptr : charset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->charset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null charset in URLResponseHead struct");

      fragment->content_length = Traits::content_length(input);

      fragment->encoded_data_length = Traits::encoded_data_length(input);

      decltype(Traits::encoded_body_length(input)) in_encoded_body_length = Traits::encoded_body_length(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->encoded_body_length)::BaseType> encoded_body_length_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::EncodedBodyLengthDataView, send_validation>(
        in_encoded_body_length,
        encoded_body_length_fragment);

      fragment->encoded_body_length.Set(
          encoded_body_length_fragment.is_null() ? nullptr : encoded_body_length_fragment.data());

      fragment->network_accessed = Traits::network_accessed(input);

      decltype(Traits::load_timing(input)) in_load_timing = Traits::load_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_timing)::BaseType> load_timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView, send_validation>(
        in_load_timing,
        load_timing_fragment);

      fragment->load_timing.Set(
          load_timing_fragment.is_null() ? nullptr : load_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->load_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null load_timing in URLResponseHead struct");

      decltype(Traits::load_timing_internal_info(input)) in_load_timing_internal_info = Traits::load_timing_internal_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->load_timing_internal_info)::BaseType> load_timing_internal_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::LoadTimingInternalInfoDataView, send_validation>(
        in_load_timing_internal_info,
        load_timing_internal_info_fragment);

      fragment->load_timing_internal_info.Set(
          load_timing_internal_info_fragment.is_null() ? nullptr : load_timing_internal_info_fragment.data());

      fragment->emitted_extra_info = Traits::emitted_extra_info(input);

      fragment->was_fetched_via_spdy = Traits::was_fetched_via_spdy(input);

      fragment->was_alpn_negotiated = Traits::was_alpn_negotiated(input);

      fragment->was_alternate_protocol_available = Traits::was_alternate_protocol_available(input);

      
      mojo::internal::Serialize<::network::mojom::ConnectionInfo>(
        Traits::connection_info(input),
        &fragment->connection_info);

      decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_alpn_negotiated_protocol,
        alpn_negotiated_protocol_fragment);

      fragment->alpn_negotiated_protocol.Set(
          alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alpn_negotiated_protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpn_negotiated_protocol in URLResponseHead struct");

      
      mojo::internal::Serialize<::network::mojom::AlternateProtocolUsage>(
        Traits::alternate_protocol_usage(input),
        &fragment->alternate_protocol_usage);

      decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::IPEndPointDataView, send_validation>(
        in_remote_endpoint,
        remote_endpoint_fragment);

      fragment->remote_endpoint.Set(
          remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->remote_endpoint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null remote_endpoint in URLResponseHead struct");

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::client_address_space(input),
        &fragment->client_address_space);

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::response_address_space(input),
        &fragment->response_address_space);

      fragment->is_validated = Traits::is_validated(input);

      fragment->was_fetched_via_cache = Traits::was_fetched_via_cache(input);

      
      mojo::internal::Serialize<::network::mojom::NavigationDeliveryType>(
        Traits::navigation_delivery_type(input),
        &fragment->navigation_delivery_type);

      decltype(Traits::proxy_chain(input)) in_proxy_chain = Traits::proxy_chain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->proxy_chain)::BaseType> proxy_chain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ProxyChainDataView, send_validation>(
        in_proxy_chain,
        proxy_chain_fragment);

      fragment->proxy_chain.Set(
          proxy_chain_fragment.is_null() ? nullptr : proxy_chain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->proxy_chain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_chain in URLResponseHead struct");

      fragment->was_fetched_via_service_worker = Traits::was_fetched_via_service_worker(input);

      
      mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
        Traits::service_worker_response_source(input),
        &fragment->service_worker_response_source);

      decltype(Traits::url_list_via_service_worker(input)) in_url_list_via_service_worker = Traits::url_list_via_service_worker(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url_list_via_service_worker)::BaseType>
          url_list_via_service_worker_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& url_list_via_service_worker_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>, send_validation>(
        in_url_list_via_service_worker,
        url_list_via_service_worker_fragment,
        &url_list_via_service_worker_validate_params);

      fragment->url_list_via_service_worker.Set(
          url_list_via_service_worker_fragment.is_null() ? nullptr : url_list_via_service_worker_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url_list_via_service_worker.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url_list_via_service_worker in URLResponseHead struct");
      fragment->initial_service_worker_status_$flag = Traits::initial_service_worker_status(input).has_value();
      if (Traits::initial_service_worker_status(input).has_value()) {
        
        mojo::internal::Serialize<::network::mojom::ServiceWorkerStatus>(
          Traits::initial_service_worker_status(input).value(),
          &fragment->initial_service_worker_status_$value);
      } else {
        fragment->initial_service_worker_status_$value =
            static_cast<int32_t>(::network::mojom::ServiceWorkerStatus::kMinValue);
      }

      decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView, send_validation>(
        in_service_worker_router_info,
        service_worker_router_info_fragment);

      fragment->service_worker_router_info.Set(
          service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::FetchResponseType>(
        Traits::response_type(input),
        &fragment->response_type);

      fragment->padding = Traits::padding(input);

      decltype(Traits::cache_storage_cache_name(input)) in_cache_storage_cache_name = Traits::cache_storage_cache_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cache_storage_cache_name)::BaseType> cache_storage_cache_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_cache_storage_cache_name,
        cache_storage_cache_name_fragment);

      fragment->cache_storage_cache_name.Set(
          cache_storage_cache_name_fragment.is_null() ? nullptr : cache_storage_cache_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cache_storage_cache_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cache_storage_cache_name in URLResponseHead struct");

      fragment->cert_status = Traits::cert_status(input);

      decltype(Traits::ssl_info(input)) in_ssl_info = Traits::ssl_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ssl_info)::BaseType> ssl_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SSLInfoDataView, send_validation>(
        in_ssl_info,
        ssl_info_fragment);

      fragment->ssl_info.Set(
          ssl_info_fragment.is_null() ? nullptr : ssl_info_fragment.data());

      decltype(Traits::request_cookies(input)) in_request_cookies = Traits::request_cookies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_cookies)::BaseType>
          request_cookies_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& request_cookies_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ParsedRequestCookieDataView>, send_validation>(
        in_request_cookies,
        request_cookies_fragment,
        &request_cookies_validate_params);

      fragment->request_cookies.Set(
          request_cookies_fragment.is_null() ? nullptr : request_cookies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request_cookies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_cookies in URLResponseHead struct");

      decltype(Traits::cors_exposed_header_names(input)) in_cors_exposed_header_names = Traits::cors_exposed_header_names(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cors_exposed_header_names)::BaseType>
          cors_exposed_header_names_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cors_exposed_header_names_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_cors_exposed_header_names,
        cors_exposed_header_names_fragment,
        &cors_exposed_header_names_validate_params);

      fragment->cors_exposed_header_names.Set(
          cors_exposed_header_names_fragment.is_null() ? nullptr : cors_exposed_header_names_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cors_exposed_header_names.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_exposed_header_names in URLResponseHead struct");

      fragment->did_service_worker_navigation_preload = Traits::did_service_worker_navigation_preload(input);

      fragment->async_revalidation_requested = Traits::async_revalidation_requested(input);

      fragment->did_mime_sniff = Traits::did_mime_sniff(input);

      fragment->is_signed_exchange_inner_response = Traits::is_signed_exchange_inner_response(input);

      fragment->is_web_bundle_inner_response = Traits::is_web_bundle_inner_response(input);

      fragment->was_in_prefetch_cache = Traits::was_in_prefetch_cache(input);

      fragment->is_prefetch_with_cross_site_contamination = Traits::is_prefetch_with_cross_site_contamination(input);

      fragment->was_cookie_in_request = Traits::was_cookie_in_request(input);

      fragment->intercepted_by_plugin = Traits::intercepted_by_plugin(input);

      fragment->has_range_requested = Traits::has_range_requested(input);

      fragment->timing_allow_passed = Traits::timing_allow_passed(input);

      decltype(Traits::auth_challenge_info(input)) in_auth_challenge_info = Traits::auth_challenge_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->auth_challenge_info)::BaseType> auth_challenge_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView, send_validation>(
        in_auth_challenge_info,
        auth_challenge_info_fragment);

      fragment->auth_challenge_info.Set(
          auth_challenge_info_fragment.is_null() ? nullptr : auth_challenge_info_fragment.data());

      decltype(Traits::request_start(input)) in_request_start = Traits::request_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_start)::BaseType> request_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_request_start,
        request_start_fragment);

      fragment->request_start.Set(
          request_start_fragment.is_null() ? nullptr : request_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->request_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_start in URLResponseHead struct");

      decltype(Traits::response_start(input)) in_response_start = Traits::response_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_start)::BaseType> response_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_response_start,
        response_start_fragment);

      fragment->response_start.Set(
          response_start_fragment.is_null() ? nullptr : response_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_start in URLResponseHead struct");

      decltype(Traits::parsed_headers(input)) in_parsed_headers = Traits::parsed_headers(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->parsed_headers)::BaseType> parsed_headers_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView, send_validation>(
        in_parsed_headers,
        parsed_headers_fragment);

      fragment->parsed_headers.Set(
          parsed_headers_fragment.is_null() ? nullptr : parsed_headers_fragment.data());

      decltype(Traits::recursive_prefetch_token(input)) in_recursive_prefetch_token = Traits::recursive_prefetch_token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->recursive_prefetch_token)::BaseType> recursive_prefetch_token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_recursive_prefetch_token,
        recursive_prefetch_token_fragment);

      fragment->recursive_prefetch_token.Set(
          recursive_prefetch_token_fragment.is_null() ? nullptr : recursive_prefetch_token_fragment.data());

      decltype(Traits::dns_aliases(input)) in_dns_aliases = Traits::dns_aliases(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dns_aliases)::BaseType>
          dns_aliases_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_dns_aliases,
        dns_aliases_fragment,
        &dns_aliases_validate_params);

      fragment->dns_aliases.Set(
          dns_aliases_fragment.is_null() ? nullptr : dns_aliases_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dns_aliases.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dns_aliases in URLResponseHead struct");

      fragment->has_authorization_covered_by_wildcard_on_preflight = Traits::has_authorization_covered_by_wildcard_on_preflight(input);

      fragment->request_include_credentials = Traits::request_include_credentials(input);

      fragment->should_use_source_hash_for_js_code_cache = Traits::should_use_source_hash_for_js_code_cache(input);

      
      mojo::internal::Serialize<::network::mojom::PrivateNetworkAccessPreflightResult>(
        Traits::private_network_access_preflight_result(input),
        &fragment->private_network_access_preflight_result);

      fragment->did_use_shared_dictionary = Traits::did_use_shared_dictionary(input);

      fragment->load_with_storage_access = Traits::load_with_storage_access(input);

      decltype(Traits::client_side_content_decoding_types(input)) in_client_side_content_decoding_types = Traits::client_side_content_decoding_types(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_side_content_decoding_types)::BaseType>
          client_side_content_decoding_types_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& client_side_content_decoding_types_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SourceType>, send_validation>(
        in_client_side_content_decoding_types,
        client_side_content_decoding_types_fragment,
        &client_side_content_decoding_types_validate_params);

      fragment->client_side_content_decoding_types.Set(
          client_side_content_decoding_types_fragment.is_null() ? nullptr : client_side_content_decoding_types_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->client_side_content_decoding_types.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_side_content_decoding_types in URLResponseHead struct");

      
      mojo::internal::Serialize<::network::mojom::DeviceBoundSessionUsage>(
        Traits::device_bound_session_usage(input),
        &fragment->device_bound_session_usage);

      fragment->from_synthetic_response = Traits::from_synthetic_response(input);

      fragment->bypass_redirect_checks = Traits::bypass_redirect_checks(input);

      decltype(Traits::unencoded_digests(input)) in_unencoded_digests = Traits::unencoded_digests(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->unencoded_digests)::BaseType> unencoded_digests_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::UnencodedDigestsDataView, send_validation>(
        in_unencoded_digests,
        unencoded_digests_fragment);

      fragment->unencoded_digests.Set(
          unencoded_digests_fragment.is_null() ? nullptr : unencoded_digests_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SEND_VALIDATION_H_