// services/network/public/mojom/url_loader_network_service_observer.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_loader_network_service_observer.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/ad_auction.mojom-blink-forward.h"
#include "services/network/public/mojom/cookie_partition_key.mojom-blink-forward.h"
#include "services/network/public/mojom/ip_address.mojom-blink-forward.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink-forward.h"
#include "services/network/public/mojom/network_param.mojom-blink.h"
#include "services/network/public/mojom/shared_storage.mojom-blink.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class ClientCertificateResponderProxy;

template <typename ImplRefTraits>
class ClientCertificateResponderStub;

class ClientCertificateResponderRequestValidator;


class BLINK_PLATFORM_EXPORT ClientCertificateResponder
    : public ClientCertificateResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ClientCertificateResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ClientCertificateResponderInterfaceBase;
  using Proxy_ = ClientCertificateResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ClientCertificateResponderStub<ImplRefTraits>;

  using RequestValidator_ = ClientCertificateResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kContinueWithCertificateMinVersion = 0,
    kContinueWithoutCertificateMinVersion = 0,
    kCancelRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ContinueWithCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ContinueWithoutCertificate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ClientCertificateResponder() = default;

  virtual void ContinueWithCertificate(::network::mojom::blink::X509CertificatePtr x509_certificate, const ::blink::String& provider_name, const ::blink::Vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) = 0;

  virtual void ContinueWithoutCertificate() = 0;

  virtual void CancelRequest() = 0;
};

class SSLPrivateKeyProxy;

template <typename ImplRefTraits>
class SSLPrivateKeyStub;

class SSLPrivateKeyRequestValidator;
class SSLPrivateKeyResponseValidator;


class BLINK_PLATFORM_EXPORT SSLPrivateKey
    : public SSLPrivateKeyInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.SSLPrivateKey";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SSLPrivateKeyInterfaceBase;
  using Proxy_ = SSLPrivateKeyProxy;

  template <typename ImplRefTraits>
  using Stub_ = SSLPrivateKeyStub<ImplRefTraits>;

  using RequestValidator_ = SSLPrivateKeyRequestValidator;
  using ResponseValidator_ = SSLPrivateKeyResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSignMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Sign_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SSLPrivateKey() = default;

  using SignCallback = base::OnceCallback<void(int32_t, const ::blink::Vector<uint8_t>&)>;
  using SignMojoCallback = base::OnceCallback<void(int32_t, const ::blink::Vector<uint8_t>&)>;

  virtual void Sign(uint16_t algorithm, const ::blink::Vector<uint8_t>& input, SignCallback callback) = 0;
};

class AuthChallengeResponderProxy;

template <typename ImplRefTraits>
class AuthChallengeResponderStub;

class AuthChallengeResponderRequestValidator;


class BLINK_PLATFORM_EXPORT AuthChallengeResponder
    : public AuthChallengeResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.AuthChallengeResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AuthChallengeResponderInterfaceBase;
  using Proxy_ = AuthChallengeResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuthChallengeResponderStub<ImplRefTraits>;

  using RequestValidator_ = AuthChallengeResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAuthCredentialsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnAuthCredentials_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AuthChallengeResponder() = default;

  virtual void OnAuthCredentials(::network::mojom::blink::AuthCredentialsPtr credentials) = 0;
};

class URLLoaderNetworkServiceObserverProxy;

template <typename ImplRefTraits>
class URLLoaderNetworkServiceObserverStub;

class URLLoaderNetworkServiceObserverRequestValidator;
class URLLoaderNetworkServiceObserverResponseValidator;


class BLINK_PLATFORM_EXPORT URLLoaderNetworkServiceObserver
    : public URLLoaderNetworkServiceObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.URLLoaderNetworkServiceObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderNetworkServiceObserverInterfaceBase;
  using Proxy_ = URLLoaderNetworkServiceObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderNetworkServiceObserverStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderNetworkServiceObserverRequestValidator;
  using ResponseValidator_ = URLLoaderNetworkServiceObserverResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnSSLCertificateErrorMinVersion = 0,
    kOnCertificateRequestedMinVersion = 0,
    kOnAuthRequiredMinVersion = 0,
    kOnLocalNetworkAccessPermissionRequiredMinVersion = 0,
    kOnClearSiteDataMinVersion = 0,
    kOnLoadingStateUpdateMinVersion = 0,
    kOnDataUseUpdateMinVersion = 0,
    kOnSharedStorageHeaderReceivedMinVersion = 0,
    kOnAdAuctionEventRecordHeaderReceivedMinVersion = 0,
    kCloneMinVersion = 0,
    kOnWebSocketConnectedToPrivateNetworkMinVersion = 0,
    kOnUrlLoaderConnectedToPrivateNetworkMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnSSLCertificateError_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCertificateRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAuthRequired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLocalNetworkAccessPermissionRequired_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClearSiteData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLoadingStateUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDataUseUpdate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSharedStorageHeaderReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAdAuctionEventRecordHeaderReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWebSocketConnectedToPrivateNetwork_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnUrlLoaderConnectedToPrivateNetwork_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoaderNetworkServiceObserver() = default;

  using OnSSLCertificateErrorCallback = base::OnceCallback<void(int32_t)>;
  using OnSSLCertificateErrorMojoCallback = base::OnceCallback<void(int32_t)>;

  virtual void OnSSLCertificateError(const ::blink::KURL& url, int32_t net_error, ::network::mojom::blink::SSLInfoPtr ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) = 0;

  virtual void OnCertificateRequested(const std::optional<::base::UnguessableToken>& window_id, ::network::mojom::blink::SSLCertRequestInfoPtr cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) = 0;

  virtual void OnAuthRequired(const std::optional<::base::UnguessableToken>& window_id, int32_t request_id, const ::blink::KURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, ::network::mojom::blink::HttpResponseHeadersPtr head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) = 0;

  using OnLocalNetworkAccessPermissionRequiredCallback = base::OnceCallback<void(bool)>;
  using OnLocalNetworkAccessPermissionRequiredMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OnLocalNetworkAccessPermissionRequired(OnLocalNetworkAccessPermissionRequiredCallback callback) = 0;

  using OnClearSiteDataCallback = base::OnceCallback<void()>;
  using OnClearSiteDataMojoCallback = base::OnceCallback<void()>;

  virtual void OnClearSiteData(const ::blink::KURL& url, const ::blink::String& header_value, int32_t load_flags, ::network::mojom::blink::CookiePartitionKeyPtr cookie_partition_key, bool partitioned_state_allowed_only, OnClearSiteDataCallback callback) = 0;

  using OnLoadingStateUpdateCallback = base::OnceCallback<void()>;
  using OnLoadingStateUpdateMojoCallback = base::OnceCallback<void()>;

  virtual void OnLoadingStateUpdate(LoadInfoPtr info, OnLoadingStateUpdateCallback callback) = 0;

  virtual void OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) = 0;

  using OnSharedStorageHeaderReceivedCallback = base::OnceCallback<void()>;
  using OnSharedStorageHeaderReceivedMojoCallback = base::OnceCallback<void()>;

  virtual void OnSharedStorageHeaderReceived(const ::scoped_refptr<const ::blink::SecurityOrigin>& request_origin, ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::blink::String>& with_lock, OnSharedStorageHeaderReceivedCallback callback) = 0;

  virtual void OnAdAuctionEventRecordHeaderReceived(::network::mojom::blink::AdAuctionEventRecordPtr ad_auction_event_record, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin) = 0;

  virtual void Clone(::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> listener) = 0;

  virtual void OnWebSocketConnectedToPrivateNetwork(const ::blink::KURL& request_url, ::network::mojom::blink::IPAddressSpace ip_address_space) = 0;

  virtual void OnUrlLoaderConnectedToPrivateNetwork(const ::blink::KURL& request_url, ::network::mojom::blink::IPAddressSpace response_address_space, ::network::mojom::blink::IPAddressSpace client_address_space, ::network::mojom::blink::IPAddressSpace target_address_space) = 0;
};



class BLINK_PLATFORM_EXPORT ClientCertificateResponderProxy
    : public ClientCertificateResponder {
 public:
  using InterfaceType = ClientCertificateResponder;

  explicit ClientCertificateResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ContinueWithCertificate(::network::mojom::blink::X509CertificatePtr x509_certificate, const ::blink::String& provider_name, const ::blink::Vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) final;
  
  void ContinueWithoutCertificate() final;
  
  void CancelRequest() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT SSLPrivateKeyProxy
    : public SSLPrivateKey {
 public:
  using InterfaceType = SSLPrivateKey;

  explicit SSLPrivateKeyProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Sign(uint16_t algorithm, const ::blink::Vector<uint8_t>& input, SignCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AuthChallengeResponderProxy
    : public AuthChallengeResponder {
 public:
  using InterfaceType = AuthChallengeResponder;

  explicit AuthChallengeResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAuthCredentials(::network::mojom::blink::AuthCredentialsPtr credentials) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT URLLoaderNetworkServiceObserverProxy
    : public URLLoaderNetworkServiceObserver {
 public:
  using InterfaceType = URLLoaderNetworkServiceObserver;

  explicit URLLoaderNetworkServiceObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnSSLCertificateError(const ::blink::KURL& url, int32_t net_error, ::network::mojom::blink::SSLInfoPtr ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) final;
  
  void OnCertificateRequested(const std::optional<::base::UnguessableToken>& window_id, ::network::mojom::blink::SSLCertRequestInfoPtr cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) final;
  
  void OnAuthRequired(const std::optional<::base::UnguessableToken>& window_id, int32_t request_id, const ::blink::KURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, ::network::mojom::blink::HttpResponseHeadersPtr head_headers, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) final;
  
  void OnLocalNetworkAccessPermissionRequired(OnLocalNetworkAccessPermissionRequiredCallback callback) final;
  
  void OnClearSiteData(const ::blink::KURL& url, const ::blink::String& header_value, int32_t load_flags, ::network::mojom::blink::CookiePartitionKeyPtr cookie_partition_key, bool partitioned_state_allowed_only, OnClearSiteDataCallback callback) final;
  
  void OnLoadingStateUpdate(LoadInfoPtr info, OnLoadingStateUpdateCallback callback) final;
  
  void OnDataUseUpdate(int32_t network_traffic_annotation_id_hash, int64_t recv_bytes, int64_t sent_bytes) final;
  
  void OnSharedStorageHeaderReceived(const ::scoped_refptr<const ::blink::SecurityOrigin>& request_origin, ::blink::Vector<::network::mojom::blink::SharedStorageModifierMethodWithOptionsPtr> methods_with_options, const std::optional<::blink::String>& with_lock, OnSharedStorageHeaderReceivedCallback callback) final;
  
  void OnAdAuctionEventRecordHeaderReceived(::network::mojom::blink::AdAuctionEventRecordPtr ad_auction_event_record, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin) final;
  
  void Clone(::mojo::PendingReceiver<URLLoaderNetworkServiceObserver> listener) final;
  
  void OnWebSocketConnectedToPrivateNetwork(const ::blink::KURL& request_url, ::network::mojom::blink::IPAddressSpace ip_address_space) final;
  
  void OnUrlLoaderConnectedToPrivateNetwork(const ::blink::KURL& request_url, ::network::mojom::blink::IPAddressSpace response_address_space, ::network::mojom::blink::IPAddressSpace client_address_space, ::network::mojom::blink::IPAddressSpace target_address_space) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ClientCertificateResponderStubDispatch {
 public:
  static bool Accept(ClientCertificateResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ClientCertificateResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ClientCertificateResponder>>
class ClientCertificateResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ClientCertificateResponderStub() = default;
  ~ClientCertificateResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientCertificateResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientCertificateResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT SSLPrivateKeyStubDispatch {
 public:
  static bool Accept(SSLPrivateKey* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SSLPrivateKey* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SSLPrivateKey>>
class SSLPrivateKeyStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SSLPrivateKeyStub() = default;
  ~SSLPrivateKeyStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLPrivateKeyStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLPrivateKeyStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AuthChallengeResponderStubDispatch {
 public:
  static bool Accept(AuthChallengeResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AuthChallengeResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AuthChallengeResponder>>
class AuthChallengeResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuthChallengeResponderStub() = default;
  ~AuthChallengeResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthChallengeResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthChallengeResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT URLLoaderNetworkServiceObserverStubDispatch {
 public:
  static bool Accept(URLLoaderNetworkServiceObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderNetworkServiceObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderNetworkServiceObserver>>
class URLLoaderNetworkServiceObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderNetworkServiceObserverStub() = default;
  ~URLLoaderNetworkServiceObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderNetworkServiceObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderNetworkServiceObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ClientCertificateResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SSLPrivateKeyRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AuthChallengeResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderNetworkServiceObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT SSLPrivateKeyResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT URLLoaderNetworkServiceObserverResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT LoadInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoadInfo, T>::value>;
  using DataView = LoadInfoDataView;
  using Data_ = internal::LoadInfo_Data;

  template <typename... Args>
  static LoadInfoPtr New(Args&&... args) {
    return LoadInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoadInfoPtr From(const U& u) {
    return mojo::TypeConverter<LoadInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoadInfo>::Convert(*this);
  }


  LoadInfo();

  LoadInfo(
      ::base::TimeTicks timestamp,
      const ::blink::String& host,
      uint32_t load_state,
      const ::blink::String& state_param,
      uint64_t upload_position,
      uint64_t upload_size);


  ~LoadInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoadInfoPtr>
  LoadInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoadInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoadInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoadInfo_UnserializedMessageContext<
            UserType, LoadInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoadInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoadInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoadInfo_UnserializedMessageContext<
            UserType, LoadInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoadInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks timestamp;
  
  ::blink::String host;
  
  uint32_t load_state;
  
  ::blink::String state_param;
  
  uint64_t upload_position;
  
  uint64_t upload_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoadInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LoadInfoPtr LoadInfo::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(host),
      mojo::Clone(load_state),
      mojo::Clone(state_param),
      mojo::Clone(upload_position),
      mojo::Clone(upload_size)
  );
}

template <typename T, LoadInfo::EnableIfSame<T>*>
bool LoadInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->load_state, other_struct.load_state))
    return false;
  if (!mojo::Equals(this->state_param, other_struct.state_param))
    return false;
  if (!mojo::Equals(this->upload_position, other_struct.upload_position))
    return false;
  if (!mojo::Equals(this->upload_size, other_struct.upload_size))
    return false;
  return true;
}

template <typename T, LoadInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.load_state < rhs.load_state)
    return true;
  if (rhs.load_state < lhs.load_state)
    return false;
  if (lhs.state_param < rhs.state_param)
    return true;
  if (rhs.state_param < lhs.state_param)
    return false;
  if (lhs.upload_position < rhs.upload_position)
    return true;
  if (rhs.upload_position < lhs.upload_position)
    return false;
  if (lhs.upload_size < rhs.upload_size)
    return true;
  if (rhs.upload_size < lhs.upload_size)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::LoadInfo::DataView,
                                         ::network::mojom::blink::LoadInfoPtr> {
  static bool IsNull(const ::network::mojom::blink::LoadInfoPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::LoadInfoPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::LoadInfo::timestamp)& timestamp(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->timestamp;
  }

  static const decltype(::network::mojom::blink::LoadInfo::host)& host(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::blink::LoadInfo::load_state) load_state(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->load_state;
  }

  static const decltype(::network::mojom::blink::LoadInfo::state_param)& state_param(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->state_param;
  }

  static decltype(::network::mojom::blink::LoadInfo::upload_position) upload_position(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->upload_position;
  }

  static decltype(::network::mojom::blink::LoadInfo::upload_size) upload_size(
      const ::network::mojom::blink::LoadInfoPtr& input) {
    return input->upload_size;
  }

  static bool Read(::network::mojom::blink::LoadInfo::DataView input, ::network::mojom::blink::LoadInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_LOADER_NETWORK_SERVICE_OBSERVER_MOJOM_BLINK_H_