// services/network/public/mojom/trust_token_access_observer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/trust_token_access_observer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-params-data.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-import-headers.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-test-utils.h"


namespace network::mojom {
TrustTokenIssuanceDetails::TrustTokenIssuanceDetails()
    : origin(),
      issuer(),
      blocked(false) {}

TrustTokenIssuanceDetails::TrustTokenIssuanceDetails(
    const ::url::Origin& origin_in,
    const std::optional<::url::Origin>& issuer_in,
    bool blocked_in)
    : origin(std::move(origin_in)),
      issuer(std::move(issuer_in)),
      blocked(std::move(blocked_in)) {}

TrustTokenIssuanceDetails::~TrustTokenIssuanceDetails() = default;

void TrustTokenIssuanceDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked"), this->blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenIssuanceDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenRedemptionDetails::TrustTokenRedemptionDetails()
    : origin(),
      issuer(),
      blocked(false) {}

TrustTokenRedemptionDetails::TrustTokenRedemptionDetails(
    const ::url::Origin& origin_in,
    const std::optional<::url::Origin>& issuer_in,
    bool blocked_in)
    : origin(std::move(origin_in)),
      issuer(std::move(issuer_in)),
      blocked(std::move(blocked_in)) {}

TrustTokenRedemptionDetails::~TrustTokenRedemptionDetails() = default;

void TrustTokenRedemptionDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked"), this->blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenRedemptionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenSigningDetails::TrustTokenSigningDetails()
    : origin(),
      blocked(false) {}

TrustTokenSigningDetails::TrustTokenSigningDetails(
    const ::url::Origin& origin_in,
    bool blocked_in)
    : origin(std::move(origin_in)),
      blocked(std::move(blocked_in)) {}

TrustTokenSigningDetails::~TrustTokenSigningDetails() = default;

void TrustTokenSigningDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked"), this->blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenSigningDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenAccessDetailsPtr
TrustTokenAccessDetails::NewIssuance(
    TrustTokenIssuanceDetailsPtr value) {
  return TrustTokenAccessDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kIssuance)>,
      std::move(value));
}

TrustTokenAccessDetailsPtr
TrustTokenAccessDetails::NewRedemption(
    TrustTokenRedemptionDetailsPtr value) {
  return TrustTokenAccessDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRedemption)>,
      std::move(value));
}

TrustTokenAccessDetailsPtr
TrustTokenAccessDetails::NewSigning(
    TrustTokenSigningDetailsPtr value) {
  return TrustTokenAccessDetailsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSigning)>,
      std::move(value));
}

TrustTokenAccessDetails::TrustTokenAccessDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kIssuance)>,
    TrustTokenIssuanceDetailsPtr value)
    : tag_(Tag::kIssuance),
      data_(std::in_place_index<static_cast<size_t>(Tag::kIssuance)>,
            std::move(value)) {}

TrustTokenAccessDetails::TrustTokenAccessDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kRedemption)>,
    TrustTokenRedemptionDetailsPtr value)
    : tag_(Tag::kRedemption),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRedemption)>,
            std::move(value)) {}

TrustTokenAccessDetails::TrustTokenAccessDetails(
    std::in_place_index_t<static_cast<size_t>(Tag::kSigning)>,
    TrustTokenSigningDetailsPtr value)
    : tag_(Tag::kSigning),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSigning)>,
            std::move(value)) {}
TrustTokenAccessDetails::~TrustTokenAccessDetails() {
  DestroyActive();
}

void TrustTokenAccessDetails::set_issuance(TrustTokenIssuanceDetailsPtr issuance) {
  if (tag_ == Tag::kIssuance) {
    data_.issuance = std::move(issuance);
  } else {
    DestroyActive();
    tag_ = Tag::kIssuance;
    new (&data_.issuance) TrustTokenIssuanceDetailsPtr(
        std::move(issuance));
  }
}

void TrustTokenAccessDetails::set_redemption(TrustTokenRedemptionDetailsPtr redemption) {
  if (tag_ == Tag::kRedemption) {
    data_.redemption = std::move(redemption);
  } else {
    DestroyActive();
    tag_ = Tag::kRedemption;
    new (&data_.redemption) TrustTokenRedemptionDetailsPtr(
        std::move(redemption));
  }
}

void TrustTokenAccessDetails::set_signing(TrustTokenSigningDetailsPtr signing) {
  if (tag_ == Tag::kSigning) {
    data_.signing = std::move(signing);
  } else {
    DestroyActive();
    tag_ = Tag::kSigning;
    new (&data_.signing) TrustTokenSigningDetailsPtr(
        std::move(signing));
  }
}


TrustTokenAccessDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kIssuance)>,
    TrustTokenIssuanceDetailsPtr value)
    : issuance(std::move(value)) {}

TrustTokenAccessDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRedemption)>,
    TrustTokenRedemptionDetailsPtr value)
    : redemption(std::move(value)) {}

TrustTokenAccessDetails::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSigning)>,
    TrustTokenSigningDetailsPtr value)
    : signing(std::move(value)) {}

void TrustTokenAccessDetails::DestroyActive() {
  switch (tag_) {

    case Tag::kIssuance:
      std::destroy_at(&data_.issuance);
      break;
    case Tag::kRedemption:
      std::destroy_at(&data_.redemption);
      break;
    case Tag::kSigning:
      std::destroy_at(&data_.signing);
      break;
  }
}

bool TrustTokenAccessDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

TrustTokenAccessObserver::IPCStableHashFunction TrustTokenAccessObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustTokenAccessObserver>(message.name())) {
    case messages::TrustTokenAccessObserver::kOnTrustTokensAccessed: {
      return &TrustTokenAccessObserver::OnTrustTokensAccessed_Sym::IPCStableHash;
    }
    case messages::TrustTokenAccessObserver::kClone: {
      return &TrustTokenAccessObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustTokenAccessObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustTokenAccessObserver>(message.name())) {
      case messages::TrustTokenAccessObserver::kOnTrustTokensAccessed:
            return "Receive network::mojom::TrustTokenAccessObserver::OnTrustTokensAccessed";
      case messages::TrustTokenAccessObserver::kClone:
            return "Receive network::mojom::TrustTokenAccessObserver::Clone";
    }
  } else {
    switch (static_cast<messages::TrustTokenAccessObserver>(message.name())) {
      case messages::TrustTokenAccessObserver::kOnTrustTokensAccessed:
            return "Receive reply network::mojom::TrustTokenAccessObserver::OnTrustTokensAccessed";
      case messages::TrustTokenAccessObserver::kClone:
            return "Receive reply network::mojom::TrustTokenAccessObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustTokenAccessObserver::OnTrustTokensAccessed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xccee82c6;  // IPCStableHash for network::mojom::TrustTokenAccessObserver::OnTrustTokensAccessed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustTokenAccessObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x375f5ce9;  // IPCStableHash for network::mojom::TrustTokenAccessObserver::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TrustTokenAccessObserverProxy::TrustTokenAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustTokenAccessObserverProxy::OnTrustTokensAccessed(
    TrustTokenAccessDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustTokenAccessObserver::OnTrustTokensAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type TrustTokenAccessDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenAccessObserver::kOnTrustTokensAccessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenAccessObserver_OnTrustTokensAccessed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->details)>
      details_fragment(params.message());
  details_fragment.Claim(&params->details);
  
  mojo::internal::Serialize<::network::mojom::TrustTokenAccessDetailsDataView>(
    in_details,
    details_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in TrustTokenAccessObserver.OnTrustTokensAccessed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenAccessObserver::Name_);
  message.set_method_name("OnTrustTokensAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TrustTokenAccessObserverProxy::Clone(
    ::mojo::PendingReceiver<TrustTokenAccessObserver> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustTokenAccessObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingReceiver<TrustTokenAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenAccessObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenAccessObserver_Clone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in TrustTokenAccessObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenAccessObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TrustTokenAccessObserverStubDispatch::Accept(
    TrustTokenAccessObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustTokenAccessObserver>(message->header()->name)) {
    case messages::TrustTokenAccessObserver::kOnTrustTokensAccessed: {
      DCHECK(message->is_serialized());
      internal::TrustTokenAccessObserver_OnTrustTokensAccessed_Params_Data* params =
          reinterpret_cast<internal::TrustTokenAccessObserver_OnTrustTokensAccessed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustTokenAccessObserver.0
      bool success = true;
      TrustTokenAccessDetailsPtr p_details{};
      TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustTokenAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTrustTokensAccessed(        
        std::move(p_details));
      return true;
    }
    case messages::TrustTokenAccessObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::TrustTokenAccessObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::TrustTokenAccessObserver_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TrustTokenAccessObserver.1
      bool success = true;
      ::mojo::PendingReceiver<TrustTokenAccessObserver> p_listener{};
      TrustTokenAccessObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustTokenAccessObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_listener));
      return true;
    }
  }
  return false;
}

// static
bool TrustTokenAccessObserverStubDispatch::AcceptWithResponder(
    TrustTokenAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustTokenAccessObserver>(message->header()->name)) {
    case messages::TrustTokenAccessObserver::kOnTrustTokensAccessed: {
      break;
    }
    case messages::TrustTokenAccessObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTrustTokenAccessObserverValidationInfo[] = {
    { &internal::TrustTokenAccessObserver_OnTrustTokensAccessed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TrustTokenAccessObserver_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool TrustTokenAccessObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::TrustTokenAccessObserver::Name_,
    kTrustTokenAccessObserverValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::TrustTokenIssuanceDetails::DataView, ::network::mojom::TrustTokenIssuanceDetailsPtr>::Read(
    ::network::mojom::TrustTokenIssuanceDetails::DataView input,
    ::network::mojom::TrustTokenIssuanceDetailsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenIssuanceDetailsPtr result(::network::mojom::TrustTokenIssuanceDetails::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success)
        result->blocked = input.blocked();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenRedemptionDetails::DataView, ::network::mojom::TrustTokenRedemptionDetailsPtr>::Read(
    ::network::mojom::TrustTokenRedemptionDetails::DataView input,
    ::network::mojom::TrustTokenRedemptionDetailsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenRedemptionDetailsPtr result(::network::mojom::TrustTokenRedemptionDetails::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success)
        result->blocked = input.blocked();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenSigningDetails::DataView, ::network::mojom::TrustTokenSigningDetailsPtr>::Read(
    ::network::mojom::TrustTokenSigningDetails::DataView input,
    ::network::mojom::TrustTokenSigningDetailsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenSigningDetailsPtr result(::network::mojom::TrustTokenSigningDetails::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->blocked = input.blocked();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::TrustTokenAccessDetails::DataView, ::network::mojom::TrustTokenAccessDetailsPtr>::Read(
    ::network::mojom::TrustTokenAccessDetails::DataView input,
    ::network::mojom::TrustTokenAccessDetailsPtr* output) {
  using UnionType = ::network::mojom::TrustTokenAccessDetails;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kIssuance: {
      ::network::mojom::TrustTokenIssuanceDetailsPtr result_issuance{};
      if (!input.ReadIssuance(&result_issuance))
        return false;

      *output = UnionType::NewIssuance(
          std::move(result_issuance));
      break;
    }
    case Tag::kRedemption: {
      ::network::mojom::TrustTokenRedemptionDetailsPtr result_redemption{};
      if (!input.ReadRedemption(&result_redemption))
        return false;

      *output = UnionType::NewRedemption(
          std::move(result_redemption));
      break;
    }
    case Tag::kSigning: {
      ::network::mojom::TrustTokenSigningDetailsPtr result_signing{};
      if (!input.ReadSigning(&result_signing))
        return false;

      *output = UnionType::NewSigning(
          std::move(result_signing));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void TrustTokenAccessObserverInterceptorForTesting::OnTrustTokensAccessed(TrustTokenAccessDetailsPtr details) {
  GetForwardingInterface()->OnTrustTokensAccessed(
    std::move(details)
    );
}
void TrustTokenAccessObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<TrustTokenAccessObserver> listener) {
  GetForwardingInterface()->Clone(
    std::move(listener)
    );
}
TrustTokenAccessObserverAsyncWaiter::TrustTokenAccessObserverAsyncWaiter(
    TrustTokenAccessObserver* proxy) : proxy_(proxy) {}

TrustTokenAccessObserverAsyncWaiter::~TrustTokenAccessObserverAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif