// services/network/public/mojom/trust_token_access_observer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/trust_token_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/trust_token_access_observer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenIssuanceDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenIssuanceDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenIssuanceDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenIssuanceDetails struct");

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      fragment->blocked = Traits::blocked(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenRedemptionDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenRedemptionDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenRedemptionDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenRedemptionDetails struct");

      decltype(Traits::issuer(input)) in_issuer = Traits::issuer(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->issuer)::BaseType> issuer_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_issuer,
        issuer_fragment);

      fragment->issuer.Set(
          issuer_fragment.is_null() ? nullptr : issuer_fragment.data());

      fragment->blocked = Traits::blocked(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenSigningDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenSigningDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustTokenSigningDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in TrustTokenSigningDetails struct");

      fragment->blocked = Traits::blocked(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TrustTokenAccessDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::TrustTokenAccessDetailsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::TrustTokenAccessDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kIssuance: {
    decltype(Traits::issuance(input))
    in_issuance = Traits::issuance(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_issuance)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenIssuanceDetailsDataView, send_validation>(
  in_issuance,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null issuance in TrustTokenAccessDetails union");
    fragment->data.f_issuance.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kRedemption: {
    decltype(Traits::redemption(input))
    in_redemption = Traits::redemption(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_redemption)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenRedemptionDetailsDataView, send_validation>(
  in_redemption,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null redemption in TrustTokenAccessDetails union");
    fragment->data.f_redemption.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::TrustTokenAccessDetailsDataView::Tag::kSigning: {
    decltype(Traits::signing(input))
    in_signing = Traits::signing(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_signing)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::TrustTokenSigningDetailsDataView, send_validation>(
  in_signing,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null signing in TrustTokenAccessDetails union");
    fragment->data.f_signing.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKEN_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_