// services/network/public/mojom/transferable_directory.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/transferable_directory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"

#include "services/network/public/mojom/transferable_directory.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TransferableDirectoryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::TransferableDirectoryDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::TransferableDirectory_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::TransferableDirectoryDataView::Tag::kHandleForIpc: {
    decltype(Traits::handle_for_ipc(input))
    in_handle_for_ipc = Traits::handle_for_ipc(input);
        
mojo::internal::Serialize<mojo::PlatformHandle, send_validation>(
  in_handle_for_ipc,
  &fragment->data.f_handle_for_ipc,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_handle_for_ipc)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null handle_for_ipc in TransferableDirectory union");
    break;
  }
  case ::network::mojom::TransferableDirectoryDataView::Tag::kPath: {
    decltype(Traits::path(input))
    in_path = Traits::path(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_path)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView, send_validation>(
  in_path,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null path in TransferableDirectory union");
    fragment->data.f_path.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_DIRECTORY_MOJOM_SEND_VALIDATION_H_