// services/network/public/mojom/structured_headers.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/structured_headers.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"


namespace network::mojom {
class StructuredHeadersParameterDataView;

class StructuredHeadersParameterizedItemDataView;

class StructuredHeadersParameterizedMemberDataView;

class StructuredHeadersDictionaryMemberDataView;

class StructuredHeadersDictionaryDataView;

class StructuredHeadersItemDataView;


}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersParameterDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersParameter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersParameterizedItemDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersParameterizedItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersParameterizedMemberDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersParameterizedMember_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersDictionaryMemberDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersDictionaryMember_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersDictionaryDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersDictionary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::StructuredHeadersItemDataView> {
  using Data = ::network::mojom::internal::StructuredHeadersItem_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class StructuredHeadersParameterDataView {
 public:
  StructuredHeadersParameterDataView() = default;

  StructuredHeadersParameterDataView(
      internal::StructuredHeadersParameter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetItemDataView(
      StructuredHeadersItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItem(UserType* output) {
    
    auto* pointer = !data_->item.is_null() ? &data_->item : nullptr;
    return mojo::internal::Deserialize<::network::mojom::StructuredHeadersItemDataView>(
        pointer, output, message_);
  }
 private:
  internal::StructuredHeadersParameter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StructuredHeadersParameterizedItemDataView {
 public:
  StructuredHeadersParameterizedItemDataView() = default;

  StructuredHeadersParameterizedItemDataView(
      internal::StructuredHeadersParameterizedItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemDataView(
      StructuredHeadersItemDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItem(UserType* output) {
    
    auto* pointer = !data_->item.is_null() ? &data_->item : nullptr;
    return mojo::internal::Deserialize<::network::mojom::StructuredHeadersItemDataView>(
        pointer, output, message_);
  }
  inline void GetParametersDataView(
      mojo::ArrayDataView<StructuredHeadersParameterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParameters(UserType* output) {
    
    auto* pointer = data_->parameters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StructuredHeadersParameterizedItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StructuredHeadersParameterizedMemberDataView {
 public:
  StructuredHeadersParameterizedMemberDataView() = default;

  StructuredHeadersParameterizedMemberDataView(
      internal::StructuredHeadersParameterizedMember_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMemberDataView(
      mojo::ArrayDataView<StructuredHeadersParameterizedItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMember(UserType* output) {
    
    auto* pointer = data_->member.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterizedItemDataView>>(
        pointer, output, message_);
  }
  bool member_is_inner_list() const {
    return data_->member_is_inner_list;
  }
  inline void GetParametersDataView(
      mojo::ArrayDataView<StructuredHeadersParameterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParameters(UserType* output) {
    
    auto* pointer = data_->parameters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersParameterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StructuredHeadersParameterizedMember_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StructuredHeadersDictionaryMemberDataView {
 public:
  StructuredHeadersDictionaryMemberDataView() = default;

  StructuredHeadersDictionaryMemberDataView(
      internal::StructuredHeadersDictionaryMember_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      StructuredHeadersParameterizedMemberDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::network::mojom::StructuredHeadersParameterizedMemberDataView>(
        pointer, output, message_);
  }
 private:
  internal::StructuredHeadersDictionaryMember_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StructuredHeadersDictionaryDataView {
 public:
  StructuredHeadersDictionaryDataView() = default;

  StructuredHeadersDictionaryDataView(
      internal::StructuredHeadersDictionary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMembersDataView(
      mojo::ArrayDataView<StructuredHeadersDictionaryMemberDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMembers(UserType* output) {
    
    auto* pointer = data_->members.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::StructuredHeadersDictionaryMemberDataView>>(
        pointer, output, message_);
  }
 private:
  internal::StructuredHeadersDictionary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class StructuredHeadersItemDataView {
 public:
  using Tag = internal::StructuredHeadersItem_Data::StructuredHeadersItem_Tag;

  StructuredHeadersItemDataView() = default;

  StructuredHeadersItemDataView(
      internal::StructuredHeadersItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_null_value() const { return data_->tag == Tag::kNullValue; }
  uint8_t null_value() const {
    CHECK(is_null_value());
    return data_->data.f_null_value;
  }
  bool is_integer_value() const { return data_->tag == Tag::kIntegerValue; }
  int64_t integer_value() const {
    CHECK(is_integer_value());
    return data_->data.f_integer_value;
  }
  bool is_decimal_value() const { return data_->tag == Tag::kDecimalValue; }
  double decimal_value() const {
    CHECK(is_decimal_value());
    return data_->data.f_decimal_value;
  }
  bool is_string_value() const { return data_->tag == Tag::kStringValue; }
  inline void GetStringValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStringValue(UserType* output) const {
    
    CHECK(is_string_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_string_value.Get(), output, message_);
  }
  bool is_token_value() const { return data_->tag == Tag::kTokenValue; }
  inline void GetTokenValueDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadTokenValue(UserType* output) const {
    
    CHECK(is_token_value());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_token_value.Get(), output, message_);
  }
  bool is_byte_sequence_value() const { return data_->tag == Tag::kByteSequenceValue; }
  inline void GetByteSequenceValueDataView(
      ::mojo_base::mojom::ByteStringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadByteSequenceValue(UserType* output) const {
    
    CHECK(is_byte_sequence_value());
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        data_->data.f_byte_sequence_value.Get(), output, message_);
  }
  bool is_boolean_value() const { return data_->tag == Tag::kBooleanValue; }
  bool boolean_value() const {
    CHECK(is_boolean_value());
    return data_->data.f_boolean_value;
  }

 private:
  internal::StructuredHeadersItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_DATA_VIEW_H_