// services/network/public/mojom/ssl_config.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/ssl_config.mojom-shared-internal.h"

#include "services/network/public/mojom/ssl_config.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SSLVersion, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::SSLNamedGroupsPreset, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SSLConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SSLConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SSLConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->rev_checking_enabled = Traits::rev_checking_enabled(input);

      fragment->rev_checking_required_local_anchors = Traits::rev_checking_required_local_anchors(input);

      fragment->sha1_local_anchors_enabled = Traits::sha1_local_anchors_enabled(input);

      
      mojo::internal::Serialize<::network::mojom::SSLVersion>(
        Traits::version_min(input),
        &fragment->version_min);

      
      mojo::internal::Serialize<::network::mojom::SSLVersion>(
        Traits::version_max(input),
        &fragment->version_max);

      decltype(Traits::disabled_cipher_suites(input)) in_disabled_cipher_suites = Traits::disabled_cipher_suites(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->disabled_cipher_suites)::BaseType>
          disabled_cipher_suites_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& disabled_cipher_suites_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>, send_validation>(
        in_disabled_cipher_suites,
        disabled_cipher_suites_fragment,
        &disabled_cipher_suites_validate_params);

      fragment->disabled_cipher_suites.Set(
          disabled_cipher_suites_fragment.is_null() ? nullptr : disabled_cipher_suites_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->disabled_cipher_suites.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null disabled_cipher_suites in SSLConfig struct");

      fragment->tls13_cipher_prefer_aes_256 = Traits::tls13_cipher_prefer_aes_256(input);

      decltype(Traits::client_cert_pooling_policy(input)) in_client_cert_pooling_policy = Traits::client_cert_pooling_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->client_cert_pooling_policy)::BaseType>
          client_cert_pooling_policy_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& client_cert_pooling_policy_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_client_cert_pooling_policy,
        client_cert_pooling_policy_fragment,
        &client_cert_pooling_policy_validate_params);

      fragment->client_cert_pooling_policy.Set(
          client_cert_pooling_policy_fragment.is_null() ? nullptr : client_cert_pooling_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->client_cert_pooling_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null client_cert_pooling_policy in SSLConfig struct");

      
      mojo::internal::Serialize<::network::mojom::SSLNamedGroupsPreset>(
        Traits::named_groups_preset(input),
        &fragment->named_groups_preset);

      fragment->post_quantum_key_agreement_enabled = Traits::post_quantum_key_agreement_enabled(input);

      fragment->ech_enabled = Traits::ech_enabled(input);

      decltype(Traits::trust_anchor_ids(input)) in_trust_anchor_ids = Traits::trust_anchor_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->trust_anchor_ids)::BaseType>
          trust_anchor_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& trust_anchor_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>, send_validation>(
        in_trust_anchor_ids,
        trust_anchor_ids_fragment,
        &trust_anchor_ids_validate_params);

      fragment->trust_anchor_ids.Set(
          trust_anchor_ids_fragment.is_null() ? nullptr : trust_anchor_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->trust_anchor_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null trust_anchor_ids in SSLConfig struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SEND_VALIDATION_H_