// services/network/public/mojom/shared_dictionary_isolation_key.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/shared_dictionary_isolation_key.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }



  function SharedDictionaryIsolationKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedDictionaryIsolationKey.prototype.initDefaults_ = function() {
    this.frameOrigin = null;
    this.topFrameSite = null;
  };
  SharedDictionaryIsolationKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedDictionaryIsolationKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryIsolationKey.frameOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedDictionaryIsolationKey.topFrameSite
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedDictionaryIsolationKey.encodedSize = codec.kStructHeaderSize + 16;

  SharedDictionaryIsolationKey.decode = function(decoder) {
    var packed;
    var val = new SharedDictionaryIsolationKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.topFrameSite =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    return val;
  };

  SharedDictionaryIsolationKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedDictionaryIsolationKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.frameOrigin);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.topFrameSite);
  };
  exports.SharedDictionaryIsolationKey = SharedDictionaryIsolationKey;
})();