// services/network/public/mojom/schemeful_site.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/schemeful_site.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/schemeful_site.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SchemefulSiteDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SchemefulSiteDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SchemefulSite_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::site_as_origin(input)) in_site_as_origin = Traits::site_as_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site_as_origin)::BaseType> site_as_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_site_as_origin,
        site_as_origin_fragment);

      fragment->site_as_origin.Set(
          site_as_origin_fragment.is_null() ? nullptr : site_as_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site_as_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_as_origin in SchemefulSite struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SEND_VALIDATION_H_