// services/network/public/mojom/reporting_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/reporting_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"


namespace network::mojom {
class ReportingApiReportDataView;

class ReportingApiEndpointDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::ReportingApiReportDataView> {
  using Data = ::network::mojom::internal::ReportingApiReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ReportingApiEndpointDataView> {
  using Data = ::network::mojom::internal::ReportingApiEndpoint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ReportingApiReportStatus : int32_t {
  
  kQueued = 0,
  
  kPending = 1,
  
  kDoomed = 2,
  
  kSuccess = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ReportingApiReportStatus value);
inline bool IsKnownEnumValue(ReportingApiReportStatus value) {
  return internal::ReportingApiReportStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ReportingApiObserverInterfaceBase {};

using ReportingApiObserverPtrDataView =
    mojo::InterfacePtrDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverRequestDataView =
    mojo::InterfaceRequestDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ReportingApiObserverInterfaceBase>;
using ReportingApiObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ReportingApiObserverInterfaceBase>;


class ReportingApiReportDataView {
 public:
  ReportingApiReportDataView() = default;

  ReportingApiReportDataView(
      internal::ReportingApiReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetGroupDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroup(UserType* output) {
    
    auto* pointer = data_->group.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  int32_t depth() const {
    return data_->depth;
  }
  int32_t attempts() const {
    return data_->attempts;
  }
  inline void GetBodyDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::ReportingApiReportStatus>(
        data_value, output);
  }
  ReportingApiReportStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReportingApiReportStatus>(data_->status));
  }
 private:
  internal::ReportingApiReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReportingApiEndpointDataView {
 public:
  ReportingApiEndpointDataView() = default;

  ReportingApiEndpointDataView(
      internal::ReportingApiEndpoint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int32_t attempted_uploads() const {
    return data_->attempted_uploads;
  }
  int32_t successful_uploads() const {
    return data_->successful_uploads;
  }
  int32_t attempted_reports() const {
    return data_->attempted_reports;
  }
  int32_t successful_reports() const {
    return data_->successful_reports;
  }
  int32_t priority() const {
    return data_->priority;
  }
  int32_t weight() const {
    return data_->weight;
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupName(UserType* output) {
    
    auto* pointer = data_->group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNetworkAnonymizationKeyDataView(
      ::network::mojom::NetworkAnonymizationKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkAnonymizationKey(UserType* output) {
    
    auto* pointer = !data_->network_anonymization_key.is_null() ? &data_->network_anonymization_key : nullptr;
    return mojo::internal::Deserialize<::network::mojom::NetworkAnonymizationKeyDataView>(
        pointer, output, message_);
  }
  inline void GetReportingSourceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingSource(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `reporting_source` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingSource` instead "
    "of `ReadReportingSource if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_source.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReportingApiEndpoint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_DATA_VIEW_H_