// services/network/public/mojom/proxy_config.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config.mojom-blink-import-headers.h"
#include "services/network/public/mojom/proxy_config.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ProxyBypassRules::ProxyBypassRules()
    : rules() {}

ProxyBypassRules::ProxyBypassRules(
    ::blink::Vector<::blink::String> rules_in)
    : rules(std::move(rules_in)) {}

ProxyBypassRules::~ProxyBypassRules() = default;

void ProxyBypassRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rules"), this->rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyBypassRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyList::ProxyList()
    : proxies() {}

ProxyList::ProxyList(
    ::blink::Vector<::net::ProxyChain> proxies_in)
    : proxies(std::move(proxies_in)) {}

ProxyList::~ProxyList() = default;

void ProxyList::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies"), this->proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::net::ProxyChain>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyList::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyRules::ProxyRules()
    : bypass_rules(),
      reverse_bypass(),
      type(),
      single_proxies(),
      proxies_for_http(),
      proxies_for_https(),
      proxies_for_ftp(),
      fallback_proxies() {}

ProxyRules::ProxyRules(
    ProxyBypassRulesPtr bypass_rules_in,
    bool reverse_bypass_in,
    ProxyRulesType type_in,
    ProxyListPtr single_proxies_in,
    ProxyListPtr proxies_for_http_in,
    ProxyListPtr proxies_for_https_in,
    ProxyListPtr proxies_for_ftp_in,
    ProxyListPtr fallback_proxies_in)
    : bypass_rules(std::move(bypass_rules_in)),
      reverse_bypass(std::move(reverse_bypass_in)),
      type(std::move(type_in)),
      single_proxies(std::move(single_proxies_in)),
      proxies_for_http(std::move(proxies_for_http_in)),
      proxies_for_https(std::move(proxies_for_https_in)),
      proxies_for_ftp(std::move(proxies_for_ftp_in)),
      fallback_proxies(std::move(fallback_proxies_in)) {}

ProxyRules::~ProxyRules() = default;

void ProxyRules::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bypass_rules"), this->bypass_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyBypassRulesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reverse_bypass"), this->reverse_bypass,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyRulesType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "single_proxies"), this->single_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyListPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_http"), this->proxies_for_http,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyListPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_https"), this->proxies_for_https,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyListPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxies_for_ftp"), this->proxies_for_ftp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyListPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fallback_proxies"), this->fallback_proxies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyListPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyRules::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyConfig::ProxyConfig()
    : auto_detect(),
      from_system(),
      pac_url(),
      pac_mandatory(),
      proxy_rules() {}

ProxyConfig::ProxyConfig(
    bool auto_detect_in,
    bool from_system_in,
    const ::blink::String& pac_url_in,
    bool pac_mandatory_in,
    ProxyRulesPtr proxy_rules_in)
    : auto_detect(std::move(auto_detect_in)),
      from_system(std::move(from_system_in)),
      pac_url(std::move(pac_url_in)),
      pac_mandatory(std::move(pac_mandatory_in)),
      proxy_rules(std::move(proxy_rules_in)) {}

ProxyConfig::~ProxyConfig() = default;

void ProxyConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auto_detect"), this->auto_detect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_system"), this->from_system,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_url"), this->pac_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pac_mandatory"), this->pac_mandatory,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_rules"), this->proxy_rules,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyRulesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ProxyBypassRules::DataView, ::network::mojom::blink::ProxyBypassRulesPtr>::Read(
    ::network::mojom::blink::ProxyBypassRules::DataView input,
    ::network::mojom::blink::ProxyBypassRulesPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyBypassRulesPtr result(::network::mojom::blink::ProxyBypassRules::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyList::DataView, ::network::mojom::blink::ProxyListPtr>::Read(
    ::network::mojom::blink::ProxyList::DataView input,
    ::network::mojom::blink::ProxyListPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyListPtr result(::network::mojom::blink::ProxyList::New());
  
      if (success && !input.ReadProxies(&result->proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyRules::DataView, ::network::mojom::blink::ProxyRulesPtr>::Read(
    ::network::mojom::blink::ProxyRules::DataView input,
    ::network::mojom::blink::ProxyRulesPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyRulesPtr result(::network::mojom::blink::ProxyRules::New());
  
      if (success && !input.ReadBypassRules(&result->bypass_rules))
        success = false;
      if (success)
        result->reverse_bypass = input.reverse_bypass();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadSingleProxies(&result->single_proxies))
        success = false;
      if (success && !input.ReadProxiesForHttp(&result->proxies_for_http))
        success = false;
      if (success && !input.ReadProxiesForHttps(&result->proxies_for_https))
        success = false;
      if (success && !input.ReadProxiesForFtp(&result->proxies_for_ftp))
        success = false;
      if (success && !input.ReadFallbackProxies(&result->fallback_proxies))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyConfig::DataView, ::network::mojom::blink::ProxyConfigPtr>::Read(
    ::network::mojom::blink::ProxyConfig::DataView input,
    ::network::mojom::blink::ProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyConfigPtr result(::network::mojom::blink::ProxyConfig::New());
  
      if (success)
        result->auto_detect = input.auto_detect();
      if (success)
        result->from_system = input.from_system();
      if (success && !input.ReadPacUrl(&result->pac_url))
        success = false;
      if (success)
        result->pac_mandatory = input.pac_mandatory();
      if (success && !input.ReadProxyRules(&result->proxy_rules))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif