// services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-params-data.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-shared-message-ids.h"

#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink-import-headers.h"
#include "services/network/public/mojom/permissions_policy/permissions_policy.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
OriginWithPossibleWildcards::OriginWithPossibleWildcards()
    : scheme(),
      host(),
      port(-1),
      is_host_wildcard(false),
      is_port_wildcard(false) {}

OriginWithPossibleWildcards::OriginWithPossibleWildcards(
    const ::blink::String& scheme_in,
    const ::blink::String& host_in,
    int32_t port_in,
    bool is_host_wildcard_in,
    bool is_port_wildcard_in)
    : scheme(std::move(scheme_in)),
      host(std::move(host_in)),
      port(std::move(port_in)),
      is_host_wildcard(std::move(is_host_wildcard_in)),
      is_port_wildcard(std::move(is_port_wildcard_in)) {}

OriginWithPossibleWildcards::~OriginWithPossibleWildcards() = default;

void OriginWithPossibleWildcards::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_host_wildcard"), this->is_host_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_port_wildcard"), this->is_port_wildcard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OriginWithPossibleWildcards::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ParsedPermissionsPolicyDeclaration::ParsedPermissionsPolicyDeclaration()
    : feature(),
      allowed_origins(),
      self_if_matches(),
      matches_all_origins(),
      matches_opaque_src(),
      reporting_endpoint() {}

ParsedPermissionsPolicyDeclaration::ParsedPermissionsPolicyDeclaration(
    ::network::mojom::blink::PermissionsPolicyFeature feature_in,
    ::blink::Vector<::network::OriginWithPossibleWildcards> allowed_origins_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& self_if_matches_in,
    bool matches_all_origins_in,
    bool matches_opaque_src_in,
    const ::blink::String& reporting_endpoint_in)
    : feature(std::move(feature_in)),
      allowed_origins(std::move(allowed_origins_in)),
      self_if_matches(std::move(self_if_matches_in)),
      matches_all_origins(std::move(matches_all_origins_in)),
      matches_opaque_src(std::move(matches_opaque_src_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)) {}

ParsedPermissionsPolicyDeclaration::~ParsedPermissionsPolicyDeclaration() = default;

void ParsedPermissionsPolicyDeclaration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature"), this->feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::PermissionsPolicyFeature>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_origins"), this->allowed_origins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::network::OriginWithPossibleWildcards>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "self_if_matches"), this->self_if_matches,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matches_all_origins"), this->matches_all_origins,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matches_opaque_src"), this->matches_opaque_src,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ParsedPermissionsPolicyDeclaration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PermissionsPolicy::PermissionsPolicy()
    : origin(),
      headerless(),
      declarations(),
      inherited_policies() {}

PermissionsPolicy::PermissionsPolicy(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin_in,
    bool headerless_in,
    ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration> declarations_in,
    const ::blink::String& inherited_policies_in)
    : origin(std::move(origin_in)),
      headerless(std::move(headerless_in)),
      declarations(std::move(declarations_in)),
      inherited_policies(std::move(inherited_policies_in)) {}

PermissionsPolicy::~PermissionsPolicy() = default;

void PermissionsPolicy::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "headerless"), this->headerless,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "declarations"), this->declarations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::network::ParsedPermissionsPolicyDeclaration>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inherited_policies"), this->inherited_policies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PermissionsPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::OriginWithPossibleWildcards::DataView, ::network::mojom::blink::OriginWithPossibleWildcardsPtr>::Read(
    ::network::mojom::blink::OriginWithPossibleWildcards::DataView input,
    ::network::mojom::blink::OriginWithPossibleWildcardsPtr* output) {
  bool success = true;
  ::network::mojom::blink::OriginWithPossibleWildcardsPtr result(::network::mojom::blink::OriginWithPossibleWildcards::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
      if (success)
        result->is_host_wildcard = input.is_host_wildcard();
      if (success)
        result->is_port_wildcard = input.is_port_wildcard();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ParsedPermissionsPolicyDeclaration::DataView, ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr>::Read(
    ::network::mojom::blink::ParsedPermissionsPolicyDeclaration::DataView input,
    ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr* output) {
  bool success = true;
  ::network::mojom::blink::ParsedPermissionsPolicyDeclarationPtr result(::network::mojom::blink::ParsedPermissionsPolicyDeclaration::New());
  
      if (success && !input.ReadFeature(&result->feature))
        success = false;
      if (success && !input.ReadAllowedOrigins(&result->allowed_origins))
        success = false;
      if (success && !input.ReadSelfIfMatches(&result->self_if_matches))
        success = false;
      if (success)
        result->matches_all_origins = input.matches_all_origins();
      if (success)
        result->matches_opaque_src = input.matches_opaque_src();
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::PermissionsPolicy::DataView, ::network::mojom::blink::PermissionsPolicyPtr>::Read(
    ::network::mojom::blink::PermissionsPolicy::DataView input,
    ::network::mojom::blink::PermissionsPolicyPtr* output) {
  bool success = true;
  ::network::mojom::blink::PermissionsPolicyPtr result(::network::mojom::blink::PermissionsPolicy::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->headerless = input.headerless();
      if (success && !input.ReadDeclarations(&result->declarations))
        success = false;
      if (success && !input.ReadInheritedPolicies(&result->inherited_policies))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif