// services/network/public/mojom/parsed_headers.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/parsed_headers.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/parsed_headers.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* OriginAgentClusterValueToStringHelper(OriginAgentClusterValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OriginAgentClusterValue::kAbsent:
      return "kAbsent";
    case OriginAgentClusterValue::kTrue:
      return "kTrue";
    case OriginAgentClusterValue::kFalse:
      return "kFalse";
    default:
      return nullptr;
  }
}

std::string OriginAgentClusterValueToString(OriginAgentClusterValue value) {
  const char *str = OriginAgentClusterValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OriginAgentClusterValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OriginAgentClusterValue value) {
  return os << OriginAgentClusterValueToString(value);
}

namespace internal {


// static
bool ParsedHeaders_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 184, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ParsedHeaders_Data* object =
      static_cast<const ParsedHeaders_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_security_policy, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_security_policy_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->content_security_policy, validation_context,
                                         &content_security_policy_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->allow_csp_from, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_opener_policy, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_opener_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_isolation_policy, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_isolation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->integrity_policy, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->integrity_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->integrity_policy_report_only, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->integrity_policy_report_only, validation_context))
    return false;


  if (!::network::mojom::internal::OriginAgentClusterValue_Data
        ::Validate(object->origin_agent_cluster, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& accept_ch_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->accept_ch, validation_context,
                                         &accept_ch_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& critical_ch_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->critical_ch, validation_context,
                                         &critical_ch_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::XFrameOptionsValue_Data
        ::Validate(object->xfo, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->link_headers, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& link_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->link_headers, validation_context,
                                         &link_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->timing_allow_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->supports_loading_mode, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& supports_loading_mode_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::LoadingMode_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->supports_loading_mode, validation_context,
                                         &supports_loading_mode_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& reporting_endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->reporting_endpoints, validation_context,
                                         &reporting_endpoints_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& cookie_indices_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cookie_indices, validation_context,
                                         &cookie_indices_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& avail_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->avail_language, validation_context,
                                         &avail_language_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& content_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->content_language, validation_context,
                                         &content_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->no_vary_search_with_parse_error, validation_context))
    return false;

  return true;
}

ParsedHeaders_Data::ParsedHeaders_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::OriginAgentClusterValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::OriginAgentClusterValue value) {
  return std::move(context).WriteString(::network::mojom::OriginAgentClusterValueToString(value));
}

} // namespace perfetto