// services/network/public/mojom/p2p.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/p2p.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "services/network/public/mojom/address_family.mojom-shared.h"
#include "services/network/public/mojom/network_interface.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"


namespace network::mojom {
using P2PHostAndIPEndPointDataView = mojo::native::NativeStructDataView;

using P2PPacketInfoDataView = mojo::native::NativeStructDataView;

using P2PPortRangeDataView = mojo::native::NativeStructDataView;

using P2PSendPacketMetricsDataView = mojo::native::NativeStructDataView;

class P2PReceivedPacketDataView;

class P2PSendPacketDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::P2PReceivedPacketDataView> {
  using Data = ::network::mojom::internal::P2PReceivedPacket_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::P2PSendPacketDataView> {
  using Data = ::network::mojom::internal::P2PSendPacket_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
using P2PSocketType = mojo::NativeEnum;
using P2PSocketOption = mojo::NativeEnum;


enum class EcnMarking : int32_t {
  
  kNotEct = 0,
  
  kEct1 = 1,
  
  kEct0 = 2,
  
  kCe = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, EcnMarking value);
inline bool IsKnownEnumValue(EcnMarking value) {
  return internal::EcnMarking_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class P2PNetworkNotificationClientInterfaceBase {};

using P2PNetworkNotificationClientPtrDataView =
    mojo::InterfacePtrDataView<P2PNetworkNotificationClientInterfaceBase>;
using P2PNetworkNotificationClientRequestDataView =
    mojo::InterfaceRequestDataView<P2PNetworkNotificationClientInterfaceBase>;
using P2PNetworkNotificationClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<P2PNetworkNotificationClientInterfaceBase>;
using P2PNetworkNotificationClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<P2PNetworkNotificationClientInterfaceBase>;
class P2PSocketManagerInterfaceBase {};

using P2PSocketManagerPtrDataView =
    mojo::InterfacePtrDataView<P2PSocketManagerInterfaceBase>;
using P2PSocketManagerRequestDataView =
    mojo::InterfaceRequestDataView<P2PSocketManagerInterfaceBase>;
using P2PSocketManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<P2PSocketManagerInterfaceBase>;
using P2PSocketManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<P2PSocketManagerInterfaceBase>;
class P2PSocketInterfaceBase {};

using P2PSocketPtrDataView =
    mojo::InterfacePtrDataView<P2PSocketInterfaceBase>;
using P2PSocketRequestDataView =
    mojo::InterfaceRequestDataView<P2PSocketInterfaceBase>;
using P2PSocketAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<P2PSocketInterfaceBase>;
using P2PSocketAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<P2PSocketInterfaceBase>;
class P2PSocketClientInterfaceBase {};

using P2PSocketClientPtrDataView =
    mojo::InterfacePtrDataView<P2PSocketClientInterfaceBase>;
using P2PSocketClientRequestDataView =
    mojo::InterfaceRequestDataView<P2PSocketClientInterfaceBase>;
using P2PSocketClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<P2PSocketClientInterfaceBase>;
using P2PSocketClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<P2PSocketClientInterfaceBase>;


class P2PReceivedPacketDataView {
 public:
  P2PReceivedPacketDataView() = default;

  P2PReceivedPacketDataView(
      internal::P2PReceivedPacket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  inline void GetSocketAddressDataView(
      ::network::mojom::IPEndPointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSocketAddress(UserType* output) {
    
    auto* pointer = data_->socket_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPEndPointDataView>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEcn(UserType* output) const {
    auto data_value = data_->ecn;
    return mojo::internal::Deserialize<::network::mojom::EcnMarking>(
        data_value, output);
  }
  EcnMarking ecn() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::EcnMarking>(data_->ecn));
  }
 private:
  internal::P2PReceivedPacket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class P2PSendPacketDataView {
 public:
  P2PSendPacketDataView() = default;

  P2PSendPacketDataView(
      internal::P2PSendPacket_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  inline void GetPacketInfoDataView(
      P2PPacketInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacketInfo(UserType* output) {
    
    auto* pointer = data_->packet_info.Get();
    return mojo::internal::Deserialize<::network::mojom::P2PPacketInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::P2PSendPacket_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_DATA_VIEW_H_