// services/network/public/mojom/oblivious_http_request.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/oblivious_http_request.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var isolation_info$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/isolation_info.mojom', 'isolation_info.mojom.js');
  }
  var mutable_network_traffic_annotation_tag$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom', 'mutable_network_traffic_annotation_tag.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', 'network_param.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', 'trust_tokens.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }



  function ObliviousHttpRequestBody(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ObliviousHttpRequestBody.prototype.initDefaults_ = function() {
    this.content = null;
    this.contentType = null;
  };
  ObliviousHttpRequestBody.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ObliviousHttpRequestBody.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequestBody.content
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequestBody.contentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ObliviousHttpRequestBody.encodedSize = codec.kStructHeaderSize + 16;

  ObliviousHttpRequestBody.decode = function(decoder) {
    var packed;
    var val = new ObliviousHttpRequestBody();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.content =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.contentType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ObliviousHttpRequestBody.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ObliviousHttpRequestBody.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(byte_string$.ByteString, val.content);
    encoder.encodeStruct(codec.String, val.contentType);
  };
  function ObliviousHttpResponse(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ObliviousHttpResponse.prototype.initDefaults_ = function() {
    this.responseCode = 0;
    this.headers = null;
    this.responseBody = null;
  };
  ObliviousHttpResponse.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ObliviousHttpResponse.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ObliviousHttpResponse.headers
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, network_param$.HttpResponseHeaders, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpResponse.responseBody
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ObliviousHttpResponse.encodedSize = codec.kStructHeaderSize + 24;

  ObliviousHttpResponse.decode = function(decoder) {
    var packed;
    var val = new ObliviousHttpResponse();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.responseCode =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.headers =
        decoder.decodeStructPointer(network_param$.HttpResponseHeaders);
    val.responseBody =
        decoder.decodeStructPointer(byte_string$.ByteString);
    return val;
  };

  ObliviousHttpResponse.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ObliviousHttpResponse.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.responseCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(network_param$.HttpResponseHeaders, val.headers);
    encoder.encodeStructPointer(byte_string$.ByteString, val.responseBody);
  };
  function ObliviousHttpPaddingParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ObliviousHttpPaddingParameters.prototype.initDefaults_ = function() {
    this.addExponentialPad = false;
    this.padToNextPowerOfTwo = false;
    this.exponentialMean = 0;
  };
  ObliviousHttpPaddingParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ObliviousHttpPaddingParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  ObliviousHttpPaddingParameters.encodedSize = codec.kStructHeaderSize + 8;

  ObliviousHttpPaddingParameters.decode = function(decoder) {
    var packed;
    var val = new ObliviousHttpPaddingParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.addExponentialPad = (packed >> 0) & 1 ? true : false;
    val.padToNextPowerOfTwo = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    val.exponentialMean =
        decoder.decodeStruct(codec.Uint16);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ObliviousHttpPaddingParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ObliviousHttpPaddingParameters.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.addExponentialPad & 1) << 0
    packed |= (val.padToNextPowerOfTwo & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint16, val.exponentialMean);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ObliviousHttpRequest(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ObliviousHttpRequest.prototype.initDefaults_ = function() {
    this.relayUrl = null;
    this.trafficAnnotation = null;
    this.timeoutDuration = null;
    this.keyConfig = null;
    this.resourceUrl = null;
    this.method = null;
    this.requestBody = null;
    this.trustTokenParams = null;
    this.paddingParams = null;
  };
  ObliviousHttpRequest.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ObliviousHttpRequest.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.relayUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.trafficAnnotation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.timeoutDuration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.keyConfig
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.resourceUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.requestBody
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, ObliviousHttpRequestBody, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.trustTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, trust_tokens$.TrustTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpRequest.paddingParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, ObliviousHttpPaddingParameters, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ObliviousHttpRequest.encodedSize = codec.kStructHeaderSize + 72;

  ObliviousHttpRequest.decode = function(decoder) {
    var packed;
    var val = new ObliviousHttpRequest();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.relayUrl =
        decoder.decodeStructPointer(url$.Url);
    val.trafficAnnotation =
        decoder.decodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag);
    val.timeoutDuration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.keyConfig =
        decoder.decodeStruct(codec.String);
    val.resourceUrl =
        decoder.decodeStructPointer(url$.Url);
    val.method =
        decoder.decodeStruct(codec.String);
    val.requestBody =
        decoder.decodeStructPointer(ObliviousHttpRequestBody);
    val.trustTokenParams =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenParams);
    val.paddingParams =
        decoder.decodeStructPointer(ObliviousHttpPaddingParameters);
    return val;
  };

  ObliviousHttpRequest.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ObliviousHttpRequest.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.relayUrl);
    encoder.encodeStructPointer(mutable_network_traffic_annotation_tag$.MutableNetworkTrafficAnnotationTag, val.trafficAnnotation);
    encoder.encodeStructPointer(time$.TimeDelta, val.timeoutDuration);
    encoder.encodeStruct(codec.String, val.keyConfig);
    encoder.encodeStructPointer(url$.Url, val.resourceUrl);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(ObliviousHttpRequestBody, val.requestBody);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenParams, val.trustTokenParams);
    encoder.encodeStructPointer(ObliviousHttpPaddingParameters, val.paddingParams);
  };
  function ObliviousHttpClient_OnCompleted_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ObliviousHttpClient_OnCompleted_Params.prototype.initDefaults_ = function() {
    this.response = null;
  };
  ObliviousHttpClient_OnCompleted_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ObliviousHttpClient_OnCompleted_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ObliviousHttpClient_OnCompleted_Params.response
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, ObliviousHttpCompletionResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ObliviousHttpClient_OnCompleted_Params.encodedSize = codec.kStructHeaderSize + 16;

  ObliviousHttpClient_OnCompleted_Params.decode = function(decoder) {
    var packed;
    var val = new ObliviousHttpClient_OnCompleted_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.response =
        decoder.decodeStruct(ObliviousHttpCompletionResult);
    return val;
  };

  ObliviousHttpClient_OnCompleted_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ObliviousHttpClient_OnCompleted_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(ObliviousHttpCompletionResult, val.response);
  };

  function ObliviousHttpCompletionResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ObliviousHttpCompletionResult.Tags = {
    netError: 0,
    outerResponseErrorCode: 1,
    innerResponse: 2,
  };

  ObliviousHttpCompletionResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ObliviousHttpCompletionResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "netError",
        "outerResponseErrorCode",
        "innerResponse",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ObliviousHttpCompletionResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ObliviousHttpCompletionResult.prototype, "netError", {
    get: function() {
      if (this.$tag != ObliviousHttpCompletionResult.Tags.netError) {
        throw new ReferenceError(
            "ObliviousHttpCompletionResult.netError is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ObliviousHttpCompletionResult.Tags.netError;
      this.$data = value;
    }
  });
  Object.defineProperty(ObliviousHttpCompletionResult.prototype, "outerResponseErrorCode", {
    get: function() {
      if (this.$tag != ObliviousHttpCompletionResult.Tags.outerResponseErrorCode) {
        throw new ReferenceError(
            "ObliviousHttpCompletionResult.outerResponseErrorCode is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ObliviousHttpCompletionResult.Tags.outerResponseErrorCode;
      this.$data = value;
    }
  });
  Object.defineProperty(ObliviousHttpCompletionResult.prototype, "innerResponse", {
    get: function() {
      if (this.$tag != ObliviousHttpCompletionResult.Tags.innerResponse) {
        throw new ReferenceError(
            "ObliviousHttpCompletionResult.innerResponse is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ObliviousHttpCompletionResult.Tags.innerResponse;
      this.$data = value;
    }
  });


    ObliviousHttpCompletionResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ObliviousHttpCompletionResult.Tags.netError:
          encoder.encodeStruct(codec.Int32, val.netError);
          break;
        case ObliviousHttpCompletionResult.Tags.outerResponseErrorCode:
          encoder.encodeStruct(codec.Int32, val.outerResponseErrorCode);
          break;
        case ObliviousHttpCompletionResult.Tags.innerResponse:
          encoder.encodeStructPointer(ObliviousHttpResponse, val.innerResponse);
          break;
      }
      encoder.align();
    };


    ObliviousHttpCompletionResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ObliviousHttpCompletionResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case ObliviousHttpCompletionResult.Tags.netError:
          result.netError = decoder.decodeStruct(codec.Int32);
          break;
        case ObliviousHttpCompletionResult.Tags.outerResponseErrorCode:
          result.outerResponseErrorCode = decoder.decodeStruct(codec.Int32);
          break;
        case ObliviousHttpCompletionResult.Tags.innerResponse:
          result.innerResponse = decoder.decodeStructPointer(ObliviousHttpResponse);
          break;
      }
      decoder.align();

      return result;
    };


    ObliviousHttpCompletionResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ObliviousHttpCompletionResult.Tags.netError:
          

          break;
        case ObliviousHttpCompletionResult.Tags.outerResponseErrorCode:
          

          break;
        case ObliviousHttpCompletionResult.Tags.innerResponse:
          

    // validate ObliviousHttpCompletionResult.innerResponse
    err = messageValidator.validateStructPointer(data_offset, ObliviousHttpResponse, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ObliviousHttpCompletionResult.encodedSize = 16;
  var kObliviousHttpClient_OnCompleted_Name = 0;

  function ObliviousHttpClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ObliviousHttpClient,
                                                   handleOrPtrInfo);
  }

  function ObliviousHttpClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ObliviousHttpClient, associatedInterfacePtrInfo);
  }

  ObliviousHttpClientAssociatedPtr.prototype =
      Object.create(ObliviousHttpClientPtr.prototype);
  ObliviousHttpClientAssociatedPtr.prototype.constructor =
      ObliviousHttpClientAssociatedPtr;

  function ObliviousHttpClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  ObliviousHttpClientPtr.prototype.onCompleted = function() {
    return ObliviousHttpClientProxy.prototype.onCompleted
        .apply(this.ptr.getProxy(), arguments);
  };

  ObliviousHttpClientProxy.prototype.onCompleted = function(response) {
    var params_ = new ObliviousHttpClient_OnCompleted_Params();
    params_.response = response;
    var builder = new codec.MessageV0Builder(
        kObliviousHttpClient_OnCompleted_Name,
        codec.align(ObliviousHttpClient_OnCompleted_Params.encodedSize));
    builder.encodeStruct(ObliviousHttpClient_OnCompleted_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ObliviousHttpClientStub(delegate) {
    this.delegate_ = delegate;
  }
  ObliviousHttpClientStub.prototype.onCompleted = function(response) {
    return this.delegate_ && this.delegate_.onCompleted && this.delegate_.onCompleted(response);
  }

  ObliviousHttpClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kObliviousHttpClient_OnCompleted_Name:
      var params = reader.decodeStruct(ObliviousHttpClient_OnCompleted_Params);
      this.onCompleted(params.response);
      return true;
    default:
      return false;
    }
  };

  ObliviousHttpClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateObliviousHttpClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kObliviousHttpClient_OnCompleted_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ObliviousHttpClient_OnCompleted_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateObliviousHttpClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ObliviousHttpClient = {
    name: 'network.mojom.ObliviousHttpClient',
    kVersion: 0,
    ptrClass: ObliviousHttpClientPtr,
    proxyClass: ObliviousHttpClientProxy,
    stubClass: ObliviousHttpClientStub,
    validateRequest: validateObliviousHttpClientRequest,
    validateResponse: null,
  };
  ObliviousHttpClientStub.prototype.validator = validateObliviousHttpClientRequest;
  ObliviousHttpClientProxy.prototype.validator = null;
  exports.ObliviousHttpRequestBody = ObliviousHttpRequestBody;
  exports.ObliviousHttpResponse = ObliviousHttpResponse;
  exports.ObliviousHttpPaddingParameters = ObliviousHttpPaddingParameters;
  exports.ObliviousHttpRequest = ObliviousHttpRequest;
  exports.ObliviousHttpCompletionResult = ObliviousHttpCompletionResult;
  exports.ObliviousHttpClient = ObliviousHttpClient;
  exports.ObliviousHttpClientPtr = ObliviousHttpClientPtr;
  exports.ObliviousHttpClientAssociatedPtr = ObliviousHttpClientAssociatedPtr;
})();