// services/network/public/mojom/network_param.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_param.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_param.mojom-params-data.h"
#include "services/network/public/mojom/network_param.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_param.mojom-import-headers.h"
#include "services/network/public/mojom/network_param.mojom-test-utils.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
AuthChallengeInfo::AuthChallengeInfo()
    : is_proxy(),
      challenger(),
      scheme(),
      realm(),
      challenge(),
      path() {}

AuthChallengeInfo::AuthChallengeInfo(
    bool is_proxy_in,
    const ::url::SchemeHostPort& challenger_in,
    const std::string& scheme_in,
    const std::string& realm_in,
    const std::string& challenge_in,
    const std::string& path_in)
    : is_proxy(std::move(is_proxy_in)),
      challenger(std::move(challenger_in)),
      scheme(std::move(scheme_in)),
      realm(std::move(realm_in)),
      challenge(std::move(challenge_in)),
      path(std::move(path_in)) {}

AuthChallengeInfo::~AuthChallengeInfo() = default;

void AuthChallengeInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_proxy"), this->is_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenger"), this->challenger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::SchemeHostPort&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "realm"), this->realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthChallengeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpVersion::HttpVersion()
    : major_value(),
      minor_value() {}

HttpVersion::HttpVersion(
    uint16_t major_value_in,
    uint16_t minor_value_in)
    : major_value(std::move(major_value_in)),
      minor_value(std::move(minor_value_in)) {}

HttpVersion::~HttpVersion() = default;

void HttpVersion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "major_value"), this->major_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minor_value"), this->minor_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HostPortPair::HostPortPair()
    : host(),
      port() {}

HostPortPair::HostPortPair(
    const std::string& host_in,
    uint16_t port_in)
    : host(std::move(host_in)),
      port(std::move(port_in)) {}

HostPortPair::~HostPortPair() = default;

void HostPortPair::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HostPortPair::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyServer::ProxyServer()
    : scheme(),
      host_and_port() {}

ProxyServer::ProxyServer(
    ::net::ProxyServer::Scheme scheme_in,
    const std::optional<::net::HostPortPair>& host_and_port_in)
    : scheme(std::move(scheme_in)),
      host_and_port(std::move(host_and_port_in)) {}

ProxyServer::~ProxyServer() = default;

void ProxyServer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::net::ProxyServer::Scheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_and_port"), this->host_and_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::HostPortPair>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyServer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyChain::ProxyChain()
    : proxy_servers(),
      ip_protection_chain_id() {}

ProxyChain::ProxyChain(
    std::optional<std::vector<::net::ProxyServer>> proxy_servers_in,
    int32_t ip_protection_chain_id_in)
    : proxy_servers(std::move(proxy_servers_in)),
      ip_protection_chain_id(std::move(ip_protection_chain_id_in)) {}

ProxyChain::~ProxyChain() = default;

void ProxyChain::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_servers"), this->proxy_servers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<::net::ProxyServer>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_chain_id"), this->ip_protection_chain_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyChain::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveErrorInfo::ResolveErrorInfo()
    : error(),
      is_secure_network_error(false) {}

ResolveErrorInfo::ResolveErrorInfo(
    int32_t error_in,
    bool is_secure_network_error_in)
    : error(std::move(error_in)),
      is_secure_network_error(std::move(is_secure_network_error_in)) {}

ResolveErrorInfo::~ResolveErrorInfo() = default;

void ResolveErrorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_secure_network_error"), this->is_secure_network_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolveErrorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SSLCertRequestInfo::SSLCertRequestInfo()
    : host_and_port(),
      is_proxy(false),
      cert_authorities(),
      signature_algorithms() {}

SSLCertRequestInfo::SSLCertRequestInfo(
    const ::net::HostPortPair& host_and_port_in,
    bool is_proxy_in,
    std::vector<std::string> cert_authorities_in,
    std::vector<uint16_t> signature_algorithms_in)
    : host_and_port(std::move(host_and_port_in)),
      is_proxy(std::move(is_proxy_in)),
      cert_authorities(std::move(cert_authorities_in)),
      signature_algorithms(std::move(signature_algorithms_in)) {}

SSLCertRequestInfo::~SSLCertRequestInfo() = default;

void SSLCertRequestInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_and_port"), this->host_and_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HostPortPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_proxy"), this->is_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_authorities"), this->cert_authorities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature_algorithms"), this->signature_algorithms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SSLCertRequestInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetLogSource::NetLogSource()
    : source_type(),
      source_id(),
      start_time() {}

NetLogSource::NetLogSource(
    uint32_t source_type_in,
    uint32_t source_id_in,
    ::base::TimeTicks start_time_in)
    : source_type(std::move(source_type_in)),
      source_id(std::move(source_id_in)),
      start_time(std::move(start_time_in)) {}

NetLogSource::~NetLogSource() = default;

void NetLogSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetLogSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::AuthChallengeInfo::DataView, ::network::mojom::AuthChallengeInfoPtr>::Read(
    ::network::mojom::AuthChallengeInfo::DataView input,
    ::network::mojom::AuthChallengeInfoPtr* output) {
  bool success = true;
  ::network::mojom::AuthChallengeInfoPtr result(::network::mojom::AuthChallengeInfo::New());
  
      if (success)
        result->is_proxy = input.is_proxy();
      if (success && !input.ReadChallenger(&result->challenger))
        success = false;
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadRealm(&result->realm))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HttpVersion::DataView, ::network::mojom::HttpVersionPtr>::Read(
    ::network::mojom::HttpVersion::DataView input,
    ::network::mojom::HttpVersionPtr* output) {
  bool success = true;
  ::network::mojom::HttpVersionPtr result(::network::mojom::HttpVersion::New());
  
      if (success)
        result->major_value = input.major_value();
      if (success)
        result->minor_value = input.minor_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HostPortPair::DataView, ::network::mojom::HostPortPairPtr>::Read(
    ::network::mojom::HostPortPair::DataView input,
    ::network::mojom::HostPortPairPtr* output) {
  bool success = true;
  ::network::mojom::HostPortPairPtr result(::network::mojom::HostPortPair::New());
  
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyServer::DataView, ::network::mojom::ProxyServerPtr>::Read(
    ::network::mojom::ProxyServer::DataView input,
    ::network::mojom::ProxyServerPtr* output) {
  bool success = true;
  ::network::mojom::ProxyServerPtr result(::network::mojom::ProxyServer::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHostAndPort(&result->host_and_port))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ProxyChain::DataView, ::network::mojom::ProxyChainPtr>::Read(
    ::network::mojom::ProxyChain::DataView input,
    ::network::mojom::ProxyChainPtr* output) {
  bool success = true;
  ::network::mojom::ProxyChainPtr result(::network::mojom::ProxyChain::New());
  
      if (success && !input.ReadProxyServers(&result->proxy_servers))
        success = false;
      if (success)
        result->ip_protection_chain_id = input.ip_protection_chain_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ResolveErrorInfo::DataView, ::network::mojom::ResolveErrorInfoPtr>::Read(
    ::network::mojom::ResolveErrorInfo::DataView input,
    ::network::mojom::ResolveErrorInfoPtr* output) {
  bool success = true;
  ::network::mojom::ResolveErrorInfoPtr result(::network::mojom::ResolveErrorInfo::New());
  
      if (success)
        result->error = input.error();
      if (success)
        result->is_secure_network_error = input.is_secure_network_error();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SSLCertRequestInfo::DataView, ::network::mojom::SSLCertRequestInfoPtr>::Read(
    ::network::mojom::SSLCertRequestInfo::DataView input,
    ::network::mojom::SSLCertRequestInfoPtr* output) {
  bool success = true;
  ::network::mojom::SSLCertRequestInfoPtr result(::network::mojom::SSLCertRequestInfo::New());
  
      if (success && !input.ReadHostAndPort(&result->host_and_port))
        success = false;
      if (success)
        result->is_proxy = input.is_proxy();
      if (success && !input.ReadCertAuthorities(&result->cert_authorities))
        success = false;
      if (success && !input.ReadSignatureAlgorithms(&result->signature_algorithms))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetLogSource::DataView, ::network::mojom::NetLogSourcePtr>::Read(
    ::network::mojom::NetLogSource::DataView input,
    ::network::mojom::NetLogSourcePtr* output) {
  bool success = true;
  ::network::mojom::NetLogSourcePtr result(::network::mojom::NetLogSource::New());
  
      if (success)
        result->source_type = input.source_type();
      if (success)
        result->source_id = input.source_id();
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif