// services/network/public/mojom/network_isolation_key.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/network_isolation_key.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var network_isolation_partition$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_isolation_partition.mojom', 'network_isolation_partition.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }



  function EmptyNetworkIsolationKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  EmptyNetworkIsolationKey.prototype.initDefaults_ = function() {
  };
  EmptyNetworkIsolationKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  EmptyNetworkIsolationKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  EmptyNetworkIsolationKey.encodedSize = codec.kStructHeaderSize + 0;

  EmptyNetworkIsolationKey.decode = function(decoder) {
    var packed;
    var val = new EmptyNetworkIsolationKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  EmptyNetworkIsolationKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(EmptyNetworkIsolationKey.encodedSize);
    encoder.writeUint32(0);
  };
  function NonEmptyNetworkIsolationKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NonEmptyNetworkIsolationKey.prototype.initDefaults_ = function() {
    this.topFrameSite = null;
    this.frameSite = null;
    this.nonce = null;
    this.networkIsolationPartition = 0;
  };
  NonEmptyNetworkIsolationKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NonEmptyNetworkIsolationKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonEmptyNetworkIsolationKey.topFrameSite
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonEmptyNetworkIsolationKey.frameSite
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonEmptyNetworkIsolationKey.nonce
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NonEmptyNetworkIsolationKey.networkIsolationPartition
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, network_isolation_partition$.NetworkIsolationPartition);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NonEmptyNetworkIsolationKey.encodedSize = codec.kStructHeaderSize + 32;

  NonEmptyNetworkIsolationKey.decode = function(decoder) {
    var packed;
    var val = new NonEmptyNetworkIsolationKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.topFrameSite =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.frameSite =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.nonce =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.networkIsolationPartition =
        decoder.decodeStruct(new codec.Enum(network_isolation_partition$.NetworkIsolationPartition));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NonEmptyNetworkIsolationKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NonEmptyNetworkIsolationKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.topFrameSite);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.frameSite);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.nonce);
    encoder.encodeStruct(codec.Int32, val.networkIsolationPartition);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };

  function NetworkIsolationKey(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  NetworkIsolationKey.Tags = {
    empty: 0,
    nonEmpty: 1,
  };

  NetworkIsolationKey.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  NetworkIsolationKey.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "empty",
        "nonEmpty",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a NetworkIsolationKey member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(NetworkIsolationKey.prototype, "empty", {
    get: function() {
      if (this.$tag != NetworkIsolationKey.Tags.empty) {
        throw new ReferenceError(
            "NetworkIsolationKey.empty is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = NetworkIsolationKey.Tags.empty;
      this.$data = value;
    }
  });
  Object.defineProperty(NetworkIsolationKey.prototype, "nonEmpty", {
    get: function() {
      if (this.$tag != NetworkIsolationKey.Tags.nonEmpty) {
        throw new ReferenceError(
            "NetworkIsolationKey.nonEmpty is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = NetworkIsolationKey.Tags.nonEmpty;
      this.$data = value;
    }
  });


    NetworkIsolationKey.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case NetworkIsolationKey.Tags.empty:
          encoder.encodeStructPointer(EmptyNetworkIsolationKey, val.empty);
          break;
        case NetworkIsolationKey.Tags.nonEmpty:
          encoder.encodeStructPointer(NonEmptyNetworkIsolationKey, val.nonEmpty);
          break;
      }
      encoder.align();
    };


    NetworkIsolationKey.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new NetworkIsolationKey();
      var tag = decoder.readUint32();
      switch (tag) {
        case NetworkIsolationKey.Tags.empty:
          result.empty = decoder.decodeStructPointer(EmptyNetworkIsolationKey);
          break;
        case NetworkIsolationKey.Tags.nonEmpty:
          result.nonEmpty = decoder.decodeStructPointer(NonEmptyNetworkIsolationKey);
          break;
      }
      decoder.align();

      return result;
    };


    NetworkIsolationKey.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case NetworkIsolationKey.Tags.empty:
          

    // validate NetworkIsolationKey.empty
    err = messageValidator.validateStructPointer(data_offset, EmptyNetworkIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case NetworkIsolationKey.Tags.nonEmpty:
          

    // validate NetworkIsolationKey.nonEmpty
    err = messageValidator.validateStructPointer(data_offset, NonEmptyNetworkIsolationKey, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  NetworkIsolationKey.encodedSize = 16;
  exports.EmptyNetworkIsolationKey = EmptyNetworkIsolationKey;
  exports.NonEmptyNetworkIsolationKey = NonEmptyNetworkIsolationKey;
  exports.NetworkIsolationKey = NetworkIsolationKey;
})();