// services/network/public/mojom/network_change_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_change_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_change_manager.mojom-params-data.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_change_manager.mojom-import-headers.h"
#include "services/network/public/mojom/network_change_manager.mojom-test-utils.h"


namespace network::mojom {
// The declaration includes the definition on other builds.

NetworkChangeManagerClient::IPCStableHashFunction NetworkChangeManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkChangeManagerClient>(message.name())) {
    case messages::NetworkChangeManagerClient::kOnInitialConnectionType: {
      return &NetworkChangeManagerClient::OnInitialConnectionType_Sym::IPCStableHash;
    }
    case messages::NetworkChangeManagerClient::kOnNetworkChanged: {
      return &NetworkChangeManagerClient::OnNetworkChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkChangeManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkChangeManagerClient>(message.name())) {
      case messages::NetworkChangeManagerClient::kOnInitialConnectionType:
            return "Receive network::mojom::NetworkChangeManagerClient::OnInitialConnectionType";
      case messages::NetworkChangeManagerClient::kOnNetworkChanged:
            return "Receive network::mojom::NetworkChangeManagerClient::OnNetworkChanged";
    }
  } else {
    switch (static_cast<messages::NetworkChangeManagerClient>(message.name())) {
      case messages::NetworkChangeManagerClient::kOnInitialConnectionType:
            return "Receive reply network::mojom::NetworkChangeManagerClient::OnInitialConnectionType";
      case messages::NetworkChangeManagerClient::kOnNetworkChanged:
            return "Receive reply network::mojom::NetworkChangeManagerClient::OnNetworkChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkChangeManagerClient::OnInitialConnectionType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54c530a1;  // IPCStableHash for network::mojom::NetworkChangeManagerClient::OnInitialConnectionType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkChangeManagerClient::OnNetworkChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x30434e23;  // IPCStableHash for network::mojom::NetworkChangeManagerClient::OnNetworkChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkChangeManagerClientProxy::NetworkChangeManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkChangeManagerClientProxy::OnInitialConnectionType(
    ConnectionType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkChangeManagerClient::OnInitialConnectionType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ConnectionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkChangeManagerClient::kOnInitialConnectionType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManagerClient::Name_);
  message.set_method_name("OnInitialConnectionType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkChangeManagerClientProxy::OnNetworkChanged(
    ConnectionType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkChangeManagerClient::OnNetworkChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ConnectionType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkChangeManagerClient::kOnNetworkChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::network::mojom::ConnectionType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManagerClient::Name_);
  message.set_method_name("OnNetworkChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkChangeManagerClientStubDispatch::Accept(
    NetworkChangeManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkChangeManagerClient>(message->header()->name)) {
    case messages::NetworkChangeManagerClient::kOnInitialConnectionType: {
      DCHECK(message->is_serialized());
      internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkChangeManagerClient.0
      bool success = true;
      ConnectionType p_type{};
      NetworkChangeManagerClient_OnInitialConnectionType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInitialConnectionType(        
        std::move(p_type));
      return true;
    }
    case messages::NetworkChangeManagerClient::kOnNetworkChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkChangeManagerClient.1
      bool success = true;
      ConnectionType p_type{};
      NetworkChangeManagerClient_OnNetworkChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnNetworkChanged(        
        std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool NetworkChangeManagerClientStubDispatch::AcceptWithResponder(
    NetworkChangeManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkChangeManagerClient>(message->header()->name)) {
    case messages::NetworkChangeManagerClient::kOnInitialConnectionType: {
      break;
    }
    case messages::NetworkChangeManagerClient::kOnNetworkChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkChangeManagerClientValidationInfo[] = {
    { &internal::NetworkChangeManagerClient_OnInitialConnectionType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NetworkChangeManagerClient_OnNetworkChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkChangeManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::NetworkChangeManagerClient::Name_,
    kNetworkChangeManagerClientValidationInfo);
}

// The declaration includes the definition on other builds.

NetworkChangeManager::IPCStableHashFunction NetworkChangeManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkChangeManager>(message.name())) {
    case messages::NetworkChangeManager::kRequestNotifications: {
      return &NetworkChangeManager::RequestNotifications_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkChangeManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkChangeManager>(message.name())) {
      case messages::NetworkChangeManager::kRequestNotifications:
            return "Receive network::mojom::NetworkChangeManager::RequestNotifications";
    }
  } else {
    switch (static_cast<messages::NetworkChangeManager>(message.name())) {
      case messages::NetworkChangeManager::kRequestNotifications:
            return "Receive reply network::mojom::NetworkChangeManager::RequestNotifications";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkChangeManager::RequestNotifications_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5733aaa;  // IPCStableHash for network::mojom::NetworkChangeManager::RequestNotifications
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetworkChangeManagerProxy::NetworkChangeManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkChangeManagerProxy::RequestNotifications(
    ::mojo::PendingRemote<NetworkChangeManagerClient> in_client_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkChangeManager::RequestNotifications", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_remote"), in_client_remote,
                        "<value of type ::mojo::PendingRemote<NetworkChangeManagerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkChangeManager::kRequestNotifications), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkChangeManager_RequestNotifications_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkChangeManagerClientInterfaceBase>>(
    in_client_remote,
    &params->client_remote,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client_remote)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client_remote in NetworkChangeManager.RequestNotifications request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkChangeManager::Name_);
  message.set_method_name("RequestNotifications");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetworkChangeManagerStubDispatch::Accept(
    NetworkChangeManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkChangeManager>(message->header()->name)) {
    case messages::NetworkChangeManager::kRequestNotifications: {
      DCHECK(message->is_serialized());
      internal::NetworkChangeManager_RequestNotifications_Params_Data* params =
          reinterpret_cast<internal::NetworkChangeManager_RequestNotifications_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetworkChangeManager.0
      bool success = true;
      ::mojo::PendingRemote<NetworkChangeManagerClient> p_client_remote{};
      NetworkChangeManager_RequestNotifications_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client_remote =
            input_data_view.TakeClientRemote<decltype(p_client_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkChangeManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestNotifications(        
        std::move(p_client_remote));
      return true;
    }
  }
  return false;
}

// static
bool NetworkChangeManagerStubDispatch::AcceptWithResponder(
    NetworkChangeManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkChangeManager>(message->header()->name)) {
    case messages::NetworkChangeManager::kRequestNotifications: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetworkChangeManagerValidationInfo[] = {
    { &internal::NetworkChangeManager_RequestNotifications_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetworkChangeManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::NetworkChangeManager::Name_,
    kNetworkChangeManagerValidationInfo);
}



}  // network::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void NetworkChangeManagerClientInterceptorForTesting::OnInitialConnectionType(ConnectionType type) {
  GetForwardingInterface()->OnInitialConnectionType(
    std::move(type)
    );
}
void NetworkChangeManagerClientInterceptorForTesting::OnNetworkChanged(ConnectionType type) {
  GetForwardingInterface()->OnNetworkChanged(
    std::move(type)
    );
}
NetworkChangeManagerClientAsyncWaiter::NetworkChangeManagerClientAsyncWaiter(
    NetworkChangeManagerClient* proxy) : proxy_(proxy) {}

NetworkChangeManagerClientAsyncWaiter::~NetworkChangeManagerClientAsyncWaiter() = default;





void NetworkChangeManagerInterceptorForTesting::RequestNotifications(::mojo::PendingRemote<NetworkChangeManagerClient> client_remote) {
  GetForwardingInterface()->RequestNotifications(
    std::move(client_remote)
    );
}
NetworkChangeManagerAsyncWaiter::NetworkChangeManagerAsyncWaiter(
    NetworkChangeManager* proxy) : proxy_(proxy) {}

NetworkChangeManagerAsyncWaiter::~NetworkChangeManagerAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif