// services/network/public/mojom/load_timing_internal_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/load_timing_internal_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var SessionSource = {};
  SessionSource.kNew = 0;
  SessionSource.kExisting = 1;
  SessionSource.MIN_VALUE = 0;
  SessionSource.MAX_VALUE = 1;

  SessionSource.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SessionSource.toKnownEnumValue = function(value) {
    return value;
  };

  SessionSource.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AdvertisedAltSvcState = {};
  AdvertisedAltSvcState.kUnknown = 0;
  AdvertisedAltSvcState.kQuicNotBroken = 1;
  AdvertisedAltSvcState.kQuicBroken = 2;
  AdvertisedAltSvcState.MIN_VALUE = 0;
  AdvertisedAltSvcState.MAX_VALUE = 2;

  AdvertisedAltSvcState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AdvertisedAltSvcState.toKnownEnumValue = function(value) {
    return value;
  };

  AdvertisedAltSvcState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function LoadTimingInternalInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadTimingInternalInfo.prototype.initDefaults_ = function() {
    this.createStreamDelay = null;
    this.connectedCallbackDelay = null;
    this.initializeStreamDelay = null;
    this.session_source_$flag = false;
    this.httpNetworkSessionQuicEnabled = false;
    this.session_source_$value = 0;
    this.advertisedAltSvcState = 0;
  };
  LoadTimingInternalInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadTimingInternalInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInternalInfo.createStreamDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInternalInfo.connectedCallbackDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInternalInfo.initializeStreamDelay
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate LoadTimingInternalInfo.session_source_$value
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, SessionSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInternalInfo.advertisedAltSvcState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, AdvertisedAltSvcState);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  LoadTimingInternalInfo.encodedSize = codec.kStructHeaderSize + 40;

  LoadTimingInternalInfo.decode = function(decoder) {
    var packed;
    var val = new LoadTimingInternalInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.createStreamDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.connectedCallbackDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.initializeStreamDelay =
        decoder.decodeStructPointer(time$.TimeDelta);
    packed = decoder.readUint8();
    val.session_source_$flag = (packed >> 0) & 1 ? true : false;
    val.httpNetworkSessionQuicEnabled = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.session_source_$value =
        decoder.decodeStruct(new codec.Enum(SessionSource));
    val.advertisedAltSvcState =
        decoder.decodeStruct(new codec.Enum(AdvertisedAltSvcState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  LoadTimingInternalInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadTimingInternalInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.createStreamDelay);
    encoder.encodeStructPointer(time$.TimeDelta, val.connectedCallbackDelay);
    encoder.encodeStructPointer(time$.TimeDelta, val.initializeStreamDelay);
    packed = 0;
    packed |= (val.session_source_$flag & 1) << 0
    packed |= (val.httpNetworkSessionQuicEnabled & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.session_source_$value);
    encoder.encodeStruct(codec.Int32, val.advertisedAltSvcState);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.SessionSource = SessionSource;
  exports.AdvertisedAltSvcState = AdvertisedAltSvcState;
  exports.LoadTimingInternalInfo = LoadTimingInternalInfo;
})();