// services/network/public/mojom/host_resolver_endpoint_result.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/connection_endpoint_metadata.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/host_resolver_endpoint_result_mojom_traits.h"




namespace network::mojom {








class  HostResolverEndpointResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HostResolverEndpointResult, T>::value>;
  using DataView = HostResolverEndpointResultDataView;
  using Data_ = internal::HostResolverEndpointResult_Data;

  template <typename... Args>
  static HostResolverEndpointResultPtr New(Args&&... args) {
    return HostResolverEndpointResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HostResolverEndpointResultPtr From(const U& u) {
    return mojo::TypeConverter<HostResolverEndpointResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HostResolverEndpointResult>::Convert(*this);
  }


  HostResolverEndpointResult();

  HostResolverEndpointResult(
      std::vector<::net::IPEndPoint> ip_endpoints,
      const ::net::ConnectionEndpointMetadata& metadata);


  ~HostResolverEndpointResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HostResolverEndpointResultPtr>
  HostResolverEndpointResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostResolverEndpointResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HostResolverEndpointResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HostResolverEndpointResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HostResolverEndpointResult_UnserializedMessageContext<
            UserType, HostResolverEndpointResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HostResolverEndpointResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HostResolverEndpointResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HostResolverEndpointResult_UnserializedMessageContext<
            UserType, HostResolverEndpointResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HostResolverEndpointResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::net::IPEndPoint> ip_endpoints;
  
  ::net::ConnectionEndpointMetadata metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HostResolverEndpointResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HostResolverEndpointResultPtr HostResolverEndpointResult::Clone() const {
  return New(
      mojo::Clone(ip_endpoints),
      mojo::Clone(metadata)
  );
}

template <typename T, HostResolverEndpointResult::EnableIfSame<T>*>
bool HostResolverEndpointResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ip_endpoints, other_struct.ip_endpoints))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  return true;
}

template <typename T, HostResolverEndpointResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ip_endpoints < rhs.ip_endpoints)
    return true;
  if (rhs.ip_endpoints < lhs.ip_endpoints)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::HostResolverEndpointResult::DataView,
                                         ::network::mojom::HostResolverEndpointResultPtr> {
  static bool IsNull(const ::network::mojom::HostResolverEndpointResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HostResolverEndpointResultPtr* output) { output->reset(); }

  static const decltype(::network::mojom::HostResolverEndpointResult::ip_endpoints)& ip_endpoints(
      const ::network::mojom::HostResolverEndpointResultPtr& input) {
    return input->ip_endpoints;
  }

  static const decltype(::network::mojom::HostResolverEndpointResult::metadata)& metadata(
      const ::network::mojom::HostResolverEndpointResultPtr& input) {
    return input->metadata;
  }

  static bool Read(::network::mojom::HostResolverEndpointResult::DataView input, ::network::mojom::HostResolverEndpointResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_ENDPOINT_RESULT_MOJOM_H_