// services/network/public/mojom/first_party_sets.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/first_party_sets.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var version$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/version.mojom', '../../../../mojo/public/mojom/base/version.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }


  var SiteType = {};
  SiteType.kPrimary = 0;
  SiteType.kAssociated = 1;
  SiteType.kService = 2;
  SiteType.MIN_VALUE = 0;
  SiteType.MAX_VALUE = 2;

  SiteType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  SiteType.toKnownEnumValue = function(value) {
    return value;
  };

  SiteType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function FirstPartySetEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetEntry.prototype.initDefaults_ = function() {
    this.primary = null;
    this.siteType = 0;
  };
  FirstPartySetEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetEntry.primary
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetEntry.siteType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, SiteType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetEntry.encodedSize = codec.kStructHeaderSize + 16;

  FirstPartySetEntry.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.primary =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.siteType =
        decoder.decodeStruct(new codec.Enum(SiteType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FirstPartySetEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.primary);
    encoder.encodeStruct(codec.Int32, val.siteType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FirstPartySetMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetMetadata.prototype.initDefaults_ = function() {
    this.frameEntry = null;
    this.topFrameEntry = null;
  };
  FirstPartySetMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetMetadata.frameEntry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FirstPartySetEntry, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetMetadata.topFrameEntry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, FirstPartySetEntry, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetMetadata.encodedSize = codec.kStructHeaderSize + 16;

  FirstPartySetMetadata.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameEntry =
        decoder.decodeStructPointer(FirstPartySetEntry);
    val.topFrameEntry =
        decoder.decodeStructPointer(FirstPartySetEntry);
    return val;
  };

  FirstPartySetMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetMetadata.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FirstPartySetEntry, val.frameEntry);
    encoder.encodeStructPointer(FirstPartySetEntry, val.topFrameEntry);
  };
  function FirstPartySetEntryOverride(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetEntryOverride.prototype.initDefaults_ = function() {
    this.entry = null;
  };
  FirstPartySetEntryOverride.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetEntryOverride.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetEntryOverride.entry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FirstPartySetEntry, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetEntryOverride.encodedSize = codec.kStructHeaderSize + 8;

  FirstPartySetEntryOverride.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetEntryOverride();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStructPointer(FirstPartySetEntry);
    return val;
  };

  FirstPartySetEntryOverride.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetEntryOverride.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FirstPartySetEntry, val.entry);
  };
  function FirstPartySetsContextConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsContextConfig.prototype.initDefaults_ = function() {
    this.customizations = null;
    this.aliases = null;
  };
  FirstPartySetsContextConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsContextConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsContextConfig.customizations
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntryOverride), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsContextConfig.aliases
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetsContextConfig.encodedSize = codec.kStructHeaderSize + 16;

  FirstPartySetsContextConfig.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsContextConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.customizations =
        decoder.decodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntryOverride));
    val.aliases =
        decoder.decodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite));
    return val;
  };

  FirstPartySetsContextConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsContextConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntryOverride), val.customizations);
    encoder.encodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite), val.aliases);
  };
  function FirstPartySetsCacheFilter(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsCacheFilter.prototype.initDefaults_ = function() {
    this.filter = null;
    this.browserRunId = 0;
  };
  FirstPartySetsCacheFilter.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsCacheFilter.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsCacheFilter.filter
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.PointerTo(schemeful_site$.SchemefulSite), codec.Int64, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FirstPartySetsCacheFilter.encodedSize = codec.kStructHeaderSize + 16;

  FirstPartySetsCacheFilter.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsCacheFilter();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.filter =
        decoder.decodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), codec.Int64);
    val.browserRunId =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FirstPartySetsCacheFilter.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsCacheFilter.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), codec.Int64, val.filter);
    encoder.encodeStruct(codec.Int64, val.browserRunId);
  };
  function GlobalFirstPartySets(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GlobalFirstPartySets.prototype.initDefaults_ = function() {
    this.publicSetsVersion = null;
    this.sets = null;
    this.aliases = null;
    this.manualConfig = null;
  };
  GlobalFirstPartySets.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GlobalFirstPartySets.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GlobalFirstPartySets.publicSetsVersion
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, version$.Version, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GlobalFirstPartySets.sets
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntry), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GlobalFirstPartySets.aliases
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GlobalFirstPartySets.manualConfig
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, FirstPartySetsContextConfig, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GlobalFirstPartySets.encodedSize = codec.kStructHeaderSize + 32;

  GlobalFirstPartySets.decode = function(decoder) {
    var packed;
    var val = new GlobalFirstPartySets();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.publicSetsVersion =
        decoder.decodeStructPointer(version$.Version);
    val.sets =
        decoder.decodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntry));
    val.aliases =
        decoder.decodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite));
    val.manualConfig =
        decoder.decodeStructPointer(FirstPartySetsContextConfig);
    return val;
  };

  GlobalFirstPartySets.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GlobalFirstPartySets.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(version$.Version, val.publicSetsVersion);
    encoder.encodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(FirstPartySetEntry), val.sets);
    encoder.encodeMapPointer(new codec.PointerTo(schemeful_site$.SchemefulSite), new codec.PointerTo(schemeful_site$.SchemefulSite), val.aliases);
    encoder.encodeStructPointer(FirstPartySetsContextConfig, val.manualConfig);
  };
  exports.SiteType = SiteType;
  exports.FirstPartySetEntry = FirstPartySetEntry;
  exports.FirstPartySetMetadata = FirstPartySetMetadata;
  exports.FirstPartySetEntryOverride = FirstPartySetEntryOverride;
  exports.FirstPartySetsContextConfig = FirstPartySetsContextConfig;
  exports.FirstPartySetsCacheFilter = FirstPartySetsCacheFilter;
  exports.GlobalFirstPartySets = GlobalFirstPartySets;
})();