// services/network/public/mojom/devtools_observer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  DevToolsObserver_OnRawRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CookieWithAccessResult_Data>>> cookies_with_access_result;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::HttpRawHeaderPair_Data>>> headers;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> timestamp;
  mojo::internal::Pointer<::network::mojom::internal::ClientSecurityState_Data> client_security_state;
  mojo::internal::Pointer<internal::OtherPartitionInfo_Data> other_partition_info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> applied_network_conditions_id;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnRawRequest_Params_Data>;

  DevToolsObserver_OnRawRequest_Params_Data();
  ~DevToolsObserver_OnRawRequest_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnRawRequest_Params_Data) == 64,
              "Bad sizeof(DevToolsObserver_OnRawRequest_Params_Data)");
class  DevToolsObserver_OnRawResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::CookieAndLineWithAccessResult_Data>>> cookies_with_access_result;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::HttpRawHeaderPair_Data>>> headers;
  mojo::internal::Pointer<mojo::internal::String_Data> raw_response_headers;
  int32_t resource_address_space;
  int32_t http_status_code;
  mojo::internal::Pointer<::network::mojom::internal::CookiePartitionKey_Data> cookie_partition_key;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnRawResponse_Params_Data>;

  DevToolsObserver_OnRawResponse_Params_Data();
  ~DevToolsObserver_OnRawResponse_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnRawResponse_Params_Data) == 56,
              "Bad sizeof(DevToolsObserver_OnRawResponse_Params_Data)");
class  DevToolsObserver_OnEarlyHintsResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::HttpRawHeaderPair_Data>>> headers;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnEarlyHintsResponse_Params_Data>;

  DevToolsObserver_OnEarlyHintsResponse_Params_Data();
  ~DevToolsObserver_OnEarlyHintsResponse_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnEarlyHintsResponse_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnEarlyHintsResponse_Params_Data)");
class  DevToolsObserver_OnPrivateNetworkRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  uint8_t is_warning : 1;
  uint8_t pad2_[3];
  int32_t resource_address_space;
  mojo::internal::Pointer<::network::mojom::internal::ClientSecurityState_Data> client_security_state;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnPrivateNetworkRequest_Params_Data>;

  DevToolsObserver_OnPrivateNetworkRequest_Params_Data();
  ~DevToolsObserver_OnPrivateNetworkRequest_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnPrivateNetworkRequest_Params_Data) == 40,
              "Bad sizeof(DevToolsObserver_OnPrivateNetworkRequest_Params_Data)");
class  DevToolsObserver_OnCorsPreflightRequest_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtool_request_id;
  mojo::internal::Pointer<::network::mojom::internal::HttpRequestHeaders_Data> request_headers;
  mojo::internal::Pointer<internal::URLRequestDevToolsInfo_Data> request_info;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> initiator_url;
  mojo::internal::Pointer<mojo::internal::String_Data> initiator_devtool_request_id;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnCorsPreflightRequest_Params_Data>;

  DevToolsObserver_OnCorsPreflightRequest_Params_Data();
  ~DevToolsObserver_OnCorsPreflightRequest_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnCorsPreflightRequest_Params_Data) == 48,
              "Bad sizeof(DevToolsObserver_OnCorsPreflightRequest_Params_Data)");
class  DevToolsObserver_OnCorsPreflightResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<internal::URLResponseHeadDevToolsInfo_Data> head;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnCorsPreflightResponse_Params_Data>;

  DevToolsObserver_OnCorsPreflightResponse_Params_Data();
  ~DevToolsObserver_OnCorsPreflightResponse_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnCorsPreflightResponse_Params_Data) == 32,
              "Bad sizeof(DevToolsObserver_OnCorsPreflightResponse_Params_Data)");
class  DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> devtool_request_id;
  mojo::internal::Pointer<::network::mojom::internal::URLLoaderCompletionStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data>;

  DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data();
  ~DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data)");
class  DevToolsObserver_OnTrustTokenOperationDone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::network::mojom::internal::TrustTokenOperationResult_Data> result;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnTrustTokenOperationDone_Params_Data>;

  DevToolsObserver_OnTrustTokenOperationDone_Params_Data();
  ~DevToolsObserver_OnTrustTokenOperationDone_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnTrustTokenOperationDone_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnTrustTokenOperationDone_Params_Data)");
class  DevToolsObserver_OnCorsError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> initiator_origin;
  mojo::internal::Pointer<::network::mojom::internal::ClientSecurityState_Data> client_security_state;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<::network::mojom::internal::CorsErrorStatus_Data> status;
  uint8_t is_warning : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnCorsError_Params_Data>;

  DevToolsObserver_OnCorsError_Params_Data();
  ~DevToolsObserver_OnCorsError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnCorsError_Params_Data) == 56,
              "Bad sizeof(DevToolsObserver_OnCorsError_Params_Data)");
class  DevToolsObserver_OnOrbError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtools_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnOrbError_Params_Data>;

  DevToolsObserver_OnOrbError_Params_Data();
  ~DevToolsObserver_OnOrbError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnOrbError_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnOrbError_Params_Data)");
class  DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> urls;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data>;

  DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data();
  ~DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data)");
class  DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<mojo::internal::String_Data> error_message;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data>;

  DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data();
  ~DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data) == 24,
              "Bad sizeof(DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data)");
class  DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> inner_request_devtools_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::String_Data> bundle_request_devtools_id;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data>;

  DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data();
  ~DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data) == 32,
              "Bad sizeof(DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data)");
class  DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> inner_request_devtools_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::String_Data> error_message;
  mojo::internal::Pointer<mojo::internal::String_Data> bundle_request_devtools_id;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data>;

  DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data();
  ~DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data) == 40,
              "Bad sizeof(DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data)");
class  DevToolsObserver_OnSharedDictionaryError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSharedDictionaryError_Params_Data>;

  DevToolsObserver_OnSharedDictionaryError_Params_Data();
  ~DevToolsObserver_OnSharedDictionaryError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSharedDictionaryError_Params_Data) == 32,
              "Bad sizeof(DevToolsObserver_OnSharedDictionaryError_Params_Data)");
class  DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::SRIMessageSignatureIssue_Data>>> issues;

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data>;

  DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data();
  ~DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data) == 32,
              "Bad sizeof(DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data)");
class  DevToolsObserver_OnUnencodedDigestError_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> devtool_request_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  int32_t issue;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_OnUnencodedDigestError_Params_Data>;

  DevToolsObserver_OnUnencodedDigestError_Params_Data();
  ~DevToolsObserver_OnUnencodedDigestError_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_OnUnencodedDigestError_Params_Data) == 32,
              "Bad sizeof(DevToolsObserver_OnUnencodedDigestError_Params_Data)");
class  DevToolsObserver_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data listener;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<DevToolsObserver_Clone_Params_Data>;

  DevToolsObserver_Clone_Params_Data();
  ~DevToolsObserver_Clone_Params_Data() = delete;
};
static_assert(sizeof(DevToolsObserver_Clone_Params_Data) == 16,
              "Bad sizeof(DevToolsObserver_Clone_Params_Data)");

}  // namespace internal


class DevToolsObserver_OnRawRequest_ParamsDataView {
 public:
  DevToolsObserver_OnRawRequest_ParamsDataView() = default;

  DevToolsObserver_OnRawRequest_ParamsDataView(
      internal::DevToolsObserver_OnRawRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesWithAccessResultDataView(
      mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiesWithAccessResult(UserType* output) {
    
    auto* pointer = data_->cookies_with_access_result.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  inline void GetOtherPartitionInfoDataView(
      OtherPartitionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOtherPartitionInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::OtherPartitionInfoDataView, UserType>(),
    "Attempting to read the optional `other_partition_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOtherPartitionInfo` instead "
    "of `ReadOtherPartitionInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->other_partition_info.Get();
    return mojo::internal::Deserialize<::network::mojom::OtherPartitionInfoDataView>(
        pointer, output, message_);
  }
  inline void GetAppliedNetworkConditionsIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppliedNetworkConditionsId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `applied_network_conditions_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAppliedNetworkConditionsId` instead "
    "of `ReadAppliedNetworkConditionsId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->applied_network_conditions_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnRawRequest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnRawResponse_ParamsDataView {
 public:
  DevToolsObserver_OnRawResponse_ParamsDataView() = default;

  DevToolsObserver_OnRawResponse_ParamsDataView(
      internal::DevToolsObserver_OnRawResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCookiesWithAccessResultDataView(
      mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiesWithAccessResult(UserType* output) {
    
    auto* pointer = data_->cookies_with_access_result.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        pointer, output, message_);
  }
  inline void GetRawResponseHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawResponseHeaders(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `raw_response_headers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRawResponseHeaders` instead "
    "of `ReadRawResponseHeaders if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->raw_response_headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResourceAddressSpace(UserType* output) const {
    auto data_value = data_->resource_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace resource_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->resource_address_space));
  }
  int32_t http_status_code() const {
    return data_->http_status_code;
  }
  inline void GetCookiePartitionKeyDataView(
      ::network::mojom::CookiePartitionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiePartitionKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookiePartitionKeyDataView, UserType>(),
    "Attempting to read the optional `cookie_partition_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookiePartitionKey` instead "
    "of `ReadCookiePartitionKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_partition_key.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiePartitionKeyDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnRawResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnEarlyHintsResponse_ParamsDataView {
 public:
  DevToolsObserver_OnEarlyHintsResponse_ParamsDataView() = default;

  DevToolsObserver_OnEarlyHintsResponse_ParamsDataView(
      internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHeadersDataView(
      mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnEarlyHintsResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView {
 public:
  DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView() = default;

  DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView(
      internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtool_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolRequestId` instead "
    "of `ReadDevtoolRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_warning() const {
    return data_->is_warning;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResourceAddressSpace(UserType* output) const {
    auto data_value = data_->resource_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace resource_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->resource_address_space));
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnPrivateNetworkRequest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnCorsPreflightRequest_ParamsDataView {
 public:
  DevToolsObserver_OnCorsPreflightRequest_ParamsDataView() = default;

  DevToolsObserver_OnCorsPreflightRequest_ParamsDataView(
      internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetRequestHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestHeaders(UserType* output) {
    
    auto* pointer = data_->request_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetRequestInfoDataView(
      URLRequestDevToolsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInfo(UserType* output) {
    
    auto* pointer = data_->request_info.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestDevToolsInfoDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorUrl(UserType* output) {
    
    auto* pointer = data_->initiator_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->initiator_devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnCorsPreflightRequest_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnCorsPreflightResponse_ParamsDataView {
 public:
  DevToolsObserver_OnCorsPreflightResponse_ParamsDataView() = default;

  DevToolsObserver_OnCorsPreflightResponse_ParamsDataView(
      internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHeadDataView(
      URLResponseHeadDevToolsInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHead(UserType* output) {
    
    auto* pointer = data_->head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDevToolsInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnCorsPreflightResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView {
 public:
  DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView() = default;

  DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView(
      internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      ::network::mojom::URLLoaderCompletionStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderCompletionStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView {
 public:
  DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView() = default;

  DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView(
      internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetResultDataView(
      ::network::mojom::TrustTokenOperationResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnTrustTokenOperationDone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnCorsError_ParamsDataView {
 public:
  DevToolsObserver_OnCorsError_ParamsDataView() = default;

  DevToolsObserver_OnCorsError_ParamsDataView(
      internal::DevToolsObserver_OnCorsError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtool_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolRequestId` instead "
    "of `ReadDevtoolRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      ::network::mojom::CorsErrorStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::CorsErrorStatusDataView>(
        pointer, output, message_);
  }
  bool is_warning() const {
    return data_->is_warning;
  }
 private:
  internal::DevToolsObserver_OnCorsError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnOrbError_ParamsDataView {
 public:
  DevToolsObserver_OnOrbError_ParamsDataView() = default;

  DevToolsObserver_OnOrbError_ParamsDataView(
      internal::DevToolsObserver_OnOrbError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolsRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsRequestId` instead "
    "of `ReadDevtoolsRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnOrbError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView {
 public:
  DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView() = default;

  DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView(
      internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrls(UserType* output) {
    
    auto* pointer = data_->urls.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnSubresourceWebBundleMetadata_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView {
 public:
  DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView() = default;

  DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView(
      internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnSubresourceWebBundleMetadataError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView {
 public:
  DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView() = default;

  DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView(
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInnerRequestDevtoolsIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerRequestDevtoolsId(UserType* output) {
    
    auto* pointer = data_->inner_request_devtools_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetBundleRequestDevtoolsIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleRequestDevtoolsId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `bundle_request_devtools_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBundleRequestDevtoolsId` instead "
    "of `ReadBundleRequestDevtoolsId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bundle_request_devtools_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnSubresourceWebBundleInnerResponse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView {
 public:
  DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView() = default;

  DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView(
      internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInnerRequestDevtoolsIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerRequestDevtoolsId(UserType* output) {
    
    auto* pointer = data_->inner_request_devtools_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBundleRequestDevtoolsIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleRequestDevtoolsId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `bundle_request_devtools_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBundleRequestDevtoolsId` instead "
    "of `ReadBundleRequestDevtoolsId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bundle_request_devtools_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnSubresourceWebBundleInnerResponseError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSharedDictionaryError_ParamsDataView {
 public:
  DevToolsObserver_OnSharedDictionaryError_ParamsDataView() = default;

  DevToolsObserver_OnSharedDictionaryError_ParamsDataView(
      internal::DevToolsObserver_OnSharedDictionaryError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::network::mojom::SharedDictionaryError>(
        data_value, output);
  }
  ::network::mojom::SharedDictionaryError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SharedDictionaryError>(data_->error));
  }
 private:
  internal::DevToolsObserver_OnSharedDictionaryError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView {
 public:
  DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView() = default;

  DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView(
      internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIssuesDataView(
      mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssues(UserType* output) {
    
    auto* pointer = data_->issues.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_OnUnencodedDigestError_ParamsDataView {
 public:
  DevToolsObserver_OnUnencodedDigestError_ParamsDataView() = default;

  DevToolsObserver_OnUnencodedDigestError_ParamsDataView(
      internal::DevToolsObserver_OnUnencodedDigestError_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDevtoolRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolRequestId(UserType* output) {
    
    auto* pointer = data_->devtool_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIssue(UserType* output) const {
    auto data_value = data_->issue;
    return mojo::internal::Deserialize<::network::mojom::UnencodedDigestIssue>(
        data_value, output);
  }
  ::network::mojom::UnencodedDigestIssue issue() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::UnencodedDigestIssue>(data_->issue));
  }
 private:
  internal::DevToolsObserver_OnUnencodedDigestError_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DevToolsObserver_Clone_ParamsDataView {
 public:
  DevToolsObserver_Clone_ParamsDataView() = default;

  DevToolsObserver_Clone_ParamsDataView(
      internal::DevToolsObserver_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DevToolsObserver_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetCookiesWithAccessResultDataView(
    mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>* output) {
  auto pointer = data_->cookies_with_access_result.Get();
  *output = mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetHeadersDataView(
    mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetOtherPartitionInfoDataView(
    OtherPartitionInfoDataView* output) {
  auto pointer = data_->other_partition_info.Get();
  *output = OtherPartitionInfoDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawRequest_ParamsDataView::GetAppliedNetworkConditionsIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->applied_network_conditions_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void DevToolsObserver_OnRawResponse_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawResponse_ParamsDataView::GetCookiesWithAccessResultDataView(
    mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>* output) {
  auto pointer = data_->cookies_with_access_result.Get();
  *output = mojo::ArrayDataView<::network::mojom::CookieAndLineWithAccessResultDataView>(pointer, message_);
}
inline void DevToolsObserver_OnRawResponse_ParamsDataView::GetHeadersDataView(
    mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>(pointer, message_);
}
inline void DevToolsObserver_OnRawResponse_ParamsDataView::GetRawResponseHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->raw_response_headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnRawResponse_ParamsDataView::GetCookiePartitionKeyDataView(
    ::network::mojom::CookiePartitionKeyDataView* output) {
  auto pointer = data_->cookie_partition_key.Get();
  *output = ::network::mojom::CookiePartitionKeyDataView(pointer, message_);
}


inline void DevToolsObserver_OnEarlyHintsResponse_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnEarlyHintsResponse_ParamsDataView::GetHeadersDataView(
    mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::ArrayDataView<::network::mojom::HttpRawHeaderPairDataView>(pointer, message_);
}


inline void DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnPrivateNetworkRequest_ParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}


inline void DevToolsObserver_OnCorsPreflightRequest_ParamsDataView::GetDevtoolRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightRequest_ParamsDataView::GetRequestHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->request_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightRequest_ParamsDataView::GetRequestInfoDataView(
    URLRequestDevToolsInfoDataView* output) {
  auto pointer = data_->request_info.Get();
  *output = URLRequestDevToolsInfoDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightRequest_ParamsDataView::GetInitiatorUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->initiator_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightRequest_ParamsDataView::GetInitiatorDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->initiator_devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DevToolsObserver_OnCorsPreflightResponse_ParamsDataView::GetDevtoolRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightResponse_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightResponse_ParamsDataView::GetHeadDataView(
    URLResponseHeadDevToolsInfoDataView* output) {
  auto pointer = data_->head.Get();
  *output = URLResponseHeadDevToolsInfoDataView(pointer, message_);
}


inline void DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView::GetDevtoolRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsPreflightRequestCompleted_ParamsDataView::GetStatusDataView(
    ::network::mojom::URLLoaderCompletionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::network::mojom::URLLoaderCompletionStatusDataView(pointer, message_);
}


inline void DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnTrustTokenOperationDone_ParamsDataView::GetResultDataView(
    ::network::mojom::TrustTokenOperationResultDataView* output) {
  auto pointer = data_->result.Get();
  *output = ::network::mojom::TrustTokenOperationResultDataView(pointer, message_);
}


inline void DevToolsObserver_OnCorsError_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsError_ParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsError_ParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnCorsError_ParamsDataView::GetStatusDataView(
    ::network::mojom::CorsErrorStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::network::mojom::CorsErrorStatusDataView(pointer, message_);
}


inline void DevToolsObserver_OnOrbError_ParamsDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnOrbError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleMetadata_ParamsDataView::GetUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->urls.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleMetadataError_ParamsDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView::GetInnerRequestDevtoolsIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inner_request_devtools_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleInnerResponse_ParamsDataView::GetBundleRequestDevtoolsIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->bundle_request_devtools_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView::GetInnerRequestDevtoolsIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inner_request_devtools_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSubresourceWebBundleInnerResponseError_ParamsDataView::GetBundleRequestDevtoolsIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->bundle_request_devtools_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DevToolsObserver_OnSharedDictionaryError_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSharedDictionaryError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DevToolsObserver_OnSRIMessageSignatureIssue_ParamsDataView::GetIssuesDataView(
    mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>* output) {
  auto pointer = data_->issues.Get();
  *output = mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>(pointer, message_);
}


inline void DevToolsObserver_OnUnencodedDigestError_ParamsDataView::GetDevtoolRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtool_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DevToolsObserver_OnUnencodedDigestError_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}





}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVTOOLS_OBSERVER_MOJOM_PARAMS_DATA_H_