// services/network/public/mojom/device_bound_sessions.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('network.mojom.ClearDataFilter');
goog.require('network.mojom.SchemefulSite');
goog.require('mojoBase.mojom.Time');
goog.require('url.mojom.Url');




goog.provide('network.mojom.DeviceBoundSessionAccessType');
goog.provide('network.mojom.DeviceBoundSessionAccessTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionAccessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionAccessType = {
  
  kCreation: 0,
  kUpdate: 1,
  kTermination: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('network.mojom.DeviceBoundSessionUsage');
goog.provide('network.mojom.DeviceBoundSessionUsageSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionUsageSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionUsage = {
  
  kUnknown: 0,
  kNoUsage: 1,
  kInScopeNotDeferred: 2,
  kDeferred: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('network.mojom.DeviceBoundSessionDeletionReason');
goog.provide('network.mojom.DeviceBoundSessionDeletionReasonSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.DeviceBoundSessionDeletionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.DeviceBoundSessionDeletionReason = {
  
  kExpired: 0,
  kFailedToRestoreKey: 1,
  kFailedToUnwrapKey: 2,
  kStoragePartitionCleared: 3,
  kClearBrowsingData: 4,
  kServerRequested: 5,
  kInvalidSessionParams: 6,
  kRefreshFatalError: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



goog.provide('network.mojom.DeviceBoundSessionManager');
goog.provide('network.mojom.DeviceBoundSessionManagerReceiver');
goog.provide('network.mojom.DeviceBoundSessionManagerCallbackRouter');
goog.provide('network.mojom.DeviceBoundSessionManagerInterface');
goog.provide('network.mojom.DeviceBoundSessionManagerRemote');
goog.provide('network.mojom.DeviceBoundSessionManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DeviceBoundSessionManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DeviceBoundSessionManager.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.DeviceBoundSessionManagerInterface = class {
  
  /**
   * @return {!Promise<{
        sessions: !Array<!network.mojom.DeviceBoundSessionKey>,
   *  }>}
   */

  getAllSessions() {}
  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { !network.mojom.DeviceBoundSessionKey } session
   */

  deleteSession(reason, session) {}
  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { ?mojoBase.mojom.Time } createdAfterTime
   * @param { ?mojoBase.mojom.Time } createdBeforeTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  deleteAllSessions(reason, createdAfterTime, createdBeforeTime, filter) {}
  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.DeviceBoundSessionAccessObserverRemote } observer
   */

  addObserver(url, observer) {}
};

/**
 * @export
 * @implements { network.mojom.DeviceBoundSessionManagerInterface }
 */
network.mojom.DeviceBoundSessionManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DeviceBoundSessionManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DeviceBoundSessionManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DeviceBoundSessionManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        sessions: !Array<!network.mojom.DeviceBoundSessionKey>,
   *  }>}
   */

  getAllSessions() {
    return this.proxy.sendMessage(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { !network.mojom.DeviceBoundSessionKey } session
   */

  deleteSession(
      reason,
      session) {
    this.proxy.sendMessage(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        [
          reason,
          session
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionDeletionReason } reason
   * @param { ?mojoBase.mojom.Time } createdAfterTime
   * @param { ?mojoBase.mojom.Time } createdBeforeTime
   * @param { ?network.mojom.ClearDataFilter } filter
   * @return {!Promise}
   */

  deleteAllSessions(
      reason,
      createdAfterTime,
      createdBeforeTime,
      filter) {
    return this.proxy.sendMessage(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        [
          reason,
          createdAfterTime,
          createdBeforeTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !network.mojom.DeviceBoundSessionAccessObserverRemote } observer
   */

  addObserver(
      url,
      observer) {
    this.proxy.sendMessage(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        [
          url,
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DeviceBoundSessionManagerReceiver = class {
  /**
   * @param {!network.mojom.DeviceBoundSessionManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DeviceBoundSessionManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        impl.getAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        impl.deleteSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        impl.deleteAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DeviceBoundSessionManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DeviceBoundSessionManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DeviceBoundSessionManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DeviceBoundSessionManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        this.getAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        this.deleteSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        this.deleteAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.DeviceBoundSessionAccessObserver');
goog.provide('network.mojom.DeviceBoundSessionAccessObserverReceiver');
goog.provide('network.mojom.DeviceBoundSessionAccessObserverCallbackRouter');
goog.provide('network.mojom.DeviceBoundSessionAccessObserverInterface');
goog.provide('network.mojom.DeviceBoundSessionAccessObserverRemote');
goog.provide('network.mojom.DeviceBoundSessionAccessObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DeviceBoundSessionAccessObserver.$interfaceName,
        scope);
  }
};

/** @interface */
network.mojom.DeviceBoundSessionAccessObserverInterface = class {
  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccess } access
   */

  onDeviceBoundSessionAccessed(access) {}
  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccessObserverPendingReceiver } observer
   */

  clone(observer) {}
};

/**
 * @export
 * @implements { network.mojom.DeviceBoundSessionAccessObserverInterface }
 */
network.mojom.DeviceBoundSessionAccessObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DeviceBoundSessionAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccess } access
   */

  onDeviceBoundSessionAccessed(
      access) {
    this.proxy.sendMessage(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        [
          access
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DeviceBoundSessionAccessObserverPendingReceiver } observer
   */

  clone(
      observer) {
    this.proxy.sendMessage(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverReceiver = class {
  /**
   * @param {!network.mojom.DeviceBoundSessionAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DeviceBoundSessionAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        impl.onDeviceBoundSessionAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DeviceBoundSessionAccessObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DeviceBoundSessionAccessObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DeviceBoundSessionAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceBoundSessionAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        this.onDeviceBoundSessionAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('network.mojom.DeviceBoundSessionKeySpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionAccessSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.DeviceBoundSessionKeySpec.$,
    'DeviceBoundSessionKey',
    [
      mojo.internal.StructField(
        'site', 0,
        0,
        network.mojom.SchemefulSiteSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.DeviceBoundSessionKey');

/** @record */
network.mojom.DeviceBoundSessionKey = class {
  constructor() {
    /** @export { !network.mojom.SchemefulSite } */
    this.site;
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessSpec.$,
    'DeviceBoundSessionAccess',
    [
      mojo.internal.StructField(
        'accessType', 0,
        0,
        network.mojom.DeviceBoundSessionAccessTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionKey', 8,
        0,
        network.mojom.DeviceBoundSessionKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'cookies', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('network.mojom.DeviceBoundSessionAccess');

/** @record */
network.mojom.DeviceBoundSessionAccess = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccessType } */
    this.accessType;
    /** @export { !network.mojom.DeviceBoundSessionKey } */
    this.sessionKey;
    /** @export { !Array<!string> } */
    this.cookies;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_Params',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.DeviceBoundSessionManager_GetAllSessions_Params');

/** @record */
network.mojom.DeviceBoundSessionManager_GetAllSessions_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_ResponseParams',
    [
      mojo.internal.StructField(
        'sessions', 0,
        0,
        mojo.internal.Array(network.mojom.DeviceBoundSessionKeySpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParams');

/** @record */
network.mojom.DeviceBoundSessionManager_GetAllSessions_ResponseParams = class {
  constructor() {
    /** @export { !Array<!network.mojom.DeviceBoundSessionKey> } */
    this.sessions;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteSession_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        network.mojom.DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 8,
        0,
        network.mojom.DeviceBoundSessionKeySpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.DeviceBoundSessionManager_DeleteSession_Params');

/** @record */
network.mojom.DeviceBoundSessionManager_DeleteSession_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @export { !network.mojom.DeviceBoundSessionKey } */
    this.session;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        network.mojom.DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'createdAfterTime', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'createdBeforeTime', 16,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        network.mojom.ClearDataFilterSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('network.mojom.DeviceBoundSessionManager_DeleteAllSessions_Params');

/** @record */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdAfterTime;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.createdBeforeTime;
    /** @export { (network.mojom.ClearDataFilter|undefined) } */
    this.filter;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParams');

/** @record */
network.mojom.DeviceBoundSessionManager_DeleteAllSessions_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
    'DeviceBoundSessionManager_AddObserver_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(network.mojom.DeviceBoundSessionAccessObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('network.mojom.DeviceBoundSessionManager_AddObserver_Params');

/** @record */
network.mojom.DeviceBoundSessionManager_AddObserver_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !network.mojom.DeviceBoundSessionAccessObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params',
    [
      mojo.internal.StructField(
        'access', 0,
        0,
        network.mojom.DeviceBoundSessionAccessSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params');

/** @record */
network.mojom.DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccess } */
    this.access;
  }
};



mojo.internal.Struct(
    network.mojom.DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DeviceBoundSessionAccessObserverPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('network.mojom.DeviceBoundSessionAccessObserver_Clone_Params');

/** @record */
network.mojom.DeviceBoundSessionAccessObserver_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.DeviceBoundSessionAccessObserverPendingReceiver } */
    this.observer;
  }
};

