// services/network/public/mojom/device_bound_sessions.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/device_bound_sessions.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "sandbox/policy/mojom/context.mojom-blink-forward.h"
#include "services/network/public/mojom/clear_data_filter.mojom-blink-forward.h"
#include "services/network/public/mojom/schemeful_site.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {

class DeviceBoundSessionManagerProxy;

template <typename ImplRefTraits>
class DeviceBoundSessionManagerStub;

class DeviceBoundSessionManagerRequestValidator;
class DeviceBoundSessionManagerResponseValidator;


class BLINK_PLATFORM_EXPORT DeviceBoundSessionManager
    : public DeviceBoundSessionManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DeviceBoundSessionManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceBoundSessionManagerInterfaceBase;
  using Proxy_ = DeviceBoundSessionManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceBoundSessionManagerStub<ImplRefTraits>;

  using RequestValidator_ = DeviceBoundSessionManagerRequestValidator;
  using ResponseValidator_ = DeviceBoundSessionManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllSessionsMinVersion = 0,
    kDeleteSessionMinVersion = 0,
    kDeleteAllSessionsMinVersion = 0,
    kAddObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetAllSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteAllSessions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceBoundSessionManager() = default;

  using GetAllSessionsCallback = base::OnceCallback<void(::blink::Vector<DeviceBoundSessionKeyPtr>)>;
  using GetAllSessionsMojoCallback = base::OnceCallback<void(::blink::Vector<DeviceBoundSessionKeyPtr>)>;

  virtual void GetAllSessions(GetAllSessionsCallback callback) = 0;

  virtual void DeleteSession(DeviceBoundSessionDeletionReason reason, DeviceBoundSessionKeyPtr session) = 0;

  using DeleteAllSessionsCallback = base::OnceCallback<void()>;
  using DeleteAllSessionsMojoCallback = base::OnceCallback<void()>;

  virtual void DeleteAllSessions(DeviceBoundSessionDeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::blink::ClearDataFilterPtr filter, DeleteAllSessionsCallback callback) = 0;

  virtual void AddObserver(const ::blink::KURL& url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> observer) = 0;
};

class DeviceBoundSessionAccessObserverProxy;

template <typename ImplRefTraits>
class DeviceBoundSessionAccessObserverStub;

class DeviceBoundSessionAccessObserverRequestValidator;


class BLINK_PLATFORM_EXPORT DeviceBoundSessionAccessObserver
    : public DeviceBoundSessionAccessObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.DeviceBoundSessionAccessObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceBoundSessionAccessObserverInterfaceBase;
  using Proxy_ = DeviceBoundSessionAccessObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceBoundSessionAccessObserverStub<ImplRefTraits>;

  using RequestValidator_ = DeviceBoundSessionAccessObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDeviceBoundSessionAccessedMinVersion = 0,
    kCloneMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDeviceBoundSessionAccessed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceBoundSessionAccessObserver() = default;

  virtual void OnDeviceBoundSessionAccessed(DeviceBoundSessionAccessPtr access) = 0;

  virtual void Clone(::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> observer) = 0;
};



class BLINK_PLATFORM_EXPORT DeviceBoundSessionManagerProxy
    : public DeviceBoundSessionManager {
 public:
  using InterfaceType = DeviceBoundSessionManager;

  explicit DeviceBoundSessionManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllSessions(GetAllSessionsCallback callback) final;
  
  void DeleteSession(DeviceBoundSessionDeletionReason reason, DeviceBoundSessionKeyPtr session) final;
  
  void DeleteAllSessions(DeviceBoundSessionDeletionReason reason, std::optional<::base::Time> created_after_time, std::optional<::base::Time> created_before_time, ::network::mojom::blink::ClearDataFilterPtr filter, DeleteAllSessionsCallback callback) final;
  
  void AddObserver(const ::blink::KURL& url, ::mojo::PendingRemote<DeviceBoundSessionAccessObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT DeviceBoundSessionAccessObserverProxy
    : public DeviceBoundSessionAccessObserver {
 public:
  using InterfaceType = DeviceBoundSessionAccessObserver;

  explicit DeviceBoundSessionAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDeviceBoundSessionAccessed(DeviceBoundSessionAccessPtr access) final;
  
  void Clone(::mojo::PendingReceiver<DeviceBoundSessionAccessObserver> observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT DeviceBoundSessionManagerStubDispatch {
 public:
  static bool Accept(DeviceBoundSessionManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceBoundSessionManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceBoundSessionManager>>
class DeviceBoundSessionManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceBoundSessionManagerStub() = default;
  ~DeviceBoundSessionManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT DeviceBoundSessionAccessObserverStubDispatch {
 public:
  static bool Accept(DeviceBoundSessionAccessObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceBoundSessionAccessObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceBoundSessionAccessObserver>>
class DeviceBoundSessionAccessObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceBoundSessionAccessObserverStub() = default;
  ~DeviceBoundSessionAccessObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionAccessObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceBoundSessionAccessObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT DeviceBoundSessionManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT DeviceBoundSessionAccessObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT DeviceBoundSessionManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class BLINK_PLATFORM_EXPORT DeviceBoundSessionKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionKey, T>::value>;
  using DataView = DeviceBoundSessionKeyDataView;
  using Data_ = internal::DeviceBoundSessionKey_Data;

  template <typename... Args>
  static DeviceBoundSessionKeyPtr New(Args&&... args) {
    return DeviceBoundSessionKeyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionKeyPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionKey>::Convert(*this);
  }


  DeviceBoundSessionKey();

  DeviceBoundSessionKey(
      const ::blink::BlinkSchemefulSite& site,
      const ::blink::String& id);


  ~DeviceBoundSessionKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionKeyPtr>
  DeviceBoundSessionKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionKey::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionKey::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionKey_UnserializedMessageContext<
            UserType, DeviceBoundSessionKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionKey::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionKey::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionKey_UnserializedMessageContext<
            UserType, DeviceBoundSessionKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionKey::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::BlinkSchemefulSite site;
  
  ::blink::String id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT DeviceBoundSessionAccess {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DeviceBoundSessionAccess, T>::value>;
  using DataView = DeviceBoundSessionAccessDataView;
  using Data_ = internal::DeviceBoundSessionAccess_Data;

  template <typename... Args>
  static DeviceBoundSessionAccessPtr New(Args&&... args) {
    return DeviceBoundSessionAccessPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DeviceBoundSessionAccessPtr From(const U& u) {
    return mojo::TypeConverter<DeviceBoundSessionAccessPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DeviceBoundSessionAccess>::Convert(*this);
  }


  DeviceBoundSessionAccess();

  DeviceBoundSessionAccess(
      DeviceBoundSessionAccessType access_type,
      DeviceBoundSessionKeyPtr session_key,
      ::blink::Vector<::blink::String> cookies);

DeviceBoundSessionAccess(const DeviceBoundSessionAccess&) = delete;
DeviceBoundSessionAccess& operator=(const DeviceBoundSessionAccess&) = delete;

  ~DeviceBoundSessionAccess();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DeviceBoundSessionAccessPtr>
  DeviceBoundSessionAccessPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionAccess::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DeviceBoundSessionAccess::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DeviceBoundSessionAccess::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DeviceBoundSessionAccess_UnserializedMessageContext<
            UserType, DeviceBoundSessionAccess::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DeviceBoundSessionAccess::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DeviceBoundSessionAccess::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DeviceBoundSessionAccess_UnserializedMessageContext<
            UserType, DeviceBoundSessionAccess::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DeviceBoundSessionAccess::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  DeviceBoundSessionAccessType access_type;
  
  DeviceBoundSessionKeyPtr session_key;
  
  ::blink::Vector<::blink::String> cookies;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DeviceBoundSessionKeyPtr DeviceBoundSessionKey::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(id)
  );
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>*>
bool DeviceBoundSessionKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  return false;
}
template <typename StructPtrType>
DeviceBoundSessionAccessPtr DeviceBoundSessionAccess::Clone() const {
  return New(
      mojo::Clone(access_type),
      mojo::Clone(session_key),
      mojo::Clone(cookies)
  );
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>*>
bool DeviceBoundSessionAccess::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->access_type, other_struct.access_type))
    return false;
  if (!mojo::Equals(this->session_key, other_struct.session_key))
    return false;
  if (!mojo::Equals(this->cookies, other_struct.cookies))
    return false;
  return true;
}

template <typename T, DeviceBoundSessionAccess::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.access_type < rhs.access_type)
    return true;
  if (rhs.access_type < lhs.access_type)
    return false;
  if (lhs.session_key < rhs.session_key)
    return true;
  if (rhs.session_key < lhs.session_key)
    return false;
  if (lhs.cookies < rhs.cookies)
    return true;
  if (rhs.cookies < lhs.cookies)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DeviceBoundSessionKey::DataView,
                                         ::network::mojom::blink::DeviceBoundSessionKeyPtr> {
  static bool IsNull(const ::network::mojom::blink::DeviceBoundSessionKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DeviceBoundSessionKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::DeviceBoundSessionKey::site)& site(
      const ::network::mojom::blink::DeviceBoundSessionKeyPtr& input) {
    return input->site;
  }

  static const decltype(::network::mojom::blink::DeviceBoundSessionKey::id)& id(
      const ::network::mojom::blink::DeviceBoundSessionKeyPtr& input) {
    return input->id;
  }

  static bool Read(::network::mojom::blink::DeviceBoundSessionKey::DataView input, ::network::mojom::blink::DeviceBoundSessionKeyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::DeviceBoundSessionAccess::DataView,
                                         ::network::mojom::blink::DeviceBoundSessionAccessPtr> {
  static bool IsNull(const ::network::mojom::blink::DeviceBoundSessionAccessPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::DeviceBoundSessionAccessPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::DeviceBoundSessionAccess::access_type) access_type(
      const ::network::mojom::blink::DeviceBoundSessionAccessPtr& input) {
    return input->access_type;
  }

  static const decltype(::network::mojom::blink::DeviceBoundSessionAccess::session_key)& session_key(
      const ::network::mojom::blink::DeviceBoundSessionAccessPtr& input) {
    return input->session_key;
  }

  static const decltype(::network::mojom::blink::DeviceBoundSessionAccess::cookies)& cookies(
      const ::network::mojom::blink::DeviceBoundSessionAccessPtr& input) {
    return input->cookies;
  }

  static bool Read(::network::mojom::blink::DeviceBoundSessionAccess::DataView input, ::network::mojom::blink::DeviceBoundSessionAccessPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_BLINK_H_