// services/network/public/mojom/data_pipe_getter.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.DataPipeGetterPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.DataPipeGetter.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.DataPipeGetterInterface }
 */
network.mojom.DataPipeGetterRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.DataPipeGetterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.DataPipeGetterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.DataPipeGetterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MojoHandle } pipe
   * @return {!Promise<{
        status: !number,
        size: !bigint,
   *  }>}
   */

  read(
      pipe) {
    return this.proxy.sendMessage(
        0,
        network.mojom.DataPipeGetter_Read_ParamsSpec.$,
        network.mojom.DataPipeGetter_Read_ResponseParamsSpec.$,
        [
          pipe
        ],
        false);
  }

  
  /**
   * @param { !network.mojom.DataPipeGetterPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        1,
        network.mojom.DataPipeGetter_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DataPipeGetter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.DataPipeGetterReceiver = class {
  /**
   * @param {!network.mojom.DataPipeGetterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.DataPipeGetterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.DataPipeGetterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DataPipeGetterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.DataPipeGetter_Read_ParamsSpec.$,
        network.mojom.DataPipeGetter_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        network.mojom.DataPipeGetter_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.DataPipeGetter = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DataPipeGetter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.DataPipeGetterRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.DataPipeGetterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DataPipeGetter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.DataPipeGetterCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.DataPipeGetterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.DataPipeGetterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.DataPipeGetter_Read_ParamsSpec.$,
        network.mojom.DataPipeGetter_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        network.mojom.DataPipeGetter_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DataPipeGetter_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DataPipeGetter_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.DataPipeGetter_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.DataPipeGetter_Read_ParamsSpec.$,
    'DataPipeGetter_Read_Params',
    [
      mojo.internal.StructField(
        'pipe', 0,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DataPipeGetter_Read_Params = class {
  constructor() {
    /** @export { !MojoHandle } */
    this.pipe;
  }
};



mojo.internal.Struct(
    network.mojom.DataPipeGetter_Read_ResponseParamsSpec.$,
    'DataPipeGetter_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'size', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.DataPipeGetter_Read_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.status;
    /** @export { !bigint } */
    this.size;
  }
};



mojo.internal.Struct(
    network.mojom.DataPipeGetter_Clone_ParamsSpec.$,
    'DataPipeGetter_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network.mojom.DataPipeGetterPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.DataPipeGetter_Clone_Params = class {
  constructor() {
    /** @export { !network.mojom.DataPipeGetterPendingReceiver } */
    this.receiver;
  }
};

